/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    static DataValueDescriptor ZERO_DECIMAL;
    static Comparable MINLONG_MINUS_ONE;
    static Comparable MAXLONG_PLUS_ONE;

    public final NumberDataValue absolute(NumberDataValue result) throws StandardException {
        if (this.isNegative()) {
            return this.minus(result);
        }
        if (result == null) {
            result = (NumberDataType)this.getNewNull();
        }
        result.setValue(this);
        return result;
    }

    public NumberDataValue sqrt(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        double doubleValue = this.getDouble();
        if (this.isNegative()) {
            if (new Double(doubleValue).equals(new Double(-0.0))) {
                doubleValue = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        result.setValue(Math.sqrt(doubleValue));
        return result;
    }

    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        int addend1Int = addend1.getInt();
        int addend2Int = addend2.getInt();
        int resultValue = addend1Int + addend2Int;
        if (addend1Int < 0 == addend2Int < 0 && addend1Int < 0 != resultValue < 0) {
            throw this.outOfRange();
        }
        result.setValue(resultValue);
        return result;
    }

    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        int diff = left.getInt() - right.getInt();
        if (left.getInt() < 0 != right.getInt() < 0 && left.getInt() < 0 != diff < 0) {
            throw this.outOfRange();
        }
        result.setValue(diff);
        return result;
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        int intDivisor = divisor.getInt();
        if (intDivisor == 0) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getInt() / intDivisor);
        return result;
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        return this.divide(dividend, divisor, result);
    }

    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        SanityManager.NOTREACHED();
        return null;
    }

    public final int compare(DataValueDescriptor arg) throws StandardException {
        if (this.typePrecedence() < arg.typePrecedence()) {
            return -arg.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = arg.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(arg);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    public final boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    protected abstract boolean isNegative();

    public void setValue(short theValue) throws StandardException {
        this.setValue((int)theValue);
    }

    public void setValue(byte theValue) throws StandardException {
        this.setValue((int)theValue);
    }

    public void setValue(Number theValue) throws StandardException {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Integer)) {
            SanityManager.THROWASSERT("NumberDataType.setValue(Number) passed a " + theValue.getClass());
        }
        this.setValue(theValue.intValue());
    }

    void setObject(Object theValue) throws StandardException {
        this.setValue((Integer)theValue);
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        Comparable bdc = (Comparable)((Object)bigDecimal);
        if (bdc.compareTo(MINLONG_MINUS_ONE) != 1 || bdc.compareTo(MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", this.getTypeName());
        }
        this.setValue(bigDecimal.longValue());
    }

    public int typeToBigDecimal() {
        return -5;
    }

    public int getDecimalValuePrecision() {
        return -1;
    }

    public int getDecimalValueScale() {
        return -1;
    }

    protected final boolean objectNull(Object o) {
        if (o == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float v) throws StandardException {
        if (Float.isNaN(v) || Float.isInfinite(v) || v < -3.402E38f || v > 3.402E38f || v > 0.0f && v < 1.175E-37f || v < 0.0f && v > -1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (v == 0.0f) {
            v = 0.0f;
        }
        return v;
    }

    public static float normalizeREAL(double v) throws StandardException {
        if (Double.isNaN(v) || Double.isInfinite(v) || v < (double)-3.402E38f || v > (double)3.402E38f || v > 0.0 && v < (double)1.175E-37f || v < 0.0 && v > (double)-1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (v == 0.0) {
            v = 0.0;
        }
        return (float)v;
    }

    public static double normalizeDOUBLE(double v) throws StandardException {
        if (Double.isNaN(v) || Double.isInfinite(v) || v < -1.79769E308 || v > 1.79769E308 || v > 0.0 && v < 2.225E-307 || v < 0.0 && v > -2.225E-307) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        if (v == 0.0) {
            v = 0.0;
        }
        return v;
    }
}

