/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.URLStorageFactory;
import org.apache.derby.io.StorageFile;

class URLFile
extends InputStreamFile {
    private final URLStorageFactory storageFactory;

    URLFile(URLStorageFactory storageFactory, String path) {
        super(storageFactory, path);
        this.storageFactory = storageFactory;
    }

    URLFile(URLStorageFactory storageFactory, String parent, String name) {
        super((BaseStorageFactory)storageFactory, parent, name);
        this.storageFactory = storageFactory;
    }

    URLFile(URLFile dir, String name) {
        super(dir, name);
        this.storageFactory = dir.storageFactory;
    }

    private URLFile(URLStorageFactory storageFactory, String child, int pathLen) {
        super((BaseStorageFactory)storageFactory, child, pathLen);
        this.storageFactory = storageFactory;
    }

    public boolean exists() {
        try {
            InputStream is = this.getInputStream();
            if (is == null) {
                return false;
            }
            is.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    StorageFile getParentDir(int pathLen) {
        return new URLFile(this.storageFactory, this.path, pathLen);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            URL url = new URL(this.path);
            return url.openStream();
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
    }
}

