/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.iapi.types.Resetable;

public class PositionedStoreStream
extends InputStream
implements PositionedStream,
Resetable {
    private final InputStream stream;
    private long pos = 0L;

    public PositionedStoreStream(InputStream in) throws IOException, StandardException {
        this.stream = in;
        ((Resetable)((Object)in)).initStream();
        ((Resetable)((Object)in)).resetStream();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        if (ret > -1) {
            this.pos += (long)ret;
        }
        return ret;
    }

    public int read() throws IOException {
        int ret = this.stream.read();
        if (ret > -1) {
            ++this.pos;
        }
        return ret;
    }

    public long skip(long toSkip) throws IOException {
        long ret = this.stream.skip(toSkip);
        this.pos += ret;
        return ret;
    }

    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.stream)).resetStream();
        this.pos = 0L;
    }

    public void initStream() throws StandardException {
        ((Resetable)((Object)this.stream)).initStream();
    }

    public void closeStream() {
        ((Resetable)((Object)this.stream)).closeStream();
    }

    public void reposition(long requestedPos) throws IOException, StandardException {
        if (requestedPos < 0L) {
            SanityManager.THROWASSERT("Negative position: " + requestedPos);
        }
        if (this.pos > requestedPos) {
            this.resetStream();
        }
        if (this.pos < requestedPos) {
            try {
                InputStreamUtil.skipFully(this.stream, requestedPos - this.pos);
            }
            catch (EOFException eofe) {
                this.resetStream();
                throw eofe;
            }
            this.pos = requestedPos;
        }
    }

    public long getPosition() {
        return this.pos;
    }

    public InputStream asInputStream() {
        return this;
    }
}

