/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;

final class CachedItem {
    private boolean valid_ = false;
    private boolean removeRequested_ = false;
    private boolean settingIdentity_ = false;
    private boolean removeOk_ = false;
    private boolean recentlyUsed_ = false;
    private int keepCount;
    private Cacheable entry;

    public void keepAfterSearch() {
        ++this.keepCount;
        this.setUsed(true);
    }

    public void keepForCreate() {
        SanityManager.ASSERT(!this.isKept());
        SanityManager.ASSERT(!this.isValid());
        this.keepCount = 1;
        this.settingIdentity_ = true;
    }

    public void unkeepForCreate() {
        this.settingIdentityComplete();
        this.unkeep();
    }

    public void keepForClean() {
        SanityManager.ASSERT(this.isValid());
        ++this.keepCount;
    }

    public synchronized boolean unkeep() {
        boolean unkept = --this.keepCount == 0;
        SanityManager.ASSERT(this.keepCount >= 0);
        return unkept && this.removeRequested_;
    }

    public final boolean isKept() {
        return this.keepCount != 0;
    }

    public void clean(boolean forRemove) throws StandardException {
        this.entry.clean(forRemove);
    }

    public synchronized void setRemoveState() {
        this.removeRequested_ = true;
    }

    public final synchronized boolean isValid() {
        return this.valid_;
    }

    public synchronized void setValidState(boolean flag) {
        this.valid_ = flag;
        this.removeRequested_ = false;
        this.removeOk_ = false;
        this.recentlyUsed_ = flag;
    }

    public Cacheable getEntry() {
        return this.entry;
    }

    public Cacheable takeOnIdentity(CacheManager cm, CacheableFactory holderFactory, Object key, boolean forCreate, Object createParameter) throws StandardException {
        Cacheable oldEntry = this.entry;
        if (oldEntry == null) {
            oldEntry = holderFactory.newCacheable(cm);
        }
        this.entry = forCreate ? oldEntry.createIdentity(key, createParameter) : oldEntry.setIdentity(key);
        if (this.entry != null) {
            SanityManager.ASSERT(this.entry.getIdentity().equals(key));
            return this.entry;
        }
        this.entry = oldEntry;
        return null;
    }

    public synchronized void settingIdentityComplete() {
        this.settingIdentity_ = false;
        this.notifyAll();
    }

    public synchronized Cacheable use() throws StandardException {
        while (this.settingIdentity_) {
            try {
                SanityManager.DEBUG("CacheTrace", "trying to use a cached item that is taking on an identity");
                this.wait();
            }
            catch (InterruptedException ie) {
                throw StandardException.interrupt(ie);
            }
        }
        if (!this.valid_) {
            return null;
        }
        if (SanityManager.DEBUG_ON("CacheTrace")) {
            SanityManager.DEBUG("CacheTrace", "item keep count is " + this.keepCount);
        }
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean removeNow) throws StandardException {
        if (!removeNow) {
            CachedItem cachedItem = this;
            synchronized (cachedItem) {
                while (!this.removeOk_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw StandardException.interrupt(ie);
                    }
                }
            }
        }
        this.clean(true);
    }

    public synchronized void notifyRemover() {
        SanityManager.ASSERT(this.removeRequested_);
        SanityManager.ASSERT(this.isKept());
        this.removeOk_ = true;
        this.notifyAll();
    }

    public synchronized void setUsed(boolean flag) {
        this.recentlyUsed_ = flag;
    }

    public synchronized boolean recentlyUsed() {
        return this.recentlyUsed_;
    }
}

