/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class CreateSchemaNode
extends DDLStatementNode {
    private String name;
    private String aid;

    public void init(Object schemaName, Object aid) throws StandardException {
        this.initAndCheck(null);
        this.name = (String)schemaName;
        this.aid = (String)aid;
    }

    public String toString() {
        return super.toString() + "schemaName: " + "\n" + this.name + "\n" + "authorizationId: " + "\n" + this.aid + "\n";
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredSchemaPriv(this.name, this.aid, 16);
        }
    }

    public String statementToString() {
        return "CREATE SCHEMA";
    }

    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSchemaConstantAction(this.name, this.aid);
    }
}

