/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class DropAliasNode
extends DDLStatementNode {
    private char aliasType;
    private char nameSpace;

    public void init(Object dropAliasName, Object aliasType) throws StandardException {
        TableName dropItem = (TableName)dropAliasName;
        this.initAndCheck(dropItem);
        this.aliasType = ((Character)aliasType).charValue();
        switch (this.aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            default: {
                SanityManager.THROWASSERT("bad type to DropAliasNode: " + this.aliasType);
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType));
    }

    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String aliasName = this.getRelativeName();
        AliasDescriptor ad = null;
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (sd.getUUID() != null) {
            ad = dataDictionary.getAliasDescriptor(sd.getUUID().toString(), aliasName, this.nameSpace);
        }
        if (ad == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)aliasName);
        }
        if (ad.getSystemAlias()) {
            throw StandardException.newException("42Y71", aliasName);
        }
        this.getCompilerContext().createDependency(ad);
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.nameSpace);
    }

    private static String aliasTypeName(char actualType) {
        String typeName = null;
        switch (actualType) {
            case 'P': {
                typeName = "PROCEDURE";
                break;
            }
            case 'F': {
                typeName = "FUNCTION";
                break;
            }
            case 'S': {
                typeName = "SYNONYM";
            }
        }
        return typeName;
    }
}

