/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;

public class NewInvocationNode
extends MethodCallNode {
    private boolean singleInstantiation = false;
    private boolean delimitedIdentifier;
    private boolean isBuiltinVTI = false;

    public void init(Object javaClassName, Object params, Object delimitedIdentifier) throws StandardException {
        super.init("<init>");
        this.addParms((Vector)params);
        this.javaClassName = (String)javaClassName;
        this.delimitedIdentifier = (Boolean)delimitedIdentifier;
    }

    public void init(Object vtiTableFuncName, Object tableDescriptor, Object params, Object delimitedIdentifier) throws StandardException {
        boolean isTableFunctionVTI;
        super.init("<init>");
        this.addParms((Vector)params);
        SanityManager.ASSERT(vtiTableFuncName == null && tableDescriptor != null || vtiTableFuncName != null && tableDescriptor == null, "Exactly one of vtiTableFuncName or tableDescriptor should be null, but neither or both of them were null.");
        TableName vtiName = (TableName)vtiTableFuncName;
        TableDescriptor td = (TableDescriptor)tableDescriptor;
        boolean bl = isTableFunctionVTI = vtiTableFuncName != null;
        if (isTableFunctionVTI) {
            td = new TableDescriptor(this.getDataDictionary(), vtiName.getTableName(), this.getSchemaDescriptor(vtiName.getSchemaName()), 5, 'R');
        }
        this.javaClassName = this.getDataDictionary().getVTIClass(td, isTableFunctionVTI);
        boolean bl2 = this.isBuiltinVTI = this.getDataDictionary().getBuiltinVTIClass(td, isTableFunctionVTI) != null;
        if (this.javaClassName == null) {
            if (!isTableFunctionVTI) {
                vtiName = this.makeTableName(td.getSchemaName(), td.getDescriptorName());
            }
            throw StandardException.newException(isTableFunctionVTI ? "42Y03" : "42X05", vtiName.getFullTableName());
        }
        this.delimitedIdentifier = (Boolean)delimitedIdentifier;
    }

    public boolean isBuiltinVTI() {
        return this.isBuiltinVTI;
    }

    void setSingleInstantiation() {
        this.singleInstantiation = true;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        TypeDescriptor returnType;
        this.bindParameters(fromList, subqueryList, aggregateVector);
        this.verifyClassExist(this.javaClassName);
        String[] parmTypeNames = this.getObjectSignature();
        boolean[] isParam = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            this.method = classInspector.findPublicConstructor(this.javaClassName, parmTypeNames, null, isParam);
            if (this.method == null) {
                String[] primParmTypeNames = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicConstructor(this.javaClassName, parmTypeNames, primParmTypeNames, isParam);
            }
        }
        catch (ClassNotFoundException e) {
            this.method = null;
        }
        if (this.method == null) {
            String parmTypes = "";
            for (int i = 0; i < parmTypeNames.length; ++i) {
                if (i != 0) {
                    parmTypes = parmTypes + ", ";
                }
                parmTypes = parmTypes + (parmTypeNames[i].length() != 0 ? parmTypeNames[i] : MessageService.getTextMessage("42Z01.U"));
            }
            throw StandardException.newException("42X75", (Object)this.javaClassName, (Object)parmTypes);
        }
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            if (!ClassInspector.primitiveType(this.methodParameterTypes[i])) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        SanityManager.ASSERT(this.javaClassName.equals(classInspector.getType(this.method)), "Constructor is wrong type, expected " + this.javaClassName + " actual is " + classInspector.getType(this.method));
        this.setJavaTypeName(this.javaClassName);
        if (this.routineInfo != null && (returnType = this.routineInfo.getReturnType()) != null) {
            this.setCollationType(returnType.getCollationType());
        }
        return this;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        pushable = pushable && super.categorize(referencedTabs, simplePredsOnly);
        return pushable;
    }

    protected boolean assignableTo(String toClassName) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        return classInspector.assignableTo(this.javaClassName, toClassName);
    }

    protected Member findPublicMethod(String methodName, boolean staticMethod) throws StandardException {
        Member publicMethod;
        String[] parmTypeNames = this.getObjectSignature();
        boolean[] isParam = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            publicMethod = classInspector.findPublicMethod(this.javaClassName, methodName, parmTypeNames, null, isParam, staticMethod, false);
            if (publicMethod == null) {
                String[] primParmTypeNames = this.getPrimitiveSignature(false);
                publicMethod = classInspector.findPublicMethod(this.javaClassName, methodName, parmTypeNames, primParmTypeNames, isParam, staticMethod, false);
            }
        }
        catch (ClassNotFoundException e) {
            SanityManager.THROWASSERT("Unexpected exception", e);
            return null;
        }
        return publicMethod;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        LocalField objectFieldLF = null;
        if (this.singleInstantiation) {
            objectFieldLF = acb.newFieldDeclaration(2, this.javaClassName);
            mb.getField(objectFieldLF);
            mb.conditionalIfNull();
        }
        mb.pushNewStart(this.javaClassName);
        int nargs = this.generateParameters(acb, mb);
        mb.pushNewComplete(nargs);
        if (this.singleInstantiation) {
            mb.putField(objectFieldLF);
            mb.startElseCode();
            mb.getField(objectFieldLF);
            mb.completeConditional();
        }
    }
}

