/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    private int objectType;
    private Object objectOfPrivilege;
    private TablePrivilegesNode specificPrivileges;

    public void init(Object objectType, Object objectOfPrivilege, Object specificPrivileges) {
        this.objectType = (Integer)objectType;
        this.objectOfPrivilege = objectOfPrivilege;
        this.specificPrivileges = (TablePrivilegesNode)specificPrivileges;
        SanityManager.ASSERT(objectOfPrivilege != null, "null privilge object");
        switch (this.objectType) {
            case 0: {
                SanityManager.ASSERT(objectOfPrivilege instanceof TableName, "incorrect name type, " + objectOfPrivilege.getClass().getName() + ", used with table privilege");
                SanityManager.ASSERT(specificPrivileges != null, "null specific privileges used with table privilege");
                break;
            }
            case 1: {
                SanityManager.ASSERT(objectOfPrivilege instanceof RoutineDesignator, "incorrect name type, " + objectOfPrivilege.getClass().getName() + ", used with table privilege");
                SanityManager.ASSERT(specificPrivileges == null, "non-null specific privileges used with execute privilege");
                break;
            }
            default: {
                SanityManager.THROWASSERT("Invalid privilege objectType: " + this.objectType);
            }
        }
    }

    public QueryTreeNode bind(HashMap dependencies, List grantees, boolean isGrant) throws StandardException {
        TupleDescriptor dependencyProvider = null;
        SchemaDescriptor sd = null;
        switch (this.objectType) {
            case 0: {
                TableName tableName = (TableName)this.objectOfPrivilege;
                sd = this.getSchemaDescriptor(tableName.getSchemaName(), true);
                if (sd.isSystemSchema()) {
                    throw StandardException.newException("42509", tableName.getFullTableName());
                }
                TableDescriptor td = this.getTableDescriptor(tableName.getTableName(), sd);
                if (td == null) {
                    throw StandardException.newException("42X05", tableName);
                }
                if (this.isSessionSchema(sd.getSchemaName())) {
                    throw StandardException.newException("XCL51.S");
                }
                if (td.getTableType() != 0 && td.getTableType() != 2) {
                    throw StandardException.newException("42509", tableName.getFullTableName());
                }
                if (grantees.contains(sd.getAuthorizationId())) {
                    throw StandardException.newException("42509", td.getQualifiedName());
                }
                this.specificPrivileges.bind(td, isGrant);
                dependencyProvider = td;
                break;
            }
            case 1: {
                RoutineDesignator rd = (RoutineDesignator)this.objectOfPrivilege;
                sd = this.getSchemaDescriptor(rd.name.getSchemaName(), true);
                if (!sd.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException("42509", rd.name.getFullTableName());
                }
                AliasDescriptor proc = null;
                RoutineAliasInfo routineInfo = null;
                List list = this.getDataDictionary().getRoutineList(sd.getUUID().toString(), rd.name.getTableName(), rd.isFunction ? (char)'F' : 'P');
                if (grantees.contains(sd.getAuthorizationId())) {
                    throw StandardException.newException("42509", rd.name.getFullTableName());
                }
                if (rd.paramTypeList == null) {
                    if (list.size() > 1) {
                        throw StandardException.newException(rd.isFunction ? "42X46" : "42X47", rd.name.getFullTableName());
                    }
                    if (list.size() != 1) {
                        throw StandardException.newException("42Y03", rd.name.getFullTableName());
                    }
                    proc = (AliasDescriptor)list.get(0);
                } else {
                    boolean found = false;
                    block4: for (int i = list.size() - 1; !found && i >= 0; --i) {
                        proc = (AliasDescriptor)list.get(i);
                        routineInfo = (RoutineAliasInfo)proc.getAliasInfo();
                        int parameterCount = routineInfo.getParameterCount();
                        if (parameterCount != rd.paramTypeList.size()) continue;
                        TypeDescriptor[] parameterTypes = routineInfo.getParameterTypes();
                        found = true;
                        for (int parmIdx = 0; parmIdx < parameterCount; ++parmIdx) {
                            if (parameterTypes[parmIdx].equals(rd.paramTypeList.get(parmIdx))) continue;
                            found = false;
                            continue block4;
                        }
                    }
                    if (!found) {
                        StringBuffer sb = new StringBuffer(rd.name.getFullTableName());
                        sb.append("(");
                        for (int i = 0; i < rd.paramTypeList.size(); ++i) {
                            if (i > 0) {
                                sb.append(",");
                            }
                            sb.append(rd.paramTypeList.get(i).toString());
                        }
                        throw StandardException.newException("42Y03", sb.toString());
                    }
                }
                rd.setAliasDescriptor(proc);
                dependencyProvider = proc;
            }
        }
        if (dependencyProvider != null && dependencies.get(dependencyProvider) == null) {
            this.getCompilerContext().createDependency((Provider)((Object)dependencyProvider));
            dependencies.put(dependencyProvider, dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return ((RoutineDesignator)this.objectOfPrivilege).makePrivilegeInfo();
            }
        }
        return null;
    }
}

