/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class UserTypeConstantNode
extends ConstantNode {
    Object value;

    public void init(Object arg1) throws StandardException {
        DataValueDescriptor dvd = null;
        if (arg1 instanceof TypeId) {
            super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(-1));
        } else {
            Integer maxWidth = null;
            TypeId typeId = null;
            if (arg1 instanceof DataValueDescriptor) {
                dvd = (DataValueDescriptor)arg1;
            }
            if (arg1 instanceof Date || dvd != null && dvd.getTypeFormatId() == 298) {
                maxWidth = ReuseFactory.getInteger(10);
                typeId = TypeId.getBuiltInTypeId(91);
            } else if (arg1 instanceof Time || dvd != null && dvd.getTypeFormatId() == 299) {
                maxWidth = ReuseFactory.getInteger(8);
                typeId = TypeId.getBuiltInTypeId(92);
            } else if (arg1 instanceof Timestamp || dvd != null && dvd.getTypeFormatId() == 31) {
                maxWidth = ReuseFactory.getInteger(26);
                typeId = TypeId.getBuiltInTypeId(93);
            } else {
                SanityManager.THROWASSERT("Unexpected class " + arg1.getClass().getName());
            }
            super.init(typeId, arg1 == null ? Boolean.TRUE : Boolean.FALSE, maxWidth);
            if (dvd != null) {
                this.setValue(dvd);
            } else if (arg1 instanceof Date) {
                this.setValue(this.getDataValueFactory().getDataValue((Date)arg1));
            } else if (arg1 instanceof Time) {
                this.setValue(this.getDataValueFactory().getDataValue((Time)arg1));
            } else if (arg1 instanceof Timestamp) {
                this.setValue(this.getDataValueFactory().getDataValue((Timestamp)arg1));
            }
            this.value = arg1;
        }
    }

    public Object getObjectValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getConstantValueAsObject() {
        return this.value;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        TypeCompiler tc = this.getTypeCompiler();
        String fieldType = tc.interfaceName();
        if (this.value == null) {
            acb.generateNull(mb, tc, this.getTypeServices().getCollationType());
        } else {
            String typeName = this.getTypeId().getCorrespondingJavaTypeName();
            mb.push(this.value.toString());
            mb.callMethod((short)184, typeName, "valueOf", typeName, 1);
            LocalField field = acb.newFieldDeclaration(2, fieldType);
            acb.generateDataValue(mb, tc, this.getTypeServices().getCollationType(), field);
        }
    }

    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("geneateConstant() not expected to be called for UserTypeConstantNode because we have implemented our own generateExpression().");
    }
}

