/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DropConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean purge;
    private boolean defragment;
    private boolean truncateEndOfTable;
    private boolean updateStatistics;
    private boolean updateStatisticsAll;
    private String indexNameForUpdateStatistics;
    private DataValueDescriptor[][] rowBufferArray;
    private DataValueDescriptor[] rowBuffer;
    private DataValueDescriptor[] lastUniqueKey;
    private static final int GROUP_FETCH_SIZE = 16;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    AlterTableConstantAction(SchemaDescriptor sd, String tableName, UUID tableId, long tableConglomerateId, int tableType, ColumnInfo[] columnInfo, ConstraintConstantAction[] constraintActions, char lockGranularity, boolean compressTable, int behavior, boolean sequential, boolean truncateTable, boolean purge, boolean defragment, boolean truncateEndOfTable, boolean updateStatistics, boolean updateStatisticsAll, String indexNameForUpdateStatistics) {
        super(tableId);
        this.sd = sd;
        this.tableName = tableName;
        this.tableConglomerateId = tableConglomerateId;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        this.constraintActions = constraintActions;
        this.lockGranularity = lockGranularity;
        this.compressTable = compressTable;
        this.behavior = behavior;
        this.sequential = sequential;
        this.truncateTable = truncateTable;
        this.purge = purge;
        this.defragment = defragment;
        this.truncateEndOfTable = truncateEndOfTable;
        this.updateStatistics = updateStatistics;
        this.updateStatisticsAll = updateStatisticsAll;
        this.indexNameForUpdateStatistics = indexNameForUpdateStatistics;
        SanityManager.ASSERT(sd != null, "schema descriptor is null");
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        int numRows = 0;
        boolean tableScanned = false;
        if (this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable)) {
            this.td = dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            if (this.purge) {
                this.purgeRows(tc);
            }
            if (this.defragment) {
                this.defragmentRows(tc, lcc);
            }
            if (this.truncateEndOfTable) {
                this.truncateEnd(tc);
            }
            return;
        }
        if (this.updateStatistics) {
            this.updateStatistics(activation);
        }
        dd.startWriting(lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(tc, this.tableConglomerateId, true);
        this.td = dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        if (this.columnInfo != null) {
            int ix;
            boolean tableNeedsScanning = false;
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                if (this.columnInfo[ix].action != 0 || this.columnInfo[ix].dataType.isNullable() || this.columnInfo[ix].defaultInfo != null || this.columnInfo[ix].autoincInc != 0L) continue;
                tableNeedsScanning = true;
            }
            if (tableNeedsScanning) {
                numRows = this.getSemiRowCount(tc);
                if (numRows > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                tableScanned = true;
            }
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                ColumnDescriptorList cdl = new ColumnDescriptorList();
                if (this.columnInfo[ix].action == 0) {
                    this.addNewColumnToTable(activation, lcc, dd, tc, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 5 || this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 7) {
                    this.modifyColumnDefault(activation, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 2) {
                    this.modifyColumnType(activation, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 3) {
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, true);
                    continue;
                }
                if (this.columnInfo[ix].action == 4) {
                    boolean[] nullCols;
                    String[] colNames;
                    if (!tableScanned) {
                        tableScanned = true;
                        numRows = this.getSemiRowCount(tc);
                    }
                    if (!this.validateNotNullConstraint(colNames = new String[]{this.columnInfo[ix].name}, nullCols = new boolean[1], numRows, lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, false);
                    continue;
                }
                if (this.columnInfo[ix].action == 1) {
                    this.dropColumnFromTable(activation, this.columnInfo[ix].name);
                    continue;
                }
                SanityManager.THROWASSERT("Unexpected action in AlterTableConstantAction");
            }
        }
        if (this.constraintActions != null) {
            for (int conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                ConstraintConstantAction cca = this.constraintActions[conIndex];
                if (cca instanceof CreateConstraintConstantAction) {
                    int constraintType = cca.getConstraintType();
                    switch (constraintType) {
                        case 2: {
                            ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
                            if (cdl.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (tableScanned) break;
                            tableScanned = true;
                            numRows = this.getSemiRowCount(tc);
                            break;
                        }
                        case 4: {
                            if (!tableScanned) {
                                tableScanned = true;
                                numRows = this.getSemiRowCount(tc);
                            }
                            if (numRows <= 0) break;
                            ConstraintConstantAction.validateConstraint(cca.getConstraintName(), ((CreateConstraintConstantAction)cca).getConstraintText(), this.td, lcc, true);
                        }
                    }
                } else if (!(cca instanceof DropConstraintConstantAction)) {
                    SanityManager.THROWASSERT("constraintActions[" + conIndex + "] expected to be instanceof " + "DropConstraintConstantAction not " + cca.getClass().getName());
                }
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
                SanityManager.THROWASSERT("lockGranularity expected to be 'T'or 'R', not " + this.lockGranularity);
            }
            this.td.setLockGranularity(this.lockGranularity);
            dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, tc);
        }
        if (this.compressTable) {
            this.compressTable(activation);
        }
        if (this.truncateTable) {
            this.truncateTable(activation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistics(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        long numRows = -1L;
        this.td = dd.getTableDescriptor(this.tableId);
        ConglomerateDescriptor[] cds = this.updateStatisticsAll ? this.td.getConglomerateDescriptors() : new ConglomerateDescriptor[]{dd.getConglomerateDescriptor(this.indexNameForUpdateStatistics, this.sd, false)};
        long[] conglomerateNumber = new long[cds.length];
        ExecIndexRow[] indexRow = new ExecIndexRow[cds.length];
        UUID[] objectUUID = new UUID[cds.length];
        ConglomerateController heapCC = tc.openConglomerate(this.td.getHeapConglomerateId(), false, 0, 6, 4);
        try {
            for (int i = 0; i < cds.length; ++i) {
                if (!cds[i].isIndex()) {
                    conglomerateNumber[i] = -1L;
                    continue;
                }
                conglomerateNumber[i] = cds[i].getConglomerateNumber();
                objectUUID[i] = cds[i].getUUID();
                indexRow[i] = cds[i].getIndexDescriptor().getNullIndexRow(this.td.getColumnDescriptorList(), heapCC.newRowLocationTemplate());
            }
        }
        finally {
            heapCC.close();
        }
        dd.startWriting(lcc);
        dm.invalidateFor(this.td, 40, lcc);
        for (int indexNumber = 0; indexNumber < conglomerateNumber.length; ++indexNumber) {
            if (conglomerateNumber[indexNumber] == -1L) continue;
            int numCols = indexRow[indexNumber].nColumns() - 1;
            long[] cardinality = new long[numCols];
            numRows = 0L;
            this.initializeRowBuffers(indexRow[indexNumber]);
            GroupFetchScanController gsc = tc.openGroupFetchScan(conglomerateNumber[indexNumber], false, 0, 6, 1, null, null, 0, null, null, 0);
            try {
                boolean firstRow = true;
                int rowsFetched = 0;
                while ((rowsFetched = gsc.fetchNextGroup(this.rowBufferArray, null)) > 0) {
                    for (int i = 0; i < rowsFetched; ++i) {
                        int whichPositionChanged = this.compareWithPrevKey(i, firstRow);
                        firstRow = false;
                        if (whichPositionChanged >= 0) {
                            int j = whichPositionChanged;
                            while (j < cardinality.length) {
                                int n = j++;
                                cardinality[n] = cardinality[n] + 1L;
                            }
                        }
                        ++numRows;
                    }
                    DataValueDescriptor[] tmp = this.rowBufferArray[15];
                    this.rowBufferArray[15] = this.lastUniqueKey;
                    this.lastUniqueKey = tmp;
                }
                gsc.setEstimatedRowCount(numRows);
            }
            finally {
                gsc.close();
                gsc = null;
            }
            if (numRows == 0L) break;
            dd.dropStatisticsDescriptors(this.tableId, objectUUID[indexNumber], tc);
            for (int i = 0; i < indexRow[indexNumber].nColumns() - 1; ++i) {
                StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), objectUUID[indexNumber], this.tableId, "I", new StatisticsImpl(numRows, cardinality[i]), i + 1);
                dd.addDescriptor(statDesc, null, 14, true, tc);
            }
        }
        if (numRows == -1L) {
            return;
        }
        ScanController heapSC = tc.openScan(this.td.getHeapConglomerateId(), false, 0, 6, 1, null, null, 0, null, null, 0);
        try {
            heapSC.setEstimatedRowCount(numRows);
        }
        finally {
            heapSC.close();
        }
    }

    private void initializeRowBuffers(ExecIndexRow ir) {
        this.rowBufferArray = new DataValueDescriptor[16][];
        this.lastUniqueKey = ir.getRowArrayClone();
        this.rowBufferArray[0] = ir.getRowArray();
    }

    private int compareWithPrevKey(int index, boolean firstRow) throws StandardException {
        if (firstRow) {
            return 0;
        }
        DataValueDescriptor[] prev = index == 0 ? this.lastUniqueKey : this.rowBufferArray[index - 1];
        DataValueDescriptor[] curr = this.rowBufferArray[index];
        for (int i = 0; i < prev.length - 1; ++i) {
            DataValueDescriptor dvd = prev[i];
            if (dvd.isNull()) {
                return i;
            }
            if (prev[i].compare(curr[i]) == 0) continue;
            return i;
        }
        return -1;
    }

    private void truncateEnd(TransactionController tc) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = this.td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.compressConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void defragmentRows(TransactionController tc, LanguageConnectionContext lcc) throws StandardException {
        TransactionController nested_tc;
        ConglomerateController[] index_cc;
        ScanController[] index_scan;
        int num_indexes;
        GenericScanController base_group_fetch_cc;
        block23: {
            block21: {
                block22: {
                    base_group_fetch_cc = null;
                    num_indexes = 0;
                    Object index_col_map = null;
                    index_scan = null;
                    index_cc = null;
                    DataValueDescriptor[][] index_row = null;
                    nested_tc = null;
                    try {
                        nested_tc = tc.startNestedUserTransaction(false);
                        switch (this.td.getTableType()) {
                            case 2: 
                            case 5: {
                                Object var22_10 = null;
                                if (base_group_fetch_cc == null) break block21;
                                break block22;
                            }
                            default: {
                                ConglomerateDescriptor heapCD = this.td.getConglomerateDescriptor(this.td.getHeapConglomerateId());
                                ExecRow baseRow = lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(this.td.getNumberOfColumns());
                                ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
                                int cdlSize = cdl.size();
                                for (int index = 0; index < cdlSize; ++index) {
                                    ColumnDescriptor cd = cdl.elementAt(index);
                                    baseRow.setColumn(cd.getPosition(), cd.getType().getNull());
                                }
                                DataValueDescriptor[][] row_array = new DataValueDescriptor[100][];
                                row_array[0] = baseRow.getRowArray();
                                RowLocation[] old_row_location_array = new RowLocation[100];
                                RowLocation[] new_row_location_array = new RowLocation[100];
                                ConglomerateDescriptor[] conglom_descriptors = this.td.getConglomerateDescriptors();
                                num_indexes = conglom_descriptors.length - 1;
                                if (num_indexes > 0) {
                                    index_col_map = new int[num_indexes][];
                                    index_scan = new ScanController[num_indexes];
                                    index_cc = new ConglomerateController[num_indexes];
                                    index_row = new DataValueDescriptor[num_indexes][];
                                    AlterTableConstantAction.setup_indexes(nested_tc, this.td, index_col_map, index_scan, index_cc, index_row);
                                }
                                base_group_fetch_cc = nested_tc.defragmentConglomerate(this.td.getHeapConglomerateId(), false, true, 4, 7, 5);
                                int num_rows_fetched = 0;
                                while ((num_rows_fetched = base_group_fetch_cc.fetchNextGroup(row_array, old_row_location_array, new_row_location_array)) != 0) {
                                    if (num_indexes <= 0) continue;
                                    for (int row = 0; row < num_rows_fetched; ++row) {
                                        for (int index = 0; index < num_indexes; ++index) {
                                            AlterTableConstantAction.fixIndex(row_array[row], index_row[index], old_row_location_array[row], new_row_location_array[row], index_cc[index], index_scan[index], index_col_map[index]);
                                        }
                                    }
                                }
                                nested_tc.commit();
                                break;
                            }
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var22_12 = null;
                        if (base_group_fetch_cc != null) {
                            base_group_fetch_cc.close();
                            base_group_fetch_cc = null;
                        }
                        if (num_indexes > 0) {
                            for (int i = 0; i < num_indexes; ++i) {
                                if (index_scan != null && index_scan[i] != null) {
                                    index_scan[i].close();
                                    index_scan[i] = null;
                                }
                                if (index_cc == null || index_cc[i] == null) continue;
                                index_cc[i].close();
                                index_cc[i] = null;
                            }
                        }
                        if (nested_tc == null) throw throwable;
                        nested_tc.destroy();
                        throw throwable;
                    }
                }
                base_group_fetch_cc.close();
                base_group_fetch_cc = null;
            }
            if (num_indexes > 0) {
                for (int i = 0; i < num_indexes; ++i) {
                    if (index_scan != null && index_scan[i] != null) {
                        index_scan[i].close();
                        index_scan[i] = null;
                    }
                    if (index_cc == null || index_cc[i] == null) continue;
                    index_cc[i].close();
                    index_cc[i] = null;
                }
            }
            if (nested_tc == null) return;
            nested_tc.destroy();
            return;
        }
        Object var22_11 = null;
        if (base_group_fetch_cc != null) {
            base_group_fetch_cc.close();
            base_group_fetch_cc = null;
        }
        if (num_indexes > 0) {
            for (int i = 0; i < num_indexes; ++i) {
                if (index_scan != null && index_scan[i] != null) {
                    index_scan[i].close();
                    index_scan[i] = null;
                }
                if (index_cc == null || index_cc[i] == null) continue;
                index_cc[i].close();
                index_cc[i] = null;
            }
        }
        if (nested_tc == null) return;
        nested_tc.destroy();
    }

    private static void setup_indexes(TransactionController tc, TableDescriptor td, int[][] index_col_map, ScanController[] index_scan, ConglomerateController[] index_cc, DataValueDescriptor[][] index_row) throws StandardException {
        ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
        int index_idx = 0;
        for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
            ConglomerateDescriptor index_cd = conglom_descriptors[cd_idx];
            if (!index_cd.isIndex()) continue;
            index_scan[index_idx] = tc.openScan(index_cd.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            index_cc[index_idx] = tc.openConglomerate(index_cd.getConglomerateNumber(), true, 4, 7, 5);
            int[] baseColumnPositions = index_cd.getIndexDescriptor().baseColumnPositions();
            int[] zero_based_map = new int[baseColumnPositions.length];
            for (int i = 0; i < baseColumnPositions.length; ++i) {
                zero_based_map[i] = baseColumnPositions[i] - 1;
            }
            index_col_map[index_idx] = zero_based_map;
            index_row[index_idx] = new DataValueDescriptor[baseColumnPositions.length + 1];
            ++index_idx;
        }
    }

    private static void fixIndex(DataValueDescriptor[] base_row, DataValueDescriptor[] index_row, RowLocation old_row_loc, RowLocation new_row_loc, ConglomerateController index_cc, ScanController index_scan, int[] index_col_map) throws StandardException {
        SanityManager.ASSERT(index_col_map != null);
        SanityManager.ASSERT(index_row != null);
        SanityManager.ASSERT(index_col_map.length == index_row.length - 1);
        for (int index = 0; index < index_col_map.length; ++index) {
            index_row[index] = base_row[index_col_map[index]];
        }
        index_row[index_row.length - 1] = old_row_loc;
        index_scan.reopenScan(index_row, 1, null, index_row, -1);
        if (index_scan.next()) {
            index_scan.delete();
        } else {
            SanityManager.THROWASSERT("Did not find row to delete.base_row = " + RowUtil.toString(base_row) + "index_row = " + RowUtil.toString(index_row));
        }
        index_row[index_row.length - 1] = new_row_loc;
        index_cc.insert(index_row);
    }

    private void purgeRows(TransactionController tc) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = this.td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.purgeConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private void addNewColumnToTable(Activation activation, LanguageConnectionContext lcc, DataDictionary dd, TransactionController tc, int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int colNumber = this.td.getMaxColumnID() + ix;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[ix].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        DataValueDescriptor storableDV = this.columnInfo[ix].defaultValue != null ? this.columnInfo[ix].defaultValue : this.columnInfo[ix].dataType.getNull();
        tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), colNumber, storableDV, this.columnInfo[ix].dataType.getCollationType());
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, colNumber + 1, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            this.updateNewAutoincrementColumn(activation, this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(activation, columnDescriptor, lcc);
        }
        this.addColumnDependencies(lcc, dd, this.td, this.columnInfo[ix]);
        dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), tc);
    }

    private void dropColumnFromTable(Activation activation, String columnName) throws StandardException {
        int j;
        ConstraintDescriptor cd;
        int i;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        boolean cascade = this.behavior == 0;
        ColumnDescriptorList generatedColumnList = this.td.getGeneratedColumns();
        int generatedColumnCount = generatedColumnList.size();
        ArrayList<String> cascadedDroppedColumns = new ArrayList<String>();
        for (int i2 = 0; i2 < generatedColumnCount; ++i2) {
            ColumnDescriptor generatedColumn = generatedColumnList.elementAt(i2);
            String[] referencedColumnNames = generatedColumn.getDefaultInfo().getReferencedColumnNames();
            int referencedColumnCount = referencedColumnNames.length;
            for (int j2 = 0; j2 < referencedColumnCount; ++j2) {
                if (!columnName.equals(referencedColumnNames[j2])) continue;
                String generatedColumnName = generatedColumn.getColumnName();
                if (!cascade) {
                    throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)columnName, (Object)"GENERATED COLUMN", (Object)generatedColumnName);
                }
                cascadedDroppedColumns.add(generatedColumnName);
            }
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        int cascadedDrops = cascadedDroppedColumns.size();
        int sizeAfterCascadedDrops = this.td.getColumnDescriptorList().size() - cascadedDrops;
        if (sizeAfterCascadedDrops == 1) {
            throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)("THE *LAST* COLUMN " + columnName), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        for (int i3 = 0; i3 < cascadedDrops; ++i3) {
            String generatedColumnName = (String)cascadedDroppedColumns.get(i3);
            activation.addWarning(StandardException.newWarning("01009", generatedColumnName, this.td.getName()));
            this.dropColumnFromTable(activation, generatedColumnName);
        }
        this.td = dd.getTableDescriptor(this.tableId);
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(columnName);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)columnName, (Object)this.td.getQualifiedName());
        }
        int size = this.td.getColumnDescriptorList().size();
        this.droppedColumnPosition = columnDescriptor.getPosition();
        FormatableBitSet toDrop = new FormatableBitSet(size + 1);
        toDrop.set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap(toDrop);
        dm.invalidateFor(this.td, cascade ? 37 : 46, lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            dm.clearDependencies(lcc, columnDescriptor.getDefaultDescriptor(dd));
        }
        GenericDescriptorList tdl = dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            int j3;
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            int[] referencedCols = trd.getReferencedCols();
            if (referencedCols == null) continue;
            int refColLen = referencedCols.length;
            boolean changed = false;
            for (j3 = 0; j3 < refColLen; ++j3) {
                if (referencedCols[j3] > this.droppedColumnPosition) {
                    changed = true;
                    continue;
                }
                if (referencedCols[j3] != this.droppedColumnPosition) continue;
                if (cascade) {
                    trd.drop(lcc);
                    activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)columnName, (Object)"TRIGGER", (Object)trd.getName());
            }
            if (j3 != refColLen || !changed) continue;
            dd.dropTriggerDescriptor(trd, tc);
            for (j3 = 0; j3 < refColLen; ++j3) {
                if (referencedCols[j3] <= this.droppedColumnPosition) continue;
                int n = j3;
                referencedCols[n] = referencedCols[n] - 1;
            }
            dd.addDescriptor(trd, this.sd, 13, false, tc);
        }
        ConstraintDescriptorList csdl = dd.getConstraintDescriptors(this.td);
        int csdl_size = csdl.size();
        ArrayList newCongloms = new ArrayList();
        int tbr_size = 0;
        ConstraintDescriptor[] toBeRemoved = new ConstraintDescriptor[csdl_size];
        for (i = csdl_size - 1; i >= 0; --i) {
            int j4;
            cd = csdl.elementAt(i);
            int[] referencedColumns = cd.getReferencedColumns();
            int numRefCols = referencedColumns.length;
            boolean changed = false;
            for (j4 = 0; j4 < numRefCols; ++j4) {
                if (referencedColumns[j4] > this.droppedColumnPosition) {
                    changed = true;
                }
                if (referencedColumns[j4] == this.droppedColumnPosition) break;
            }
            if (j4 == numRefCols) {
                if (!(cd instanceof CheckConstraintDescriptor) || !changed) continue;
                dd.dropConstraintDescriptor(cd, tc);
                for (j4 = 0; j4 < numRefCols; ++j4) {
                    if (referencedColumns[j4] <= this.droppedColumnPosition) continue;
                    int n = j4;
                    referencedColumns[n] = referencedColumns[n] - 1;
                }
                ((CheckConstraintDescriptor)cd).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl(referencedColumns));
                dd.addConstraintDescriptor(cd, tc);
                continue;
            }
            if (!cascade) {
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)columnName, (Object)"CONSTRAINT", (Object)cd.getConstraintName());
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                toBeRemoved[tbr_size++] = cd;
                continue;
            }
            dm.invalidateFor(cd, 19, lcc);
            this.dropConstraint(cd, this.td, newCongloms, activation, lcc, true);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
        }
        for (i = tbr_size - 1; i >= 0; --i) {
            cd = toBeRemoved[i];
            this.dropConstraint(cd, this.td, newCongloms, activation, lcc, false);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
            if (cascade) {
                ConstraintDescriptorList fkcdl = dd.getForeignKeys(cd.getUUID());
                for (j = 0; j < fkcdl.size(); ++j) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(j);
                    dm.invalidateFor(fkcd, 19, lcc);
                    this.dropConstraint(fkcd, this.td, newCongloms, activation, lcc, true);
                    activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            dm.invalidateFor(cd, 19, lcc);
            dm.clearDependencies(lcc, cd);
        }
        this.createNewBackingCongloms(newCongloms, null, activation, dd);
        this.td = dd.getTableDescriptor(this.tableId);
        this.compressTable(activation);
        ColumnDescriptorList tab_cdl = this.td.getColumnDescriptorList();
        dd.dropColumnDescriptor(this.td.getUUID(), columnName, tc);
        TupleDescriptor[] cdlArray = new ColumnDescriptor[size - columnDescriptor.getPosition()];
        int i4 = columnDescriptor.getPosition();
        j = 0;
        while (i4 < size) {
            ColumnDescriptor cd2 = tab_cdl.elementAt(i4);
            dd.dropColumnDescriptor(this.td.getUUID(), cd2.getColumnName(), tc);
            cd2.setPosition(i4);
            if (cd2.isAutoincrement()) {
                cd2.setAutoinc_create_or_modify_Start_Increment(0);
            }
            cdlArray[j] = cd2;
            ++i4;
            ++j;
        }
        dd.addDescriptorArray(cdlArray, this.td, 2, false, tc);
        List deps = dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        ListIterator depsIterator = deps.listIterator();
        while (depsIterator.hasNext()) {
            DependencyDescriptor depDesc = (DependencyDescriptor)depsIterator.next();
            DependableFinder finder = depDesc.getProviderFinder();
            if (!(finder instanceof DDColumnDependableFinder)) continue;
            DDColumnDependableFinder colFinder = (DDColumnDependableFinder)finder;
            FormatableBitSet oldColumnBitMap = new FormatableBitSet(colFinder.getColumnBitMap());
            FormatableBitSet newColumnBitMap = new FormatableBitSet(oldColumnBitMap);
            newColumnBitMap.clear();
            int bitLen = oldColumnBitMap.getLength();
            for (int i5 = 0; i5 < bitLen; ++i5) {
                if (i5 < this.droppedColumnPosition && oldColumnBitMap.isSet(i5)) {
                    newColumnBitMap.set(i5);
                }
                if (i5 <= this.droppedColumnPosition || !oldColumnBitMap.isSet(i5)) continue;
                newColumnBitMap.set(i5 - 1);
            }
            if (newColumnBitMap.equals(oldColumnBitMap)) continue;
            dd.dropStoredDependency(depDesc, tc);
            colFinder.setColumnBitMap(newColumnBitMap.getByteArray());
            dd.addDescriptor(depDesc, null, 6, true, tc);
        }
        dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), tc, columnDescriptor);
        tab_cdl.remove(this.td.getColumnDescriptor(columnName));
    }

    private void modifyColumnType(Activation activation, int ix) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        ColumnDescriptor newColumnDescriptor = null;
        newColumnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnDescriptor.getPosition(), this.columnInfo[ix].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnConstraint(Activation activation, String colName, boolean nullability) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(colName);
        ColumnDescriptor newColumnDescriptor = null;
        DataTypeDescriptor dataType = columnDescriptor.getType().getNullabilityType(nullability);
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
        int columnPostion = columnDescriptor.getPosition();
        for (int i = 0; i < cdl.size(); ++i) {
            ConglomerateDescriptor desc;
            ConstraintDescriptor cd = cdl.elementAt(i);
            if (cd.getConstraintType() != 3) continue;
            ColumnDescriptorList columns = cd.getColumnDescriptors();
            for (int count = 0; count < columns.size() && columns.elementAt(count).getPosition() == columnPostion && (desc = this.td.getConglomerateDescriptor(cd.getConglomerateId())).getIndexDescriptor().isUnique(); ++count) {
                this.recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(desc, this.td, activation, lcc);
            }
        }
        newColumnDescriptor = new ColumnDescriptor(colName, columnDescriptor.getPosition(), dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc());
        dd.dropColumnDescriptor(this.td.getUUID(), colName, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnDefault(Activation activation, int ix) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        int columnPosition = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dd, this.columnInfo[ix].oldDefaultUUID, this.td.getUUID(), columnPosition);
            dm.invalidateFor(defaultDescriptor, 31, lcc);
            dm.clearDependencies(lcc, defaultDescriptor);
        }
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnPosition, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        if (this.columnInfo[ix].action == 6) {
            long maxValue = this.getColumnMax(activation, this.td, this.columnInfo[ix].name, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincStart);
            dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, maxValue, true);
        } else if (this.columnInfo[ix].action == 5) {
            dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, false);
        }
    }

    private void compressTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(!this.compressTable || this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        int[] collation_ids = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes(activation);
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow newRow = activation.getExecutionFactory().getValueRow(emptyHeapRow.nColumns() - 1);
            int[] new_collation_ids = new int[collation_ids.length - 1];
            for (int i = 0; i < newRow.nColumns(); ++i) {
                newRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? emptyHeapRow.getColumn(i + 1) : emptyHeapRow.getColumn(i + 1 + 1));
                new_collation_ids[i] = collation_ids[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            emptyHeapRow = newRow;
            collation_ids = new_collation_ids;
        }
        this.setUpAllSorts(emptyHeapRow, rl);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long newHeapConglom = this.tc.createAndLoadConglomerate("heap", emptyHeapRow.getRowArray(), null, collation_ids, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController compressHeapSC = this.tc.openScan(newHeapConglom, false, 4, 7, 5, null, null, 0, null, null, 0);
        compressHeapSC.setEstimatedRowCount(this.rowCount);
        compressHeapSC.close();
        compressHeapSC = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(newHeapConglom, this.dd);
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void truncateTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
        for (int index = 0; index < cdl.size(); ++index) {
            ReferencedKeyConstraintDescriptor rfcd;
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || !(rfcd = (ReferencedKeyConstraintDescriptor)cd).hasNonSelfReferencingFK(1)) continue;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        GenericDescriptorList tdl = this.dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            if (!trd.listensForEvent(2) || !trd.isEnabled()) continue;
            throw StandardException.newException("XCL49.S", (Object)this.td.getName(), (Object)trd.getName());
        }
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long newHeapConglom = this.tc.createConglomerate("heap", emptyHeapRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes(activation);
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            this.collation = new int[this.numIndexes][];
            for (int index = 0; index < this.numIndexes; ++index) {
                this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
                this.compressIRGs[index].getIndexRow(emptyHeapRow, rl, this.indexRows[index], null);
                int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
                boolean[] isAscending = this.compressIRGs[index].isAscending();
                int numColumnOrderings = baseColumnPositions.length + 1;
                this.ordering[index] = new ColumnOrdering[numColumnOrderings];
                this.collation[index] = new int[baseColumnPositions.length + 1];
                for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                    this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
                }
                this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] newIndexCongloms = new long[this.numIndexes];
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, this.dd, index, newIndexCongloms);
            }
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void updateAllIndexes(long newHeapConglom, DataDictionary dd) throws StandardException {
        long[] newIndexCongloms = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(newHeapConglom, dd, 0, newIndexCongloms);
            }
            for (int index = 1; index < this.numIndexes; ++index) {
                this.openBulkFetchScan(newHeapConglom);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(index, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
                this.closeBulkFetchScan();
            }
        } else {
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
            }
        }
    }

    private void updateIndex(long newHeapConglom, DataDictionary dd, int index, long[] newIndexCongloms) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[index]);
        ConglomerateController indexCC = this.tc.openConglomerate(this.indexConglomerateNumbers[index], false, 4, 7, 5);
        indexCC.getInternalTablePropertySet(properties);
        int indexRowLength = this.indexRows[index].nColumns();
        properties.put("baseConglomerateId", Long.toString(newHeapConglom));
        if (cd.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength));
        }
        properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
        properties.put("nKeyFields", Integer.toString(indexRowLength));
        indexCC.close();
        CardinalityCounter cCount = null;
        boolean statisticsExist = false;
        if (!this.truncateTable) {
            long numRows;
            this.sorters[index].completedInserts();
            this.sorters[index] = null;
            if (this.td.statisticsExist(cd)) {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
                statisticsExist = true;
            } else {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
            }
            newIndexCongloms[index] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0, cCount, null);
            if (statisticsExist) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
            if ((numRows = cCount.getRowCount()) > 0L) {
                long[] c = cCount.getCardinality();
                for (int i = 0; i < c.length; ++i) {
                    StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cd.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                    dd.addDescriptor(statDesc, null, 14, true, this.tc);
                }
            }
        } else {
            newIndexCongloms[index] = this.tc.createConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0);
            if (this.td.statisticsExist(cd)) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
        }
        dd.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[index]), newIndexCongloms[index], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[index]);
    }

    private void getAffectedIndexes(Activation activation) throws StandardException {
        Object[] compressIndexResult;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        ArrayList newCongloms = new ArrayList();
        if (!this.compressTable && !this.truncateTable) {
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor cd;
                int j;
                int[] baseColumnPositions = this.compressIRGs[i].baseColumnPositions();
                for (j = 0; j < baseColumnPositions.length && baseColumnPositions[j] != this.droppedColumnPosition; ++j) {
                }
                if (j == baseColumnPositions.length) continue;
                if (baseColumnPositions.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    this.dropConglomerate(cd, this.td, true, newCongloms, activation, activation.getLanguageConnectionContext());
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)cd.getConglomerateName());
            }
            this.createNewBackingCongloms(newCongloms, this.indexConglomerateNumbers, activation, this.dd);
            IndexRowGenerator[] newIRGs = new IndexRowGenerator[this.numIndexes];
            long[] newIndexConglomNumbers = new long[this.numIndexes];
            int i = 0;
            int j = 0;
            while (i < this.numIndexes) {
                while (this.compressIRGs[j] == null) {
                    ++j;
                }
                int[] baseColumnPositions = this.compressIRGs[j].baseColumnPositions();
                newIRGs[i] = this.compressIRGs[j];
                newIndexConglomNumbers[i] = this.indexConglomerateNumbers[j];
                boolean[] isAscending = this.compressIRGs[j].isAscending();
                boolean reMakeArrays = false;
                int size = baseColumnPositions.length;
                for (int k = 0; k < size; ++k) {
                    if (baseColumnPositions[k] > this.droppedColumnPosition) {
                        int n = k;
                        baseColumnPositions[n] = baseColumnPositions[n] - 1;
                        continue;
                    }
                    if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                    baseColumnPositions[k] = 0;
                    reMakeArrays = true;
                }
                if (reMakeArrays) {
                    int[] newBCP = new int[--size];
                    boolean[] newIsAscending = new boolean[size];
                    int step = 0;
                    for (int k = 0; k < size; ++k) {
                        if (step == 0 && baseColumnPositions[k + step] == 0) {
                            ++step;
                        }
                        newBCP[k] = baseColumnPositions[k + step];
                        newIsAscending[k] = isAscending[k + step];
                    }
                    IndexDescriptor id = this.compressIRGs[j].getIndexDescriptor();
                    id.setBaseColumnPositions(newBCP);
                    id.setIsAscending(newIsAscending);
                    id.setNumberOfOrderedColumns(id.numberOfOrderedColumns() - 1);
                }
                ++i;
                ++j;
            }
            this.compressIRGs = newIRGs;
            this.indexConglomerateNumbers = newIndexConglomNumbers;
        }
        if ((compressIndexResult = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])compressIndexResult[1];
            this.compressIRGs = (IndexRowGenerator[])compressIndexResult[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int index = 0; index < this.numIndexes; ++index) {
            int[] colIds = this.compressIRGs[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                this.indexedCols.set(colIds[index2]);
            }
        }
    }

    private void createNewBackingCongloms(ArrayList newConglomActions, long[] ixCongNums, Activation activation, DataDictionary dd) throws StandardException {
        int sz = newConglomActions.size();
        for (int i = 0; i < sz; ++i) {
            int j;
            CreateIndexConstantAction ca = (CreateIndexConstantAction)newConglomActions.get(i);
            if (dd.getConglomerateDescriptor(ca.getCreatedUUID()) == null) continue;
            this.executeConglomReplacement(ca, activation);
            long oldCongNum = ca.getReplacedConglomNumber();
            long newCongNum = ca.getCreatedConglomNumber();
            ConglomerateDescriptor[] tdCDs = this.td.getConglomerateDescriptors(oldCongNum);
            for (j = 0; j < tdCDs.length; ++j) {
                tdCDs[j].setConglomerateNumber(newCongNum);
            }
            if (ixCongNums == null) continue;
            for (j = 0; j < ixCongNums.length; ++j) {
                if (ixCongNums[j] != oldCongNum) continue;
                ixCongNums[j] = newCongNum;
            }
        }
    }

    private void setUpAllSorts(ExecRow sourceRow, RowLocation rl) throws StandardException {
        int index;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.collation = new int[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        int[] base_table_collation_ids = this.td.getColumnCollationIds();
        for (index = 0; index < this.numIndexes; ++index) {
            this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
            this.compressIRGs[index].getIndexRow(sourceRow, rl, this.indexRows[index], null);
            this.collation[index] = this.compressIRGs[index].getColumnCollationIds(this.td.getColumnDescriptorList());
            int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
            boolean[] isAscending = this.compressIRGs[index].isAscending();
            int numColumnOrderings = baseColumnPositions.length + 1;
            boolean reuseWrappers = this.numIndexes == 1;
            BasicSortObserver sortObserver = new BasicSortObserver(false, false, this.indexRows[index], reuseWrappers);
            this.ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            this.sortIds[index] = this.tc.createSort(null, this.indexRows[index].getRowArrayClone(), this.ordering[index], sortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (index = 0; index < this.numIndexes; ++index) {
            this.sorters[index] = this.tc.openSort(this.sortIds[index]);
            this.needToDropSort[index] = true;
        }
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int index;
            int bulkFetched = 0;
            bulkFetched = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = bulkFetched != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += bulkFetched;
            for (index = 0; index < bulkFetched; ++index) {
                this.validRow[index] = true;
            }
            for (index = bulkFetched; index < this.bulkFetchSize; ++index) {
                this.validRow[index] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (int i = 0; i < this.currentRow.nColumns(); ++i) {
                    this.currentRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(i + 1) : this.baseRow[this.currentCompressRow].getColumn(i + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    public void rowLocation(RowLocation rl) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int maxIndex = this.compressIRGs.length;
            if (maxIndex > 1 && this.sequential) {
                maxIndex = 1;
            }
            for (int index = 0; index < maxIndex; ++index) {
                this.insertIntoSorter(index, rl);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int index, RowLocation rl) throws StandardException {
        this.indexRows[index].getNewObjectArray();
        this.compressIRGs[index].getIndexRow(this.currentRow, (RowLocation)rl.cloneObject(), this.indexRows[index], null);
        this.sorters[index].insert(this.indexRows[index].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int index;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (index = 0; index < this.compressIRGs.length; ++index) {
                if (this.sorters[index] != null) {
                    this.sorters[index].completedInserts();
                }
                this.sorters[index] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (index = 0; index < this.needToDropSort.length; ++index) {
                if (!this.needToDropSort[index]) continue;
                this.tc.dropSort(this.sortIds[index]);
                this.needToDropSort[index] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController tc) throws StandardException {
        int numRows = 0;
        ScanController sc = tc.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (sc.next() && ++numRows != 2) {
        }
        sc.close();
        return numRows;
    }

    private void updateNewColumnToDefault(Activation activation, ColumnDescriptor columnDescriptor, LanguageConnectionContext lcc) throws StandardException {
        DefaultInfo defaultInfo = columnDescriptor.getDefaultInfo();
        String columnName = columnDescriptor.getColumnName();
        String defaultText = defaultInfo.isGeneratedColumn() ? "default" : columnDescriptor.getDefaultInfo().getDefaultText();
        String updateStmt = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + columnName + "\" = " + defaultText;
        AlterTableConstantAction.executeUpdate(lcc, updateStmt);
    }

    private static void executeUpdate(LanguageConnectionContext lcc, String updateStmt) throws StandardException {
        PreparedStatement ps = lcc.prepareInternalStatement(updateStmt);
        ResultSet rs = ps.executeSubStatement(lcc, true, 0L);
        rs.close();
    }

    private long getColumnMax(Activation activation, TableDescriptor td, String columnName, long increment, long initial) throws StandardException {
        String maxStr = increment > 0L ? "MAX" : "MIN";
        String maxStmt = "SELECT " + maxStr + "(\"" + columnName + "\")" + "FROM \"" + td.getSchemaName() + "\".\"" + td.getName() + "\"";
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        PreparedStatement ps = lcc.prepareInternalStatement(maxStmt);
        ResultSet rs = ps.executeSubStatement(lcc, false, 0L);
        DataValueDescriptor[] rowArray = rs.getNextRow().getRowArray();
        rs.close();
        rs.finish();
        return rowArray[0].getLong();
    }

    private void dropAllColumnDefaults(UUID tableId, DataDictionary dd) throws StandardException {
        ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (cd.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDesc = cd.getDefaultDescriptor(dd);
            this.dm.clearDependencies(this.lcc, defaultDesc);
        }
    }

    private void openBulkFetchScan(long heapConglomNumber) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(heapConglomNumber, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(Activation activation, String columnName, long initial, long increment) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        lcc.setAutoincrementUpdate(true);
        lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnName, new Long(initial), increment, 0);
        String updateStmt = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + columnName + "\" = " + "org.apache.derby.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + "'" + this.td.getSchemaName() + "'" + "," + "'" + this.td.getName() + "'" + "," + "'" + columnName + "'" + ")";
        try {
            try {
                AlterTableConstantAction.executeUpdate(lcc, updateStmt);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("22003")) {
                    throw StandardException.newException("42Z24", se, (Object)this.td.getName(), (Object)columnName);
                }
                throw se;
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            lcc.autoincrementFlushCache(this.td.getUUID());
            lcc.setAutoincrementUpdate(false);
            throw throwable;
        }
        lcc.autoincrementFlushCache(this.td.getUUID());
        lcc.setAutoincrementUpdate(false);
    }

    private boolean validateNotNullConstraint(String[] columnNames, boolean[] nullCols, int numRows, LanguageConnectionContext lcc, String errorMsg) throws StandardException {
        boolean foundNullable = false;
        StringBuffer constraintText = new StringBuffer();
        for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
            ColumnDescriptor cd = this.td.getColumnDescriptor(columnNames[colCtr]);
            if (cd == null) {
                throw StandardException.newException("42X14", (Object)columnNames[colCtr], (Object)this.td.getName());
            }
            if (!cd.getType().isNullable()) continue;
            if (numRows > 0) {
                if (foundNullable) {
                    constraintText.append(" AND ");
                }
                constraintText.append(IdUtil.normalToDelimited(columnNames[colCtr]) + " IS NOT NULL ");
            }
            foundNullable = true;
            nullCols[colCtr] = true;
        }
        if (foundNullable && numRows > 0 && !ConstraintConstantAction.validateConstraint(null, constraintText.toString(), this.td, lcc, false)) {
            if (errorMsg.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            if (errorMsg.equals("X0Y63.S.1")) {
                throw StandardException.newException("X0Y63.S.1", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", (Object)this.td.getQualifiedName(), (Object)columnNames[0]);
        }
        return foundNullable;
    }

    private Object[] compressIndexArrays(long[] indexCIDS, IndexRowGenerator[] irgs) {
        long[] workSpace = new long[indexCIDS.length];
        int j = 0;
        int k = indexCIDS.length - 1;
        for (int i = 0; i < indexCIDS.length; ++i) {
            int m;
            for (m = 0; m < j; ++m) {
                if (indexCIDS[i] != workSpace[m]) continue;
                workSpace[k--] = i;
                break;
            }
            if (m != j) continue;
            workSpace[j++] = indexCIDS[i];
        }
        if (j < indexCIDS.length) {
            long[] newIndexCIDS = new long[j];
            IndexRowGenerator[] newIrgs = new IndexRowGenerator[j];
            int[] duplicateIndexes = new int[indexCIDS.length - j];
            k = 0;
            int n = indexCIDS.length - 1;
            for (int m = 0; m < indexCIDS.length; ++m) {
                if (m < j) {
                    newIndexCIDS[m] = workSpace[m];
                } else {
                    duplicateIndexes[indexCIDS.length - m - 1] = (int)workSpace[m];
                }
                if (n >= j && m == (int)workSpace[n]) {
                    --n;
                    continue;
                }
                newIrgs[k] = irgs[m];
                ++k;
            }
            Object[] returnValue = new Object[]{duplicateIndexes, newIndexCIDS, newIrgs};
            return returnValue;
        }
        return null;
    }
}

