/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.BulkTableScanResultSet;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.InsertConstantAction;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RIBulkChecker;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.ValueRow;

class InsertResultSet
extends DMLWriteResultSet
implements TargetResultSet {
    private NoPutResultSet sourceResultSet;
    NoPutResultSet savedSource;
    InsertConstantAction constants;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private long heapConglom;
    private ResultSet autoGeneratedKeysResultSet;
    private TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    private RowChanger rowChanger;
    private TransactionController tc;
    private ExecRow row;
    boolean userSpecifiedBulkInsert;
    boolean bulkInsertPerformed;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private boolean firstRow = true;
    private boolean[] needToDropSort;
    private Hashtable indexConversionTable;
    private FormatableBitSet indexedCols;
    private ConglomerateController bulkHeapCC;
    protected DataDictionary dd;
    protected TableDescriptor td;
    private ExecIndexRow[] indexRows;
    private ExecRow fullTemplate;
    private long[] sortIds;
    private RowLocationRetRowSource[] rowSources;
    private ScanController bulkHeapSC;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private SortController[] sorters;
    private TemporaryRowHolderImpl rowHolder;
    private RowLocation rl;
    private boolean hasBeforeStatementTrigger;
    private boolean hasBeforeRowTrigger;
    private BulkTableScanResultSet tableScan;
    private int numOpens;
    private boolean firstExecute;
    private FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private NumberDataValue[] aiCache;
    protected boolean autoincrementGenerated;
    private long identityVal;
    private boolean setIdentity;

    public void changedRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        SanityManager.ASSERT(this.bulkInsert, "bulkInsert exected to be true");
        if (this.constants.irgs.length > 0) {
            RowLocation rlClone = (RowLocation)rowLocation.cloneObject();
            for (int i = 0; i < execRow.getRowArray().length; ++i) {
                if (!this.constants.indexedCols[i] || !(execRow.getRowArray()[i] instanceof StreamStorable)) continue;
                execRow.getRowArray()[i].getObject();
            }
            if (this.firstRow) {
                this.firstRow = false;
                this.indexRows = new ExecIndexRow[this.constants.irgs.length];
                this.setUpAllSorts(execRow.getNewNullRow(), rlClone);
            }
            for (int index = 0; index < this.constants.irgs.length; ++index) {
                this.indexRows[index].getNewObjectArray();
                this.constants.irgs[index].getIndexRow(execRow, rlClone, this.indexRows[index], null);
                this.sorters[index].insert(this.indexRows[index].getRowArray());
            }
        }
    }

    public ExecRow preprocessSourceRow(ExecRow execRow) throws StandardException {
        if (this.hasBeforeRowTrigger) {
            this.rowHolder.truncate();
            this.rowHolder.insert(execRow);
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
        }
        if (this.generationClauses != null) {
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, execRow, false);
        }
        if (this.checkGM != null && !this.hasBeforeStatementTrigger) {
            this.evaluateCheckConstraints();
        }
        if (this.constants.irgs.length > 0) {
            return execRow.getClone(this.indexedCols);
        }
        return execRow;
    }

    private void evaluateCheckConstraints() throws StandardException {
        if (this.checkGM != null) {
            this.checkGM.invoke(this.activation);
        }
    }

    InsertResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = source;
        this.constants = (InsertConstantAction)this.constantAction;
        this.generationClauses = generationClauses;
        this.checkGM = checkGM;
        this.heapConglom = this.constants.conglomId;
        this.tc = activation.getTransactionController();
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.hasBeforeStatementTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, false) : false;
        this.hasBeforeRowTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, true) : false;
        ResultDescription resultDescription = activation.getResultDescription();
        String insertMode = this.constants.getProperty("insertMode");
        RowLocation[] rla = this.constants.getAutoincRowLocation();
        if (rla != null) {
            this.aiCache = new NumberDataValue[rla.length];
            for (int i = 0; i < resultDescription.getColumnCount(); ++i) {
                if (rla[i] == null) continue;
                ResultColumnDescriptor rcd = resultDescription.getColumnDescriptor(i + 1);
                this.aiCache[i] = (NumberDataValue)rcd.getType().getNull();
            }
        }
        if (insertMode != null) {
            if (StringUtil.SQLEqualsIgnoreCase(insertMode, "BULKINSERT")) {
                this.userSpecifiedBulkInsert = true;
            } else if (StringUtil.SQLEqualsIgnoreCase(insertMode, "REPLACE")) {
                this.userSpecifiedBulkInsert = true;
                this.bulkInsertReplace = true;
                this.bulkInsert = true;
                if (this.triggerInfo != null) {
                    TriggerDescriptor td = this.triggerInfo.getTriggerArray()[0];
                    throw StandardException.newException("X0Y72.S", (Object)this.constants.getTableName(), (Object)td.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws StandardException {
        this.setup();
        this.firstExecute = this.rowChanger == null;
        this.autoincrementGenerated = false;
        this.dd = this.lcc.getDataDictionary();
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            if (this.activation.getAutoGeneratedKeysColumnIndexes() != null) {
                this.verifyAutoGeneratedColumnsIndexes(this.activation.getAutoGeneratedKeysColumnIndexes());
            } else if (this.activation.getAutoGeneratedKeysColumnNames() != null) {
                this.verifyAutoGeneratedColumnsNames(this.activation.getAutoGeneratedKeysColumnNames());
            }
        }
        this.rowCount = 0;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        if (this.userSpecifiedBulkInsert) {
            if (!this.bulkInsertReplace) {
                this.bulkInsert = this.verifyBulkInsert();
            } else {
                this.getExclusiveTableLock();
            }
        }
        if (this.bulkInsert) {
            this.sourceResultSet.setTargetResultSet(this);
            long baseTableConglom = this.bulkInsertCore(this.lcc, this.heapConglom);
            if (this.hasBeforeStatementTrigger) {
                this.tableScan = this.getTableScanResultSet(baseTableConglom);
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.tableScan);
                if (this.checkGM != null || this.generationClauses != null) {
                    this.tableScan = this.getTableScanResultSet(baseTableConglom);
                    try {
                        ExecRow currRow = null;
                        while ((currRow = this.tableScan.getNextRowCore()) != null) {
                            this.sourceResultSet.setCurrentRow(currRow);
                            this.evaluateCheckConstraints();
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.sourceResultSet.clearCurrentRow();
                        throw throwable;
                    }
                    this.sourceResultSet.clearCurrentRow();
                    {
                    }
                }
            }
            this.bulkValidateForeignKeys(this.tc, this.lcc.getContextManager());
            if (this.triggerInfo != null && (this.triggerInfo.hasTrigger(false, true) || this.triggerInfo.hasTrigger(false, false))) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.getTableScanResultSet(baseTableConglom));
            }
            this.bulkInsertPerformed = true;
        } else {
            this.row = this.getNextRowCore(this.sourceResultSet);
            this.normalInsertCore(this.lcc, this.firstExecute);
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
        this.cleanUp();
        if (this.aiCache != null) {
            HashMap<String, Long> aiHashtable = new HashMap<String, Long>();
            int numColumns = this.aiCache.length;
            for (int i = 0; i < numColumns; ++i) {
                if (this.aiCache[i] == null) continue;
                aiHashtable.put(AutoincrementCounter.makeIdentity(this.constants.getSchemaName(), this.constants.getTableName(), this.constants.getColumnName(i)), new Long(this.aiCache[i].getLong()));
            }
            InternalTriggerExecutionContext itec = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (itec == null) {
                this.lcc.copyHashtableToAIHT(aiHashtable);
            } else {
                itec.copyHashtableToAIHT(aiHashtable);
            }
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    public void close() throws StandardException {
        super.close();
        if (this.autoGeneratedKeysRowsHolder != null) {
            this.autoGeneratedKeysRowsHolder.close();
        }
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] columnIndexes) throws StandardException {
        int size = columnIndexes.length;
        TableDescriptor td = this.dd.getTableDescriptor(this.constants.targetUUID);
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = td.getColumnDescriptor(columnIndexes[i]);
            if (this.verifyAutoGenColumn(cd)) continue;
            throw StandardException.newException("X0X0E.S", (Object)new Integer(columnIndexes[i]), (Object)td.getName());
        }
    }

    private int[] generatedColumnPositionsArray() throws StandardException {
        int i;
        TableDescriptor td = this.dd.getTableDescriptor(this.constants.targetUUID);
        int size = td.getMaxColumnID();
        int[] generatedColumnPositionsArray = new int[size];
        int generatedColumnNumbers = 0;
        for (i = 0; i < size; ++i) {
            generatedColumnPositionsArray[i] = -1;
        }
        for (i = 0; i < size; ++i) {
            ColumnDescriptor cd = td.getColumnDescriptor(i + 1);
            if (cd.isAutoincrement()) {
                ++generatedColumnNumbers;
                generatedColumnPositionsArray[i] = i + 1;
                continue;
            }
            if (cd.getDefaultValue() == null && cd.getDefaultInfo() == null) continue;
            ++generatedColumnNumbers;
            generatedColumnPositionsArray[i] = i + 1;
        }
        int[] returnGeneratedColumnPositionsArray = new int[generatedColumnNumbers];
        int j = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (generatedColumnPositionsArray[i2] == -1) continue;
            returnGeneratedColumnPositionsArray[j++] = generatedColumnPositionsArray[i2];
        }
        return returnGeneratedColumnPositionsArray;
    }

    private int[] uniqueColumnPositionArray(int[] columnIndexes) throws StandardException {
        int size = columnIndexes.length;
        TableDescriptor td = this.dd.getTableDescriptor(this.constants.targetUUID);
        int[] uniqueColumnIndexes = new int[td.getMaxColumnID()];
        int uniqueColumnNumbers = 0;
        for (int i = 0; i < size; ++i) {
            if (uniqueColumnIndexes[columnIndexes[i] - 1] != 0) continue;
            ++uniqueColumnNumbers;
            uniqueColumnIndexes[columnIndexes[i] - 1] = columnIndexes[i];
        }
        int[] returnUniqueColumnIndexes = new int[uniqueColumnNumbers];
        int j = 0;
        for (int i = 0; i < uniqueColumnIndexes.length; ++i) {
            if (uniqueColumnIndexes[i] == 0) continue;
            returnUniqueColumnIndexes[j++] = uniqueColumnIndexes[i];
        }
        return returnUniqueColumnIndexes;
    }

    private void verifyAutoGeneratedColumnsNames(String[] columnNames) throws StandardException {
        int size = columnNames.length;
        int[] columnPositions = new int[size];
        TableDescriptor td = this.dd.getTableDescriptor(this.constants.targetUUID);
        for (int i = 0; i < size; ++i) {
            if (columnNames[i] == null) {
                throw StandardException.newException("X0X0F.S", (Object)columnNames[i], (Object)td.getName());
            }
            ColumnDescriptor cd = td.getColumnDescriptor(columnNames[i]);
            if (!this.verifyAutoGenColumn(cd)) {
                throw StandardException.newException("X0X0F.S", (Object)columnNames[i], (Object)td.getName());
            }
            columnPositions[i] = cd.getPosition();
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(columnPositions, null);
    }

    private boolean verifyAutoGenColumn(ColumnDescriptor cd) {
        return cd != null && cd.isAutoincrement();
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumberDataValue getSetAutoincrementValue(int columnPosition, long increment) throws StandardException {
        NumberDataValue newValue;
        int index;
        block13: {
            long startValue = 0L;
            index = columnPosition - 1;
            this.setIdentity = !this.autoincrementGenerated && this.isSourceRowResultSet();
            this.autoincrementGenerated = true;
            if (this.bulkInsert) {
                ColumnDescriptor cd = this.td.getColumnDescriptor(columnPosition);
                if (this.aiCache[index].isNull()) {
                    if (this.bulkInsertReplace) {
                        startValue = cd.getAutoincStart();
                    } else {
                        NumberDataValue dvd = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[index], this.tc, false, this.aiCache[index], true);
                        startValue = dvd.getLong();
                    }
                    this.lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), cd.getColumnName(), new Long(startValue), increment, columnPosition);
                }
                long ret = this.lcc.nextAutoincrementValue(this.td.getSchemaName(), this.td.getName(), cd.getColumnName());
                this.aiCache[columnPosition - 1].setValue(ret);
                return this.aiCache[index];
            }
            TransactionController nestedTC = null;
            TransactionController tcToUse = this.tc;
            try {
                tcToUse = nestedTC = this.tc.startNestedUserTransaction(false);
            }
            catch (StandardException se) {
                tcToUse = this.tc;
            }
            try {
                try {
                    newValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[index], tcToUse, true, this.aiCache[index], tcToUse == this.tc);
                }
                catch (StandardException se) {
                    if (tcToUse == this.tc) {
                        throw se;
                    }
                    if (!se.getMessageId().equals("40XL1")) {
                        if (!se.getMessageId().equals("22003")) throw se;
                        throw StandardException.newException("42Z24", se, (Object)this.constants.getTableName(), (Object)this.constants.getColumnName(index));
                    }
                    newValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[index], this.tc, true, this.aiCache[index], true);
                    Object var13_14 = null;
                    if (nestedTC != null) {
                        nestedTC.commit();
                        nestedTC.destroy();
                    }
                    break block13;
                }
                Object var13_13 = null;
                if (nestedTC == null) break block13;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (nestedTC == null) throw throwable;
                nestedTC.commit();
                nestedTC.destroy();
                throw throwable;
            }
            nestedTC.commit();
            nestedTC.destroy();
        }
        this.aiCache[index] = newValue;
        if (!this.setIdentity) return this.aiCache[index];
        this.identityVal = newValue.getLong();
        return this.aiCache[index];
    }

    private boolean isSourceRowResultSet() {
        boolean isRow = false;
        if (this.sourceResultSet instanceof NormalizeResultSet) {
            isRow = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return isRow;
    }

    private boolean isSingleRowResultSet() {
        boolean isRow = false;
        if (this.sourceResultSet instanceof RowResultSet) {
            isRow = true;
        } else if (this.sourceResultSet instanceof NormalizeResultSet) {
            isRow = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return isRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalInsertCore(LanguageConnectionContext lcc, boolean firstExecute) throws StandardException {
        int i;
        boolean setUserIdentity = this.constants.hasAutoincrement() && this.isSingleRowResultSet();
        boolean firstDeferredRow = true;
        ExecRow deferredRowBuffer = null;
        long user_autoinc = 0L;
        if (firstExecute) {
            this.rowChanger = lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, 0, this.tc, null, this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        } else {
            lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        int lockMode = this.decodeLockMode(this.constants.lockMode);
        this.rowChanger.open(lockMode);
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
        if (firstExecute && this.constants.deferred) {
            Properties properties = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties);
            this.rowChanger.setRowHolder(this.rowHolder);
        }
        int[] columnIndexes = null;
        if (firstExecute && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            columnIndexes = this.activation.getAutoGeneratedKeysColumnIndexes();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            columnIndexes = columnIndexes != null ? this.uniqueColumnPositionArray(columnIndexes) : this.generatedColumnPositionsArray();
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.activation, properties);
        }
        while (this.row != null) {
            if (this.activation.getAutoGeneratedKeysResultsetMode()) {
                this.autoGeneratedKeysRowsHolder.insert(this.getCompactRow(this.row, columnIndexes));
            }
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, this.row, false);
            if (this.constants.deferred) {
                this.rowHolder.insert(this.row);
            } else {
                this.evaluateCheckConstraints();
                if (this.fkChecker != null) {
                    this.fkChecker.doFKCheck(this.row);
                }
                if (this.constants.irgs.length > 0) {
                    DataValueDescriptor[] rowArray = this.row.getRowArray();
                    for (i = 0; i < rowArray.length; ++i) {
                        if (!this.constants.indexedCols[i] || !(rowArray[i] instanceof StreamStorable)) continue;
                        rowArray[i].getObject();
                    }
                }
                this.rowChanger.insertRow(this.row);
            }
            ++this.rowCount;
            if (setUserIdentity) {
                ColumnDescriptor cd;
                int col;
                this.dd = lcc.getDataDictionary();
                this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
                int maxColumns = this.td.getMaxColumnID();
                for (col = 1; col <= maxColumns && !(cd = this.td.getColumnDescriptor(col)).isAutoincrement(); ++col) {
                }
                if (col <= maxColumns) {
                    DataValueDescriptor dvd = this.row.cloneColumn(col);
                    user_autoinc = dvd.getLong();
                }
            }
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            if (this.triggerInfo != null) {
                Vector<AutoincrementCounter> v = null;
                if (this.aiCache != null) {
                    v = new Vector<AutoincrementCounter>();
                    for (i = 0; i < this.aiCache.length; ++i) {
                        if (this.aiCache[i] == null) continue;
                        String s = this.constants.getSchemaName();
                        String t = this.constants.getTableName();
                        String c = this.constants.getColumnName(i);
                        Long initialValue = lcc.lastAutoincrementValue(s, t, c);
                        AutoincrementCounter aic = new AutoincrementCounter(initialValue, this.constants.getAutoincIncrement(i), this.aiCache[i].getLong(), s, t, c, i + 1);
                        v.addElement(aic);
                    }
                }
                if (this.triggerActivator == null) {
                    this.triggerActivator = new TriggerEventActivator(lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, v);
                } else {
                    this.triggerActivator.reopen();
                }
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
            }
            CursorResultSet rs = this.rowHolder.getResultSet();
            try {
                rs.open();
                while ((deferredRowBuffer = rs.getNextRow()) != null) {
                    this.sourceResultSet.setCurrentRow(deferredRowBuffer);
                    this.evaluateCheckConstraints();
                    this.rowChanger.insertRow(deferredRowBuffer);
                }
                Object var18_17 = null;
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                this.sourceResultSet.clearCurrentRow();
                rs.close();
                throw throwable;
            }
            this.sourceResultSet.clearCurrentRow();
            rs.close();
            if (this.fkChecker != null) {
                rs = this.rowHolder.getResultSet();
                try {
                    rs.open();
                    while ((deferredRowBuffer = rs.getNextRow()) != null) {
                        this.fkChecker.doFKCheck(deferredRowBuffer);
                    }
                    Object var20_20 = null;
                }
                catch (Throwable throwable) {
                    Object var20_21 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                {
                }
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.rowHolder.getResultSet());
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
            this.fkChecker = null;
        }
        if (this.setIdentity) {
            lcc.setIdentityValue(this.identityVal);
        } else if (setUserIdentity) {
            lcc.setIdentityValue(user_autoinc);
        }
    }

    private ExecRow getCompactRow(ExecRow inputRow, int[] columnIndexes) throws StandardException {
        int numInputCols = inputRow.nColumns();
        if (columnIndexes == null) {
            ValueRow outRow = new ValueRow(numInputCols);
            DataValueDescriptor[] src = inputRow.getRowArray();
            DataValueDescriptor[] dst = outRow.getRowArray();
            System.arraycopy(src, 0, dst, 0, src.length);
            return outRow;
        }
        int numOutputCols = columnIndexes.length;
        ValueRow outRow = new ValueRow(numOutputCols);
        for (int i = 0; i < numOutputCols; ++i) {
            outRow.setColumn(i + 1, inputRow.getColumn(columnIndexes[i]));
        }
        return outRow;
    }

    private long bulkInsertCore(LanguageConnectionContext lcc, long oldHeapConglom) throws StandardException {
        this.fullTemplate = this.constants.getEmptyHeapRow(lcc);
        this.bulkHeapCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, this.constants.heapSCOCI, this.heapDCOCI);
        Properties properties = new Properties();
        this.bulkHeapCC.getInternalTablePropertySet(properties);
        if (this.triggerInfo != null) {
            this.triggerActivator = new TriggerEventActivator(lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, null);
        }
        if (this.hasBeforeRowTrigger && this.rowHolder != null) {
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties);
        }
        Properties targetProperties = this.constants.getTargetProperties();
        Enumeration<Object> key = targetProperties.keys();
        while (key.hasMoreElements()) {
            String keyValue = (String)key.nextElement();
            properties.put(keyValue, targetProperties.getProperty(keyValue));
        }
        if (this.constants.irgs.length > 0) {
            this.sourceResultSet.setNeedsRowLocation(true);
        }
        this.dd = lcc.getDataDictionary();
        this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
        long[] loadedRowCount = new long[1];
        long newHeapConglom = this.bulkInsertReplace ? this.tc.createAndLoadConglomerate("heap", this.fullTemplate.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, this.sourceResultSet, loadedRowCount) : this.tc.recreateAndLoadConglomerate("heap", false, this.fullTemplate.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, oldHeapConglom, this.sourceResultSet, loadedRowCount);
        if (newHeapConglom == oldHeapConglom) {
            return oldHeapConglom;
        }
        this.rowCount = (int)loadedRowCount[0];
        this.setEstimatedRowCount(newHeapConglom);
        this.dd.startWriting(lcc);
        lcc.autoincrementFlushCache(this.constants.targetUUID);
        DependencyManager dm = this.dd.getDependencyManager();
        dm.invalidateFor(this.td, 15, lcc);
        if (this.constants.irgs.length > 0) {
            this.updateAllIndexes(newHeapConglom, this.constants, this.td, this.dd, this.fullTemplate);
        }
        this.bulkHeapCC.close();
        this.bulkHeapCC = null;
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        return newHeapConglom;
    }

    private void bulkValidateForeignKeys(TransactionController tc, ContextManager cm) throws StandardException {
        if (this.indexRows == null && !this.bulkInsertReplace || this.fkInfoArray == null) {
            return;
        }
        for (int i = 0; i < this.fkInfoArray.length; ++i) {
            FKInfo fkInfo = this.fkInfoArray[i];
            if (this.bulkInsertReplace) {
                for (int index = 0; index < fkInfo.fkConglomNumbers.length; ++index) {
                    long fkConglom;
                    long pkConglom;
                    if (fkInfo.fkIsSelfReferencing[index] && this.indexRows == null) continue;
                    if (fkInfo.fkIsSelfReferencing[index]) {
                        pkConglom = (Long)this.indexConversionTable.get(new Long(fkInfo.refConglomNumber));
                        fkConglom = (Long)this.indexConversionTable.get(new Long(fkInfo.fkConglomNumbers[index]));
                    } else {
                        Long pkConglomLong = (Long)this.indexConversionTable.get(new Long(fkInfo.refConglomNumber));
                        Long fkConglomLong = (Long)this.indexConversionTable.get(new Long(fkInfo.fkConglomNumbers[index]));
                        pkConglom = pkConglomLong == null ? fkInfo.refConglomNumber : pkConglomLong;
                        fkConglom = fkConglomLong == null ? fkInfo.fkConglomNumbers[index] : fkConglomLong;
                    }
                    this.bulkValidateForeignKeysCore(tc, cm, this.fkInfoArray[i], fkConglom, pkConglom, fkInfo.fkConstraintNames[index]);
                }
                continue;
            }
            SanityManager.ASSERT(fkInfo.type == 1, "error, expected to only check foreign keys on insert");
            Long fkConglom = (Long)this.indexConversionTable.get(new Long(fkInfo.fkConglomNumbers[0]));
            this.bulkValidateForeignKeysCore(tc, cm, this.fkInfoArray[i], fkConglom, fkInfo.refConglomNumber, fkInfo.fkConstraintNames[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkValidateForeignKeysCore(TransactionController tc, ContextManager cm, FKInfo fkInfo, long fkConglom, long pkConglom, String fkConstraintName) throws StandardException {
        GenericScanController refScan;
        block7: {
            refScan = null;
            GenericScanController fkScan = null;
            try {
                ExecRow template = this.makeIndexTemplate(fkInfo, this.fullTemplate, cm);
                fkScan = tc.openGroupFetchScan(fkConglom, false, 0, 7, 2, null, null, 1, null, null, -1);
                if (!this.bulkInsertReplace) {
                    SanityManager.ASSERT(fkScan.next(), "No rows in fk index, even though indexRows != null");
                    fkScan.reopenScan(null, 1, null, null, -1);
                }
                refScan = tc.openGroupFetchScan(pkConglom, false, 0, fkConglom == pkConglom ? 7 : 6, 2, null, null, 1, null, null, -1);
                ExecRow firstFailedRow = template.getClone();
                RIBulkChecker riChecker = new RIBulkChecker((GroupFetchScanController)refScan, (GroupFetchScanController)fkScan, template, true, null, firstFailedRow);
                int numFailures = riChecker.doCheck();
                if (numFailures > 0) {
                    StandardException se = StandardException.newException("23503", fkConstraintName, (Object)fkInfo.tableName, (Object)StatementUtil.typeName(fkInfo.stmtType), (Object)RowUtil.toString(firstFailedRow, 0, fkInfo.colArray.length - 1));
                    throw se;
                }
                Object var17_14 = null;
                if (fkScan == null) break block7;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                if (fkScan != null) {
                    fkScan.close();
                    fkScan = null;
                }
                if (refScan != null) {
                    refScan.close();
                    refScan = null;
                }
                throw throwable;
            }
            fkScan.close();
            fkScan = null;
        }
        if (refScan != null) {
            refScan.close();
            refScan = null;
        }
    }

    private ExecRow makeIndexTemplate(FKInfo fkInfo, ExecRow fullTemplate, ContextManager cm) throws StandardException {
        ExecIndexRow newRow = RowUtil.getEmptyIndexRow(fkInfo.colArray.length + 1, this.lcc);
        DataValueDescriptor[] templateColArray = fullTemplate.getRowArray();
        DataValueDescriptor[] newRowColArray = newRow.getRowArray();
        for (int i = 0; i < fkInfo.colArray.length; ++i) {
            newRowColArray[i] = templateColArray[fkInfo.colArray[i] - 1].getClone();
        }
        newRowColArray[i] = (DataValueDescriptor)fkInfo.rowLocation.cloneObject();
        return newRow;
    }

    private void setUpAllSorts(ExecRow sourceRow, RowLocation rl) throws StandardException {
        int index;
        int numIndexes = this.constants.irgs.length;
        int numColumns = this.td.getNumberOfColumns();
        this.ordering = new ColumnOrdering[numIndexes][];
        this.collation = new int[numIndexes][];
        this.needToDropSort = new boolean[numIndexes];
        this.sortIds = new long[numIndexes];
        this.rowSources = new RowLocationRetRowSource[numIndexes];
        this.indexedCols = new FormatableBitSet(numColumns + 1);
        for (index = 0; index < numIndexes; ++index) {
            int numColumnOrderings;
            boolean reuseWrappers;
            int[] keyColumns = this.constants.irgs[index].baseColumnPositions();
            for (int i2 = 0; i2 < keyColumns.length; ++i2) {
                this.indexedCols.set(keyColumns[i2]);
            }
            this.indexRows[index] = this.constants.irgs[index].getIndexRowTemplate();
            this.constants.irgs[index].getIndexRow(sourceRow, rl, this.indexRows[index], null);
            ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.constants.indexCIDS[index]);
            int[] baseColumnPositions = this.constants.irgs[index].baseColumnPositions();
            boolean[] isAscending = this.constants.irgs[index].isAscending();
            BasicSortObserver sortObserver = null;
            boolean bl = reuseWrappers = numIndexes == 1;
            if (cd.getIndexDescriptor().isUnique()) {
                numColumnOrderings = baseColumnPositions.length;
                String[] columnNames = this.getColumnNames(baseColumnPositions);
                String indexOrConstraintName = cd.getConglomerateName();
                if (cd.isConstraint()) {
                    ConstraintDescriptor conDesc = this.dd.getConstraintDescriptor(this.td, cd.getUUID());
                    indexOrConstraintName = conDesc.getConstraintName();
                }
                sortObserver = new UniqueIndexSortObserver(false, cd.isConstraint(), indexOrConstraintName, this.indexRows[index], reuseWrappers, this.td.getName());
            } else {
                numColumnOrderings = baseColumnPositions.length + 1;
                sortObserver = new BasicSortObserver(false, false, this.indexRows[index], reuseWrappers);
            }
            this.ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < isAscending.length; ++ii) {
                this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            if (numColumnOrderings > isAscending.length) {
                this.ordering[index][isAscending.length] = new IndexColumnOrder(isAscending.length);
            }
            this.collation[index] = this.constants.irgs[index].getColumnCollationIds(this.td.getColumnDescriptorList());
            this.sortIds[index] = this.tc.createSort(null, this.indexRows[index].getRowArrayClone(), this.ordering[index], sortObserver, false, (int)this.sourceResultSet.getEstimatedRowCount(), -1);
            this.needToDropSort[index] = true;
        }
        this.sorters = new SortController[numIndexes];
        for (index = 0; index < numIndexes; ++index) {
            this.sorters[index] = this.tc.openSort(this.sortIds[index]);
            this.needToDropSort[index] = true;
        }
    }

    private void updateAllIndexes(long newHeapConglom, InsertConstantAction constants, TableDescriptor td, DataDictionary dd, ExecRow fullTemplate) throws StandardException {
        int numIndexes = constants.irgs.length;
        if (this.indexRows == null) {
            if (this.bulkInsertReplace) {
                this.emptyIndexes(newHeapConglom, constants, td, dd, fullTemplate);
            }
            return;
        }
        dd.dropStatisticsDescriptors(td.getUUID(), null, this.tc);
        long[] newIndexCongloms = new long[numIndexes];
        this.indexConversionTable = new Hashtable(numIndexes);
        for (int index = 0; index < numIndexes; ++index) {
            Properties properties = new Properties();
            ConglomerateDescriptor cd = td.getConglomerateDescriptor(constants.indexCIDS[index]);
            ConglomerateController indexCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, constants.indexSCOCIs[index], this.indexDCOCIs[index]);
            indexCC.getInternalTablePropertySet(properties);
            int indexRowLength = this.indexRows[index].nColumns();
            properties.put("baseConglomerateId", Long.toString(newHeapConglom));
            if (cd.getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(indexRowLength));
            }
            properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
            properties.put("nKeyFields", Integer.toString(indexRowLength));
            indexCC.close();
            this.sorters[index].completedInserts();
            this.sorters[index] = null;
            this.rowSources[index] = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
            newIndexCongloms[index] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0, this.rowSources[index], null);
            CardinalityCounter cCount = (CardinalityCounter)this.rowSources[index];
            long numRows = cCount.getRowCount();
            if (numRows > 0L) {
                long[] c = cCount.getCardinality();
                DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
                for (int i = 0; i < c.length; ++i) {
                    StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cd.getUUID(), td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                    dd.addDescriptor(statDesc, null, 14, true, this.tc);
                }
            }
            dd.updateConglomerateDescriptor(td.getConglomerateDescriptors(constants.indexCIDS[index]), newIndexCongloms[index], this.tc);
            this.tc.dropConglomerate(constants.indexCIDS[index]);
            this.indexConversionTable.put(new Long(constants.indexCIDS[index]), new Long(newIndexCongloms[index]));
        }
    }

    public void cleanUp() throws StandardException {
        int index;
        if (this.tableScan != null) {
            this.tableScan.close();
            this.tableScan = null;
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        this.numOpens = 0;
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.bulkHeapCC != null) {
            this.bulkHeapCC.close();
            this.bulkHeapCC = null;
        }
        if (this.bulkHeapSC != null) {
            this.bulkHeapSC.close();
            this.bulkHeapSC = null;
        }
        if (this.sorters != null) {
            for (index = 0; index < this.constants.irgs.length; ++index) {
                if (this.sorters[index] != null) {
                    this.sorters[index].completedInserts();
                }
                this.sorters[index] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (index = 0; index < this.needToDropSort.length; ++index) {
                if (!this.needToDropSort[index]) continue;
                this.tc.dropSort(this.sortIds[index]);
                this.needToDropSort[index] = false;
            }
        }
        if (this.rowSources != null) {
            for (index = 0; index < this.rowSources.length; ++index) {
                if (this.rowSources[index] == null) continue;
                this.rowSources[index].closeRowSource();
                this.rowSources[index] = null;
            }
        }
        super.close();
    }

    protected boolean verifyBulkInsert() throws StandardException {
        if (this.constants.deferred) {
            SanityManager.ASSERT(!this.bulkInsertReplace, "bulkInsertReplace expected to be false for deferred mode inserts");
            return false;
        }
        return this.getExclusiveTableLock();
    }

    private boolean getExclusiveTableLock() throws StandardException {
        boolean rowFound = false;
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        if (!this.bulkInsertReplace) {
            rowFound = this.bulkHeapSC.next();
        } else {
            this.rl = this.bulkHeapSC.newRowLocationTemplate();
        }
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
        return !rowFound;
    }

    private void setEstimatedRowCount(long heapConglom) throws StandardException {
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        this.bulkHeapSC.setEstimatedRowCount(this.rowCount);
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
    }

    private void emptyIndexes(long newHeapConglom, InsertConstantAction constants, TableDescriptor td, DataDictionary dd, ExecRow fullTemplate) throws StandardException {
        int index;
        int numIndexes = constants.irgs.length;
        ExecIndexRow[] indexRows = new ExecIndexRow[numIndexes];
        ExecRow baseRows = null;
        ColumnOrdering[][] ordering = new ColumnOrdering[numIndexes][];
        int numColumns = td.getNumberOfColumns();
        FormatableBitSet bitSet = new FormatableBitSet(numColumns + 1);
        int numReferencedColumns = 0;
        for (int index2 = 0; index2 < numIndexes; ++index2) {
            int[] baseColumnPositions = constants.irgs[index2].baseColumnPositions();
            for (int bcp = 0; bcp < baseColumnPositions.length; ++bcp) {
                if (bitSet.get(baseColumnPositions[bcp])) continue;
                bitSet.set(baseColumnPositions[bcp]);
                ++numReferencedColumns;
            }
        }
        baseRows = this.activation.getExecutionFactory().getValueRow(numReferencedColumns);
        int colNumber = 0;
        for (index = 0; index < numColumns; ++index) {
            if (!bitSet.get(index + 1)) continue;
            baseRows.setColumn(++colNumber, fullTemplate.getColumn(index + 1).getClone());
        }
        this.needToDropSort = new boolean[numIndexes];
        this.sortIds = new long[numIndexes];
        for (index = 0; index < numIndexes; ++index) {
            int numColumnOrderings;
            indexRows[index] = constants.irgs[index].getIndexRowTemplate();
            constants.irgs[index].getIndexRow(baseRows, this.rl, indexRows[index], bitSet);
            ConglomerateDescriptor cd = td.getConglomerateDescriptor(constants.indexCIDS[index]);
            int[] baseColumnPositions = constants.irgs[index].baseColumnPositions();
            boolean[] isAscending = constants.irgs[index].isAscending();
            BasicSortObserver sortObserver = null;
            if (cd.getIndexDescriptor().isUnique()) {
                numColumnOrderings = baseColumnPositions.length;
                String[] columnNames = this.getColumnNames(baseColumnPositions);
                String indexOrConstraintName = cd.getConglomerateName();
                if (cd.isConstraint()) {
                    ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                    indexOrConstraintName = conDesc.getConstraintName();
                }
                sortObserver = new UniqueIndexSortObserver(false, cd.isConstraint(), indexOrConstraintName, indexRows[index], true, td.getName());
            } else {
                numColumnOrderings = baseColumnPositions.length + 1;
                sortObserver = new BasicSortObserver(false, false, indexRows[index], true);
            }
            ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < isAscending.length; ++ii) {
                ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            if (numColumnOrderings > isAscending.length) {
                ordering[index][isAscending.length] = new IndexColumnOrder(isAscending.length);
            }
            this.sortIds[index] = this.tc.createSort(null, indexRows[index].getRowArrayClone(), ordering[index], sortObserver, false, this.rowCount, -1);
            this.needToDropSort[index] = true;
        }
        this.rowSources = new RowLocationRetRowSource[numIndexes];
        SortController[] sorters = new SortController[numIndexes];
        for (int index3 = 0; index3 < numIndexes; ++index3) {
            sorters[index3] = this.tc.openSort(this.sortIds[index3]);
            sorters[index3].completedInserts();
            this.rowSources[index3] = this.tc.openSortRowSource(this.sortIds[index3]);
        }
        long[] newIndexCongloms = new long[numIndexes];
        for (int index4 = 0; index4 < numIndexes; ++index4) {
            Properties properties = new Properties();
            ConglomerateDescriptor cd = td.getConglomerateDescriptor(constants.indexCIDS[index4]);
            ConglomerateController indexCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, constants.indexSCOCIs[index4], this.indexDCOCIs[index4]);
            indexCC.getInternalTablePropertySet(properties);
            int indexRowLength = indexRows[index4].nColumns();
            properties.put("baseConglomerateId", Long.toString(newHeapConglom));
            if (cd.getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(indexRowLength));
            }
            properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
            properties.put("nKeyFields", Integer.toString(indexRowLength));
            indexCC.close();
            newIndexCongloms[index4] = this.tc.createAndLoadConglomerate("BTREE", indexRows[index4].getRowArray(), null, this.collation[index4], properties, 0, this.rowSources[index4], null);
            dd.updateConglomerateDescriptor(td.getConglomerateDescriptors(constants.indexCIDS[index4]), newIndexCongloms[index4], this.tc);
            this.tc.dropConglomerate(constants.indexCIDS[index4]);
        }
    }

    private BulkTableScanResultSet getTableScanResultSet(long conglomId) throws StandardException {
        if (this.tableScan == null) {
            this.tableScan = new BulkTableScanResultSet(conglomId, this.tc.getStaticCompiledConglomInfo(conglomId), this.activation, new MyRowAllocator(this.fullTemplate), 0, null, 0, null, 0, false, null, "tableName", null, null, false, false, -1, -1, 7, true, 2, 16, false, 0.0, 0.0);
            this.tableScan.openCore();
        } else {
            this.tableScan.reopenCore();
        }
        return this.tableScan;
    }

    private String[] getColumnNames(int[] baseColumnPositions) {
        int length = baseColumnPositions.length;
        String[] columnNames = new String[length];
        for (int i = 0; i < length; ++i) {
            columnNames[i] = this.constants.getColumnName(i);
        }
        return columnNames;
    }

    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }

    class MyRowAllocator
    implements GeneratedMethod {
        private ExecRow row;

        MyRowAllocator(ExecRow row) {
            this.row = row;
        }

        public Object invoke(Object ref) {
            return this.row.getClone();
        }
    }
}

