/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private boolean dumpedStats;
    NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;
    private int firstColumn = -1;
    private int[] generatedColumnPositions;
    private DataValueDescriptor[] normalizedGeneratedValues;

    NoRowsResultSetImpl(Activation activation) throws StandardException {
        this.activation = activation;
        if (activation == null) {
            SanityManager.THROWASSERT("activation is null in result set " + this.getClass());
        }
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
        StatementContext sc = this.lcc.getStatementContext();
        sc.setTopResultSet(this, null);
        this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
    }

    void setup() throws StandardException {
        this.isOpen = true;
    }

    public final boolean returnsRows() {
        return false;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public final Activation getActivation() {
        return this.activation;
    }

    public final ExecRow getAbsoluteRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    public final ExecRow getRelativeRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    public final void clearCurrentRow() {
    }

    public final boolean checkRowPosition(int isType) {
        return false;
    }

    public final int getRowNumber() {
        return 0;
    }

    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (!this.dumpedStats) {
            if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit() && !this.activation.isClosed()) {
                HeaderPrintWriter istream;
                this.endExecutionTime = this.getCurrentTimeMillis();
                ResultSetStatisticsFactory rssf = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory();
                this.lcc.setRunTimeStatisticsObject(rssf.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter = istream = this.lcc.getLogQueryPlan() ? Monitor.getStream() : null;
                if (istream != null) {
                    istream.printlnWithHeader("(XID = " + this.lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + this.lcc.getInstanceNumber() + "), " + this.lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + this.lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            this.dumpedStats = true;
        }
        int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int index = 0; index < staLength; ++index) {
            if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
            this.subqueryTrackingArray[index].close();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution()) {
            this.activation.close();
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
    }

    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int depth) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    public long getTimeSpent(int type) {
        return 0L;
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static void evaluateACheckConstraint(GeneratedMethod checkGM, String checkName, long heapConglom, Activation activation) throws StandardException {
        DataValueDescriptor checkBoolean;
        if (checkGM != null && (checkBoolean = (DataValueDescriptor)checkGM.invoke(activation)) != null && !checkBoolean.isNull() && !checkBoolean.getBoolean()) {
            DataDictionary dd = activation.getLanguageConnectionContext().getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(heapConglom);
            TableDescriptor td = dd.getTableDescriptor(cd.getTableID());
            StandardException se = StandardException.newException("23513", (Object)td.getQualifiedName(), (Object)checkName);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evaluateGenerationClauses(GeneratedMethod generationClauses, Activation activation, NoPutResultSet source, ExecRow newRow, boolean isUpdate) throws StandardException {
        ExecRow oldRow;
        block6: {
            if (generationClauses == null) return;
            oldRow = (ExecRow)activation.getCurrentRow(source.resultSetNumber());
            try {
                source.setCurrentRow(newRow);
                generationClauses.invoke(activation);
                if (this.firstColumn < 0) {
                    this.firstColumn = NormalizeResultSet.computeStartColumn(isUpdate, activation.getResultDescription());
                }
                if (this.generatedColumnPositions == null) {
                    this.setupGeneratedColumns(activation, (ValueRow)newRow);
                }
                ResultDescription resultDescription = activation.getResultDescription();
                int count = this.generatedColumnPositions.length;
                for (int i = 0; i < count; ++i) {
                    int position = this.generatedColumnPositions[i];
                    DataValueDescriptor normalizedColumn = NormalizeResultSet.normalizeColumn(resultDescription.getColumnDescriptor(position).getType(), newRow, position, this.normalizedGeneratedValues[i], resultDescription);
                    newRow.setColumn(position, normalizedColumn);
                }
                Object var13_12 = null;
                if (oldRow != null) break block6;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (oldRow == null) {
                    source.clearCurrentRow();
                    throw throwable;
                }
                source.setCurrentRow(oldRow);
                throw throwable;
            }
            source.clearCurrentRow();
            return;
        }
        source.setCurrentRow(oldRow);
    }

    private void setupGeneratedColumns(Activation activation, ValueRow newRow) throws StandardException {
        ResultDescription resultDescription = activation.getResultDescription();
        int columnCount = resultDescription.getColumnCount();
        ExecRow emptyRow = newRow.getNewNullRow();
        int generatedColumnCount = 0;
        for (int i = 1; i <= columnCount; ++i) {
            ResultColumnDescriptor rcd;
            if (i < this.firstColumn || !(rcd = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            ++generatedColumnCount;
        }
        this.generatedColumnPositions = new int[generatedColumnCount];
        this.normalizedGeneratedValues = new DataValueDescriptor[generatedColumnCount];
        int idx = 0;
        for (int i = 1; i <= columnCount; ++i) {
            ResultColumnDescriptor rcd;
            if (i < this.firstColumn || !(rcd = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            this.generatedColumnPositions[idx] = i;
            this.normalizedGeneratedValues[idx] = emptyRow.getColumn(i);
            ++idx;
        }
    }

    public static void evaluateCheckConstraints(GeneratedMethod checkGM, Activation activation) throws StandardException {
        if (checkGM != null) {
            checkGM.invoke(activation);
        }
    }

    public boolean doesCommit() {
        return false;
    }

    public SQLWarning getWarnings() {
        return null;
    }
}

