/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class RenameConstantAction
extends DDLSingleTableConstantAction {
    private String fullTableName;
    private String tableName;
    private String newTableName;
    private String oldObjectName;
    private String newObjectName;
    private UUID schemaId;
    private SchemaDescriptor sd;
    private boolean usedAlterTable;
    private int renamingWhat;

    public RenameConstantAction(String fullTableName, String tableName, String oldObjectName, String newObjectName, SchemaDescriptor sd, UUID tableId, boolean usedAlterTable, int renamingWhat) {
        super(tableId);
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        this.usedAlterTable = usedAlterTable;
        this.renamingWhat = renamingWhat;
        switch (this.renamingWhat) {
            case 1: {
                this.newTableName = newObjectName;
                this.oldObjectName = null;
                this.newObjectName = newObjectName;
                break;
            }
            case 2: 
            case 3: {
                this.oldObjectName = oldObjectName;
                this.newObjectName = newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameConstantAction");
            }
        }
        SanityManager.ASSERT(sd != null, "SchemaDescriptor is null");
    }

    public String toString() {
        String renameString = this.usedAlterTable ? "ALTER TABLE " : "RENAME ";
        switch (this.renamingWhat) {
            case 1: {
                if (this.usedAlterTable) {
                    renameString = renameString + this.fullTableName + " RENAME TO " + this.newTableName;
                    break;
                }
                renameString = renameString + " TABLE " + this.fullTableName + " TO " + this.newTableName;
                break;
            }
            case 2: {
                if (this.usedAlterTable) {
                    renameString = renameString + this.fullTableName + " RENAME " + this.oldObjectName + " TO " + this.newObjectName;
                    break;
                }
                renameString = renameString + " COLUMN " + this.fullTableName + "." + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
            case 3: {
                renameString = renameString + " INDEX " + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameConstantAction");
            }
        }
        return renameString;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        if (this.sd == null) {
            this.sd = RenameConstantAction.getAndCheckSchemaDescriptor(dd, this.schemaId, "RENAME TABLE");
        }
        long heapId = td.getHeapConglomerateId();
        this.lockTableForDDL(tc, heapId, true);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        switch (this.renamingWhat) {
            case 1: {
                this.execGutsRenameTable(td, activation);
                break;
            }
            case 2: {
                this.execGutsRenameColumn(td, activation);
                break;
            }
            case 3: {
                this.execGutsRenameIndex(td, activation);
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameConstantAction");
            }
        }
    }

    private void execGutsRenameTable(TableDescriptor td, Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(td, 34, lcc);
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(td);
        for (int index = 0; index < constraintDescriptorList.size(); ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor)) continue;
            dm.invalidateFor(constraintDescriptor, 34, lcc);
        }
        dd.dropTableDescriptor(td, this.sd, tc);
        td.setTableName(this.newTableName);
        dd.addDescriptor(td, this.sd, 1, false, tc);
    }

    private void execGutsRenameColumn(TableDescriptor td, Activation activation) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        int columnPosition = 0;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        columnDescriptor = td.getColumnDescriptor(this.oldObjectName);
        columnPosition = columnDescriptor.getPosition();
        FormatableBitSet toRename = new FormatableBitSet(td.getColumnDescriptorList().size() + 1);
        toRename.set(columnPosition);
        td.setReferencedColumnMap(toRename);
        dm.invalidateFor(td, 34, lcc);
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(td);
        for (int index = 0; index < constraintDescriptorList.size(); ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            int[] referencedColumns = constraintDescriptor.getReferencedColumns();
            int numRefCols = referencedColumns.length;
            for (int j = 0; j < numRefCols; ++j) {
                if (referencedColumns[j] != columnPosition || !(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor)) continue;
                dm.invalidateFor(constraintDescriptor, 34, lcc);
            }
        }
        dd.dropColumnDescriptor(td.getUUID(), this.oldObjectName, tc);
        columnDescriptor.setColumnName(this.newObjectName);
        dd.addDescriptor(columnDescriptor, td, 2, false, tc);
        td = dd.getTableDescriptor(td.getObjectID());
    }

    private void execGutsRenameIndex(TableDescriptor td, Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(td, 41, lcc);
        ConglomerateDescriptor conglomerateDescriptor = dd.getConglomerateDescriptor(this.oldObjectName, this.sd, true);
        if (conglomerateDescriptor == null) {
            throw StandardException.newException("X0X99.S", this.oldObjectName);
        }
        dd.dropConglomerateDescriptor(conglomerateDescriptor, tc);
        conglomerateDescriptor.setConglomerateName(this.newObjectName);
        dd.addDescriptor(conglomerateDescriptor, this.sd, 0, false, tc);
    }

    public String getTableName() {
        return this.tableName;
    }
}

