/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;

final class StreamFileContainerHandle
implements StreamContainerHandle,
Observer {
    private final UUID rawStoreId;
    protected final ContainerKey identity;
    protected boolean active;
    protected StreamFileContainer container;
    protected RawTransaction xact;
    private boolean hold;

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, ContainerKey identity, boolean hold) {
        this.identity = identity;
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
    }

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, StreamFileContainer container, boolean hold) {
        this.identity = container.getIdentity();
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
        this.container = container;
    }

    public void getContainerProperties(Properties prop) throws StandardException {
        this.container.getContainerProperties(prop);
    }

    public boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        return this.container.fetchNext(row);
    }

    public void close() {
        if (this.xact == null) {
            SanityManager.ASSERT(!this.active);
            return;
        }
        this.active = false;
        this.container.close();
        this.container = null;
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    public void removeContainer() throws StandardException {
        this.container.removeContainer();
    }

    public ContainerKey getId() {
        return this.identity;
    }

    public void update(Observable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT("still on observr list " + this);
        }
        if (this.xact == null) {
            return;
        }
        if (obj != this.xact) {
            SanityManager.THROWASSERT("Observable passed to update is incorrect expected " + this.xact + " got " + obj);
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            this.close();
            return;
        }
        if (arg.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            return;
        }
    }

    public boolean useContainer() throws StandardException {
        SanityManager.ASSERT(!this.active);
        SanityManager.ASSERT(this.container != null);
        if (!this.container.use(this)) {
            this.container = null;
            return false;
        }
        this.active = true;
        if (!this.hold) {
            this.xact.addObserver(this);
            this.xact.addObserver(new DropOnCommit(this.identity, true));
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        SanityManager.ASSERT(this.xact != null);
        return this.xact;
    }

    public String toString() {
        String str = new String();
        str = str + "StreamContainerHandle:(" + this.identity.toString() + ")";
        return str;
    }
}

