/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.params.ModifiableSolrParams;

public abstract class AbstractUpdateRequest
extends SolrRequest {
    protected ModifiableSolrParams params;
    protected int commitWithin = -1;

    public AbstractUpdateRequest(SolrRequest.METHOD m, String path) {
        super(m, path);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher) {
        return this.setAction(action, waitFlush, waitSearcher, 1);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        if (action == ACTION.OPTIMIZE) {
            this.params.set("optimize", new String[]{"true"});
            this.params.set("maxSegments", maxSegments);
        } else if (action == ACTION.COMMIT) {
            this.params.set("commit", new String[]{"true"});
        }
        this.params.set("waitFlush", new String[]{String.valueOf(waitFlush)});
        this.params.set("waitSearcher", new String[]{String.valueOf(waitSearcher)});
        return this;
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments, boolean expungeDeletes) {
        this.setAction(action, waitFlush, waitSearcher, maxSegments);
        this.params.set("expungeDeletes", new String[]{String.valueOf(expungeDeletes)});
        return this;
    }

    public AbstractUpdateRequest rollback() {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set("rollback", new String[]{"true"});
        return this;
    }

    public void setParam(String param, String value) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set(param, new String[]{value});
    }

    public void setParams(ModifiableSolrParams params) {
        this.params = params;
    }

    public ModifiableSolrParams getParams() {
        return this.params;
    }

    public UpdateResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        UpdateResponse res = new UpdateResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    public boolean isWaitFlush() {
        return this.params != null && this.params.getBool("waitFlush", false);
    }

    public boolean isWaitSearcher() {
        return this.params != null && this.params.getBool("waitSearcher", false);
    }

    public ACTION getAction() {
        if (this.params == null) {
            return null;
        }
        if (this.params.getBool("commit", false)) {
            return ACTION.COMMIT;
        }
        if (this.params.getBool("optimize", false)) {
            return ACTION.OPTIMIZE;
        }
        return null;
    }

    public void setWaitFlush(boolean waitFlush) {
        this.setParam("waitFlush", waitFlush + "");
    }

    public void setWaitSearcher(boolean waitSearcher) {
        this.setParam("waitSearcher", waitSearcher + "");
    }

    public int getCommitWithin() {
        return this.commitWithin;
    }

    public void setCommitWithin(int commitWithin) {
        this.commitWithin = commitWithin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ACTION {
        COMMIT,
        OPTIMIZE;

    }
}

