/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.WordDelimiterFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDelimiterFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private CharArraySet protectedWords = null;
    int generateWordParts = 0;
    int generateNumberParts = 0;
    int catenateWords = 0;
    int catenateNumbers = 0;
    int catenateAll = 0;
    int splitOnCaseChange = 0;
    int splitOnNumerics = 0;
    int preserveOriginal = 0;
    int stemEnglishPossessive = 0;

    @Override
    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            try {
                File protectedWordFiles = new File(wordFiles);
                if (protectedWordFiles.exists()) {
                    List wlist = loader.getLines(wordFiles);
                    this.protectedWords = new CharArraySet((Collection)wlist, false);
                } else {
                    List files = StrUtils.splitFileNames((String)wordFiles);
                    for (String file : files) {
                        List wlist = loader.getLines(file.trim());
                        if (this.protectedWords == null) {
                            this.protectedWords = new CharArraySet((Collection)wlist, false);
                            continue;
                        }
                        this.protectedWords.addAll((Collection)wlist);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.generateWordParts = this.getInt("generateWordParts", 1);
        this.generateNumberParts = this.getInt("generateNumberParts", 1);
        this.catenateWords = this.getInt("catenateWords", 0);
        this.catenateNumbers = this.getInt("catenateNumbers", 0);
        this.catenateAll = this.getInt("catenateAll", 0);
        this.splitOnCaseChange = this.getInt("splitOnCaseChange", 1);
        this.splitOnNumerics = this.getInt("splitOnNumerics", 1);
        this.preserveOriginal = this.getInt("preserveOriginal", 0);
        this.stemEnglishPossessive = this.getInt("stemEnglishPossessive", 1);
    }

    public WordDelimiterFilter create(TokenStream input) {
        return new WordDelimiterFilter(input, this.generateWordParts, this.generateNumberParts, this.catenateWords, this.catenateNumbers, this.catenateAll, this.splitOnCaseChange, this.preserveOriginal, this.splitOnNumerics, this.stemEnglishPossessive, this.protectedWords);
    }
}

