/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import org.apache.wsil.Description;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.apache.wsil.impl.extension.uddi.UDDIExtensionBuilder;
import org.apache.wsil.impl.extension.wsdl.WSDLExtensionBuilder;
import org.apache.wsil.util.FileListBuilder;
import org.apache.wsil.util.Util;
import org.apache.wsil.util.WSDLDocument;
import org.apache.wsil.util.WSILProperties;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceList;
import org.uddi4j.util.BusinessKey;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.ServiceKey;

public class WSILDocBuilder {
    protected static final int MAX_ROWS = 100;
    protected WSILDocument wsilDocument = null;

    public WSILDocBuilder() throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
    }

    public WSILDocBuilder(String string) throws WSILException, WSDLException, IOException {
        this.initWSDL(string);
    }

    public WSILDocBuilder(URL uRL) throws WSILException {
        this.initUDDI(uRL, null);
    }

    public WSILDocBuilder(URL uRL, String string) throws WSILException {
        this.initUDDI(uRL, string);
    }

    private void initWSDL(String string) throws WSILException, WSDLException, IOException {
        this.wsilDocument = WSILDocument.newInstance();
        this.wsilDocument.setDocumentURL(Util.formatURL(WSILProperties.WSIL_HOSTNAME, WSILProperties.WSIL_PORT, ""));
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        WSDLExtensionBuilder wSDLExtensionBuilder = (WSDLExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/");
        FileListBuilder fileListBuilder = new FileListBuilder(string, "wsdl");
        File[] fileArray = fileListBuilder.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                WSDLDocument wSDLDocument = new WSDLDocument(fileArray[i].getPath());
                String string2 = null;
                QName qName = null;
                javax.wsdl.Service[] serviceArray = null;
                if (!wSDLDocument.isServiceImplementation()) continue;
                String string3 = fileArray[i].getPath();
                int n = (string3 = string3.replace('\\', '/')).indexOf(string = string.replace('\\', '/')) != -1 ? string3.indexOf(string) + string.length() + 1 : 0;
                String string4 = string3.substring(n);
                string2 = string4.replace('\\', '/');
                serviceArray = wSDLDocument.getServices();
                Description description = this.wsilDocument.createDescription();
                description.setReferencedNamespace("http://schemas.xmlsoap.org/wsdl/");
                description.setLocation(string2);
                Reference reference = (Reference)wSDLExtensionBuilder.createElement(Reference.QNAME);
                for (int j = 0; j < serviceArray.length; ++j) {
                    WSILElement wSILElement;
                    Object[] objectArray = serviceArray[j].getPorts().values().toArray();
                    QName qName2 = null;
                    for (int k = 0; k < objectArray.length; ++k) {
                        qName = new QName(((Port)objectArray[k]).getBinding().getQName().getNamespaceURI(), ((Port)objectArray[k]).getBinding().getQName().getLocalPart());
                        if (qName2 != null && qName2.equals(qName)) continue;
                        qName2 = qName;
                        wSILElement = (ImplementedBinding)wSDLExtensionBuilder.createElement(ImplementedBinding.QNAME);
                        wSILElement.setBindingName(qName);
                        reference.setEndpointPresent(new Boolean("true"));
                        if (serviceArray.length > 1) {
                            ReferencedService referencedService = (ReferencedService)wSDLExtensionBuilder.createElement(ReferencedService.QNAME);
                            QName qName3 = new QName(wSDLDocument.getDefinitions().getTargetNamespace(), serviceArray[j].getQName().getLocalPart());
                            referencedService.setReferencedServiceName(qName3);
                            reference.setReferencedService(referencedService);
                        }
                        reference.addImplementedBinding((ImplementedBinding)wSILElement);
                    }
                    description.setExtensionElement(reference);
                    Service service = this.wsilDocument.createService();
                    wSILElement = this.wsilDocument.createServiceName();
                    wSILElement.setText(serviceArray[j].getQName().getLocalPart());
                    service.addServiceName((ServiceName)wSILElement);
                    service.addDescription(description);
                    this.wsilDocument.getInspection().addService(service);
                }
                continue;
            }
            catch (WSDLException wSDLException) {
                System.err.println("WSDL Exception occurred for:\"" + fileArray[i].getPath() + "\" error is: " + wSDLException.getMessage());
                continue;
            }
            catch (WSILException wSILException) {
                System.err.println("WSILExceptione occurred for:\"" + fileArray[i].getPath() + "\" error is: " + wSILException.getMessage());
            }
        }
    }

    private void initUDDI(URL uRL, String string) throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        UDDIExtensionBuilder uDDIExtensionBuilder = (UDDIExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/uddi/");
        try {
            Object object;
            BusinessService[] businessServiceArray;
            Properties properties = new Properties();
            properties.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
            properties.setProperty("org.uddi4j.inquiryURL", uRL.toString());
            UDDIProxy uDDIProxy = new UDDIProxy(properties);
            ServiceList serviceList = null;
            if (string == null) {
                serviceList = uDDIProxy.find_service("", "%", null, 100);
            } else {
                businessServiceArray = uDDIProxy.get_businessDetail(string);
                Vector vector = businessServiceArray.getBusinessEntityVector();
                object = null;
                if (vector.size() > 0) {
                    object = (BusinessEntity)vector.firstElement();
                }
                serviceList = uDDIProxy.find_service("", object.getDefaultNameString(), null, 100);
            }
            businessServiceArray = this.findServices(serviceList, uDDIProxy);
            for (int i = 0; i < businessServiceArray.length; ++i) {
                Serializable serializable;
                Object object2;
                object = businessServiceArray[i].getDefaultNameString();
                String string2 = businessServiceArray[i].getServiceKey();
                Description description = this.wsilDocument.createDescription();
                description.setReferencedNamespace("urn:uddi-org:api");
                ServiceDescription serviceDescription = (ServiceDescription)uDDIExtensionBuilder.createElement(ServiceDescription.QNAME);
                serviceDescription.setLocation(uRL.toString());
                ServiceKey serviceKey = serviceDescription.createServiceKey();
                serviceKey.setText(string2);
                serviceDescription.setServiceKey(serviceKey);
                BusinessDetail businessDetail = uDDIProxy.get_businessDetail(businessServiceArray[i].getBusinessKey());
                Vector vector = businessDetail.getBusinessEntityVector();
                BusinessEntity businessEntity = null;
                if (vector.size() > 0) {
                    businessEntity = (BusinessEntity)vector.firstElement();
                    object2 = businessEntity.getDiscoveryURLs();
                    serializable = object2.getDiscoveryURLVector();
                    for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                        serviceDescription.setDiscoveryURL((DiscoveryURL)((Vector)serializable).elementAt(j));
                    }
                }
                description.setExtensionElement(serviceDescription);
                object2 = this.wsilDocument.createService();
                serializable = this.wsilDocument.createServiceName();
                serializable.setText((String)object);
                object2.addServiceName((ServiceName)serializable);
                object2.addDescription(description);
                this.wsilDocument.getInspection().addService((Service)object2);
            }
        }
        catch (Exception exception) {
            throw new WSILException("Unable to create WSILDocBuilder", exception);
        }
    }

    public WSILDocument getWSILDocument() {
        return this.wsilDocument;
    }

    public void addLink(String string, String string2) {
        Link link = this.wsilDocument.createLink();
        link.setReferencedNamespace(string);
        link.setLocation(string2);
        this.wsilDocument.getInspection().addLink(link);
    }

    public void addLink(URL uRL) throws WSILException {
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        UDDIExtensionBuilder uDDIExtensionBuilder = (UDDIExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/uddi/");
        try {
            Properties properties = new Properties();
            properties.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
            properties.setProperty("org.uddi4j.inquiryURL", uRL.toString());
            UDDIProxy uDDIProxy = new UDDIProxy(properties);
            BusinessList businessList = uDDIProxy.find_business("%", null, 100);
            BusinessEntity[] businessEntityArray = null;
            businessEntityArray = this.findBusinessEntities(businessList.getBusinessInfos(), uDDIProxy);
            for (int i = 0; i < businessEntityArray.length; ++i) {
                Link link = this.wsilDocument.createLink();
                link.setReferencedNamespace("urn:uddi-org:api");
                String string = businessEntityArray[i].getBusinessKey();
                BusinessDescription businessDescription = (BusinessDescription)uDDIExtensionBuilder.createElement(BusinessDescription.QNAME);
                businessDescription.setLocation(uRL.toString());
                BusinessKey businessKey = businessDescription.createBusinessKey();
                businessKey.setText(string);
                businessDescription.setBusinessKey(businessKey);
                DiscoveryURLs discoveryURLs = businessEntityArray[i].getDiscoveryURLs();
                Vector vector = discoveryURLs.getDiscoveryURLVector();
                for (int j = 0; j < vector.size(); ++j) {
                    businessDescription.setDiscoveryURL((DiscoveryURL)vector.elementAt(j));
                }
                link.setExtensionElement(businessDescription);
                this.wsilDocument.getInspection().addLink(link);
            }
        }
        catch (Exception exception) {
            throw new WSILException("Unable to create WSILDocBuilder", exception);
        }
    }

    public void addService(String string) throws WSILException, WSDLException, IOException {
        this.initWSDL(string);
    }

    public void addService(URL uRL) throws WSILException {
        this.initUDDI(uRL, null);
    }

    protected BusinessService[] findServices(ServiceList serviceList, UDDIProxy uDDIProxy) throws WSILException {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = serviceList.getServiceInfos().getServiceInfoVector();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(((ServiceInfo)vector2.elementAt(i)).getServiceKey());
            }
            ServiceDetail serviceDetail = uDDIProxy.get_serviceDetail(vector);
            Vector vector3 = serviceDetail.getBusinessServiceVector();
            if (vector3.size() > 0) {
                objectArray = new BusinessService[vector3.size()];
                vector3.copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            throw new WSILException("Find services exception: " + exception.toString(), exception);
        }
        return objectArray;
    }

    protected BusinessEntity[] findBusinessEntities(BusinessInfos businessInfos, UDDIProxy uDDIProxy) throws WSILException {
        Object[] objectArray = null;
        try {
            BusinessDetail businessDetail;
            Vector vector;
            Vector vector2 = WSILDocBuilder.getBusinessKeyVector(businessInfos);
            if (vector2.size() > 0 && (vector = (businessDetail = uDDIProxy.get_businessDetail(vector2)).getBusinessEntityVector()).size() > 0) {
                objectArray = new BusinessEntity[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            throw new WSILException("Could not list all business entities.", exception);
        }
        return objectArray;
    }

    public static Vector getBusinessKeyVector(BusinessInfos businessInfos) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = businessInfos.getBusinessInfoVector();
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(((BusinessInfo)vector2.elementAt(i)).getBusinessKey());
        }
        return vector;
    }
}

