/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import java.util.Iterator;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private String tableName;
    private ObjectArray<Prepared> constraintCommands = ObjectArray.newInstance();
    private ObjectArray<Column> columns = ObjectArray.newInstance();
    private IndexColumn[] pkColumns;
    private boolean ifNotExists;
    private boolean persistIndexes = true;
    private boolean persistData = true;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean clustered;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = ObjectArray.newInstance();
        }
        this.columns.add(column);
    }

    public void addConstraintCommand(Prepared prepared) throws SQLException {
        if (prepared instanceof CreateIndex) {
            this.constraintCommands.add(prepared);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)prepared;
            boolean bl = alterTableAddConstraint.getType() == 3 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.constraintCommands.add(prepared);
            }
        }
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        block24: {
            this.session.commit(true);
            Database database = this.session.getDatabase();
            if (!database.isPersistent()) {
                this.persistIndexes = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
                if (this.ifNotExists) {
                    return 0;
                }
                throw Message.getSQLException(42101, this.tableName);
            }
            if (this.asQuery != null) {
                this.asQuery.prepare();
                if (this.columns.size() == 0) {
                    this.generateColumnsFromQuery();
                } else if (this.columns.size() != this.asQuery.getColumnCount()) {
                    throw Message.getSQLException(21002);
                }
            }
            if (this.pkColumns != null) {
                for (Column object2 : this.columns) {
                    for (IndexColumn indexColumn : this.pkColumns) {
                        if (!object2.getName().equals(indexColumn.columnName)) continue;
                        object2.setNullable(false);
                    }
                }
            }
            ObjectArray objectArray = ObjectArray.newInstance();
            for (Column column : this.columns) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int sQLException = this.getObjectId(true, true);
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), sQLException, this.temporary);
                }
                if ((sequence = column.getSequence()) == null) continue;
                objectArray.add(sequence);
            }
            int n = this.getObjectId(true, true);
            TableData tableData = this.getSchema().createTable(this.tableName, n, this.columns, this.temporary, this.persistIndexes, this.persistData, this.clustered, this.headPos, this.session);
            tableData.setComment(this.comment);
            tableData.setGlobalTemporary(this.globalTemporary);
            if (this.temporary && !this.globalTemporary) {
                if (this.onCommitDrop) {
                    tableData.setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    tableData.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(tableData);
            } else {
                database.addSchemaObject(this.session, tableData);
            }
            try {
                for (Column column : this.columns) {
                    column.prepareExpression(this.session);
                }
                Iterator<Object> iterator = objectArray.iterator();
                while (iterator.hasNext()) {
                    Sequence sequence = (Sequence)((Object)iterator.next());
                    tableData.addSequence(sequence);
                }
                for (Prepared prepared : this.constraintCommands) {
                    prepared.update();
                }
                if (this.asQuery == null) break block24;
                boolean bl = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setQuery(this.asQuery);
                    insert.setTable(tableData);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(bl);
                }
            }
            catch (SQLException sQLException) {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, tableData);
                throw sQLException;
            }
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ObjectArray<Expression> objectArray = this.asQuery.getExpressions();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = objectArray.get(i);
            int n3 = expression.getType();
            String string = expression.getAlias();
            long l = expression.getPrecision();
            int n4 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n3);
            if (l > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l && dataType.defaultPrecision < 127L)) {
                l = dataType.defaultPrecision;
            }
            if ((n2 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n2)) {
                n2 = dataType.defaultScale;
            }
            Column column = new Column(string, n3, l, n2, n4);
            this.addColumn(column);
        }
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) throws SQLException {
        if (this.pkColumns != null) {
            if (indexColumnArray.length != this.pkColumns.length) {
                throw Message.getSQLException(90017);
            }
            for (int i = 0; i < indexColumnArray.length; ++i) {
                if (indexColumnArray[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw Message.getSQLException(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl) {
        this.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setClustered(boolean bl) {
        this.clustered = bl;
    }

    public void setPersistData(boolean bl) {
        this.persistData = bl;
    }
}

