/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int Icode_DUP = -1;
    private static final int Icode_DUP2 = -2;
    private static final int Icode_SWAP = -3;
    private static final int Icode_POP = -4;
    private static final int Icode_POP_RESULT = -5;
    private static final int Icode_IFEQ_POP = -6;
    private static final int Icode_VAR_INC_DEC = -7;
    private static final int Icode_NAME_INC_DEC = -8;
    private static final int Icode_PROP_INC_DEC = -9;
    private static final int Icode_ELEM_INC_DEC = -10;
    private static final int Icode_REF_INC_DEC = -11;
    private static final int Icode_SCOPE_LOAD = -12;
    private static final int Icode_SCOPE_SAVE = -13;
    private static final int Icode_TYPEOFNAME = -14;
    private static final int Icode_NAME_AND_THIS = -15;
    private static final int Icode_PROP_AND_THIS = -16;
    private static final int Icode_ELEM_AND_THIS = -17;
    private static final int Icode_VALUE_AND_THIS = -18;
    private static final int Icode_CLOSURE_EXPR = -19;
    private static final int Icode_CLOSURE_STMT = -20;
    private static final int Icode_CALLSPECIAL = -21;
    private static final int Icode_RETUNDEF = -22;
    private static final int Icode_GOSUB = -23;
    private static final int Icode_STARTSUB = -24;
    private static final int Icode_RETSUB = -25;
    private static final int Icode_LINE = -26;
    private static final int Icode_SHORTNUMBER = -27;
    private static final int Icode_INTNUMBER = -28;
    private static final int Icode_LITERAL_NEW = -29;
    private static final int Icode_LITERAL_SET = -30;
    private static final int Icode_SPARE_ARRAYLIT = -31;
    private static final int Icode_REG_IND_C0 = -32;
    private static final int Icode_REG_IND_C1 = -33;
    private static final int Icode_REG_IND_C2 = -34;
    private static final int Icode_REG_IND_C3 = -35;
    private static final int Icode_REG_IND_C4 = -36;
    private static final int Icode_REG_IND_C5 = -37;
    private static final int Icode_REG_IND1 = -38;
    private static final int Icode_REG_IND2 = -39;
    private static final int Icode_REG_IND4 = -40;
    private static final int Icode_REG_STR_C0 = -41;
    private static final int Icode_REG_STR_C1 = -42;
    private static final int Icode_REG_STR_C2 = -43;
    private static final int Icode_REG_STR_C3 = -44;
    private static final int Icode_REG_STR1 = -45;
    private static final int Icode_REG_STR2 = -46;
    private static final int Icode_REG_STR4 = -47;
    private static final int Icode_GETVAR1 = -48;
    private static final int Icode_SETVAR1 = -49;
    private static final int Icode_UNDEF = -50;
    private static final int Icode_ZERO = -51;
    private static final int Icode_ONE = -52;
    private static final int Icode_ENTERDQ = -53;
    private static final int Icode_LEAVEDQ = -54;
    private static final int Icode_TAIL_CALL = -55;
    private static final int Icode_LOCAL_CLEAR = -56;
    private static final int MIN_ICODE = -56;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsICodeTop;
    private int itsStackDepth;
    private int itsLineNumber;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsLiteralIds = new ObjArray();
    private int itsExceptionTableTop;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_HANDLER_SLOT = 2;
    private static final int EXCEPTION_TYPE_SLOT = 3;
    private static final int EXCEPTION_LOCAL_SLOT = 4;
    private static final int EXCEPTION_SCOPE_SLOT = 5;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int ECF_TAIL = 1;

    private static String bytecodeName(int bytecode) {
        if (!Interpreter.validBytecode(bytecode)) {
            throw new IllegalArgumentException(String.valueOf(bytecode));
        }
        return String.valueOf(bytecode);
    }

    private static boolean validIcode(int icode) {
        return -56 <= icode && icode <= -1;
    }

    private static boolean validTokenCode(int token) {
        return 2 <= token && token <= 76;
    }

    private static boolean validBytecode(int bytecode) {
        return Interpreter.validIcode(bytecode) || Interpreter.validTokenCode(bytecode);
    }

    public Object compile(CompilerEnvirons compilerEnv, ScriptOrFnNode tree, String encodedSource, boolean returnFunction) {
        this.compilerEnv = compilerEnv;
        new NodeTransformer().transform(tree);
        if (returnFunction) {
            tree = tree.getFunctionNode(0);
        }
        this.scriptOrFn = tree;
        this.itsData = new InterpreterData(compilerEnv.getLanguageVersion(), this.scriptOrFn.getSourceName(), encodedSource);
        this.itsData.topLevel = true;
        if (returnFunction) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    public Script createScriptObject(Object bytecode, Object staticSecurityDomain) {
        InterpreterData idata = (InterpreterData)bytecode;
        return InterpretedFunction.createScript(this.itsData, staticSecurityDomain);
    }

    public Function createFunctionObject(Context cx, Scriptable scope, Object bytecode, Object staticSecurityDomain) {
        InterpreterData idata = (InterpreterData)bytecode;
        return InterpretedFunction.createFunction(cx, scope, this.itsData, staticSecurityDomain);
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode theFunction = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = theFunction.getFunctionType();
        this.itsData.itsNeedsActivation = theFunction.requiresActivation();
        this.itsData.itsName = theFunction.getFunctionName();
        if (!theFunction.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        this.generateICodeFromTree(theFunction.getLastChild());
    }

    private void generateICodeFromTree(Node tree) {
        Object[] tmp;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement(tree);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(62);
        }
        if (this.itsData.itsICode.length != this.itsICodeTop) {
            tmp = new byte[this.itsICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, this.itsICodeTop);
            this.itsData.itsICode = tmp;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            ObjToIntMap.Iterator iter = this.itsStrings.newIterator();
            iter.start();
            while (!iter.done()) {
                String str = (String)iter.getKey();
                int index = iter.getValue();
                if (this.itsData.itsStringTable[index] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[index] = str;
                iter.next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            tmp = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, tmp, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = tmp;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            tmp = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, tmp, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = tmp;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.itsLiteralIds.size() != 0) {
            this.itsData.literalIds = this.itsLiteralIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int functionCount = this.scriptOrFn.getFunctionCount();
        if (functionCount == 0) {
            return;
        }
        InterpreterData[] array = new InterpreterData[functionCount];
        for (int i = 0; i != functionCount; ++i) {
            FunctionNode def = this.scriptOrFn.getFunctionNode(i);
            Interpreter jsi = new Interpreter();
            jsi.compilerEnv = this.compilerEnv;
            jsi.scriptOrFn = def;
            jsi.itsData = new InterpreterData(this.itsData);
            jsi.generateFunctionICode();
            array[i] = jsi.itsData;
        }
        this.itsData.itsNestedFunctions = array;
    }

    private void generateRegExpLiterals() {
        int N = this.scriptOrFn.getRegexpCount();
        if (N == 0) {
            return;
        }
        Context cx = Context.getContext();
        RegExpProxy rep = ScriptRuntime.checkRegExpProxy(cx);
        Object[] array = new Object[N];
        for (int i = 0; i != N; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String flags = this.scriptOrFn.getRegexpFlags(i);
            array[i] = rep.compileRegExp(cx, string, flags);
        }
        this.itsData.itsRegExpLiterals = array;
    }

    private void updateLineNumber(Node node) {
        int lineno = node.getLineno();
        if (lineno != this.itsLineNumber && lineno >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = lineno;
            }
            this.itsLineNumber = lineno;
            this.addIcode(-26);
            this.addUint16(lineno & 0xFFFF);
        }
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node) {
        int type = node.getType();
        switch (type) {
            case 105: {
                int fnIndex = node.getExistingIntProp(1);
                int fnType = this.scriptOrFn.getFunctionNode(fnIndex).getFunctionType();
                if (fnType == 3) {
                    this.addIndexOp(-20, fnIndex);
                    break;
                }
                if (fnType == 1) break;
                throw Kit.codeBug();
            }
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: {
                Node child;
                this.updateLineNumber(node);
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.visitStatement(child);
                }
                break;
            }
            case 2: {
                Node child;
                this.visitExpression(child, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 137: {
                Node child;
                int local = this.allocLocal();
                node.putIntProp(2, local);
                this.updateLineNumber(node);
                while (child != null) {
                    this.visitStatement(child);
                    child = child.getNext();
                }
                this.addIndexOp(-56, local);
                this.releaseLocal(local);
                break;
            }
            case 110: {
                Node child;
                this.updateLineNumber(node);
                Node.Jump switchNode = (Node.Jump)node;
                this.visitExpression(child, 0);
                for (Node.Jump caseNode = (Node.Jump)child.getNext(); caseNode != null; caseNode = (Node.Jump)caseNode.getNext()) {
                    if (caseNode.getType() != 111) {
                        throw this.badTree(caseNode);
                    }
                    Node test = caseNode.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(test, 0);
                    this.addToken(45);
                    this.stackChange(-1);
                    this.addGoto(caseNode.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 127: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node child;
                Node target = ((Node.Jump)node).target;
                this.visitExpression(child, 0);
                this.addGoto(target, type);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node target = ((Node.Jump)node).target;
                this.addGoto(target, type);
                break;
            }
            case 131: {
                Node target = ((Node.Jump)node).target;
                this.addGoto(target, -23);
                break;
            }
            case 121: {
                Node child;
                this.stackChange(1);
                int finallyRegister = this.getLocalBlockRef(node);
                this.addIndexOp(-24, finallyRegister);
                this.stackChange(-1);
                while (child != null) {
                    this.visitStatement(child);
                    child = child.getNext();
                }
                this.addIndexOp(-25, finallyRegister);
                break;
            }
            case 129: 
            case 130: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addIcode(type == 129 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 77: {
                Node finallyTarget;
                Node child;
                Node.Jump tryNode = (Node.Jump)node;
                int exceptionObjectLocal = this.getLocalBlockRef(tryNode);
                int scopeLocal = this.allocLocal();
                this.addIndexOp(-13, scopeLocal);
                int tryStart = this.itsICodeTop;
                while (child != null) {
                    this.visitStatement(child);
                    child = child.getNext();
                }
                Node catchTarget = tryNode.target;
                if (catchTarget != null) {
                    int catchStartPC = this.itsLabelTable[this.getTargetLabel(catchTarget)];
                    this.addExceptionHandler(tryStart, catchStartPC, catchStartPC, false, exceptionObjectLocal, scopeLocal);
                }
                if ((finallyTarget = tryNode.getFinally()) != null) {
                    int finallyStartPC = this.itsLabelTable[this.getTargetLabel(finallyTarget)];
                    this.addExceptionHandler(tryStart, finallyStartPC, finallyStartPC, true, exceptionObjectLocal, scopeLocal);
                }
                this.addIndexOp(-56, scopeLocal);
                this.releaseLocal(scopeLocal);
                break;
            }
            case 56: {
                Node child;
                int localIndex = this.getLocalBlockRef(node);
                int scopeIndex = node.getExistingIntProp(14);
                String name = child.getString();
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addStringPrefix(name);
                this.addIndexPrefix(localIndex);
                this.addToken(56);
                this.addUint8(scopeIndex != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 49: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addToken(49);
                this.addUint16(this.itsLineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 50: {
                this.updateLineNumber(node);
                this.addIndexOp(50, this.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node child;
                this.updateLineNumber(node);
                if (child != null) {
                    this.visitExpression(child, 1);
                    this.addToken(4);
                    this.stackChange(-1);
                    break;
                }
                this.addIcode(-22);
                break;
            }
            case 62: {
                this.updateLineNumber(node);
                this.addToken(62);
                break;
            }
            case 57: 
            case 58: {
                Node child;
                this.visitExpression(child, 0);
                this.addIndexOp(type, this.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (this.itsStackDepth != 0) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int contextFlags) {
        int type = node.getType();
        int savedStackDepth = this.itsStackDepth;
        switch (type) {
            case 105: {
                int fnIndex = node.getExistingIntProp(1);
                FunctionNode fn = this.scriptOrFn.getFunctionNode(fnIndex);
                if (fn.getFunctionType() != 2) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-19, fnIndex);
                this.stackChange(1);
                break;
            }
            case 53: {
                int localIndex = this.getLocalBlockRef(node);
                this.addIndexOp(53, localIndex);
                this.stackChange(1);
                break;
            }
            case 85: {
                Node child;
                Node lastChild = node.getLastChild();
                for (child = node.getFirstChild(); child != lastChild; child = child.getNext()) {
                    this.visitExpression(child, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(child, contextFlags & 1);
                break;
            }
            case 134: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 37: 
            case 68: {
                Node child;
                if (type == 30) {
                    this.visitExpression(child, 0);
                } else {
                    this.generateCallFunAndThis(child);
                }
                int argCount = 0;
                while ((child = child.getNext()) != null) {
                    this.visitExpression(child, 0);
                    ++argCount;
                }
                int callType = node.getIntProp(10, 0);
                if (callType != 0) {
                    this.addIndexOp(-21, argCount);
                    this.addUint8(callType);
                    this.addUint8(type == 30 ? 1 : 0);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                } else {
                    if (type == 37 && (contextFlags & 1) != 0) {
                        type = -55;
                    }
                    this.addIndexOp(type, argCount);
                }
                if (type == 30) {
                    this.stackChange(-argCount);
                } else {
                    this.stackChange(-1 - argCount);
                }
                if (argCount <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = argCount;
                break;
            }
            case 100: 
            case 101: {
                Node child;
                this.visitExpression(child, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int afterSecondJumpStart = this.itsICodeTop;
                int jump = type == 101 ? 7 : 6;
                this.addForwardGoto(jump);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                child = child.getNext();
                this.visitExpression(child, contextFlags & 1);
                this.resolveForwardGoto(afterSecondJumpStart);
                break;
            }
            case 98: {
                Node child;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.visitExpression(child, 0);
                int elseJumpStart = this.itsICodeTop;
                this.addForwardGoto(7);
                this.stackChange(-1);
                this.visitExpression(ifThen, contextFlags & 1);
                int afterElseJumpStart = this.itsICodeTop;
                this.addForwardGoto(5);
                this.resolveForwardGoto(elseJumpStart);
                this.itsStackDepth = savedStackDepth;
                this.visitExpression(ifElse, contextFlags & 1);
                this.resolveForwardGoto(afterElseJumpStart);
                break;
            }
            case 33: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.addStringOp(33, child.getString());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addToken(type);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 122: {
                Node child;
                this.visitExpression(child, 0);
                if (type == 122) {
                    this.addIcode(-4);
                    this.addIcode(-50);
                    break;
                }
                this.addToken(type);
                break;
            }
            case 65: 
            case 67: {
                Node child;
                this.visitExpression(child, 0);
                this.addToken(type);
                break;
            }
            case 34: 
            case 135: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                String property = child.getString();
                child = child.getNext();
                if (type == 135) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, property);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addStringOp(34, property);
                this.stackChange(-1);
                break;
            }
            case 36: 
            case 136: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                child = child.getNext();
                if (type == 136) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(35);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addToken(36);
                this.stackChange(-2);
                break;
            }
            case 66: 
            case 138: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                if (type == 138) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(65);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addToken(66);
                this.stackChange(-1);
                break;
            }
            case 8: {
                Node child;
                String name = child.getString();
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addStringOp(8, name);
                this.stackChange(-1);
                break;
            }
            case 133: {
                String name = node.getString();
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.scriptOrFn.getParamOrVarIndex(name);
                }
                if (index == -1) {
                    this.addStringOp(-14, name);
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(54, index);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 38: 
            case 40: 
            case 48: {
                this.addStringOp(type, node.getString());
                this.stackChange(1);
                break;
            }
            case 102: 
            case 103: {
                Node child;
                this.visitIncDec(node, child);
                break;
            }
            case 39: {
                double num = node.getDouble();
                int inum = (int)num;
                if ((double)inum == num) {
                    if (inum == 0) {
                        this.addIcode(-51);
                        if (1.0 / num < 0.0) {
                            this.addToken(29);
                        }
                    } else if (inum == 1) {
                        this.addIcode(-52);
                    } else if ((short)inum == inum) {
                        this.addIcode(-27);
                        this.addUint16(inum & 0xFFFF);
                    } else {
                        this.addIcode(-28);
                        this.addInt(inum);
                    }
                } else {
                    int index = this.getDoubleIndex(num);
                    this.addIndexOp(39, index);
                }
                this.stackChange(1);
                break;
            }
            case 54: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String name = node.getString();
                int index = this.scriptOrFn.getParamOrVarIndex(name);
                this.addVarOp(54, index);
                this.stackChange(1);
                break;
            }
            case 55: {
                Node child;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String name = child.getString();
                child = child.getNext();
                this.visitExpression(child, 0);
                int index = this.scriptOrFn.getParamOrVarIndex(name);
                this.addVarOp(55, index);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: {
                this.addToken(type);
                this.stackChange(1);
                break;
            }
            case 59: 
            case 60: {
                this.addIndexOp(type, this.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 47: {
                int index = node.getExistingIntProp(4);
                this.addIndexOp(47, index);
                this.stackChange(1);
                break;
            }
            case 63: 
            case 64: {
                Node child;
                this.visitLiteral(node, child);
                break;
            }
            case 69: {
                Node child;
                this.visitExpression(child, 0);
                this.addStringOp(type, (String)node.getProp(17));
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                Node child;
                int memberTypeFlags = node.getIntProp(16, 0);
                int childCount = 0;
                do {
                    this.visitExpression(child, 0);
                    ++childCount;
                } while ((child = child.getNext()) != null);
                this.addIndexOp(type, memberTypeFlags);
                this.stackChange(1 - childCount);
                break;
            }
            case 142: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addIcode(-53);
                this.stackChange(-1);
                int queryPC = this.itsICodeTop;
                this.visitExpression(child.getNext(), 0);
                this.addBackwardGoto(-54, queryPC);
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                Node child;
                this.visitExpression(child, 0);
                this.addToken(type);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (savedStackDepth + 1 != this.itsStackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node left) {
        int type = left.getType();
        switch (type) {
            case 38: {
                String name = left.getString();
                this.addStringOp(-15, name);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 35: {
                Node target = left.getFirstChild();
                this.visitExpression(target, 0);
                Node id = target.getNext();
                if (type == 33) {
                    String property = id.getString();
                    this.addStringOp(-16, property);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(id, 0);
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(left, 0);
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node child) {
        int incrDecrMask = node.getExistingIntProp(13);
        int childType = child.getType();
        switch (childType) {
            case 54: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String name = child.getString();
                int i = this.scriptOrFn.getParamOrVarIndex(name);
                this.addVarOp(-7, i);
                this.addUint8(incrDecrMask);
                this.stackChange(1);
                break;
            }
            case 38: {
                String name = child.getString();
                this.addStringOp(-8, name);
                this.addUint8(incrDecrMask);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node object = child.getFirstChild();
                this.visitExpression(object, 0);
                String property = object.getNext().getString();
                this.addStringOp(-9, property);
                this.addUint8(incrDecrMask);
                break;
            }
            case 35: {
                Node object = child.getFirstChild();
                this.visitExpression(object, 0);
                Node index = object.getNext();
                this.visitExpression(index, 0);
                this.addIcode(-10);
                this.addUint8(incrDecrMask);
                this.stackChange(-1);
                break;
            }
            case 65: {
                Node ref = child.getFirstChild();
                this.visitExpression(ref, 0);
                this.addIcode(-11);
                this.addUint8(incrDecrMask);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visitLiteral(Node node, Node child) {
        void var4_5;
        int count;
        int type = node.getType();
        Object[] propertyIds = null;
        if (type == 63) {
            count = 0;
            for (Node n = child; n != null; n = n.getNext()) {
                ++count;
            }
        } else if (type == 64) {
            propertyIds = (Object[])node.getProp(12);
            count = propertyIds.length;
        } else {
            throw this.badTree(node);
        }
        this.addIndexOp(-29, (int)var4_5);
        this.stackChange(1);
        while (child != null) {
            this.visitExpression(child, 0);
            this.addIcode(-30);
            this.stackChange(-1);
            child = child.getNext();
        }
        if (type == 63) {
            int[] skipIndexes = (int[])node.getProp(11);
            if (skipIndexes == null) {
                this.addToken(63);
            } else {
                int index = this.itsLiteralIds.size();
                this.itsLiteralIds.add(skipIndexes);
                this.addIndexOp(-31, index);
            }
        } else {
            int index = this.itsLiteralIds.size();
            this.itsLiteralIds.add(propertyIds);
            this.addIndexOp(64, index);
        }
    }

    private int getLocalBlockRef(Node node) {
        Node localBlock = (Node)node.getProp(3);
        return localBlock.getExistingIntProp(2);
    }

    private int getTargetLabel(Node target) {
        int label = target.labelId();
        if (label != -1) {
            return label;
        }
        label = this.itsLabelTableTop;
        if (this.itsLabelTable == null || label == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] tmp = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, tmp, 0, label);
                this.itsLabelTable = tmp;
            }
        }
        this.itsLabelTableTop = label + 1;
        this.itsLabelTable[label] = -1;
        target.labelId(label);
        return label;
    }

    private void markTargetLabel(Node target) {
        int label = this.getTargetLabel(target);
        if (this.itsLabelTable[label] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[label] = this.itsICodeTop;
    }

    private void addGoto(Node target, int gotoOp) {
        int label = this.getTargetLabel(target);
        if (label >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        int targetPC = this.itsLabelTable[label];
        int gotoPC = this.itsICodeTop;
        if (Interpreter.validIcode(gotoOp)) {
            this.addIcode(gotoOp);
        } else {
            this.addToken(gotoOp);
        }
        if (targetPC != -1) {
            this.recordJump(gotoPC, targetPC);
            this.itsICodeTop += 2;
        } else {
            this.addUint16(0);
            int top = this.itsFixupTableTop;
            if (this.itsFixupTable == null || top == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] tmp = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, tmp, 0, top);
                    this.itsFixupTable = tmp;
                }
            }
            this.itsFixupTableTop = top + 1;
            this.itsFixupTable[top] = (long)label << 32 | (long)gotoPC;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long fixup = this.itsFixupTable[i];
            int label = (int)(fixup >> 32);
            int jumpSource = (int)fixup;
            int pc = this.itsLabelTable[label];
            if (pc == -1) {
                throw Kit.codeBug();
            }
            this.recordJump(jumpSource, pc);
        }
        this.itsFixupTableTop = 0;
    }

    private void addBackwardGoto(int gotoOp, int jumpPC) {
        if (jumpPC >= this.itsICodeTop) {
            throw Kit.codeBug();
        }
        int fromPC = this.itsICodeTop;
        this.addIcode(gotoOp);
        this.recordJump(fromPC, jumpPC);
        this.itsICodeTop += 2;
    }

    private void addForwardGoto(int gotoOp) {
        this.addToken(gotoOp);
        this.addUint16(0);
    }

    private void resolveForwardGoto(int fromPC) {
        if (fromPC + 3 > this.itsICodeTop) {
            throw Kit.codeBug();
        }
        this.recordJump(fromPC, this.itsICodeTop);
    }

    private void recordJump(int jumpSource, int jumpDestination) {
        int deltaCapacity;
        if (jumpSource == jumpDestination) {
            throw Kit.codeBug();
        }
        int offsetSite = jumpSource + 1;
        int offset = jumpDestination - jumpSource;
        if (offset != (short)offset) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(offsetSite, jumpDestination);
            offset = 0;
        }
        if ((deltaCapacity = offsetSite + 2 - this.itsData.itsICode.length) > 0) {
            this.increaseICodeCapasity(deltaCapacity);
        }
        this.itsData.itsICode[offsetSite] = (byte)(offset >> 8);
        this.itsData.itsICode[offsetSite + 1] = (byte)offset;
    }

    private void addToken(int token) {
        if (!Interpreter.validTokenCode(token)) {
            throw Kit.codeBug();
        }
        this.addUint8(token);
    }

    private void addIcode(int icode) {
        if (!Interpreter.validIcode(icode)) {
            throw Kit.codeBug();
        }
        this.addUint8(icode & 0xFF);
    }

    private void addUint8(int value) {
        if ((value & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int top = this.itsICodeTop;
        byte[] array = this.itsData.itsICode;
        if (top == array.length) {
            array = this.increaseICodeCapasity(1);
        }
        array[top] = (byte)value;
        this.itsICodeTop = top + 1;
    }

    private void addUint16(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int top = this.itsICodeTop;
        byte[] array = this.itsData.itsICode;
        if (top + 2 > array.length) {
            array = this.increaseICodeCapasity(2);
        }
        array[top] = (byte)(value >>> 8);
        array[top + 1] = (byte)value;
        this.itsICodeTop = top + 2;
    }

    private void addInt(int i) {
        int top = this.itsICodeTop;
        byte[] array = this.itsData.itsICode;
        if (top + 4 > array.length) {
            array = this.increaseICodeCapasity(4);
        }
        array[top] = (byte)(i >>> 24);
        array[top + 1] = (byte)(i >>> 16);
        array[top + 2] = (byte)(i >>> 8);
        array[top + 3] = (byte)i;
        this.itsICodeTop = top + 4;
    }

    private int getDoubleIndex(double num) {
        int index = this.itsDoubleTableTop;
        if (index == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, na, 0, index);
            this.itsData.itsDoubleTable = na;
        }
        this.itsData.itsDoubleTable[index] = num;
        this.itsDoubleTableTop = index + 1;
        return index;
    }

    private void addVarOp(int op, int varIndex) {
        switch (op) {
            case 54: 
            case 55: {
                if (varIndex < 128) {
                    this.addIcode(op == 54 ? -48 : -49);
                    this.addUint8(varIndex);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(op, varIndex);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int op, String str) {
        this.addStringPrefix(str);
        if (Interpreter.validIcode(op)) {
            this.addIcode(op);
        } else {
            this.addToken(op);
        }
    }

    private void addIndexOp(int op, int index) {
        this.addIndexPrefix(index);
        if (Interpreter.validIcode(op)) {
            this.addIcode(op);
        } else {
            this.addToken(op);
        }
    }

    private void addStringPrefix(String str) {
        int index = this.itsStrings.get(str, -1);
        if (index == -1) {
            index = this.itsStrings.size();
            this.itsStrings.put(str, index);
        }
        if (index < 4) {
            this.addIcode(-41 - index);
        } else if (index <= 255) {
            this.addIcode(-45);
            this.addUint8(index);
        } else if (index <= 65535) {
            this.addIcode(-46);
            this.addUint16(index);
        } else {
            this.addIcode(-47);
            this.addInt(index);
        }
    }

    private void addIndexPrefix(int index) {
        if (index < 0) {
            Kit.codeBug();
        }
        if (index < 6) {
            this.addIcode(-32 - index);
        } else if (index <= 255) {
            this.addIcode(-38);
            this.addUint8(index);
        } else if (index <= 65535) {
            this.addIcode(-39);
            this.addUint16(index);
        } else {
            this.addIcode(-40);
            this.addInt(index);
        }
    }

    private void addExceptionHandler(int icodeStart, int icodeEnd, int handlerStart, boolean isFinally, int exceptionObjectLocal, int scopeLocal) {
        int top = this.itsExceptionTableTop;
        int[] table = this.itsData.itsExceptionTable;
        if (table == null) {
            if (top != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = table = new int[12];
        } else if (table.length == top) {
            table = new int[table.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, table, 0, top);
            this.itsData.itsExceptionTable = table;
        }
        table[top + 0] = icodeStart;
        table[top + 1] = icodeEnd;
        table[top + 2] = handlerStart;
        table[top + 3] = isFinally ? 1 : 0;
        table[top + 4] = exceptionObjectLocal;
        table[top + 5] = scopeLocal;
        this.itsExceptionTableTop = top + 6;
    }

    private byte[] increaseICodeCapasity(int extraSize) {
        int top = this.itsICodeTop;
        int capacity = this.itsData.itsICode.length;
        if (top + extraSize <= capacity) {
            throw Kit.codeBug();
        }
        if (top + extraSize > (capacity *= 2)) {
            capacity = top + extraSize;
        }
        byte[] array = new byte[capacity];
        System.arraycopy(this.itsData.itsICode, 0, array, 0, top);
        this.itsData.itsICode = array;
        return array;
    }

    private void stackChange(int change) {
        if (change <= 0) {
            this.itsStackDepth += change;
        } else {
            int newDepth = this.itsStackDepth + change;
            if (newDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = newDepth;
            }
            this.itsStackDepth = newDepth;
        }
    }

    private int allocLocal() {
        int localSlot = this.itsLocalTop++;
        if (this.itsLocalTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.itsLocalTop;
        }
        return localSlot;
    }

    private void releaseLocal(int localSlot) {
        --this.itsLocalTop;
        if (localSlot != this.itsLocalTop) {
            Kit.codeBug();
        }
    }

    private static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame frame, boolean onlyFinally) {
        int[] exceptionTable = frame.idata.itsExceptionTable;
        if (exceptionTable == null) {
            return -1;
        }
        int pc = frame.pc - 1;
        int best = -1;
        int bestStart = 0;
        int bestEnd = 0;
        for (int i = 0; i != exceptionTable.length; i += 6) {
            int start = exceptionTable[i + 0];
            int end = exceptionTable[i + 1];
            if (start > pc || pc >= end || onlyFinally && exceptionTable[i + 3] != 1) continue;
            if (best >= 0) {
                if (bestEnd < end) continue;
                if (bestStart > start) {
                    Kit.codeBug();
                }
                if (bestEnd == end) {
                    Kit.codeBug();
                }
            }
            best = i;
            bestStart = start;
            bestEnd = end;
        }
        return best;
    }

    private static void dumpICode(InterpreterData idata) {
    }

    private static int bytecodeSpan(int bytecode) {
        switch (bytecode) {
            case 49: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 56: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(bytecode)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData data) {
        int span;
        UintMap presentLines = new UintMap();
        byte[] iCode = data.itsICode;
        int iCodeLength = iCode.length;
        for (int pc = 0; pc != iCodeLength; pc += span) {
            byte bytecode = iCode[pc];
            span = Interpreter.bytecodeSpan(bytecode);
            if (bytecode != -26) continue;
            if (span != 3) {
                Kit.codeBug();
            }
            int line = Interpreter.getIndex(iCode, pc + 1);
            presentLines.put(line, 0);
        }
        return presentLines.getKeys();
    }

    static void captureInterpreterStackInfo(RhinoException ex) {
        Object[] array;
        Context cx = Context.getCurrentContext();
        if (cx == null || cx.lastInterpreterFrame == null) {
            ex.interpreterStackInfo = null;
            ex.interpreterLineData = null;
            return;
        }
        if (cx.previousInterpreterInvocations == null || cx.previousInterpreterInvocations.size() == 0) {
            array = new CallFrame[1];
        } else {
            int previousCount = cx.previousInterpreterInvocations.size();
            if (cx.previousInterpreterInvocations.peek() == cx.lastInterpreterFrame) {
                --previousCount;
            }
            array = new CallFrame[previousCount + 1];
            cx.previousInterpreterInvocations.toArray(array);
        }
        array[array.length - 1] = (CallFrame)cx.lastInterpreterFrame;
        int interpreterFrameCount = 0;
        for (int i = 0; i != array.length; ++i) {
            interpreterFrameCount += 1 + ((CallFrame)array[i]).frameIndex;
        }
        int[] linePC = new int[interpreterFrameCount];
        int linePCIndex = interpreterFrameCount;
        int i = array.length;
        while (i != 0) {
            Object frame = array[--i];
            while (frame != null) {
                linePC[--linePCIndex] = ((CallFrame)frame).pcSourceLineStart;
                frame = ((CallFrame)frame).parentFrame;
            }
        }
        if (linePCIndex != 0) {
            Kit.codeBug();
        }
        ex.interpreterStackInfo = array;
        ex.interpreterLineData = linePC;
    }

    static String getSourcePositionFromStack(Context cx, int[] linep) {
        CallFrame frame = (CallFrame)cx.lastInterpreterFrame;
        InterpreterData idata = frame.idata;
        linep[0] = frame.pcSourceLineStart >= 0 ? Interpreter.getIndex(idata.itsICode, frame.pcSourceLineStart) : 0;
        return idata.itsSourceFile;
    }

    static String getPatchedStack(RhinoException ex, String nativeStackTrace) {
        String tag = "org.mozilla.javascript.Interpreter.interpretLoop";
        StringBuffer sb = new StringBuffer(nativeStackTrace.length() + 1000);
        String lineSeparator = System.getProperty("line.separator");
        CallFrame[] array = (CallFrame[])ex.interpreterStackInfo;
        int[] linePC = ex.interpreterLineData;
        int arrayIndex = array.length;
        int linePCIndex = linePC.length;
        int offset = 0;
        while (arrayIndex != 0) {
            char c;
            --arrayIndex;
            int pos = nativeStackTrace.indexOf(tag, offset);
            if (pos < 0) break;
            pos += tag.length();
            while (pos != nativeStackTrace.length() && (c = nativeStackTrace.charAt(pos)) != '\n' && c != '\r') {
                ++pos;
            }
            sb.append(nativeStackTrace.substring(offset, pos));
            offset = pos;
            CallFrame frame = array[arrayIndex];
            while (frame != null) {
                if (linePCIndex == 0) {
                    Kit.codeBug();
                }
                --linePCIndex;
                InterpreterData idata = frame.idata;
                sb.append(lineSeparator);
                sb.append("\tat script");
                if (idata.itsName != null && idata.itsName.length() != 0) {
                    sb.append('.');
                    sb.append(idata.itsName);
                }
                sb.append('(');
                sb.append(idata.itsSourceFile);
                int pc = linePC[linePCIndex];
                if (pc >= 0) {
                    sb.append(':');
                    sb.append(Interpreter.getIndex(idata.itsICode, pc));
                }
                sb.append(')');
                frame = frame.parentFrame;
            }
        }
        sb.append(nativeStackTrace.substring(offset));
        return sb.toString();
    }

    static String getEncodedSource(InterpreterData idata) {
        if (idata.encodedSource == null) {
            return null;
        }
        return idata.encodedSource.substring(idata.encodedSourceStart, idata.encodedSourceEnd);
    }

    private static void initFunction(Context cx, Scriptable scope, InterpretedFunction parent, int index) {
        InterpretedFunction fn = InterpretedFunction.createFunction(cx, scope, parent, index);
        ScriptRuntime.initFunction(cx, scope, fn, fn.idata.itsFunctionType, parent.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction ifun, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.hasTopCall(cx)) {
            Kit.codeBug();
        }
        if (cx.interpreterSecurityDomain != ifun.securityDomain) {
            Object savedDomain = cx.interpreterSecurityDomain;
            cx.interpreterSecurityDomain = ifun.securityDomain;
            try {
                Object object = ifun.securityController.callWithDomain(ifun.securityDomain, cx, ifun, scope, thisObj, args);
                return object;
            }
            finally {
                cx.interpreterSecurityDomain = savedDomain;
            }
        }
        CallFrame frame = new CallFrame();
        Interpreter.initFrame(cx, scope, thisObj, args, null, 0, args.length, ifun, null, frame);
        return Interpreter.interpretLoop(cx, frame, null);
    }

    public static Object restartContinuation(Continuation c, Context cx, Scriptable scope, Object[] args) {
        if (!ScriptRuntime.hasTopCall(cx)) {
            return ScriptRuntime.doTopCall(c, cx, scope, null, args);
        }
        Object arg = args.length == 0 ? Undefined.instance : args[0];
        CallFrame capturedFrame = (CallFrame)c.getImplementation();
        if (capturedFrame == null) {
            return arg;
        }
        ContinuationJump cjump = new ContinuationJump(c, null);
        cjump.result = arg;
        return Interpreter.interpretLoop(cx, null, cjump);
    }

    /*
     * Unable to fully structure code
     */
    private static Object interpretLoop(Context cx, CallFrame frame, Object throwable) {
        block269: {
            DBL_MRK = UniqueTag.DOUBLE_MARK;
            undefined = Undefined.instance;
            instructionCounting = cx.instructionThreshold != 0;
            INVOCATION_COST = 100;
            EXCEPTION_COST = 100;
            stringReg = null;
            indexReg = -1;
            if (cx.lastInterpreterFrame != null) {
                if (cx.previousInterpreterInvocations == null) {
                    cx.previousInterpreterInvocations = new ObjArray();
                }
                cx.previousInterpreterInvocations.push(cx.lastInterpreterFrame);
            }
            if (throwable != null && !(throwable instanceof ContinuationJump)) {
                Kit.codeBug();
            }
            interpreterResult = null;
            interpreterResultDbl = 0.0;
            block145: while (true) {
                block270: {
                    block268: {
                        try {
                            block146: while (true) {
                                if (throwable != null) {
                                    if (indexReg >= 0) {
                                        if (frame.frozen) {
                                            frame = frame.cloneFrozen();
                                        }
                                        table = frame.idata.itsExceptionTable;
                                        frame.pc = table[indexReg + 2];
                                        if (instructionCounting) {
                                            frame.pcPrevBranch = frame.pc;
                                        }
                                        frame.savedStackTop = frame.emptyStackTop;
                                        scopeLocal = frame.localShift + table[indexReg + 5];
                                        exLocal = frame.localShift + table[indexReg + 4];
                                        frame.scope = (Scriptable)frame.stack[scopeLocal];
                                        frame.stack[exLocal] = throwable;
                                        throwable = null;
                                    } else {
                                        cjump = (ContinuationJump)throwable;
                                        throwable = null;
                                        if (cjump.branchFrame != frame) {
                                            Kit.codeBug();
                                        }
                                        if (cjump.capturedFrame == null) {
                                            Kit.codeBug();
                                        }
                                        rewindCount = cjump.capturedFrame.frameIndex + 1;
                                        if (cjump.branchFrame != null) {
                                            rewindCount -= cjump.branchFrame.frameIndex;
                                        }
                                        enterCount = 0;
                                        enterFrames = null;
                                        x = cjump.capturedFrame;
                                        for (i = 0; i != rewindCount; ++i) {
                                            if (!x.frozen) {
                                                Kit.codeBug();
                                            }
                                            if (Interpreter.isFrameEnterExitRequired(x)) {
                                                if (enterFrames == null) {
                                                    enterFrames = new CallFrame[rewindCount - i];
                                                }
                                                enterFrames[enterCount] = x;
                                                ++enterCount;
                                            }
                                            x = x.parentFrame;
                                        }
                                        while (enterCount != 0) {
                                            x = enterFrames[--enterCount];
                                            Interpreter.enterFrame(cx, x, ScriptRuntime.emptyArgs);
                                        }
                                        frame = cjump.capturedFrame.cloneFrozen();
                                        Interpreter.setCallResult(frame, cjump.result, cjump.resultDbl);
                                    }
                                    if (throwable != null) {
                                        Kit.codeBug();
                                    }
                                } else if (frame.frozen) {
                                    Kit.codeBug();
                                }
                                stack = frame.stack;
                                sDbl = frame.sDbl;
                                vars = frame.varSource.stack;
                                varDbls = frame.varSource.sDbl;
                                iCode = frame.idata.itsICode;
                                strings = frame.idata.itsStringTable;
                                stackTop = frame.savedStackTop;
                                cx.lastInterpreterFrame = frame;
                                block149: while (true) {
                                    op = iCode[frame.pc++];
                                    switch (op) {
                                        case 49: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) {
                                                value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            --stackTop;
                                            sourceLine = Interpreter.getIndex(iCode, frame.pc);
                                            throwable = new JavaScriptException(value, frame.idata.itsSourceFile, sourceLine);
                                            break block268;
                                        }
                                        case 50: {
                                            throwable = stack[indexReg += frame.localShift];
                                            break block268;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            rhs = stack[--stackTop + 1];
                                            lhs = stack[stackTop];
                                            if (rhs != DBL_MRK) ** GOTO lbl102
                                            rDbl = sDbl[stackTop + 1];
                                            lDbl = Interpreter.stack_double(frame, stackTop);
                                            ** GOTO lbl105
lbl102:
                                            // 1 sources

                                            if (lhs != DBL_MRK) ** GOTO lbl120
                                            rDbl = ScriptRuntime.toNumber(rhs);
                                            lDbl = sDbl[stackTop];
lbl105:
                                            // 2 sources

                                            switch (op) {
                                                case 17: {
                                                    valBln = lDbl >= rDbl;
                                                    ** GOTO lbl135
                                                }
                                                case 15: {
                                                    valBln = lDbl <= rDbl;
                                                    ** GOTO lbl135
                                                }
                                                case 16: {
                                                    valBln = lDbl > rDbl;
                                                    ** GOTO lbl135
                                                }
                                                case 14: {
                                                    valBln = lDbl < rDbl;
                                                    ** GOTO lbl135
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl120:
                                            // 1 sources

                                            switch (op) {
                                                case 17: {
                                                    valBln = ScriptRuntime.cmp_LE(rhs, lhs);
                                                    break;
                                                }
                                                case 15: {
                                                    valBln = ScriptRuntime.cmp_LE(lhs, rhs);
                                                    break;
                                                }
                                                case 16: {
                                                    valBln = ScriptRuntime.cmp_LT(rhs, lhs);
                                                    break;
                                                }
                                                case 14: {
                                                    valBln = ScriptRuntime.cmp_LT(lhs, rhs);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl135:
                                            // 8 sources

                                            stack[stackTop] = ScriptRuntime.wrapBoolean(valBln);
                                            continue block149;
                                        }
                                        case 51: 
                                        case 52: {
                                            rhs = stack[stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            valBln = op == 51 ? ScriptRuntime.in(lhs, rhs, cx) : ScriptRuntime.instanceOf(lhs, rhs, cx);
                                            stack[stackTop] = ScriptRuntime.wrapBoolean(valBln);
                                            continue block149;
                                        }
                                        case 12: 
                                        case 13: {
                                            rhs = stack[--stackTop + 1];
                                            lhs = stack[stackTop];
                                            valBln = rhs == DBL_MRK ? (lhs == DBL_MRK ? sDbl[stackTop] == sDbl[stackTop + 1] : ScriptRuntime.eqNumber(sDbl[stackTop + 1], lhs)) : (lhs == DBL_MRK ? ScriptRuntime.eqNumber(sDbl[stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
                                            stack[stackTop] = ScriptRuntime.wrapBoolean(valBln ^= op == 13);
                                            continue block149;
                                        }
                                        case 45: 
                                        case 46: {
                                            rhs = stack[--stackTop + 1];
                                            lhs = stack[stackTop];
                                            if (rhs != DBL_MRK) ** GOTO lbl165
                                            rdbl = sDbl[stackTop + 1];
                                            if (lhs != DBL_MRK) ** GOTO lbl160
                                            ldbl = sDbl[stackTop];
                                            ** GOTO lbl177
lbl160:
                                            // 1 sources

                                            if (!(lhs instanceof Number)) ** GOTO lbl163
                                            ldbl = ((Number)lhs).doubleValue();
                                            ** GOTO lbl177
lbl163:
                                            // 1 sources

                                            valBln = false;
                                            ** GOTO lbl178
lbl165:
                                            // 1 sources

                                            if (lhs != DBL_MRK) ** GOTO lbl175
                                            ldbl = sDbl[stackTop];
                                            if (rhs != DBL_MRK) ** GOTO lbl170
                                            rdbl = sDbl[stackTop + 1];
                                            ** GOTO lbl177
lbl170:
                                            // 1 sources

                                            if (!(rhs instanceof Number)) ** GOTO lbl173
                                            rdbl = ((Number)rhs).doubleValue();
                                            ** GOTO lbl177
lbl173:
                                            // 1 sources

                                            valBln = false;
                                            ** GOTO lbl178
lbl175:
                                            // 1 sources

                                            valBln = ScriptRuntime.shallowEq(lhs, rhs);
                                            ** GOTO lbl178
lbl177:
                                            // 4 sources

                                            valBln = ldbl == rdbl;
lbl178:
                                            // 4 sources

                                            stack[stackTop] = ScriptRuntime.wrapBoolean(valBln ^= op == 46);
                                            continue block149;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(frame, stackTop--)) break;
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(frame, stackTop--)) break;
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(frame, stackTop--)) {
                                                frame.pc += 2;
                                                continue block149;
                                            }
                                            stack[stackTop--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = frame.pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (stackTop == frame.emptyStackTop + 1) {
                                                stack[indexReg += frame.localShift] = stack[stackTop];
                                                sDbl[indexReg] = sDbl[stackTop];
                                                --stackTop;
                                                continue block149;
                                            }
                                            if (stackTop == frame.emptyStackTop) continue block149;
                                            Kit.codeBug();
                                            continue block149;
                                        }
                                        case -25: {
                                            if (instructionCounting) {
                                                Interpreter.addInstructionCount(cx, frame, 0);
                                            }
                                            if ((value = stack[indexReg += frame.localShift]) != DBL_MRK) {
                                                throwable = value;
                                                break block268;
                                            }
                                            frame.pc = (int)sDbl[indexReg];
                                            if (!instructionCounting) continue block149;
                                            frame.pcPrevBranch = frame.pc;
                                            continue block149;
                                        }
                                        case -4: {
                                            stack[stackTop] = null;
                                            --stackTop;
                                            continue block149;
                                        }
                                        case -5: {
                                            frame.result = stack[stackTop];
                                            frame.resultDbl = sDbl[stackTop];
                                            stack[stackTop] = null;
                                            --stackTop;
                                            continue block149;
                                        }
                                        case -1: {
                                            stack[stackTop + 1] = stack[stackTop];
                                            sDbl[stackTop + 1] = sDbl[stackTop];
                                            ++stackTop;
                                            continue block149;
                                        }
                                        case -2: {
                                            stack[stackTop + 1] = stack[stackTop - 1];
                                            sDbl[stackTop + 1] = sDbl[stackTop - 1];
                                            stack[stackTop + 2] = stack[stackTop];
                                            sDbl[stackTop + 2] = sDbl[stackTop];
                                            stackTop += 2;
                                            continue block149;
                                        }
                                        case -3: {
                                            o = stack[stackTop];
                                            stack[stackTop] = stack[stackTop - 1];
                                            stack[stackTop - 1] = o;
                                            d = sDbl[stackTop];
                                            sDbl[stackTop] = sDbl[stackTop - 1];
                                            sDbl[stackTop - 1] = d;
                                            continue block149;
                                        }
                                        case 4: {
                                            frame.result = stack[stackTop];
                                            frame.resultDbl = sDbl[stackTop];
                                            --stackTop;
                                            break block149;
                                        }
                                        case 62: {
                                            break block149;
                                        }
                                        case -22: {
                                            frame.result = undefined;
                                            break block149;
                                        }
                                        case 27: {
                                            rIntValue = Interpreter.stack_int32(frame, stackTop);
                                            stack[stackTop] = DBL_MRK;
                                            sDbl[stackTop] = ~rIntValue;
                                            continue block149;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            rIntValue = Interpreter.stack_int32(frame, stackTop);
                                            lIntValue = Interpreter.stack_int32(frame, --stackTop);
                                            stack[stackTop] = DBL_MRK;
                                            switch (op) {
                                                case 11: {
                                                    lIntValue &= rIntValue;
                                                    break;
                                                }
                                                case 9: {
                                                    lIntValue |= rIntValue;
                                                    break;
                                                }
                                                case 10: {
                                                    lIntValue ^= rIntValue;
                                                    break;
                                                }
                                                case 18: {
                                                    lIntValue <<= rIntValue;
                                                    break;
                                                }
                                                case 19: {
                                                    lIntValue >>= rIntValue;
                                                }
                                            }
                                            sDbl[stackTop] = lIntValue;
                                            continue block149;
                                        }
                                        case 20: {
                                            rIntValue = Interpreter.stack_int32(frame, stackTop) & 31;
                                            lDbl = Interpreter.stack_double(frame, --stackTop);
                                            stack[stackTop] = DBL_MRK;
                                            sDbl[stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                                            continue block149;
                                        }
                                        case 28: 
                                        case 29: {
                                            rDbl = Interpreter.stack_double(frame, stackTop);
                                            stack[stackTop] = DBL_MRK;
                                            if (op == 29) {
                                                rDbl = -rDbl;
                                            }
                                            sDbl[stackTop] = rDbl;
                                            continue block149;
                                        }
                                        case 21: {
                                            Interpreter.do_add(stack, sDbl, --stackTop, cx);
                                            continue block149;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            rDbl = Interpreter.stack_double(frame, stackTop);
                                            lDbl = Interpreter.stack_double(frame, --stackTop);
                                            stack[stackTop] = DBL_MRK;
                                            switch (op) {
                                                case 22: {
                                                    lDbl -= rDbl;
                                                    break;
                                                }
                                                case 23: {
                                                    lDbl *= rDbl;
                                                    break;
                                                }
                                                case 24: {
                                                    lDbl /= rDbl;
                                                    break;
                                                }
                                                case 25: {
                                                    lDbl %= rDbl;
                                                }
                                            }
                                            sDbl[stackTop] = lDbl;
                                            continue block149;
                                        }
                                        case 26: {
                                            stack[stackTop] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(frame, stackTop) == false);
                                            continue block149;
                                        }
                                        case 48: {
                                            stack[++stackTop] = ScriptRuntime.bind(cx, frame.scope, stringReg);
                                            continue block149;
                                        }
                                        case 8: {
                                            rhs = stack[stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            lhs = (Scriptable)stack[--stackTop];
                                            stack[stackTop] = ScriptRuntime.setName(lhs, rhs, cx, frame.scope, stringReg);
                                            continue block149;
                                        }
                                        case 31: {
                                            rhs = stack[stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.delete(lhs, rhs, cx);
                                            continue block149;
                                        }
                                        case 33: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.getObjectProp(lhs, stringReg, cx);
                                            continue block149;
                                        }
                                        case 34: {
                                            rhs = stack[stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.setObjectProp(lhs, stringReg, rhs, cx);
                                            continue block149;
                                        }
                                        case -9: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.propIncrDecr(lhs, stringReg, cx, iCode[frame.pc]);
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case 35: {
                                            lhs = stack[--stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((id = stack[stackTop + 1]) != DBL_MRK) {
                                                value = ScriptRuntime.getObjectElem(lhs, id, cx);
                                            } else {
                                                d = sDbl[stackTop + 1];
                                                value = ScriptRuntime.getObjectIndex(lhs, d, cx);
                                            }
                                            stack[stackTop] = value;
                                            continue block149;
                                        }
                                        case 36: {
                                            rhs = stack[(stackTop -= 2) + 2];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop + 2]);
                                            }
                                            if ((lhs = stack[stackTop]) == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((id = stack[stackTop + 1]) != DBL_MRK) {
                                                value = ScriptRuntime.setObjectElem(lhs, id, rhs, cx);
                                            } else {
                                                d = sDbl[stackTop + 1];
                                                value = ScriptRuntime.setObjectIndex(lhs, d, rhs, cx);
                                            }
                                            stack[stackTop] = value;
                                            continue block149;
                                        }
                                        case -10: {
                                            rhs = stack[stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.elemIncrDecr(lhs, rhs, cx, iCode[frame.pc]);
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case 65: {
                                            ref = (Ref)stack[stackTop];
                                            stack[stackTop] = ScriptRuntime.refGet(ref, cx);
                                            continue block149;
                                        }
                                        case 66: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) {
                                                value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            ref = (Ref)stack[--stackTop];
                                            stack[stackTop] = ScriptRuntime.refSet(ref, value, cx);
                                            continue block149;
                                        }
                                        case 67: {
                                            ref = (Ref)stack[stackTop];
                                            stack[stackTop] = ScriptRuntime.refDel(ref, cx);
                                            continue block149;
                                        }
                                        case -11: {
                                            ref = (Ref)stack[stackTop];
                                            stack[stackTop] = ScriptRuntime.refIncrDecr(ref, cx, iCode[frame.pc]);
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case 53: {
                                            stack[++stackTop] = stack[indexReg += frame.localShift];
                                            sDbl[stackTop] = sDbl[indexReg];
                                            continue block149;
                                        }
                                        case -56: {
                                            stack[indexReg += frame.localShift] = null;
                                            continue block149;
                                        }
                                        case -15: {
                                            stack[++stackTop] = ScriptRuntime.getNameFunctionAndThis(stringReg, cx, frame.scope);
                                            stack[++stackTop] = ScriptRuntime.lastStoredScriptable(cx);
                                            continue block149;
                                        }
                                        case -16: {
                                            obj = stack[stackTop];
                                            if (obj == DBL_MRK) {
                                                obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.getPropFunctionAndThis(obj, stringReg, cx);
                                            stack[++stackTop] = ScriptRuntime.lastStoredScriptable(cx);
                                            continue block149;
                                        }
                                        case -17: {
                                            obj = stack[stackTop - 1];
                                            if (obj == DBL_MRK) {
                                                obj = ScriptRuntime.wrapNumber(sDbl[stackTop - 1]);
                                            }
                                            if ((id = stack[stackTop]) == DBL_MRK) {
                                                id = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop - 1] = ScriptRuntime.getElemFunctionAndThis(obj, id, cx);
                                            stack[stackTop] = ScriptRuntime.lastStoredScriptable(cx);
                                            continue block149;
                                        }
                                        case -18: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) {
                                                value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.getValueFunctionAndThis(value, cx);
                                            stack[++stackTop] = ScriptRuntime.lastStoredScriptable(cx);
                                            continue block149;
                                        }
                                        case -21: {
                                            if (instructionCounting) {
                                                cx.instructionCount += 100;
                                            }
                                            callType = iCode[frame.pc] & 255;
                                            isNew = iCode[frame.pc + 1] != 0;
                                            sourceLine = Interpreter.getIndex(iCode, frame.pc + 2);
                                            if (isNew) {
                                                function = stack[stackTop -= indexReg];
                                                if (function == DBL_MRK) {
                                                    function = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                                }
                                                outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 1, indexReg);
                                                stack[stackTop] = ScriptRuntime.newSpecial(cx, function, outArgs, frame.scope, callType);
                                            } else {
                                                functionThis = (Scriptable)stack[(stackTop -= 1 + indexReg) + 1];
                                                function = (Callable)stack[stackTop];
                                                outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg);
                                                stack[stackTop] = ScriptRuntime.callSpecial(cx, function, functionThis, outArgs, frame.scope, frame.thisObj, callType, frame.idata.itsSourceFile, sourceLine);
                                            }
                                            frame.pc += 4;
                                            continue block149;
                                        }
                                        case -55: 
                                        case 37: 
                                        case 68: {
                                            if (instructionCounting) {
                                                cx.instructionCount += 100;
                                            }
                                            fun = (Callable)stack[stackTop -= 1 + indexReg];
                                            funThisObj = (Scriptable)stack[stackTop + 1];
                                            if (op == 68) {
                                                outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg);
                                                stack[stackTop] = ScriptRuntime.callRef(fun, funThisObj, outArgs, cx);
                                                continue block149;
                                            }
                                            calleeScope = frame.scope;
                                            if (frame.useActivation) {
                                                calleeScope = ScriptableObject.getTopLevelScope(frame.scope);
                                            }
                                            if (fun instanceof InterpretedFunction) {
                                                ifun = (InterpretedFunction)fun;
                                                if (frame.fnOrScript.securityDomain == ifun.securityDomain) {
                                                    callParentFrame = frame;
                                                    calleeFrame = new CallFrame();
                                                    if (op == -55) {
                                                        callParentFrame = frame.parentFrame;
                                                    }
                                                    Interpreter.initFrame(cx, calleeScope, funThisObj, stack, sDbl, stackTop + 2, indexReg, ifun, callParentFrame, calleeFrame);
                                                    if (op == -55) {
                                                        Interpreter.exitFrame(cx, frame, null);
                                                    } else {
                                                        frame.savedStackTop = stackTop;
                                                        frame.savedCallOp = op;
                                                    }
                                                    frame = calleeFrame;
                                                    continue block146;
                                                }
                                            }
                                            if (fun instanceof Continuation) {
                                                cjump = new ContinuationJump((Continuation)fun, frame);
                                                if (indexReg == 0) {
                                                    cjump.result = undefined;
                                                } else {
                                                    cjump.result = stack[stackTop + 2];
                                                    cjump.resultDbl = sDbl[stackTop + 2];
                                                }
                                                throwable = cjump;
                                                break block268;
                                            }
                                            if (fun instanceof IdFunctionObject && Continuation.isContinuationConstructor(ifun = (IdFunctionObject)fun)) {
                                                Interpreter.captureContinuation(cx, frame, stackTop);
                                                continue block149;
                                            }
                                            outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 2, indexReg);
                                            stack[stackTop] = fun.call(cx, calleeScope, funThisObj, outArgs);
                                            continue block149;
                                        }
                                        case 30: {
                                            if (instructionCounting) {
                                                cx.instructionCount += 100;
                                            }
                                            if ((lhs = stack[stackTop -= indexReg]) instanceof InterpretedFunction) {
                                                f = (InterpretedFunction)lhs;
                                                if (frame.fnOrScript.securityDomain == f.securityDomain) {
                                                    newInstance = f.createObject(cx, frame.scope);
                                                    calleeFrame = new CallFrame();
                                                    Interpreter.initFrame(cx, frame.scope, newInstance, stack, sDbl, stackTop + 1, indexReg, f, frame, calleeFrame);
                                                    stack[stackTop] = newInstance;
                                                    frame.savedStackTop = stackTop;
                                                    frame.savedCallOp = op;
                                                    frame = calleeFrame;
                                                    continue block146;
                                                }
                                            }
                                            if (!(lhs instanceof Function)) {
                                                if (lhs == DBL_MRK) {
                                                    lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                                }
                                                throw ScriptRuntime.notFunctionError(lhs);
                                            }
                                            fun = (Function)lhs;
                                            if (fun instanceof IdFunctionObject && Continuation.isContinuationConstructor(ifun = (IdFunctionObject)fun)) {
                                                Interpreter.captureContinuation(cx, frame, stackTop);
                                                continue block149;
                                            }
                                            outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop + 1, indexReg);
                                            stack[stackTop] = fun.construct(cx, frame.scope, outArgs);
                                            continue block149;
                                        }
                                        case 32: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.typeof(lhs);
                                            continue block149;
                                        }
                                        case -14: {
                                            stack[++stackTop] = ScriptRuntime.typeofName(frame.scope, stringReg);
                                            continue block149;
                                        }
                                        case 40: {
                                            stack[++stackTop] = stringReg;
                                            continue block149;
                                        }
                                        case -27: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = Interpreter.getShort(iCode, frame.pc);
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case -28: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = Interpreter.getInt(iCode, frame.pc);
                                            frame.pc += 4;
                                            continue block149;
                                        }
                                        case 39: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = frame.idata.itsDoubleTable[indexReg];
                                            continue block149;
                                        }
                                        case 38: {
                                            stack[++stackTop] = ScriptRuntime.name(cx, frame.scope, stringReg);
                                            continue block149;
                                        }
                                        case -8: {
                                            stack[++stackTop] = ScriptRuntime.nameIncrDecr(frame.scope, stringReg, iCode[frame.pc]);
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case -49: {
                                            indexReg = iCode[frame.pc++];
                                        }
                                        case 55: {
                                            if (!frame.useActivation) {
                                                vars[indexReg] = stack[stackTop];
                                                varDbls[indexReg] = sDbl[stackTop];
                                                continue block149;
                                            }
                                            val = stack[stackTop];
                                            if (val == DBL_MRK) {
                                                val = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stringReg = frame.idata.argNames[indexReg];
                                            frame.scope.put(stringReg, frame.scope, val);
                                            continue block149;
                                        }
                                        case -48: {
                                            indexReg = iCode[frame.pc++];
                                        }
                                        case 54: {
                                            ++stackTop;
                                            if (!frame.useActivation) {
                                                stack[stackTop] = vars[indexReg];
                                                sDbl[stackTop] = varDbls[indexReg];
                                                continue block149;
                                            }
                                            stringReg = frame.idata.argNames[indexReg];
                                            stack[stackTop] = frame.scope.get(stringReg, frame.scope);
                                            continue block149;
                                        }
                                        case -7: {
                                            ++stackTop;
                                            incrDecrMask = iCode[frame.pc];
                                            if (!frame.useActivation) {
                                                stack[stackTop] = DBL_MRK;
                                                varValue = vars[indexReg];
                                                if (varValue == DBL_MRK) {
                                                    d = varDbls[indexReg];
                                                } else {
                                                    d = ScriptRuntime.toNumber(varValue);
                                                    vars[indexReg] = DBL_MRK;
                                                }
                                                varDbls[indexReg] = d2 = (incrDecrMask & 1) == 0 ? d + 1.0 : d - 1.0;
                                                sDbl[stackTop] = (incrDecrMask & 2) == 0 ? d2 : d;
                                            } else {
                                                varName = frame.idata.argNames[indexReg];
                                                stack[stackTop] = ScriptRuntime.nameIncrDecr(frame.scope, varName, incrDecrMask);
                                            }
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case -51: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = 0.0;
                                            continue block149;
                                        }
                                        case -52: {
                                            stack[++stackTop] = DBL_MRK;
                                            sDbl[stackTop] = 1.0;
                                            continue block149;
                                        }
                                        case 41: {
                                            stack[++stackTop] = null;
                                            continue block149;
                                        }
                                        case 42: {
                                            stack[++stackTop] = frame.thisObj;
                                            continue block149;
                                        }
                                        case 61: {
                                            stack[++stackTop] = frame.fnOrScript;
                                            continue block149;
                                        }
                                        case 43: {
                                            stack[++stackTop] = Boolean.FALSE;
                                            continue block149;
                                        }
                                        case 44: {
                                            stack[++stackTop] = Boolean.TRUE;
                                            continue block149;
                                        }
                                        case -50: {
                                            stack[++stackTop] = undefined;
                                            continue block149;
                                        }
                                        case 2: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            --stackTop;
                                            frame.scope = ScriptRuntime.enterWith(lhs, cx, frame.scope);
                                            continue block149;
                                        }
                                        case 3: {
                                            frame.scope = ScriptRuntime.leaveWith(frame.scope);
                                            continue block149;
                                        }
                                        case 56: {
                                            afterFirstScope = frame.idata.itsICode[frame.pc] != 0;
                                            caughtException = (Throwable)stack[--stackTop + 1];
                                            lastCatchScope = afterFirstScope == false ? null : (Scriptable)stack[indexReg += frame.localShift];
                                            stack[indexReg] = ScriptRuntime.newCatchScope(caughtException, lastCatchScope, stringReg, cx, frame.scope);
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case 57: 
                                        case 58: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            --stackTop;
                                            stack[indexReg += frame.localShift] = ScriptRuntime.enumInit(lhs, cx, op == 58);
                                            continue block149;
                                        }
                                        case 59: 
                                        case 60: {
                                            val = stack[indexReg += frame.localShift];
                                            stack[++stackTop] = op == 59 ? ScriptRuntime.enumNext(val) : ScriptRuntime.enumId(val, cx);
                                            continue block149;
                                        }
                                        case 69: {
                                            obj = stack[stackTop];
                                            if (obj == DBL_MRK) {
                                                obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.specialRef(obj, stringReg, cx);
                                            continue block149;
                                        }
                                        case 73: {
                                            elem = stack[stackTop];
                                            if (elem == DBL_MRK) {
                                                elem = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((obj = stack[--stackTop]) == DBL_MRK) {
                                                obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.memberRef(obj, elem, cx, indexReg);
                                            continue block149;
                                        }
                                        case 74: {
                                            elem = stack[stackTop];
                                            if (elem == DBL_MRK) {
                                                elem = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((ns = stack[--stackTop]) == DBL_MRK) {
                                                ns = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((obj = stack[--stackTop]) == DBL_MRK) {
                                                obj = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.memberRef(obj, ns, elem, cx, indexReg);
                                            continue block149;
                                        }
                                        case 75: {
                                            name = stack[stackTop];
                                            if (name == DBL_MRK) {
                                                name = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.nameRef(name, cx, frame.scope, indexReg);
                                            continue block149;
                                        }
                                        case 76: {
                                            name = stack[stackTop];
                                            if (name == DBL_MRK) {
                                                name = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            if ((ns = stack[--stackTop]) == DBL_MRK) {
                                                ns = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.nameRef(ns, name, cx, frame.scope, indexReg);
                                            continue block149;
                                        }
                                        case -12: {
                                            frame.scope = (Scriptable)stack[indexReg += frame.localShift];
                                            continue block149;
                                        }
                                        case -13: {
                                            stack[indexReg += frame.localShift] = frame.scope;
                                            continue block149;
                                        }
                                        case -19: {
                                            stack[++stackTop] = InterpretedFunction.createFunction(cx, frame.scope, frame.fnOrScript, indexReg);
                                            continue block149;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(cx, frame.scope, frame.fnOrScript, indexReg);
                                            continue block149;
                                        }
                                        case 47: {
                                            stack[++stackTop] = frame.scriptRegExps[indexReg];
                                            continue block149;
                                        }
                                        case -29: {
                                            stack[++stackTop] = new Object[indexReg];
                                            sDbl[stackTop] = 0.0;
                                            continue block149;
                                        }
                                        case -30: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) {
                                                value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            i = (int)sDbl[--stackTop];
                                            ((Object[])stack[stackTop])[i] = value;
                                            sDbl[stackTop] = i + 1;
                                            continue block149;
                                        }
                                        case -31: 
                                        case 63: 
                                        case 64: {
                                            data = (Object[])stack[stackTop];
                                            if (op == 64) {
                                                ids = (Object[])frame.idata.literalIds[indexReg];
                                                val = ScriptRuntime.newObjectLiteral(ids, data, cx, frame.scope);
                                            } else {
                                                skipIndexces = null;
                                                if (op == -31) {
                                                    skipIndexces = (int[])frame.idata.literalIds[indexReg];
                                                }
                                                val = ScriptRuntime.newArrayLiteral(data, skipIndexces, cx, frame.scope);
                                            }
                                            stack[stackTop] = val;
                                            continue block149;
                                        }
                                        case -53: {
                                            lhs = stack[stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            --stackTop;
                                            frame.scope = ScriptRuntime.enterDotQuery(lhs, frame.scope);
                                            continue block149;
                                        }
                                        case -54: {
                                            valBln = Interpreter.stack_boolean(frame, stackTop);
                                            x = ScriptRuntime.updateDotQuery(valBln, frame.scope);
                                            if (x != null) {
                                                stack[stackTop] = x;
                                                frame.scope = ScriptRuntime.leaveDotQuery(frame.scope);
                                                frame.pc += 2;
                                                continue block149;
                                            }
                                            --stackTop;
                                            break;
                                        }
                                        case 70: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) {
                                                value = ScriptRuntime.wrapNumber(sDbl[stackTop]);
                                            }
                                            stack[stackTop] = ScriptRuntime.setDefaultNamespace(value, cx);
                                            continue block149;
                                        }
                                        case 71: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) continue block149;
                                            stack[stackTop] = ScriptRuntime.escapeAttributeValue(value, cx);
                                            continue block149;
                                        }
                                        case 72: {
                                            value = stack[stackTop];
                                            if (value == DBL_MRK) continue block149;
                                            stack[stackTop] = ScriptRuntime.escapeTextValue(value, cx);
                                            continue block149;
                                        }
                                        case -26: {
                                            frame.pcSourceLineStart = frame.pc;
                                            if (frame.debuggerFrame != null) {
                                                line = Interpreter.getIndex(iCode, frame.pc);
                                                frame.debuggerFrame.onLineChange(cx, line);
                                            }
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case -32: {
                                            indexReg = 0;
                                            continue block149;
                                        }
                                        case -33: {
                                            indexReg = 1;
                                            continue block149;
                                        }
                                        case -34: {
                                            indexReg = 2;
                                            continue block149;
                                        }
                                        case -35: {
                                            indexReg = 3;
                                            continue block149;
                                        }
                                        case -36: {
                                            indexReg = 4;
                                            continue block149;
                                        }
                                        case -37: {
                                            indexReg = 5;
                                            continue block149;
                                        }
                                        case -38: {
                                            indexReg = 255 & iCode[frame.pc];
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case -39: {
                                            indexReg = Interpreter.getIndex(iCode, frame.pc);
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case -40: {
                                            indexReg = Interpreter.getInt(iCode, frame.pc);
                                            frame.pc += 4;
                                            continue block149;
                                        }
                                        case -41: {
                                            stringReg = strings[0];
                                            continue block149;
                                        }
                                        case -42: {
                                            stringReg = strings[1];
                                            continue block149;
                                        }
                                        case -43: {
                                            stringReg = strings[2];
                                            continue block149;
                                        }
                                        case -44: {
                                            stringReg = strings[3];
                                            continue block149;
                                        }
                                        case -45: {
                                            stringReg = strings[255 & iCode[frame.pc]];
                                            ++frame.pc;
                                            continue block149;
                                        }
                                        case -46: {
                                            stringReg = strings[Interpreter.getIndex(iCode, frame.pc)];
                                            frame.pc += 2;
                                            continue block149;
                                        }
                                        case -47: {
                                            stringReg = strings[Interpreter.getInt(iCode, frame.pc)];
                                            frame.pc += 4;
                                            continue block149;
                                        }
                                        default: {
                                            Interpreter.dumpICode(frame.idata);
                                            throw new RuntimeException("Unknown icode : " + op + " @ pc : " + (frame.pc - 1));
                                        }
                                    }
                                    if (instructionCounting) {
                                        Interpreter.addInstructionCount(cx, frame, 2);
                                    }
                                    frame.pc = (offset = Interpreter.getShort(iCode, frame.pc)) != 0 ? (frame.pc += offset - 1) : frame.idata.longJumps.getExistingInt(frame.pc);
                                    if (!instructionCounting) continue;
                                    frame.pcPrevBranch = frame.pc;
                                }
                                Interpreter.exitFrame(cx, frame, null);
                                interpreterResult = frame.result;
                                interpreterResultDbl = frame.resultDbl;
                                if (frame.parentFrame != null) {
                                    frame = frame.parentFrame;
                                    if (frame.frozen) {
                                        frame = frame.cloneFrozen();
                                    }
                                    Interpreter.setCallResult(frame, interpreterResult, interpreterResultDbl);
                                    interpreterResult = null;
                                    continue;
                                }
                                break block269;
                                break;
                            }
                        }
                        catch (Throwable ex) {
                            if (throwable != null) {
                                ex.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            throwable = ex;
                        }
                    }
                    if (throwable == null) {
                        Kit.codeBug();
                    }
                    EX_CATCH_STATE = 2;
                    EX_FINALLY_STATE = true;
                    EX_NO_JS_STATE = false;
                    cjump = null;
                    if (throwable instanceof JavaScriptException) {
                        exState = 2;
                    } else if (throwable instanceof EcmaError) {
                        exState = 2;
                    } else if (throwable instanceof EvaluatorException) {
                        exState = 2;
                    } else if (throwable instanceof RuntimeException) {
                        exState = 1;
                    } else if (throwable instanceof Error) {
                        exState = 0;
                    } else {
                        exState = 1;
                        cjump = (ContinuationJump)throwable;
                    }
                    if (instructionCounting) {
                        try {
                            Interpreter.addInstructionCount(cx, frame, 100);
                        }
                        catch (RuntimeException ex) {
                            throwable = ex;
                            exState = 1;
                        }
                        catch (Error ex) {
                            throwable = ex;
                            cjump = null;
                            exState = 0;
                        }
                    }
                    if (frame.debuggerFrame != null && throwable instanceof RuntimeException) {
                        rex = (RuntimeException)throwable;
                        try {
                            frame.debuggerFrame.onExceptionThrown(cx, rex);
                        }
                        catch (Throwable ex) {
                            throwable = ex;
                            cjump = null;
                            exState = 0;
                        }
                    }
                    do {
                        if (exState != 0 && (indexReg = Interpreter.getExceptionHandler(frame, onlyFinally = exState != 2)) >= 0) continue block145;
                        Interpreter.exitFrame(cx, frame, throwable);
                        frame = frame.parentFrame;
                        if (frame == null) break block270;
                    } while (cjump == null || cjump.branchFrame != frame);
                    indexReg = -1;
                    continue;
                }
                if (cjump == null) break block269;
                if (cjump.branchFrame != null) {
                    Kit.codeBug();
                }
                if (cjump.capturedFrame == null) break;
                indexReg = -1;
            }
            interpreterResult = cjump.result;
            interpreterResultDbl = cjump.resultDbl;
            throwable = null;
        }
        if (cx.previousInterpreterInvocations != null && cx.previousInterpreterInvocations.size() != 0) {
            cx.lastInterpreterFrame = cx.previousInterpreterInvocations.pop();
        } else {
            cx.lastInterpreterFrame = null;
            cx.previousInterpreterInvocations = null;
        }
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        return interpreterResult != DBL_MRK ? interpreterResult : ScriptRuntime.wrapNumber(interpreterResultDbl);
    }

    private static void initFrame(Context cx, Scriptable callerScope, Scriptable thisObj, Object[] args, double[] argsDbl, int argShift, int argCount, InterpretedFunction fnOrScript, CallFrame parentFrame, CallFrame frame) {
        int i;
        double[] sDbl;
        Object[] stack;
        boolean stackReuse;
        int emptyStackTop;
        int maxFrameArray;
        Scriptable scope;
        InterpreterData idata = fnOrScript.idata;
        boolean useActivation = idata.itsNeedsActivation;
        DebugFrame debuggerFrame = null;
        if (cx.debugger != null && (debuggerFrame = cx.debugger.getFrame(cx, idata)) != null) {
            useActivation = true;
        }
        if (useActivation) {
            if (argsDbl != null) {
                args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
            }
            argShift = 0;
            argsDbl = null;
        }
        if (idata.itsFunctionType != 0) {
            scope = !idata.useDynamicScope ? fnOrScript.getParentScope() : callerScope;
            if (useActivation) {
                scope = ScriptRuntime.createFunctionActivation(fnOrScript, scope, args);
            }
        } else {
            scope = callerScope;
            ScriptRuntime.initScript(fnOrScript, thisObj, cx, scope, fnOrScript.idata.evalScriptFlag);
        }
        if (idata.itsNestedFunctions != null) {
            if (idata.itsFunctionType != 0 && !idata.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i2 = 0; i2 < idata.itsNestedFunctions.length; ++i2) {
                InterpreterData fdata = idata.itsNestedFunctions[i2];
                if (fdata.itsFunctionType != 1) continue;
                Interpreter.initFunction(cx, scope, fnOrScript, i2);
            }
        }
        Scriptable[] scriptRegExps = null;
        if (idata.itsRegExpLiterals != null) {
            scriptRegExps = idata.itsFunctionType != 0 ? fnOrScript.functionRegExps : fnOrScript.createRegExpWraps(cx, scope);
        }
        if ((maxFrameArray = idata.itsMaxFrameArray) != (emptyStackTop = idata.itsMaxVars + idata.itsMaxLocals - 1) + idata.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (frame.stack != null && maxFrameArray <= frame.stack.length) {
            stackReuse = true;
            stack = frame.stack;
            sDbl = frame.sDbl;
        } else {
            stackReuse = false;
            stack = new Object[maxFrameArray];
            sDbl = new double[maxFrameArray];
        }
        int definedArgs = idata.argCount;
        if (definedArgs > argCount) {
            definedArgs = argCount;
        }
        frame.parentFrame = parentFrame;
        frame.frameIndex = parentFrame == null ? 0 : parentFrame.frameIndex + 1;
        frame.frozen = false;
        frame.fnOrScript = fnOrScript;
        frame.idata = idata;
        frame.stack = stack;
        frame.sDbl = sDbl;
        frame.varSource = frame;
        frame.localShift = idata.itsMaxVars;
        frame.emptyStackTop = emptyStackTop;
        frame.debuggerFrame = debuggerFrame;
        frame.useActivation = useActivation;
        frame.thisObj = thisObj;
        frame.scriptRegExps = scriptRegExps;
        frame.result = Undefined.instance;
        frame.pc = 0;
        frame.pcPrevBranch = 0;
        frame.pcSourceLineStart = idata.firstLinePC;
        frame.scope = scope;
        frame.savedStackTop = emptyStackTop;
        frame.savedCallOp = 0;
        System.arraycopy(args, argShift, stack, 0, definedArgs);
        if (argsDbl != null) {
            System.arraycopy(argsDbl, argShift, sDbl, 0, definedArgs);
        }
        for (i = definedArgs; i != idata.itsMaxVars; ++i) {
            stack[i] = Undefined.instance;
        }
        if (stackReuse) {
            for (i = emptyStackTop + 1; i != stack.length; ++i) {
                stack[i] = null;
            }
        }
        Interpreter.enterFrame(cx, frame, args);
    }

    private static boolean isFrameEnterExitRequired(CallFrame frame) {
        return frame.debuggerFrame != null || frame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context cx, CallFrame frame, Object[] args) {
        if (frame.debuggerFrame != null) {
            frame.debuggerFrame.onEnter(cx, frame.scope, frame.thisObj, args);
        }
        if (frame.idata.itsNeedsActivation) {
            ScriptRuntime.enterActivationFunction(cx, frame.scope);
        }
    }

    private static void exitFrame(Context cx, CallFrame frame, Object throwable) {
        if (frame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(cx);
        }
        if (frame.debuggerFrame != null) {
            try {
                if (throwable instanceof Throwable) {
                    frame.debuggerFrame.onExit(cx, true, throwable);
                } else {
                    ContinuationJump cjump = (ContinuationJump)throwable;
                    Object result = cjump == null ? frame.result : cjump.result;
                    if (result == UniqueTag.DOUBLE_MARK) {
                        double resultDbl = cjump == null ? frame.resultDbl : cjump.resultDbl;
                        result = ScriptRuntime.wrapNumber(resultDbl);
                    }
                    frame.debuggerFrame.onExit(cx, false, result);
                }
            }
            catch (Throwable ex) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                ex.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame frame, Object callResult, double callResultDbl) {
        if (frame.savedCallOp == 37) {
            frame.stack[frame.savedStackTop] = callResult;
            frame.sDbl[frame.savedStackTop] = callResultDbl;
        } else if (frame.savedCallOp == 30) {
            if (callResult instanceof Scriptable) {
                frame.stack[frame.savedStackTop] = callResult;
            }
        } else {
            Kit.codeBug();
        }
        frame.savedCallOp = 0;
    }

    private static void captureContinuation(Context cx, CallFrame frame, int stackTop) {
        Continuation c = new Continuation();
        ScriptRuntime.setObjectProtoAndParent(c, ScriptRuntime.getTopCallScope(cx));
        CallFrame x = frame.parentFrame;
        while (x != null && !x.frozen) {
            x.frozen = true;
            for (int i = x.savedStackTop + 1; i != x.stack.length; ++i) {
                x.stack[i] = null;
            }
            if (x.savedCallOp == 37) {
                x.stack[x.savedStackTop] = null;
            } else if (x.savedCallOp != 30) {
                Kit.codeBug();
            }
            x = x.parentFrame;
        }
        c.initImplementation(frame.parentFrame);
        frame.stack[stackTop] = c;
    }

    private static int stack_int32(CallFrame frame, int i) {
        Object x = frame.stack[i];
        double value = x == UniqueTag.DOUBLE_MARK ? frame.sDbl[i] : ScriptRuntime.toNumber(x);
        return ScriptRuntime.toInt32(value);
    }

    private static double stack_double(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (x != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(x);
        }
        return frame.sDbl[i];
    }

    private static boolean stack_boolean(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (x == Boolean.TRUE) {
            return true;
        }
        if (x == Boolean.FALSE) {
            return false;
        }
        if (x == UniqueTag.DOUBLE_MARK) {
            double d = frame.sDbl[i];
            return d == d && d != 0.0;
        }
        if (x == null || x == Undefined.instance) {
            return false;
        }
        if (x instanceof Number) {
            double d = ((Number)x).doubleValue();
            return d == d && d != 0.0;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return ScriptRuntime.toBoolean(x);
    }

    /*
     * WARNING - void declaration
     */
    private static void do_add(Object[] stack, double[] sDbl, int stackTop, Context cx) {
        void var8_7;
        void var6_6;
        boolean leftRightOrder;
        double d;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            d = sDbl[stackTop + 1];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                int n = stackTop;
                sDbl[n] = sDbl[n] + d;
                return;
            }
            leftRightOrder = true;
        } else if (lhs == UniqueTag.DOUBLE_MARK) {
            d = sDbl[stackTop];
            lhs = rhs;
            leftRightOrder = false;
        } else {
            if (lhs instanceof Scriptable || rhs instanceof Scriptable) {
                stack[stackTop] = ScriptRuntime.add(lhs, rhs, cx);
            } else if (lhs instanceof String) {
                String lstr = (String)lhs;
                String rstr = ScriptRuntime.toString(rhs);
                stack[stackTop] = lstr.concat(rstr);
            } else if (rhs instanceof String) {
                String lstr = ScriptRuntime.toString(lhs);
                String rstr = (String)rhs;
                stack[stackTop] = lstr.concat(rstr);
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(rhs);
                stack[stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[stackTop] = lDbl + rDbl;
            }
            return;
        }
        if (lhs instanceof Scriptable) {
            rhs = ScriptRuntime.wrapNumber((double)var6_6);
            if (var8_7 == false) {
                Object tmp = lhs;
                lhs = rhs;
                rhs = tmp;
            }
            stack[stackTop] = ScriptRuntime.add(lhs, rhs, cx);
        } else if (lhs instanceof String) {
            String lstr = (String)lhs;
            String rstr = ScriptRuntime.toString((double)var6_6);
            stack[stackTop] = var8_7 != false ? lstr.concat(rstr) : rstr.concat(lstr);
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
            stack[stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[stackTop] = lDbl + var6_6;
        }
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, int shift, int count) {
        if (count == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] args = new Object[count];
        int i = 0;
        while (i != count) {
            Object val = stack[shift];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[shift]);
            }
            args[i] = val;
            ++i;
            ++shift;
        }
        return args;
    }

    private static void addInstructionCount(Context cx, CallFrame frame, int extra) {
        cx.instructionCount += frame.pc - frame.pcPrevBranch + extra;
        if (cx.instructionCount > cx.instructionThreshold) {
            cx.observeInstructionCount(cx.instructionCount);
            cx.instructionCount = 0;
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame copy;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                copy = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
            copy.stack = (Object[])this.stack.clone();
            copy.sDbl = (double[])this.sDbl.clone();
            copy.frozen = false;
            return copy;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(Continuation c, CallFrame current) {
            this.capturedFrame = (CallFrame)c.getImplementation();
            if (this.capturedFrame == null || current == null) {
                this.branchFrame = null;
            } else {
                CallFrame chain1 = this.capturedFrame;
                CallFrame chain2 = current;
                int diff = chain1.frameIndex - chain2.frameIndex;
                if (diff != 0) {
                    if (diff < 0) {
                        chain1 = current;
                        chain2 = this.capturedFrame;
                        diff = -diff;
                    }
                    do {
                        chain1 = chain1.parentFrame;
                    } while (--diff != 0);
                    if (chain1.frameIndex != chain2.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (chain1 != chain2 && chain1 != null) {
                    chain1 = chain1.parentFrame;
                    chain2 = chain2.parentFrame;
                }
                this.branchFrame = chain1;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }
}

