/**
* Essential OCL Lexer
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Lexer and Parser refactoring to support extensibility and flexible error handling
*   Borland - Bug 242880
*   E.D.Willink - Bug 292112, 295166
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (242153)
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - Introducing new LPG templates (299396)
*
* </copyright>
*
* $Id: OCLLexerprs.java,v 1.19 2010/02/09 21:04:08 ewillink Exp $
*/
/**
* Complete OCL Lexer
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Bug 292112, 292594
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (242153)
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - Introducing new LPG templates (299396)
*
* </copyright>
*/

package org.eclipse.ocl.parser;

public class OCLLexerprs implements lpg.runtime.ParseTable, OCLLexersym {
    public final static int ERROR_SYMBOL = 0;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 0;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 0;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 0;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 43;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 103;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 726;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 268;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 35;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 138;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 269;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 0;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 99;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 104;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 457;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 458;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return OCLLexersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,1,
            0,0,0,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            19,22,23,24,27,32,14,29,34,5,
            21,35,7,8,16,17,20,26,28,33,
            2,3,4,6,9,10,11,12,13,15,
            18,25,30,31,1
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,3,4,3,3,3,1,2,2,1,
            1,5,1,1,1,1,1,1,1,1,
            1,1,2,2,2,1,1,1,1,2,
            1,1,1,2,1,1,1,1,2,1,
            1,2,2,3,2,2,0,1,2,2,
            2,1,2,3,2,3,3,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,2,1,2,2,2,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,2,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,2,
            1,2,0,1,1,1,2,1
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,13,21,14,
            24,25,25,25,27,27,27,27,28,28,
            26,26,7,7,30,15,15,15,11,11,
            11,11,11,2,2,2,2,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,4,1,
            1,1,1,1,1,1,1,1,1,17,
            17,29,29,22,22,22,22,32,32,32,
            32,32,32,32,32,32,32,32,32,32,
            32,32,32,32,32,32,32,32,32,32,
            32,32,32,32,32,32,32,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,18,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,19,19,8,8,33,33,
            33,33,6,16,16,16,16,31,31,31,
            31,31,31,31,31,34,34,34,34,20,
            20,20,20,20,9,9,9,9,9,23,
            23,12,12,10,10,21,21,21,21,891,
            419,417,417,417,1087,369,397,1098,1158,1198,
            430,369,36,38,994,135,134,134,134,132,
            277,284,1199,415,10,423,969,304,278,416,
            503,432,432,432,432,432,432,1200,432,432,
            346,990,359,503,432,432,432,432,432,432,
            1202,432,432,350,383,359,503,432,432,432,
            432,432,432,1194,432,432,366,1196,359,794,
            432,432,432,432,432,432,100,432,432,400,
            1101,359,600,376,376,376,376,376,376,697,
            262,262,262,262,262,262,1204,262,262,1136,
            53,376,376,1147,53,376,406,260,260,260,
            260,260,260,1,46,46,46,46,309,232,
            232,232,232,232,46,260,260,1073,53,46,
            1205,46,103,44,44,44,44,1161,53,1172,
            53,402,43,44,274,1201,1195,1210,44,1211,
            44,232,232,205,51,51,51,51,8,9,
            1212,42,1159,274,1103,373,1114,407,1125,409,
            458,373,458,407,458,409,458,458,458,458,
            458,458,458,458,51,51,458,458
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,0,
            100,101,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,102,100,101,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,0,0,0,0,103,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,0,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,0,
            91,92,93,94,95,96,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,0,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,0,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,0,79,
            80,81,82,83,84,85,86,87,88,89,
            90,0,14,0,16,0,0,97,98,0,
            100,101,102,0,1,2,3,4,5,6,
            7,8,9,10,11,12,0,0,0,0,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,0,74,0,0,0,0,0,0,
            0,78,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,0,1,2,3,
            4,5,6,7,8,9,10,0,0,0,
            0,15,0,1,2,3,4,5,6,7,
            8,9,10,0,1,2,3,4,5,6,
            7,8,9,10,0,1,2,3,4,5,
            6,7,8,9,10,0,1,2,3,4,
            5,6,7,8,9,10,0,1,2,3,
            4,5,6,7,8,9,10,0,0,73,
            0,1,2,3,4,5,6,7,8,9,
            10,0,1,2,3,4,5,6,7,8,
            9,10,0,1,2,3,4,5,6,7,
            8,9,10,0,0,0,99,0,0,0,
            0,0,102,0,0,11,12,14,15,0,
            0,0,0,13,13,16,0,0,0,0,
            0,0,0,0,0,0,69,0,70,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,97,98,0,100,101,0,
            102,0,0,0,0,70,0,0,71,0,
            72,0,0,70,70,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,99,0,0,0,0,0,
            0,0,0,0,0,0,0,0,99,99,
            99,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            458,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,504,504,504,504,504,504,
            504,504,504,504,402,504,504,504,504,504,
            504,504,504,504,504,504,504,503,504,504,
            504,504,504,504,504,504,504,504,504,458,
            504,504,458,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,502,502,502,502,
            502,502,502,502,502,502,507,502,502,502,
            502,502,502,502,502,502,502,502,502,470,
            502,502,502,502,502,502,502,502,502,502,
            502,464,502,502,11,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,47,458,458,458,509,458,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,690,690,690,690,690,
            690,690,690,690,690,458,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,718,718,718,718,718,
            718,718,718,718,718,460,718,718,718,718,
            718,388,263,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,458,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,388,458,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,376,
            376,376,376,376,376,376,376,376,376,458,
            376,376,376,376,376,388,264,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,458,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,720,720,720,720,720,720,720,720,
            720,720,388,263,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,458,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,432,
            432,432,432,432,432,432,432,432,432,388,
            458,419,419,419,419,419,419,419,419,419,
            419,417,417,320,307,333,480,417,417,417,
            417,417,417,417,417,417,417,417,417,417,
            417,417,417,417,417,417,417,417,417,417,
            417,417,337,417,417,417,417,417,417,417,
            417,417,417,417,417,417,417,417,417,417,
            417,417,417,417,417,417,417,417,417,430,
            326,279,292,472,474,489,723,300,21,493,
            486,487,484,485,726,490,296,311,476,477,
            352,458,483,458,482,458,458,430,430,17,
            430,430,313,1,593,593,593,593,593,593,
            593,593,593,593,592,592,458,458,458,458,
            592,592,592,592,592,592,592,592,592,592,
            592,592,592,592,592,592,592,592,592,592,
            592,592,592,592,592,592,592,592,592,592,
            592,592,592,592,592,592,592,592,592,592,
            592,592,592,592,592,592,592,592,592,592,
            592,592,458,297,458,458,458,458,458,458,
            458,594,40,511,511,511,511,511,511,511,
            511,511,511,274,274,1909,458,369,369,369,
            369,369,369,369,369,369,369,458,458,458,
            458,438,458,373,373,373,373,373,373,373,
            373,373,373,458,407,407,407,407,407,407,
            407,407,407,407,458,409,409,409,409,409,
            409,409,409,409,409,55,511,511,511,511,
            511,511,511,511,511,511,54,511,511,511,
            511,511,511,511,511,511,511,13,261,436,
            57,511,511,511,511,511,511,511,511,511,
            511,56,511,511,511,511,511,511,511,511,
            511,511,40,434,434,434,434,434,434,434,
            434,434,434,15,10,133,457,266,33,20,
            7,37,463,458,458,274,274,488,508,133,
            52,131,458,320,497,481,458,458,458,458,
            458,458,458,458,458,458,590,458,264,458,
            458,458,458,458,458,458,458,458,458,458,
            458,458,458,458,458,458,458,458,458,458,
            458,458,458,458,590,590,458,590,590,458,
            264,458,458,458,458,339,458,458,725,458,
            492,458,458,462,461,458,458,458,458,458,
            458,458,458,458,458,458,458,458,458,458,
            458,458,458,458,1,458,458,458,458,458,
            458,458,458,458,458,458,458,458,1,40,
            13
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
