/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: OCLBacktrackingParserprs.java,v 1.19 2010/02/09 21:04:08 ewillink Exp $
*/
/**
* Complete OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Bug 259818, 285633, 292112
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*/

package org.eclipse.ocl.parser.backtracking;

/**
 * The backtracking variant of the OCL parser parse table.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * 
 * @since 1.3
 */
@SuppressWarnings("nls")
public class OCLBacktrackingParserprs implements lpg.runtime.ParseTable, OCLBacktrackingParsersym {
    public final static int ERROR_SYMBOL = 1;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 53;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 54;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 29;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 256;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 79;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 4814;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 336;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 123;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 202;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 4031;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 6;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 73;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 73;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 4477;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 4478;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return OCLBacktrackingParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,0,0,1,1,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,1,1,0,0,0,0,
            0,0,1,0,1,0,0,1,0,0,
            0,0,0,0,1,0,0,0,0,0,
            0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            12,13,123,9,10,15,17,18,11,29,
            30,31,32,33,38,39,40,41,42,43,
            44,46,47,48,49,50,51,52,53,54,
            59,60,61,86,88,89,90,91,100,83,
            84,85,80,81,82,77,78,79,74,75,
            76,71,72,73,68,69,70,65,66,67,
            24,55,62,63,64,21,121,6,8,14,
            25,56,99,57,16,22,23,58,97,94,
            28,87,109,110,111,112,27,36,37,95,
            96,103,26,34,35,98,101,102,105,108,
            114,115,116,119,120,2,3,4,19,20,
            45,92,93,104,106,107,113,117,118,122,
            1,5,7
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,0,0,1,0,0,1,
            1,1,1,1,1,1,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,1,1,1,1,1,1,1,1,
            0,1,1,0,0,1,1,1,0,0,
            1,1,0,0,1,1,1,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,4,0,1,1,3,1,1,3,1,
            1,1,1,1,1,1,4,1,3,1,
            1,1,2,1,1,1,1,1,1,1,
            1,1,1,1,1,8,10,10,8,10,
            1,1,1,5,6,8,8,7,7,5,
            6,9,1,4,6,4,7,5,0,0,
            1,1,3,1,1,1,1,1,1,1,
            1,1,3,1,3,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,3,3,1,3,
            3,3,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,1,3,3,1,
            1,1,2,2,1,2,2,1,1,1,
            1,1,1,3,7,4,1,3,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,1,1,1,0,1,1,0,1,
            7,2,2,1,6,6,0,1,1,3,
            1,3,1,1,1,2,1,1,4,1,
            0,1,1,2,1,1,1,7,1,2,
            3,3,3,5,1,2,4,4,5,3,
            3,3,1,2,4,4,4,6,8,0,
            1,1,3,1,1,1,1,4,2,1,
            4,7,5,3,3,3,4,4,3,2,
            2,3,3,4,5,2,1,7,3,3,
            3,3,2,2,5,4,-91,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-98,1,2,3,-2,-3,6,-16,
            -15,1,2,3,-4,-14,6,-78,1,2,
            3,-83,-34,6,88,89,-96,1,2,3,
            94,95,-92,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,83,84,
            85,86,80,-10,83,84,85,86,99,107,
            108,-97,1,2,3,-99,1,2,3,-77,
            88,89,-38,101,-129,-80,94,95,-197,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,73,74,73,74,71,
            -21,-23,-223,-25,76,80,-28,-30,-33,90,
            -146,-177,-148,-36,-149,87,-237,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,73,74,73,74,73,72,-37,
            -39,80,76,91,-40,-41,-42,-44,-124,-185,
            1,2,3,87,-190,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            71,-13,1,2,3,-46,77,6,80,-32,
            -47,-48,-202,-49,-50,-51,-52,-53,-54,-55,
            -56,-57,93,-61,-62,-63,92,-182,-64,101,
            -65,97,98,-191,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,90,
            73,74,-66,91,-67,-68,-69,-73,-86,-87,
            -88,-94,-95,-100,-107,-108,-109,-120,-121,118,
            -122,-125,-126,-127,-128,92,-210,-130,119,117,
            97,98,-131,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-132,73,
            74,-133,-134,-135,72,-219,-160,1,2,3,
            78,-180,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,71,73,74,
            -136,-137,-138,72,-229,-233,1,2,3,78,
            -188,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,71,73,74,-139,
            -140,-141,-142,-144,-145,-147,-150,-151,-152,-153,
            -154,-155,-156,-249,-157,-158,-159,-163,88,89,
            -209,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,73,74,-164,-165,
            -166,-167,72,-168,-169,-170,-171,-176,78,-212,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-183,-184,-189,-192,-195,
            -196,72,-198,-199,-200,-201,-203,78,-213,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-205,-206,-207,-208,-211,-214,
            72,-215,-216,-217,-218,-224,78,-240,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-227,-228,-230,-231,-241,-242,72,
            -243,-244,-245,-246,-247,78,-85,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-248,-250,-254,-255,-256,0,72,-194,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,0,0,0,0,0,
            0,72,-226,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,92,-236,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,0,0,0,0,0,0,72,-17,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-19,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            -20,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,-43,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-45,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-70,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-71,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            -72,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,-76,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-118,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-143,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-161,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            -172,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,-173,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-181,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-187,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-204,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            -232,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,-234,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,-251,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-252,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,-253,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            -101,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,-117,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,-102,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,-116,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,-103,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,-104,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,-112,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            -113,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,-114,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,-115,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,-105,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,-106,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,-58,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,-59,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,0,0,82,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-81,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,82,-110,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,-111,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,-5,-6,82,
            -1,1,2,3,-18,1,2,3,4,5,
            6,7,8,120,0,0,-174,1,2,3,
            -238,1,2,3,4,5,6,7,8,-239,
            1,2,3,4,5,6,7,8,-22,82,
            0,-178,1,2,3,0,0,0,-93,1,
            2,3,4,5,6,7,8,-24,-7,1,
            2,3,4,5,67,67,66,0,-26,-29,
            0,71,0,0,0,-31,76,77,0,75,
            80,81,66,83,84,85,86,71,0,0,
            90,91,76,77,0,75,0,81,0,99,
            100,0,0,0,75,67,106,66,0,0,
            0,0,71,113,114,115,96,76,77,0,
            104,105,81,75,67,96,68,69,70,-8,
            1,2,3,4,5,67,67,79,-75,1,
            2,3,67,0,0,104,105,-9,1,2,
            3,4,5,-11,1,2,3,4,5,-12,
            1,2,3,4,5,-27,1,2,3,4,
            5,-162,1,2,3,4,5,6,7,8,
            -175,1,2,3,4,5,6,7,8,0,
            0,0,0,0,0,0,0,68,69,70,
            0,0,0,0,66,0,0,-74,79,-79,
            1,2,3,4,5,68,69,70,0,0,
            -35,68,69,70,0,0,79,68,69,70,
            -123,-220,79,68,69,70,0,0,79,0,
            102,103,0,0,79,-222,75,-82,1,2,
            3,4,5,0,0,75,-179,1,2,3,
            4,5,6,7,8,-225,1,2,3,4,
            5,6,7,8,67,0,0,68,69,70,
            -84,1,2,3,4,5,-193,1,2,3,
            4,5,-221,1,2,3,0,67,67,-89,
            1,2,3,83,84,85,86,0,-90,1,
            2,3,67,0,0,68,69,70,0,0,
            100,-119,1,2,3,-235,1,2,3,0,
            0,75,-60,1,2,3,116,0,0,0,
            75,-186,1,2,3,0,0,0,68,69,
            70,0,0,0,68,69,70,0,66,0,
            0,0,0,71,0,0,0,0,76,77,
            71,0,0,81,66,0,77,0,0,0,
            0,0,0,0,0,0,0,66,0,0,
            0,66,93,0,0,0,0,0,0,0,
            0,76,0,71,0,0,0,66,0,0,
            111,0,87,0,0,0,0,109,110,0,
            0,0,0,102,103,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,112,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            106,107,107,107,107,107,107,107,107,107,
            107,107,107,107,107,107,108,122,122,122,
            122,122,122,122,122,122,122,122,68,123,
            69,69,69,9,1,1,2,2,70,70,
            6,6,5,5,5,5,5,5,5,5,
            4,4,4,4,4,75,75,75,75,7,
            8,109,109,110,110,76,66,77,71,93,
            93,87,87,81,81,81,81,10,10,10,
            10,11,11,94,94,95,95,88,88,89,
            13,13,13,13,13,13,13,12,111,111,
            15,16,17,17,18,18,19,20,21,14,
            14,14,22,22,24,24,25,25,25,26,
            26,23,23,23,28,28,28,28,28,28,
            28,28,28,30,29,29,31,31,31,74,
            78,78,72,72,61,61,33,32,62,62,
            65,65,63,63,64,64,59,59,58,58,
            60,60,56,56,55,55,57,57,53,53,
            52,52,54,54,50,50,49,49,49,51,
            51,51,47,47,46,46,46,46,46,48,
            48,48,48,48,44,44,43,43,43,45,
            45,45,41,41,40,40,40,42,42,42,
            82,82,34,34,34,35,35,35,27,27,
            36,36,36,36,36,38,37,112,112,106,
            106,106,106,106,106,122,122,122,122,122,
            122,122,122,122,122,122,79,79,5,96,
            96,28,31,73,74,39,39,97,97,98,
            98,92,92,92,36,113,113,114,114,99,
            115,116,116,100,100,83,83,83,84,117,
            117,91,91,85,85,101,101,80,80,80,
            102,102,86,119,119,90,90,90,103,118,
            104,104,105,105,67,120,3,1,7,12,
            111,31,38,38,38,38,27,39,39,85,
            102,102,80,80,80,103,103,103,118,118,
            90,90,90,91,91,99,99,79,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,1130,144,
            801,149,789,845,613,408,307,5,39,1136,
            44,549,40,408,307,673,153,4251,549,40,
            408,307,434,746,699,85,87,549,1134,408,
            307,1053,1131,127,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,1130,144,801,149,789,274,
            275,276,277,285,773,274,275,276,277,266,
            16,611,549,1135,408,307,549,615,408,307,
            816,85,87,1034,526,1039,989,1132,1131,249,
            976,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            1380,1385,801,149,789,1384,880,879,254,134,
            1382,1137,1169,1093,1172,71,286,1175,1177,1178,
            294,1195,1042,1026,77,1096,1383,473,1144,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,142,144,
            801,149,789,72,254,1299,254,1300,1301,1533,
            130,174,286,71,280,865,435,956,82,978,
            549,973,408,307,1465,1,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,263,144,801,149,
            789,70,549,609,408,307,848,69,423,285,
            595,121,1067,1076,349,648,767,27,460,981,
            1146,678,1077,99,1082,126,768,259,1195,384,
            612,1153,1375,1377,40,523,408,307,697,109,
            690,696,111,146,222,77,78,79,80,90,
            91,691,93,94,95,96,220,112,113,114,
            115,698,121,122,123,133,786,221,204,207,
            614,215,223,264,776,794,199,782,792,189,
            781,795,179,785,791,172,784,796,166,788,
            790,160,787,799,154,263,144,801,149,789,
            293,254,138,849,279,236,273,347,1180,310,
            421,793,476,961,1091,910,1053,1183,1167,1100,
            780,1185,1103,1012,1155,1186,259,1125,880,520,
            603,1378,1377,175,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,142,144,801,149,789,868,
            254,1455,876,1108,1106,1297,1011,549,887,408,
            307,1296,212,523,408,307,697,109,690,696,
            111,146,222,77,78,79,80,90,91,691,
            93,94,95,96,220,112,113,114,115,698,
            121,122,123,133,786,221,204,207,614,215,
            223,264,776,794,199,782,792,189,781,795,
            179,785,791,172,784,796,166,788,790,160,
            787,799,154,142,144,801,149,789,228,880,
            879,1188,1190,201,1297,1195,549,887,408,307,
            1307,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,1130,144,801,149,789,1459,254,137,
            290,1193,1194,1110,1062,1115,751,871,1197,962,
            1196,987,725,750,1019,923,1118,1119,1014,86,
            87,286,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,142,144,801,149,789,880,879,1121,
            1122,1131,1133,1297,817,1123,897,1198,1200,1454,
            323,523,408,307,697,109,690,696,111,146,
            222,77,78,79,80,90,91,691,93,94,
            95,96,220,112,113,114,115,698,121,122,
            123,133,786,221,204,207,614,215,223,264,
            776,794,199,782,792,189,781,795,179,785,
            791,172,784,796,166,788,790,160,787,799,
            154,142,144,801,149,789,1201,1202,1134,534,
            778,1206,1297,1203,1211,1207,1217,1222,1456,360,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            142,144,801,149,789,1223,1230,1212,1229,1136,
            1236,1297,946,877,1231,1235,974,1457,436,523,
            408,307,697,109,690,696,111,146,222,77,
            78,79,80,90,91,691,93,94,95,96,
            220,112,113,114,115,698,121,122,123,133,
            786,221,204,207,614,215,223,264,776,794,
            199,782,792,189,781,795,179,785,791,172,
            784,796,166,788,790,160,787,799,154,142,
            144,801,149,789,1237,1241,1242,1255,1256,1213,
            1297,1262,1218,1250,1139,1248,1534,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,142,144,
            801,149,789,1163,1264,1266,1270,1271,4478,898,
            473,523,408,307,697,109,690,696,111,146,
            222,77,78,79,80,90,91,691,93,94,
            95,96,220,112,113,114,115,698,121,122,
            123,133,786,221,204,207,614,215,223,264,
            776,794,199,782,792,189,781,795,179,785,
            791,172,784,796,166,788,790,160,787,799,
            154,142,144,801,149,789,4478,4478,4478,4478,
            4478,4478,1379,397,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,263,144,801,149,789,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,260,473,523,408,307,
            697,109,690,696,111,146,222,77,78,79,
            80,90,91,691,93,94,95,96,220,112,
            113,114,115,698,121,122,123,133,786,221,
            204,207,614,215,223,264,776,794,199,782,
            792,189,781,795,179,785,791,172,784,796,
            166,788,790,160,787,799,154,142,144,801,
            149,789,4478,4478,4478,4478,4478,4478,1464,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            67,144,801,149,789,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,282,144,801,149,
            789,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,281,144,801,149,789,510,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,882,144,
            801,149,789,473,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,884,144,801,149,789,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            297,144,801,149,789,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,296,144,801,149,
            789,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,295,144,801,149,789,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,287,144,
            801,149,789,473,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,68,144,801,149,789,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            1298,144,801,149,789,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,226,144,801,149,
            789,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,291,144,801,149,789,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,290,144,
            801,149,789,473,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,143,144,801,149,789,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            89,144,801,149,789,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,1386,144,801,149,
            789,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,786,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,787,
            799,154,1458,144,801,149,789,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,786,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,781,795,179,785,791,172,784,
            796,166,788,790,160,787,799,154,1461,144,
            801,149,789,473,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,786,221,204,207,614,
            215,223,264,776,794,199,782,792,189,781,
            795,179,785,791,172,784,796,166,788,790,
            160,787,799,154,1535,144,801,149,789,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,786,221,204,207,614,215,223,264,776,
            794,199,782,792,189,781,795,179,785,791,
            172,784,796,166,788,790,160,787,799,154,
            1536,144,801,149,789,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,786,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,785,791,172,784,796,166,
            788,790,160,787,799,154,1537,144,801,149,
            789,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,1137,221,204,207,614,215,223,
            264,776,794,199,782,792,189,781,795,179,
            785,791,172,784,796,166,788,790,160,156,
            1138,155,473,523,408,307,697,109,690,696,
            111,146,222,77,78,79,80,90,91,691,
            93,94,95,96,220,112,113,114,115,698,
            121,122,123,133,1226,221,204,207,614,215,
            223,264,776,794,199,782,792,189,781,795,
            179,785,791,172,784,796,166,162,1227,161,
            473,523,408,307,697,109,690,696,111,146,
            222,77,78,79,80,90,91,691,93,94,
            95,96,220,112,113,114,115,698,121,122,
            123,133,1139,221,204,207,614,215,223,264,
            776,794,199,782,792,189,781,795,179,785,
            791,172,168,1140,167,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,1224,221,204,
            207,614,215,223,264,776,794,199,782,792,
            189,781,795,179,174,1225,173,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,1141,
            221,204,207,614,215,223,264,776,794,199,
            782,792,189,182,1142,181,473,523,408,307,
            697,109,690,696,111,146,222,77,78,79,
            80,90,91,691,93,94,95,96,220,112,
            113,114,115,698,121,122,123,133,1141,221,
            204,207,614,215,223,264,776,794,199,782,
            792,189,182,1143,180,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,1148,221,204,
            207,614,215,223,264,776,794,199,194,1219,
            193,473,523,408,307,697,109,690,696,111,
            146,222,77,78,79,80,90,91,691,93,
            94,95,96,220,112,113,114,115,698,121,
            122,123,133,1148,221,204,207,614,215,223,
            264,776,794,199,194,1220,192,473,523,408,
            307,697,109,690,696,111,146,222,77,78,
            79,80,90,91,691,93,94,95,96,220,
            112,113,114,115,698,121,122,123,133,1148,
            221,204,207,614,215,223,264,776,794,199,
            194,1221,191,473,523,408,307,697,109,690,
            696,111,146,222,77,78,79,80,90,91,
            691,93,94,95,96,220,112,113,114,115,
            698,121,122,123,133,1148,221,204,207,614,
            215,223,264,776,794,199,194,1222,190,473,
            523,408,307,697,109,690,696,111,146,222,
            77,78,79,80,90,91,691,93,94,95,
            96,220,112,113,114,115,698,121,122,123,
            133,1145,221,204,207,614,215,223,264,202,
            1146,201,473,523,408,307,697,109,690,696,
            111,146,222,77,78,79,80,90,91,691,
            93,94,95,96,220,112,113,114,115,698,
            121,122,123,133,1145,221,204,207,614,215,
            223,264,202,1147,200,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,885,221,210,
            217,614,215,223,264,473,523,408,307,697,
            109,690,696,111,146,222,77,78,79,80,
            90,91,691,93,94,95,96,220,112,113,
            114,115,698,121,122,123,133,885,221,210,
            216,614,215,223,264,4478,4478,214,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,721,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,213,473,523,
            408,307,697,109,690,696,111,146,222,77,
            78,79,80,90,91,691,93,94,95,96,
            220,112,113,114,115,698,121,122,123,133,
            885,221,210,209,614,215,223,264,473,523,
            408,307,697,109,690,696,111,146,222,77,
            78,79,80,90,91,691,93,94,95,96,
            220,112,113,114,115,698,121,122,123,133,
            885,221,210,208,614,215,223,264,596,884,
            206,925,415,408,307,743,40,408,307,876,
            55,877,57,58,894,4478,4478,783,415,408,
            307,718,40,408,307,876,55,877,57,58,
            547,40,408,307,876,55,877,57,58,899,
            205,4478,954,415,408,307,4478,4478,4478,743,
            40,408,307,876,55,877,57,58,932,571,
            38,408,307,30,31,334,333,75,4478,967,
            972,4478,76,4478,4478,4478,1047,73,74,4478,
            873,230,233,75,273,275,276,277,76,4478,
            4478,231,232,73,74,4478,250,4478,302,4478,
            267,416,4478,4478,4478,250,332,407,75,4478,
            4478,4478,4478,76,410,265,268,298,73,74,
            4478,1304,1305,302,1133,331,299,32,39,4069,
            598,38,408,307,30,31,330,323,601,573,
            4261,408,307,322,4478,4478,1306,1305,622,38,
            408,307,30,31,646,38,408,307,30,31,
            670,38,408,307,30,31,694,38,408,307,
            30,31,743,40,408,307,876,55,877,57,
            58,743,40,408,307,876,55,877,57,58,
            4478,4478,4478,4478,4478,4478,4478,4478,32,39,
            4088,4478,4478,4478,4478,889,4478,4478,1085,602,
            821,38,408,893,30,31,32,39,4099,4478,
            4478,977,32,39,4100,4478,4478,604,32,39,
            4106,798,1148,607,32,39,4238,4478,4478,608,
            4478,288,888,4478,4478,878,1150,1303,821,38,
            408,307,30,31,4478,4478,66,743,40,408,
            307,876,55,877,57,58,743,40,408,307,
            876,55,877,57,58,324,4478,4478,32,39,
            892,821,38,408,307,30,31,821,38,408,
            307,30,31,549,415,408,307,4478,321,325,
            624,973,408,307,273,275,276,277,4478,776,
            1051,408,307,328,4478,4478,32,39,41,4478,
            4478,422,573,4261,408,307,549,1463,408,307,
            4478,4478,783,549,887,408,307,3924,4478,4478,
            4478,262,549,1051,408,307,4478,4478,4478,32,
            39,525,4478,4478,4478,32,39,897,4478,75,
            4478,4478,4478,4478,76,4478,4478,4478,4478,73,
            74,70,4478,4478,303,63,4478,69,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,889,4478,
            4478,4478,72,98,4478,4478,4478,4478,4478,4478,
            4478,4478,71,4478,227,4478,4478,4478,64,4478,
            4478,969,4478,1462,4478,4478,4478,4478,974,1052,
            4478,4478,4478,4478,289,888,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,886,4478,0
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,0,27,28,29,
            30,31,32,33,34,35,36,0,0,0,
            1,2,3,0,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,25,25,65,27,28,29,30,
            31,32,33,34,35,36,0,73,0,1,
            2,0,56,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,0,25,65,27,28,29,30,31,
            32,33,34,35,36,72,40,41,42,43,
            0,40,41,42,43,0,0,1,2,0,
            52,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,0,27,28,29,30,31,32,33,
            34,35,36,0,44,45,46,47,39,44,
            45,46,47,0,0,1,2,3,52,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,25,25,
            0,27,28,29,30,31,32,33,34,35,
            36,0,1,2,3,63,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,0,25,2,27,28,
            29,30,31,32,33,34,35,36,0,1,
            2,3,52,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,0,25,2,27,28,29,30,31,
            32,33,34,35,36,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,2,27,28,29,30,31,32,33,34,
            35,36,0,1,2,3,0,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,0,27,
            28,29,30,31,32,33,34,35,36,0,
            1,2,3,74,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,39,27,28,29,30,
            31,32,33,34,35,36,0,1,2,51,
            0,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,2,27,28,29,30,31,32,33,
            34,35,36,0,0,0,1,2,3,56,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,65,27,28,29,30,31,32,33,34,
            35,36,0,1,2,0,1,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,63,25,64,27,
            28,29,30,31,32,33,34,35,36,0,
            1,2,53,0,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,2,27,28,29,30,
            31,32,33,34,35,36,0,1,0,1,
            75,5,6,5,6,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,1,0,1,4,5,6,5,6,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,0,1,0,1,4,
            54,4,5,6,58,59,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,1,0,1,4,5,6,5,6,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,0,1,0,54,4,
            5,6,58,59,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            1,24,0,4,5,6,4,0,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,1,48,24,4,5,6,
            0,24,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,0,1,0,
            0,1,5,6,0,48,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,0,1,0,0,1,5,6,0,
            0,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,0,44,45,
            46,47,0,7,8,0,1,0,3,2,
            5,6,0,1,39,3,66,5,6,39,
            24,0,0,44,45,46,47,0,1,2,
            55,4,57,37,38,60,40,41,42,43,
            44,45,46,47,48,0,0,51,51,53,
            0,1,56,7,8,5,6,55,62,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,1,54,0,0,5,
            6,7,8,37,38,8,40,41,42,43,
            44,45,46,47,0,1,2,0,24,54,
            0,27,24,58,59,0,0,7,8,0,
            1,37,38,0,1,38,0,4,44,45,
            46,47,48,26,24,51,0,53,0,1,
            56,26,4,7,8,26,62,37,38,0,
            40,41,42,43,44,45,46,47,48,52,
            24,51,0,53,0,1,50,52,64,5,
            6,0,1,37,38,4,40,41,42,43,
            44,45,46,47,48,0,70,51,69,40,
            41,42,43,0,1,0,3,2,5,6,
            0,0,40,41,42,43,0,1,7,8,
            4,0,1,0,1,4,0,0,54,55,
            0,57,58,59,60,24,0,63,0,0,
            0,67,68,7,8,50,72,73,37,38,
            0,40,41,42,43,44,45,46,47,48,
            0,0,2,0,4,39,39,0,0,64,
            2,8,4,37,38,0,40,41,42,43,
            0,71,55,0,57,2,26,60,0,63,
            2,0,62,55,71,57,0,1,60,39,
            4,38,0,40,41,42,43,39,0,49,
            50,0,1,2,39,54,0,49,50,58,
            59,61,39,7,49,0,0,39,26,61,
            70,0,49,7,0,1,61,49,4,8,
            0,1,0,3,61,0,55,2,57,0,
            1,60,0,37,2,0,4,0,3,0,
            1,4,3,37,0,1,2,0,0,38,
            0,0,0,24,0,8,8,7,7,77,
            0,24,0,0,1,0,0,7,0,7,
            4,3,67,68,49,0,24,0,1,0,
            1,4,0,4,0,38,38,37,37,67,
            68,26,0,39,26,3,0,37,0,37,
            48,0,4,49,0,4,0,0,4,0,
            4,4,0,4,0,0,4,0,26,0,
            24,4,0,0,0,0,0,0,53,0,
            0,0,0,3,69,0,0,2,24,76,
            0,0,0,3,62,26,0,0,26,3,
            66,0,0,24,3,3,24,26,0,0,
            0,3,26,4,0,0,0,26,3,3,
            0,0,2,49,3,52,51,0,0,0,
            53,66,56,4,0,0,26,3,3,0,
            26,0,50,0,3,0,3,50,3,0,
            0,0,3,3,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,50,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            4478,4784,2043,257,4478,4514,4512,3865,4584,4528,
            4529,4530,4531,4532,4523,4521,4524,4522,4520,695,
            4525,4527,4526,4726,4478,4580,152,3825,4578,4579,
            4511,1977,4363,4582,4583,4586,4585,4478,35,4478,
            4784,2043,257,229,4514,4512,3865,4584,4528,4529,
            4530,4531,4532,4523,4521,4524,4522,4520,695,4525,
            4527,4526,4726,4515,4580,1376,3825,4578,4579,4511,
            1977,4363,4582,4583,4586,4585,212,4477,4478,4784,
            2043,4478,156,4514,4512,3865,4584,4528,4529,4530,
            4531,4532,4523,4521,4524,4522,4520,695,4525,4527,
            4526,4726,4478,4580,1376,3825,4578,4579,4511,1977,
            4363,4582,4583,4586,4585,411,218,218,218,218,
            176,516,403,427,512,4478,4478,4784,2043,4478,
            83,4514,4512,3865,4584,4528,4529,4530,4531,4532,
            4523,4521,4524,4522,4520,695,4525,4527,4526,4726,
            4478,4580,270,3825,4578,4579,4511,1977,4363,4582,
            4583,4586,4585,4478,182,182,182,182,4311,3693,
            3647,3601,3555,92,4478,4784,2043,140,83,4514,
            4512,3865,4584,4528,4529,4530,4531,4532,4523,4521,
            4524,4522,4520,695,4525,4527,4526,4726,4581,4580,
            4478,3825,4578,4579,4511,1977,4363,4582,4583,4586,
            4585,4478,4784,2043,140,772,4514,4512,3865,4584,
            4528,4529,4530,4531,4532,4523,4521,4524,4522,4520,
            695,4525,4527,4526,4726,4478,4580,4339,3825,4578,
            4579,4511,1977,4363,4582,4583,4586,4585,4478,4784,
            2043,4602,4560,4514,4512,3865,4584,4528,4529,4530,
            4531,4532,4523,4521,4524,4522,4520,695,4525,4527,
            4526,4726,4478,4580,4079,3825,4578,4579,4511,1977,
            4363,4582,4583,4586,4585,4478,4784,2043,140,88,
            4514,4512,3865,4584,4528,4529,4530,4531,4532,4523,
            4521,4524,4522,4520,695,4525,4527,4526,4726,4478,
            4580,903,3825,4578,4579,4511,1977,4363,4582,4583,
            4586,4585,4478,4784,2043,140,4478,4514,4512,3865,
            4584,4528,4529,4530,4531,4532,4523,4521,4524,4522,
            4520,695,4525,4527,4526,4726,56,4580,164,3825,
            4578,4579,4511,1977,4363,4582,4583,4586,4585,4478,
            4784,2043,140,2769,4514,4512,3865,4584,4528,4529,
            4530,4531,4532,4523,4521,4524,4522,4520,695,4525,
            4527,4526,4726,4478,4580,4278,3825,4578,4579,4511,
            1977,4363,4582,4583,4586,4585,4478,4784,2043,168,
            4478,4514,4512,3865,4584,4528,4529,4530,4531,4532,
            4523,4521,4524,4522,4520,695,4525,4527,4526,4726,
            252,4580,254,3825,4578,4579,4511,1977,4363,4582,
            4583,4586,4585,272,110,4478,4784,2043,140,3292,
            4514,4512,3865,4584,4528,4529,4530,4531,4532,4523,
            4521,4524,4522,4520,695,4525,4527,4526,4726,158,
            4580,1376,3825,4578,4579,4511,1977,4363,4582,4583,
            4586,4585,4478,4784,2043,4478,4792,4514,4512,3865,
            4584,4528,4529,4530,4531,4532,4523,4521,4524,4522,
            4520,695,4525,4527,4526,4726,772,4580,337,3825,
            4578,4579,4511,1977,4363,4582,4583,4586,4585,4478,
            883,2043,162,4478,4514,4512,3865,4584,4528,4529,
            4530,4531,4532,4523,4521,4524,4522,4520,695,4525,
            4527,4526,4726,4478,4580,1151,3825,4578,4579,4511,
            1977,4363,4582,4583,4586,4585,4478,4784,4478,4784,
            2439,4514,4512,4514,4512,4528,4529,4530,4531,4532,
            4523,4521,4524,4522,4520,875,4525,4527,4526,4726,
            4478,4784,4478,891,246,4514,4512,4514,4512,4528,
            4529,4530,4531,4532,4523,4521,4524,4522,4520,4506,
            4525,4527,4526,4726,4478,4478,4782,4478,4784,1845,
            249,246,4514,4512,249,249,4528,4529,4530,4531,
            4532,4523,4521,4524,4522,4520,4506,4525,4527,4526,
            4726,4478,4784,4478,972,246,4514,4512,4514,4512,
            4528,4529,4530,4531,4532,4523,4521,4524,4522,4520,
            4506,4525,4527,4526,4726,4478,4784,170,4178,246,
            4514,4512,4160,4089,4528,4529,4530,4531,4532,4523,
            4521,4524,4522,4520,4506,4525,4527,4526,4726,4478,
            4784,174,65,246,4514,4512,4035,4478,4528,4529,
            4530,4531,4532,4523,4521,4524,4522,4520,4506,4525,
            4527,4526,4726,4478,4784,174,1779,246,4514,4512,
            4478,3506,4528,4529,4530,4531,4532,4523,4521,4524,
            4522,4520,4506,4525,4527,4526,4726,4478,4784,4478,
            4478,895,4514,4512,178,3457,4528,4529,4530,4531,
            4532,4523,4521,4524,4522,4520,875,4525,4527,4526,
            4726,249,4478,4784,4478,4478,4797,4514,4512,177,
            4478,4528,4529,4530,4531,4532,4523,4521,4524,4522,
            4520,875,4525,4527,4526,4726,145,4478,3693,3647,
            3601,3555,4478,195,203,4478,4784,136,61,1230,
            4514,4512,4478,4784,4240,300,4747,4514,4512,4317,
            175,4478,4478,3693,3647,3601,3555,4478,1228,4047,
            4184,4211,4190,195,203,504,219,219,219,219,
            183,183,183,183,175,292,175,169,3405,163,
            4478,4784,157,195,203,4514,4512,4196,151,4528,
            4529,4530,4531,4532,4523,4521,4524,4522,4520,4506,
            4525,4527,4526,4726,4478,4784,4731,196,66,4514,
            4512,4491,4492,195,203,202,219,219,219,219,
            183,183,183,183,4478,4787,4339,4478,4488,4178,
            157,4481,2373,4160,4089,306,4478,195,203,4478,
            4789,4490,4493,4478,4782,202,4478,1911,4487,4484,
            4486,4485,4489,700,175,4479,163,4482,4478,4782,
            4483,310,247,195,203,2703,4480,195,203,211,
            219,219,219,219,183,183,183,183,175,4575,
            175,169,203,163,4478,4784,2967,310,4330,4514,
            4512,4478,4782,195,203,247,219,219,219,219,
            183,183,183,183,175,4478,1056,169,798,219,
            219,219,219,4478,4784,4478,300,4079,4514,4512,
            306,169,219,219,219,219,4478,4782,195,203,
            247,4478,4782,4478,4790,247,271,4478,4178,4184,
            4478,4190,4160,4089,504,175,183,772,283,4478,
            4478,4028,4029,195,203,2901,411,234,195,203,
            4478,219,219,219,219,183,183,183,183,175,
            147,307,139,195,4035,4278,4278,4478,147,433,
            139,203,4211,195,203,139,219,219,219,219,
            4478,4793,4184,147,4190,139,617,504,139,772,
            982,284,3231,4184,4703,4190,4478,4782,504,40,
            247,203,4478,219,219,219,219,40,4478,881,
            65,4478,4796,705,40,329,184,881,65,329,
            329,1467,40,194,881,4478,4478,41,977,1467,
            65,4478,881,3739,4478,4782,1540,881,247,3988,
            4478,4794,278,4702,1467,4478,4184,529,4190,4478,
            4798,504,41,194,4072,4478,4287,4478,4538,4478,
            4786,4202,4537,3782,4478,4795,804,198,197,3948,
            188,187,171,2637,139,3988,3988,3739,3739,2505,
            186,1779,185,4478,4791,4478,4478,3739,4478,3739,
            2109,4604,4028,4029,881,4478,3506,4478,4782,4478,
            4782,4051,148,4060,4478,3948,3948,3782,3782,4028,
            4029,2703,4478,41,2703,4605,4478,3782,4478,3782,
            3457,4478,2175,881,4478,2241,4478,40,4169,4478,
            2307,418,4478,4352,306,336,4202,4478,2703,62,
            2571,4211,84,4478,139,165,153,159,3350,304,
            4478,141,4478,4608,1055,4478,301,1309,327,2835,
            4478,258,4478,4262,150,4372,4478,4478,1061,4276,
            4813,4478,4478,326,4609,4734,2373,2703,4478,261,
            72,4733,4323,4296,144,4478,4478,1613,4603,4606,
            135,4478,1388,881,4607,4559,3405,4478,4478,65,
            3350,305,3292,4211,4478,4478,4356,4729,4597,4478,
            1706,4478,3033,4478,4594,4478,4610,3099,4598,4478,
            4478,4478,4596,4595,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,4478,4478,4478,
            4478,4478,4478,4478,4478,4478,4478,3165
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            442,101,54,103,516,516,499,499,499,109,
            499,499,235,153,235,100,206,220,206,206,
            517,516,517,516,517,516,499,517,516,517,
            516,200,351,352,519,61,356,57,114,157,
            161,158,206,334,206,65,69,67,75,73,
            61,77,76,239,241,243,246,206,206,235,
            51,424,249,251,78,260,33,33,253,206,
            206,206,517,516,235,206,195,235,220,94,
            307,220,306,220,206,33,267,202,235,391,
            1,1,220,310,313,235,235,35,235,393,
            206,206,206,206,206,206,61,339,517,206,
            206,206,206,206,206,206,206,206,235,475,
            474,342,343,353,350,347,308,99,58,358,
            362,430,396,398,394,517,106,431,429,430,
            431,393,206,32,32,111,356,57,111,61,
            77,61,75,61,69,69,61,65,65,235,
            206,220,61,67,67,67,67,61,73,61,
            76,206,206,391,220,300,94,391,220,362,
            206,60,394,106,235,235,206,206,433,204,
            204,33,220,206,267,33,362,475,394,106,
            394,454,394,206,394,105,106,394,362,58,
            359,362,362,394,265,264,263,106,401,516,
            235,516,149,436,220,205,394,267,60,394,
            394,206,235,206,235,206,206,457,477,362,
            394,265,394,265,439,106,265,106,402,394,
            206,206,206,394,394,394
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            52,32,7,27,31,9,10,11,12,13,
            19,35,36,8,33,34,25,29,28,18,
            15,17,14,16,20,22,21,23,30,6,
            5,1,2,0,5,1,6,51,62,27,
            53,56,45,47,46,44,24,48,37,7,
            8,38,0,4,70,25,61,39,2,49,
            40,41,42,43,8,38,37,7,44,45,
            46,47,24,48,51,53,56,62,3,52,
            69,50,26,74,75,76,71,77,54,58,
            59,67,68,63,1,57,55,60,66,72,
            73,0,73,24,4,3,26,0,55,0,
            2,49,0,37,7,8,38,44,45,24,
            46,47,48,3,52,69,40,50,26,41,
            74,42,43,75,76,71,51,53,56,62,
            77,57,54,58,55,59,60,25,66,1,
            68,67,72,73,63,0,1,2,64,0,
            37,7,8,38,44,45,24,46,47,48,
            3,52,69,40,50,26,41,74,42,43,
            75,76,71,51,53,56,62,77,57,55,
            67,68,60,64,63,72,66,73,1,58,
            59,54,0,3,65,32,7,27,2,31,
            35,36,8,33,34,25,29,28,30,18,
            15,17,14,16,20,22,21,23,9,10,
            11,12,13,19,6,1,5,0,62,0,
            53,0,24,48,0,37,7,0,51,0,
            56,0,54,58,59,67,68,1,39,3,
            73,24,26,70,50,0,2,37,7,8,
            38,44,45,46,47,48,3,52,69,40,
            50,26,41,74,42,43,75,76,71,51,
            53,56,62,77,54,58,59,67,68,24,
            57,72,55,60,73,63,1,66,0,75,
            1,0,37,7,8,38,44,45,24,46,
            47,48,2,61,39,49,75,51,53,56,
            62,1,71,40,41,43,42,0,77,26,
            0,24,1,4,2,0,54,58,59,2,
            4,1,57,55,60,39,0,1,69,26,
            0,32,7,27,2,31,9,10,11,12,
            13,19,35,36,8,33,34,25,29,28,
            18,15,17,14,16,20,22,21,23,30,
            6,5,1,3,0,52,26,24,4,0,
            70,37,7,8,38,24,48,3,40,26,
            41,42,43,51,53,56,62,50,39,2,
            49,4,61,44,45,46,47,0,74,26,
            52,0,76,1,0,71,1,0,50,4,
            0,73,72,63,57,55,60,54,58,59,
            6,1,5,68,67,0,18,15,17,14,
            16,20,22,21,23,5,6,9,10,11,
            12,13,19,1,24,0,54,58,59,18,
            15,17,14,16,20,22,21,23,5,1,
            6,9,10,11,12,13,19,0,9,10,
            11,12,13,18,15,17,14,16,20,22,
            21,23,19,5,6,1,4,0,66,1,
            63,39,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            92,24,24,24,90,90,23,23,23,24,
            23,23,30,6,23,4,20,22,20,20,
            24,90,24,90,24,90,23,24,90,24,
            90,33,24,8,93,24,24,12,24,24,
            24,24,20,24,20,24,24,24,24,24,
            24,24,24,24,24,24,24,82,82,109,
            24,24,24,24,24,24,24,24,24,20,
            20,20,24,90,95,20,10,23,100,16,
            88,23,6,23,20,24,24,24,103,106,
            20,20,22,24,24,23,23,1,23,24,
            40,52,64,64,76,76,24,24,24,82,
            82,70,70,70,70,58,46,20,95,24,
            24,24,90,8,24,24,24,24,14,24,
            20,24,24,24,24,24,24,24,24,24,
            24,24,20,24,24,14,24,14,12,24,
            24,24,24,24,24,24,24,24,24,37,
            20,22,24,24,24,24,24,24,24,24,
            24,20,20,23,22,24,16,23,22,20,
            20,14,24,24,27,97,20,20,24,20,
            20,24,23,20,24,24,18,24,24,24,
            24,35,24,20,24,24,24,24,20,14,
            24,20,20,24,24,24,24,24,12,90,
            23,90,25,24,22,20,24,24,14,24,
            24,20,37,20,23,20,20,22,22,20,
            24,24,24,24,24,24,24,24,12,24,
            20,20,20,24,24,24
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,108,0,99,0,83,0,101,0,90,
            0,73,0,74,0,80,0,66,71,7,
            17,4,2,0,91,0,2,93,0,2,
            118,0,119,0,117,0,2,71,0,7,
            17,4,2,60,0,4,7,17,2,57,
            0,7,17,4,2,54,0,4,7,17,
            2,51,0,7,17,4,2,48,0,4,
            7,17,2,45,0,7,17,4,2,42,
            0,2,7,17,4,35,0,120,0,67,
            0,2,100,0,103,102,2,66,0,2,
            3,0,2,111,0,110,2,0,2,112,
            0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            80,11,12,20,30,77,2,3,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,75,7,33,19,42,31,32,34,
            35,44,46,47,48,49,1,4,21,17,
            23,26,27,5,6,8,9,10,25,18,
            39,14,40,65,70,41,64,66,71,74,
            15,43,67,13,28,69,72,73,16,22,
            38,68,76,24,36,37,45,78,79
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            83,84,150,82,0,86,88,0,0,0,
            0,0,0,0,0,0,98,0,0,0,
            0,0,0,0,0,0,100,0,0,0,
            0,103,0,0,128,129,0,0,0,124,
            125,126,121,122,123,118,119,120,115,116,
            117,112,113,114,109,110,111,106,107,108,
            91,101,104,0,105,90,148,0,0,85,
            92,102,135,0,87,0,0,0,0,132,
            95,127,140,0,0,0,94,97,0,133,
            134,137,93,0,96,0,0,136,138,139,
            142,143,144,0,147,0,0,81,0,89,
            99,130,131,0,0,0,141,145,146,149,
            0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            215,251,261,149,183,191,237,271,225,18,
            57,18,169,176,43,51,158,209,143,199,
            245,9,164,9,9,35,39,279,285,289,
            293,39,35,1,6,1,64,6,6,6,
            82,82,90,90,98,98,98,98,112,112,
            120,125,130,135
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            49,49,49,49,49,49,49,49,233,4,
            49,70,49,49,49,49,49,49,140,205,
            233,4,49,25,72,4,4,283,283,283,
            49,49,140,4,4,49,67,14,29,76,
            84,87,92,95,100,103,106,109,114,117,
            122,127,132,137
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            26,25,25,28,28,28,26,25,26,38,
            28,38,28,28,39,39,28,28,31,28,
            26,38,28,38,38,31,7,12,11,11,
            8,7,31,27,38,36,37,38,38,38,
            42,42,45,45,48,48,48,48,51,51,
            54,57,60,64
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            3,3,3,3,3,3,3,3,50,1,
            3,71,3,3,3,3,3,3,69,26,
            50,1,3,76,76,1,1,52,52,52,
            3,3,69,1,1,3,77,75,75,75,
            38,8,7,37,47,46,45,44,48,24,
            51,53,56,62
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,1,9,9,9,
            1,1,9,9,9,9,9,9,9,9,
            13,13,15,15,19,19,19,19,21,21,
            22,23,24,25
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            140,2,0,1,0,140,31,0,140,75,
            140,31,0,75,140,1,0,140,76,140,
            75,140,31,0,76,140,1,0,75,140,
            76,140,1,0,151,61,80,0,154,2,
            83,0,176,2,80,42,106,0,3,0,
            176,2,80,43,106,0,157,2,152,80,
            40,106,0,191,32,0,77,140,0,71,
            0,76,140,71,0,75,140,76,140,71,
            0,120,0,38,114,0,8,114,0,123,
            0,7,121,0,37,121,0,126,0,47,
            124,0,46,124,0,45,124,0,44,124,
            0,129,0,48,127,0,24,127,0,132,
            0,51,130,0,135,0,53,133,0,138,
            0,56,136,0,144,0,62,139,0,69,
            153,0,151,61,80,41,106,0,157,2,
            153,149,39,85,41,106,0,157,2,149,
            39,85,0,157,2,153,80,0,157,2,
            153,80,41,106,0,157,2,153,187,41,
            106,0,151,26,80,2,80,40,106,0,
            151,26,141,2,80,40,106,0,141,2,
            80,40,106,0,26,151,3,0,140,2,
            80,40,106,0,140,50,150,70,166,2,
            80,40,106,0,150,70,166,2,80,40,
            106,0,50,140,3,0,140,50,150,2,
            80,40,106,0,150,2,80,40,106,0,
            140,50,166,26,145,2,80,40,106,0,
            140,50,166,26,80,2,80,40,106,0,
            140,50,166,2,80,40,106,0,190,64,
            19,0,52,0,173,64,86,0,173,64,
            83,0,188,2,19,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            4060,4051,4296,4287,4211,4202,4079,4035,3988,3948,
            3865,3825,3782,3739,3693,3647,3601,3555,3506,3457,
            3405,3350,3292,3231,3165,3099,3033,1388,617,1706,
            2967,2901,1613,1309,1230,1151,2835,529,1540,804,
            705,1061,2769,2703,982,2637,2571,2505,2439,903,
            2373,433,337,1467,2307,2241,2175,2109,2043,1977,
            1911,1845,1779,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,185,81,80,67,68,59,58,54,60,
            55,57,63,179,72,192,24,4,4,4,
            158,149,158,149,158,149,55,158,149,158,
            149,197,80,85,85,115,85,80,96,19,
            86,83,31,106,2,119,125,122,131,128,
            111,137,134,144,135,129,123,27,7,32,
            120,126,132,138,142,154,19,83,85,4,
            4,4,158,149,4,4,198,4,39,180,
            195,39,179,39,61,153,152,49,64,2,
            64,64,2,140,1,42,43,41,40,140,
            62,53,48,24,7,37,111,191,80,38,
            8,47,46,45,44,51,56,24,4,182,
            145,1,80,85,149,82,199,1,149,151,
            2,190,1,80,188,80,189,173,140,174,
            173,154,75,80,80,187,85,80,80,111,
            138,111,132,111,126,126,111,120,120,26,
            77,4,111,123,123,123,123,111,129,111,
            135,24,24,2,4,1,180,2,4,2,
            26,69,157,151,26,26,74,26,140,2,
            2,153,39,61,153,152,2,154,183,184,
            183,154,157,76,176,65,177,176,2,149,
            151,2,2,140,150,166,145,141,80,3,
            26,3,196,140,4,26,157,153,69,157,
            157,50,70,50,26,26,26,4,4,2,
            140,150,140,166,80,151,166,151,80,157,
            50,50,50,140,140,140
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@",
            "^",
            "^^",
            "?",
            "$empty",
            "QUOTED_IDENTIFIER",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "STRING_LITERAL",
            "self",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "null",
            "invalid",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "OclInvalid",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "body",
            "derive",
            "init",
            "static",
            "OclMessage",
            "EOF_TOKEN",
            "IDENTIFIER",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "ERROR_TOKEN",
            "conceptualOperationNameCS",
            "CollectionTypeIdentifierCS",
            "simpleNameCS",
            "QuotedSimpleNameCS",
            "unreservedSimpleNameCS",
            "pathNameCS",
            "typeCS",
            "collectionTypeCS",
            "tupleTypePartsCS",
            "typedUninitializedVariableCS",
            "OclExpressionCS",
            "typedInitializedVariableCS",
            "initializedVariableCS",
            "uninitializedVariableCS",
            "VariableDeclarationCS",
            "CollectionLiteralPartsCS",
            "CollectionLiteralPartCS",
            "StringLiteralExpCS",
            "TupleLiteralPartsCS",
            "primaryExpCS",
            "notNameExpressionCS",
            "argumentsCS",
            "SimpleNameExpCS",
            "impliesNotNameNotLetCS",
            "impliesNotLetCS",
            "xorNotNameNotLetCS",
            "xorNotLetCS",
            "xorWithLetCS",
            "orNotNameNotLetCS",
            "orNotLetCS",
            "orWithLetCS",
            "andNotNameNotLetCS",
            "andNotLetCS",
            "andWithLetCS",
            "equalityNotNameNotLetCS",
            "equalityNotLetCS",
            "equalityWithLetCS",
            "relationalNotNameNotLetCS",
            "relationalNotLetCS",
            "relationalWithLetCS",
            "additiveNotNameNotLetCS",
            "additiveNotLetCS",
            "additiveWithLetCS",
            "multiplicativeNotNameNotLetCS",
            "multiplicativeNotLetCS",
            "multiplicativeWithLetCS",
            "unaryNotLetCS",
            "unaryWithLetCS",
            "primaryNotNameCS",
            "letVariablesCS",
            "packageDeclarationsCS",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "isMarkedPreCS",
            "OclMessageArgumentsCS",
            "OclMessageArgCS",
            "packageDeclarationCS_A",
            "contextDeclsCS",
            "contextDeclCS",
            "initOrDerValuesCS",
            "invOrDefsCS",
            "defExpressionCS",
            "operationCS1",
            "operationCS2",
            "prePostOrBodyDeclsCS",
            "parametersCS",
            "ERROR_Colon",
            "ERROR_Empty",
            "ERROR_SimpleNameCS"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
