/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.scoping;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.AbstractOperationFilter;

public class ImplicitCollectFilter
extends AbstractOperationFilter {
    protected final Type iteratorType;

    public ImplicitCollectFilter(TypeManager typeManager, CollectionType sourceType, Type iteratorType) {
        super(typeManager, (Type)sourceType);
        this.iteratorType = iteratorType;
    }

    public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
        if (!(eObject instanceof Iteration)) {
            return false;
        }
        Iteration candidateIteration = (Iteration)eObject;
        int iteratorCount = candidateIteration.getOwnedIterators().size();
        if (iteratorCount != 1) {
            return false;
        }
        int accumulatorCount = candidateIteration.getOwnedAccumulators().size();
        if (accumulatorCount != 0) {
            return false;
        }
        TemplateSignature templateSignature = candidateIteration.getClass_().getOwnedTemplateSignature();
        if (templateSignature == null) {
            return false;
        }
        EList templateParameters = templateSignature.getOwnedParameters();
        if (templateParameters.size() != 1) {
            return false;
        }
        Map bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)this.sourceType);
        TemplateParameter iteratorParameter = (TemplateParameter)templateParameters.get(0);
        bindings.put(iteratorParameter, this.iteratorType);
        this.installBindings(environmentView, forType, eObject, bindings);
        return true;
    }
}

