/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.modelregistry.eclipse.ModelResourceResolver;
import org.eclipse.ocl.examples.modelregistry.environment.ModelResolver;
import org.eclipse.ocl.examples.modelregistry.standalone.JavaProjectHandle;
import org.eclipse.ocl.examples.modelregistry.standalone.ModelFileResolver;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationContext;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLCS2Pivot;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSResource
extends LazyLinkingResource
implements BaseCSResource,
EvaluationContext {
    private static final Logger logger = Logger.getLogger(EssentialOCLCSResource.class);
    private PivotEnvironment environment = null;
    private NamedElement specificationContext = null;
    private ModelResolver modelResolver = null;

    protected void addLibraryError(List<Resource.Diagnostic> errors, IllegalLibraryException e) {
        String message = e.getMessage();
        for (Resource.Diagnostic diagnostic : errors) {
            Exception exception;
            if (!(diagnostic instanceof LibraryDiagnostic) || !((exception = ((LibraryDiagnostic)diagnostic).getException()) instanceof IllegalLibraryException) || !message.equals(exception.getMessage())) continue;
            return;
        }
        errors.add((Resource.Diagnostic)new LibraryDiagnostic((Exception)((Object)e)));
    }

    public CS2Pivot createCS2Pivot(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, TypeManager typeManager) {
        return new EssentialOCLCS2Pivot(cs2pivotResourceMap, typeManager);
    }

    public TypeManager createTypeManager() {
        ResourceSet resourceSet = this.getResourceSet();
        TypeManagerResourceSetAdapter resourceSetAdapter = TypeManagerResourceSetAdapter.findAdapter((ResourceSet)resourceSet);
        if (resourceSetAdapter != null) {
            return resourceSetAdapter.getTypeManager();
        }
        return new TypeManager();
    }

    protected void doLinking() {
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (!(error instanceof LibraryDiagnostic)) continue;
                errors.remove(i);
            }
        }
        super.doLinking();
    }

    public PivotEnvironment getEnvironment() {
        return this.environment;
    }

    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    public NamedElement getSpecificationContext() {
        return this.specificationContext;
    }

    public URI resolve(URI uri) {
        try {
            java.net.URI javaURI;
            URI resolvedURI;
            ModelResolver resolver = this.useModelResolver();
            if (resolver != null && (resolvedURI = resolver.getURI(javaURI = new java.net.URI(uri.toString()))) != null) {
                uri = resolvedURI;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to resolve '" + uri + "'"), (Throwable)e);
        }
        return uri.resolve(this.getURI());
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        TypeManager typeManager;
        TypeManagerResourceAdapter adapter;
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            boolean hasSyntaxError = false;
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (error instanceof LibraryDiagnostic) {
                    hasSyntaxError = true;
                    continue;
                }
                if (!(error instanceof XtextSyntaxDiagnostic)) continue;
                hasSyntaxError = true;
            }
            if (hasSyntaxError) {
                return;
            }
        }
        if ((adapter = TypeManagerResourceAdapter.findAdapter((Resource)this)) != null && (typeManager = adapter.getTypeManager()) != null) {
            try {
                typeManager.getOclAnyType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getOclVoidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getOclInvalidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getClassifierType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getBooleanType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getRealType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getIntegerType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getUnlimitedNaturalType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getStringType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getCollectionType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getBagType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getSequenceType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getOrderedSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getEnumerationType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                typeManager.getTupleType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
        }
        super.resolveLazyCrossReferences(mon);
    }

    public void setContext(NamedElement pivotContext, Map<String, Type> pivotParameters) {
        this.specificationContext = pivotContext;
    }

    public void setEnvironment(PivotEnvironment environment) {
        this.environment = environment;
    }

    public void setModelResolver(ModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    public ModelResolver useModelResolver() throws IOException {
        if (this.modelResolver == null) {
            URI uri = this.getURI();
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                this.modelResolver = new ModelResourceResolver(workspaceResource);
            } else {
                File[] listFiles;
                if (uri.isPlatformPlugin()) {
                    return null;
                }
                String fileName = uri.toFileString();
                File file = new File(fileName);
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (name.equals("org.eclipse.ocl.modelregistry")) {
                            return true;
                        }
                        return name.equals(".settings");
                    }
                };
                File projectFolder = null;
                File registryFile = null;
                File folder = file.getParentFile();
                while (folder != null) {
                    listFiles = folder.listFiles(filter);
                    if (listFiles != null && listFiles.length > 0) {
                        projectFolder = folder;
                        registryFile = listFiles[0];
                        break;
                    }
                    folder = folder.getParentFile();
                }
                String registryPath = null;
                if (registryFile != null && registryFile.isDirectory()) {
                    listFiles = registryFile.listFiles(filter);
                    if (listFiles != null && listFiles.length > 0) {
                        registryPath = ".settings/org.eclipse.ocl.modelregistry";
                    }
                } else {
                    registryPath = "org.eclipse.ocl.modelregistry";
                }
                if (projectFolder != null && registryPath != null) {
                    JavaProjectHandle project = new JavaProjectHandle(projectFolder, registryPath);
                    this.modelResolver = new ModelFileResolver(project, file);
                }
            }
        }
        return this.modelResolver;
    }
}

