/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.ui.findrefs;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.findrefs.DefaultReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseReferenceFinder
extends DefaultReferenceFinder {
    @Inject
    public BaseReferenceFinder(IResourceDescriptions index) {
        super(index);
    }

    protected Map<EObject, URI> createExportedElementsMap(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        CS2Pivot cs2Pivot = CS2Pivot.findAdapter((ResourceSet)resourceSet);
        if (cs2Pivot != null) {
            for (Resource csResource : cs2Pivot.getCSResources()) {
                if (resource != cs2Pivot.getPivotResource(csResource)) continue;
                return super.createExportedElementsMap(csResource);
            }
        }
        return super.createExportedElementsMap(resource);
    }

    public void findLocalReferences(Set<? extends EObject> targets, IAcceptor<IReferenceDescription> acceptor, Predicate<IReferenceDescription> filter, IProgressMonitor monitor) {
        HashSet<? extends EObject> csTargets = new HashSet<EObject>(targets);
        for (EObject eObject : targets) {
            Element element;
            if (eObject instanceof MonikeredElement) {
                MonikeredElementCS monikeredElementCS = ElementUtil.getCsElement((MonikeredElement)((MonikeredElement)eObject));
                if (monikeredElementCS == null) continue;
                csTargets.add((EObject)monikeredElementCS);
                continue;
            }
            if (!(eObject instanceof Pivotable) || (element = ((Pivotable)eObject).getPivot()) == null) continue;
            csTargets.add((EObject)element);
        }
        super.findLocalReferences(csTargets, acceptor, filter, monitor);
    }
}

