/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.NullValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationManager<ACC extends Value> {
    private final int depth;
    private final EvaluationVisitor evaluationVisitor;
    private final CollectionValue collectionValue;
    private final OclExpression body;
    private ACC accumulatorValue;
    private final VariableDeclaration accumulatorVariable;
    private final List<Parameter> referredIterators;
    private final List<ValueIterator> iterators;

    public IterationManager(EvaluationVisitor evaluationVisitor, LoopExp iteratorExp, CollectionValue collectionValue, ACC accumulatorValue) {
        this.depth = 0;
        this.evaluationVisitor = evaluationVisitor.createNestedVisitor();
        this.collectionValue = collectionValue;
        this.body = iteratorExp.getBody();
        this.accumulatorValue = accumulatorValue;
        if (iteratorExp instanceof IterateExp) {
            this.accumulatorVariable = ((IterateExp)iteratorExp).getResult().getRepresentedParameter();
            this.getEvaluationEnvironment().add(this.accumulatorVariable, accumulatorValue);
        } else {
            this.accumulatorVariable = null;
        }
        this.referredIterators = iteratorExp.getReferredIteration().getOwnedIterators();
        this.iterators = new ArrayList<ValueIterator>(this.referredIterators.size());
        for (Parameter referredIterator : this.referredIterators) {
            this.iterators.add(new ValueIterator((VariableDeclaration)referredIterator));
        }
    }

    public IterationManager(IterationManager<ACC> iterationManager, Value value) throws InvalidValueException {
        this.depth = iterationManager.depth + 1;
        this.evaluationVisitor = iterationManager.evaluationVisitor;
        this.body = iterationManager.body;
        this.collectionValue = value instanceof CollectionValue ? (CollectionValue)value : this.getValueFactory().createSequenceValue(new Value[]{value});
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
        this.referredIterators = iterationManager.referredIterators;
        this.iterators = new ArrayList<ValueIterator>(this.referredIterators.size());
        for (Parameter referredIterator : this.referredIterators) {
            this.iterators.add(new ValueIterator((VariableDeclaration)referredIterator));
        }
    }

    public void advance() {
        int curr = this.getNextUnfinishedIterator();
        int i = 0;
        while (i < this.iterators.size()) {
            ValueIterator iterator = this.iterators.get(i);
            if (i < curr) {
                iterator.reset();
            } else if (i == curr) {
                iterator.next();
            } else {
                iterator.get();
            }
            ++i;
        }
    }

    public Value get(int i) {
        return this.iterators.get(0).get();
    }

    public ACC getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public Value getBodyValue() {
        return (Value)this.body.accept((Visitor)this.evaluationVisitor);
    }

    public CollectionValue getCollectionValue() {
        return this.collectionValue;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationVisitor.getEvaluationEnvironment();
    }

    public Value getFalse() {
        return this.getValueFactory().getFalse();
    }

    private int getNextUnfinishedIterator() {
        int numIters = this.iterators.size();
        int curr = 0;
        while (curr < numIters) {
            if (this.iterators.get(curr).hasCurrent()) break;
            ++curr;
        }
        return curr;
    }

    public Value getTrue() {
        return this.getValueFactory().getTrue();
    }

    public ValueFactory getValueFactory() {
        return this.evaluationVisitor.getValueFactory();
    }

    public boolean hasCurrent() {
        int curr = this.getNextUnfinishedIterator();
        return curr < this.iterators.size();
    }

    public boolean isOuterIteration() {
        return this.depth == 0;
    }

    public void replaceAccumulator(ACC accumulatorValue) {
        this.accumulatorValue = accumulatorValue;
        if (this.accumulatorVariable != null) {
            this.getEvaluationEnvironment().replace(this.accumulatorVariable, accumulatorValue);
        }
    }

    public String toString() {
        return this.body.eContainer().toString();
    }

    public NullValue throwInvalidEvaluation(String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException(this.getEvaluationEnvironment(), boundMessage, null, null, null);
    }

    public NullValue throwInvalidEvaluation(InvalidValueException e) {
        return this.getEvaluationEnvironment().throwInvalidEvaluation(e);
    }

    private class ValueIterator {
        private final VariableDeclaration variable;
        private Iterator<Value> javaIter;
        private Value value = null;

        public ValueIterator(VariableDeclaration variable) {
            this.variable = variable;
            this.reset();
        }

        public Value get() {
            return this.value;
        }

        public boolean hasCurrent() {
            return this.value != null;
        }

        public Value next() {
            if (!this.javaIter.hasNext()) {
                this.value = null;
            } else {
                this.value = this.javaIter.next();
                IterationManager.this.evaluationVisitor.getEvaluationEnvironment().replace(this.variable, this.value);
            }
            return this.value;
        }

        public Value reset() {
            this.javaIter = IterationManager.this.collectionValue.iterator();
            return this.next();
        }
    }
}

