/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import java.util.Set;
import org.eclipse.ocl.examples.library.AbstractOperation;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class CollectionProductOperation
extends AbstractOperation {
    public static final CollectionProductOperation INSTANCE = new CollectionProductOperation();

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceVal, OperationCallExp operationCall) throws InvalidValueException {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        CollectionValue sourceValue = sourceVal.asCollectionValue();
        Value argVal = this.evaluateArgument(evaluationVisitor, operationCall, 0);
        CollectionValue argumentValue = argVal.asCollectionValue();
        CollectionType collType = (CollectionType)operationCall.getType();
        TupleType tupleType = (TupleType)collType.getElementType();
        Set product = sourceValue.product(argumentValue, tupleType);
        return valueFactory.createSetValue(product);
    }
}

