/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.logical;

import org.eclipse.ocl.examples.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class BooleanAndOperation
extends AbstractBinaryOperation {
    public static final BooleanAndOperation INSTANCE = new BooleanAndOperation();

    public BooleanValue evaluate(EvaluationVisitor evaluationVisitor, Value sourceVal, OperationCallExp operationCall) throws InvalidValueException {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        if (sourceVal.isFalse()) {
            return valueFactory.getFalse();
        }
        Value argVal = this.evaluateArgument(evaluationVisitor, operationCall, 0);
        return this.evaluate(valueFactory, sourceVal, argVal);
    }

    public BooleanValue evaluate(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        if (left.isFalse() || right.isFalse()) {
            return valueFactory.getFalse();
        }
        return valueFactory.booleanValueOf(left.asBoolean() && right.asBoolean());
    }
}

