/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.TypeValue;
import org.eclipse.ocl.examples.pivot.values.Value;

public class NumericOclAsTypeOperation
extends OclAnyOclAsTypeOperation {
    public static final NumericOclAsTypeOperation INSTANCE = new NumericOclAsTypeOperation();

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceVal, OperationCallExp operationCall) throws InvalidValueException {
        TypeManager typeManager = evaluationVisitor.getTypeManager();
        Type sourceType = sourceVal.getType(typeManager, operationCall.getSource().getType());
        if (sourceType == null) {
            return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceType, EvaluatorMessages.MissingSourceType, new Object[0]);
        }
        Value argVal = this.evaluateArgument(evaluationVisitor, operationCall, 0);
        TypeValue typeVal = argVal.asTypeValue();
        Type argType = typeVal.getInstanceType();
        if (typeManager.conformsTo(sourceType, argType, null)) {
            if (sourceVal.isUnlimited() && (argType == typeManager.getIntegerType() || argType == typeManager.getRealType())) {
                return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceVal, EvaluatorMessages.NonFiniteIntegerValue, new Object[0]);
            }
            if (sourceVal instanceof IntegerValue && argType == typeManager.getRealType()) {
                return ((IntegerValue)sourceVal).toRealValue();
            }
            return sourceVal;
        }
        RealValue realValue = sourceVal.asRealValue();
        if (realValue != null) {
            if (argType == typeManager.getUnlimitedNaturalType()) {
                if (realValue.signum() < 0) {
                    return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceVal, EvaluatorMessages.NonPositiveUnlimitedNaturalValue, new Object[0]);
                }
                return realValue.toIntegerValue();
            }
            if (argType == typeManager.getIntegerType()) {
                return realValue.toIntegerValue();
            }
            return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)argType, EvaluatorMessages.IncompatibleArgumentType, new Object[]{argType});
        }
        IntegerValue integerValue = sourceVal.asIntegerValue();
        if (integerValue != null && argType == typeManager.getUnlimitedNaturalType()) {
            if (integerValue.signum() < 0) {
                return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceVal, EvaluatorMessages.NonPositiveUnlimitedNaturalValue, new Object[0]);
            }
            return integerValue;
        }
        return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceVal, EvaluatorMessages.UnknownSourceType, new Object[0]);
    }
}

