/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class StringAtOperation
extends AbstractBinaryOperation {
    public static final StringAtOperation INSTANCE = new StringAtOperation();

    public Value evaluate(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        String leftString = left.asString();
        Integer rightInteger = right.asInteger();
        if (leftString != null && rightInteger != null) {
            int size = leftString.length();
            int index = rightInteger;
            if (index > 0 && index <= size) {
                char c = leftString.charAt(index - 1);
                return valueFactory.stringValueOf(String.valueOf(c));
            }
        }
        return null;
    }
}

