/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AllSubclassesFinder;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AlwaysEmptyChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.HashCodeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.SourceTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TargetTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.HighlightingToStringVisitor;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNavigationStep
implements NavigationStep {
    private static int idCounter;
    private final int id;
    private EClass sourceType;
    private EClass targetType;
    private final Set<OCLExpression> debugInfo;
    private int cacheMisses;
    private int resultObjectsCounter;
    private List<AlwaysEmptyChangeListener> alwaysEmptyChangeListeners = null;
    private List<SourceTypeChangeListener> sourceTypeChangeListeners = null;
    private List<TargetTypeChangeListener> targetTypeChangeListeners = null;
    private List<HashCodeChangeListener> hashCodeChangeListeners = null;
    private boolean alwaysEmpty;
    private String annotation;
    private final SemanticIdentity semanticIdentity;
    private int navigateCounter;
    private static int maxToken;
    private Set<Variable> leavingScopes = new HashSet<Variable>();
    private Set<Variable> enteringScopes = new HashSet<Variable>();
    private static final String OCL_DELEGATE_URI_SLASH = "http://www.eclipse.org/emf/2002/Ecore/OCL/";

    static {
        maxToken = 0;
    }

    public AbstractNavigationStep(EClass sourceType, EClass targetType, OCLExpression debugInfo) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.debugInfo = new HashSet<OCLExpression>();
        this.debugInfo.add(debugInfo);
        this.id = idCounter++;
        this.semanticIdentity = new AbstractNavigationStepIdentity();
    }

    protected static int newTokenForFiringHashCodeChangeEvent() {
        return maxToken++;
    }

    @Override
    public EClass getTargetType() {
        return this.targetType;
    }

    @Override
    public EClass getSourceType() {
        return this.sourceType;
    }

    @Override
    public void addAlwaysEmptyChangeListener(AlwaysEmptyChangeListener listener) {
        if (this.alwaysEmptyChangeListeners == null) {
            this.alwaysEmptyChangeListeners = new ArrayList<AlwaysEmptyChangeListener>(1);
        }
        this.alwaysEmptyChangeListeners.add(listener);
    }

    @Override
    public void addSourceTypeChangeListener(SourceTypeChangeListener listener) {
        if (this.sourceTypeChangeListeners == null) {
            this.sourceTypeChangeListeners = new ArrayList<SourceTypeChangeListener>(1);
        }
        this.sourceTypeChangeListeners.add(listener);
    }

    @Override
    public void addTargetTypeChangeListener(TargetTypeChangeListener listener) {
        if (this.targetTypeChangeListeners == null) {
            this.targetTypeChangeListeners = new ArrayList<TargetTypeChangeListener>(1);
        }
        this.targetTypeChangeListeners.add(listener);
    }

    @Override
    public void addHashCodeChangeListener(HashCodeChangeListener listener) {
        if (this.hashCodeChangeListeners == null) {
            this.hashCodeChangeListeners = new ArrayList<HashCodeChangeListener>(1);
        }
        this.hashCodeChangeListeners.add(listener);
    }

    void setSourceType(EClass sourceType) {
        boolean changed;
        boolean bl = changed = this.sourceType == null && sourceType != null || this.sourceType != null && !this.sourceType.equals(sourceType);
        if (changed) {
            this.fireBeforeHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            this.sourceType = sourceType;
            this.fireAfterHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            if (this.sourceTypeChangeListeners != null) {
                for (SourceTypeChangeListener listener : this.sourceTypeChangeListeners) {
                    listener.sourceTypeChanged(this);
                }
            }
        }
    }

    protected void fireAfterHashCodeChange(int token) {
        if (this.hashCodeChangeListeners != null) {
            for (HashCodeChangeListener listener : this.hashCodeChangeListeners) {
                listener.afterHashCodeChange(this, token);
            }
        }
    }

    protected void fireBeforeHashCodeChange(int token) {
        if (this.hashCodeChangeListeners != null) {
            for (HashCodeChangeListener listener : this.hashCodeChangeListeners) {
                listener.beforeHashCodeChange(this, token);
            }
        }
    }

    void setTargetType(EClass targetType) {
        boolean changed;
        boolean bl = changed = this.targetType == null && targetType != null || this.targetType != null && !this.targetType.equals(targetType);
        if (changed) {
            this.fireBeforeHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            this.targetType = targetType;
            this.fireAfterHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            if (this.targetTypeChangeListeners != null) {
                for (TargetTypeChangeListener listener : this.targetTypeChangeListeners) {
                    listener.targetTypeChanged(this);
                }
            }
        }
    }

    @Override
    public void addExpressionForWhichThisIsNavigationStep(OCLExpression oclExpression) {
        this.debugInfo.add(oclExpression);
    }

    public int getNavigateCounter() {
        return this.navigateCounter;
    }

    public int getResultObjectsCounter() {
        return this.resultObjectsCounter;
    }

    @Override
    public Set<OCLExpression> getDebugInfo() {
        return this.debugInfo;
    }

    protected AnnotatedEObject annotateEObject(AnnotatedEObject fromObject, EObject next) {
        if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
            return new AnnotatedEObject(next, fromObject, this.getAnnotation());
        }
        return new AnnotatedEObject(next, "To enable annotations, set the system property org.eclipse.ocl.examples.impactanalyzer.debug to true, e.g., by using the VM argument -Dorg.eclipse.ocl.examples.impactanalyzer.debug=true");
    }

    private String getAnnotation() {
        if (this.annotation == null) {
            this.annotation = this.getVerboseDebugInfo();
        }
        return this.annotation;
    }

    private String getVerboseDebugInfo() {
        try {
            if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
                StringBuilder result = new StringBuilder();
                result.append("Step's expressions: ");
                for (OCLExpression debugInfo : this.getDebugInfo()) {
                    result.append(debugInfo);
                    OCLExpression root = OclHelper.getRootExpression((EObject)debugInfo);
                    if (root != debugInfo) {
                        result.append("\n ==== in expression =====\n");
                        result.append((String)root.accept((Visitor)HighlightingToStringVisitor.getInstance((EObject)root, debugInfo)));
                    }
                    result.append(this.getDefines(OclHelper.getRootExpression((EObject)debugInfo)) != null ? "\n ===== which is the body of operation " + this.getDefines(OclHelper.getRootExpression((EObject)debugInfo)).getName() + " =====" : "");
                }
                return result.toString();
            }
            return "To enable annotations, set the system property org.eclipse.ocl.examples.impactanalyzer.debug to true, e.g., by using the VM argument -Dorg.eclipse.ocl.examples.impactanalyzer.debug=true";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EOperation getDefines(OCLExpression rootExpression) {
        EAnnotation annotation;
        EOperation result = null;
        if (rootExpression.eContainer() instanceof EAnnotation && AbstractNavigationStep.isDelegateAnnotation(annotation = (EAnnotation)rootExpression.eContainer()) && annotation.eContainer() instanceof EOperation) {
            result = (EOperation)annotation.eContainer();
        }
        return result;
    }

    private static boolean isDelegateAnnotation(EAnnotation eAnnotation) {
        String source = eAnnotation.getSource();
        if (source != null) {
            if (source.equals("http://www.eclipse.org/emf/2002/Ecore/OCL")) {
                return true;
            }
            if (source.startsWith(OCL_DELEGATE_URI_SLASH)) {
                return true;
            }
        }
        return false;
    }

    protected void incrementNavigateCounter(Set<AnnotatedEObject> from) {
        ++this.navigateCounter;
    }

    @Override
    public Set<AnnotatedEObject> navigate(Set<AnnotatedEObject> from, TracebackCache cache, Notification changeEvent) {
        this.incrementNavigateCounter(from);
        HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>(from.size());
        if (this.isAbsolute()) {
            from = Collections.singleton(null);
        }
        if (!this.isAlwaysEmpty()) {
            for (AnnotatedEObject fromObject : from) {
                if (!this.isAbsolute() && !AbstractTracer.doesTypeMatch(this.getSourceType(), fromObject)) continue;
                for (AnnotatedEObject singleResult : this.getFromCacheOrNavigate(fromObject, cache, changeEvent)) {
                    if (!AbstractTracer.doesTypeMatch(this.getTargetType(), singleResult)) continue;
                    result.add(singleResult);
                }
            }
        }
        this.resultObjectsCounter += result.size();
        return result;
    }

    private Collection<AnnotatedEObject> getFromCacheOrNavigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        Set<AnnotatedEObject> result = cache.get(this, fromObject);
        if (result == null) {
            ++this.cacheMisses;
            result = this.navigate(fromObject, cache, changeEvent);
            cache.put(this, fromObject, result);
        }
        return result;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public boolean isAlwaysEmpty() {
        return this.alwaysEmpty;
    }

    protected void setAlwaysEmpty() {
        if (!this.alwaysEmpty) {
            this.fireBeforeHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            this.alwaysEmpty = true;
            this.fireAfterHashCodeChange(AbstractNavigationStep.newTokenForFiringHashCodeChangeEvent());
            if (this.alwaysEmptyChangeListeners != null) {
                for (AlwaysEmptyChangeListener listener : this.alwaysEmptyChangeListeners) {
                    listener.alwaysEmptyChanged(this);
                }
            }
        }
    }

    protected abstract Set<AnnotatedEObject> navigate(AnnotatedEObject var1, TracebackCache var2, Notification var3);

    public String toString() {
        HashMap<NavigationStep, Integer> visited = new HashMap<NavigationStep, Integer>();
        return this.toString(visited, 0);
    }

    private int getCacheMisses() {
        return this.cacheMisses;
    }

    protected String toString(Map<NavigationStep, Integer> visited, int indent) {
        if (visited.containsKey(this)) {
            return "(#" + this.getCacheMisses() + "/" + this.getNavigateCounter() + ") GOTO " + visited.get(this);
        }
        visited.put(this, this.id);
        return this.id + "(#" + this.getCacheMisses() + "/" + this.getNavigateCounter() + "):" + "(" + (this.getSourceType() == null ? "null" : this.getSourceType().getName()) + ")" + this.contentToString(visited, indent) + "(" + (this.getTargetType() == null ? "null" : this.getTargetType().getName()) + ")";
    }

    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return "";
    }

    protected static boolean haveIntersectingSubclassTree(EClass a, EClass b) {
        boolean result;
        boolean bl = result = a == null || b == null || a.equals(b);
        if (!result) {
            HashSet<EClass> targetSubtypesIncludingTargetType = new HashSet<EClass>(AllSubclassesFinder.getInstance().getAllSubclasses(a));
            targetSubtypesIncludingTargetType.add(a);
            if (targetSubtypesIncludingTargetType.contains(b)) {
                result = true;
            } else {
                HashSet<EClass> larger;
                HashSet<EClass> smaller;
                HashSet<EClass> sourceSubtypesIncludingSourceType = new HashSet<EClass>(AllSubclassesFinder.getInstance().getAllSubclasses(b));
                sourceSubtypesIncludingSourceType.add(b);
                if (targetSubtypesIncludingTargetType.size() < sourceSubtypesIncludingSourceType.size()) {
                    smaller = targetSubtypesIncludingTargetType;
                    larger = sourceSubtypesIncludingSourceType;
                } else {
                    smaller = sourceSubtypesIncludingSourceType;
                    larger = targetSubtypesIncludingTargetType;
                }
                for (Object e : smaller) {
                    if (!larger.contains((EClassifier)e)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public int size() {
        HashSet<NavigationStep> visited = new HashSet<NavigationStep>();
        return this.size(visited);
    }

    protected int size(Set<NavigationStep> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        return 1;
    }

    @Override
    public int distinctSize() {
        HashSet<SemanticIdentity> visited = new HashSet<SemanticIdentity>();
        return this.distinctSize(visited);
    }

    protected int distinctSize(Set<SemanticIdentity> visited) {
        if (visited.contains(this.getSemanticIdentity())) {
            return 0;
        }
        visited.add(this.getSemanticIdentity());
        return 1;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    @Override
    public Set<Variable> getLeavingScopes() {
        return Collections.unmodifiableSet(this.leavingScopes);
    }

    @Override
    public void addLeavingScopes(Set<Variable> leavingScopes) {
        this.leavingScopes.addAll(leavingScopes);
    }

    @Override
    public Set<Variable> getEnteringScopes() {
        return Collections.unmodifiableSet(this.enteringScopes);
    }

    @Override
    public void addEnteringScopes(Set<Variable> enteringScope) {
        this.enteringScopes.addAll(enteringScope);
    }

    private class AbstractNavigationStepIdentity
    extends SemanticIdentity {
        private AbstractNavigationStepIdentity() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            boolean result = false;
            if (o instanceof AbstractNavigationStepIdentity) {
                AbstractNavigationStep otherStep = ((AbstractNavigationStepIdentity)o).getNavigationStep();
                result = this.getNavigationStep().getClass() == otherStep.getClass() && this.getNavigationStep().alwaysEmpty == otherStep.alwaysEmpty && (AbstractNavigationStep.this.isAbsolute() && otherStep.isAbsolute() || this.getNavigationStep().sourceType != null && otherStep.sourceType != null && this.getNavigationStep().sourceType.equals(otherStep.sourceType)) && this.getNavigationStep().targetType != null && otherStep.targetType != null && this.getNavigationStep().targetType.equals(otherStep.targetType);
            }
            return result;
        }

        public int calculateHashCode() {
            return 0x1267 ^ this.getClass().hashCode() ^ (AbstractNavigationStep.this.alwaysEmpty ? 31 : 0) ^ (AbstractNavigationStep.this.sourceType == null ? 0 : AbstractNavigationStep.this.sourceType.hashCode()) ^ (AbstractNavigationStep.this.targetType == null ? 0 : AbstractNavigationStep.this.targetType.hashCode());
        }

        public AbstractNavigationStep getNavigationStep() {
            return AbstractNavigationStep.this;
        }

        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

