/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LiteralExp;
import org.eclipse.ocl.ecore.NavigationCallExp;
import org.eclipse.ocl.ecore.NullLiteralExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.PrimitiveLiteralExp;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TupleLiteralExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.eventmanager.NotificationHelper;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluatorFactory;
import org.eclipse.ocl.examples.impactanalyzer.configuration.ActivationOption;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEvaluatorFactoryImpl;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEvaluatorImpl;
import org.eclipse.ocl.examples.impactanalyzer.filterSynthesis.FilterSynthesisImpl;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.BooleanLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.CollectionLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EnumLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IfExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IntegerLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InvalidlLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IterateExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IteratorExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.LetExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NullLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.OperationCallExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.OppositePropertyCallExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PropertyCallExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.RealLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.StringLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.Tracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TupleLiteralExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TypeExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.VariableExpTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceScopeAnalysis
extends PartialEvaluatorFactoryImpl {
    private final Logger logger = Logger.getLogger(InstanceScopeAnalysis.class.getName());
    private final PathCache pathCache;
    private final TracebackStepCache tracebackStepCache;
    private final OCLExpression expression;
    private final FilterSynthesisImpl filterSynthesizer;
    private final EClass context;
    private final OppositeEndFinder oppositeEndFinder;
    private final ActivationOption configuration;
    private final OCLFactory oclFactory;
    private final PartialEvaluatorImpl partialEvaluatorForAllInstancesDeltaPropagation;
    private static final Set<String> comparisonOpNames = new HashSet<String>(Arrays.asList("=", "<", "<=", ">", ">=", "<>"));

    public InstanceScopeAnalysis(OCLExpression expression, EClass exprContext, FilterSynthesisImpl filterSynthesizer, OppositeEndFinder oppositeEndFinder, ActivationOption configuration, OCLFactory oclFactory) {
        this(expression, exprContext, filterSynthesizer, oppositeEndFinder, new PartialEvaluatorImpl(oclFactory, oppositeEndFinder), configuration, oclFactory, configuration.isTracebackStepISAActive() ? null : new PathCache(oppositeEndFinder), configuration.isTracebackStepISAActive() ? new TracebackStepCache(oppositeEndFinder) : null);
    }

    protected void initInstanceScopeAnalysisOnPathCache() {
        if (this.pathCache != null) {
            this.pathCache.initInstanceScopeAnalysis(this);
        }
        if (this.tracebackStepCache != null) {
            this.tracebackStepCache.initInstanceScopeAnalysis(this);
        }
    }

    protected InstanceScopeAnalysis(OCLExpression expression, EClass exprContext, FilterSynthesisImpl filterSynthesizer, OppositeEndFinder oppositeEndFinder, PartialEvaluatorImpl partialEvaluator, ActivationOption configuration, OCLFactory oclFactory, PathCache pathCache, TracebackStepCache tracebackStepCache) {
        this.checkConstructorArgs(expression, exprContext, filterSynthesizer);
        this.context = exprContext;
        this.oclFactory = oclFactory;
        this.expression = expression;
        this.partialEvaluatorForAllInstancesDeltaPropagation = partialEvaluator;
        this.filterSynthesizer = filterSynthesizer;
        this.oppositeEndFinder = oppositeEndFinder;
        this.configuration = configuration;
        this.tracebackStepCache = tracebackStepCache;
        this.pathCache = pathCache;
        this.initInstanceScopeAnalysisOnPathCache();
    }

    private void checkConstructorArgs(OCLExpression expression, EClass exprContext, FilterSynthesisImpl filterSynthesizer) {
        if (exprContext == null) {
            throw new IllegalArgumentException("exprContext must not be null. Maybe no context type specified to ImpactAnalyzerImpl constructor, and no self-expression found to infer it?");
        }
        if (expression == null || filterSynthesizer == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
    }

    protected PathCache getPathCache() {
        return this.pathCache;
    }

    public static Set<EObject> getAllPossibleContextInstances(Notifier context, EClass cls, OppositeEndFinder oppositeEndFinder) {
        return oppositeEndFinder.getAllInstancesSeeing(cls, context);
    }

    protected Tracer createTracer(OCLExpression expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        switch (expression.eClass().getClassifierID()) {
            case 43: {
                return new PropertyCallExpTracer((PropertyCallExp)expression, tuplePartNames, oclFactory);
            }
            case 53: {
                return new OppositePropertyCallExpTracer((OppositePropertyCallExp)expression, tuplePartNames, oclFactory);
            }
            case 19: {
                return new BooleanLiteralExpTracer((BooleanLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 22: {
                return new CollectionLiteralExpTracer((CollectionLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 25: {
                return new EnumLiteralExpTracer((EnumLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 27: {
                return new IfExpTracer((IfExp)expression, tuplePartNames, oclFactory);
            }
            case 28: {
                return new IntegerLiteralExpTracer((IntegerLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 31: {
                return new IterateExpTracer((IterateExp)expression, tuplePartNames, oclFactory);
            }
            case 32: {
                return new IteratorExpTracer((IteratorExp)expression, tuplePartNames, oclFactory);
            }
            case 33: {
                return new LetExpTracer((LetExp)expression, tuplePartNames, oclFactory);
            }
            case 41: {
                return new OperationCallExpTracer((OperationCallExp)expression, tuplePartNames, oclFactory);
            }
            case 44: {
                return new RealLiteralExpTracer((RealLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 46: {
                return new StringLiteralExpTracer((StringLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 47: {
                return new TupleLiteralExpTracer((TupleLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 49: {
                return new TypeExpTracer((TypeExp)expression, tuplePartNames, oclFactory);
            }
            case 52: {
                return new VariableExpTracer((VariableExp)expression, tuplePartNames, oclFactory);
            }
            case 38: {
                return new NullLiteralExpTracer((NullLiteralExp)expression, tuplePartNames, oclFactory);
            }
            case 30: {
                return new InvalidlLiteralExpTracer((InvalidLiteralExp)expression, tuplePartNames, oclFactory);
            }
        }
        throw new RuntimeException("Unsupported expression type " + expression.eClass().getName());
    }

    public Collection<EObject> getContextObjects(Notification event, boolean notifyOnNewContextElements) {
        Collection<Object> resultCollection = NotificationHelper.isElementLifeCycleEvent((Notification)event) ? this.handleLifeCycleEvent(event, notifyOnNewContextElements) : new HashSet();
        TracebackCache cacheForNavigationSteps = this.createNavigationStepCache();
        org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache cacheForTracebackSteps = this.createTracebackStepCache();
        for (NavigationCallExp navigationCallExp : this.getAttributeOrAssociationEndCalls(event)) {
            for (AnnotatedEObject sourceElement : this.getSourceElement(event, navigationCallExp)) {
                if (this.hasNoEffectOnOverallExpression(event, navigationCallExp, sourceElement) || sourceElement == null) continue;
                Iterable<AnnotatedEObject> selfCandidates = this.configuration.isTracebackStepISAActive() ? this.selfWithTracebackSteps(navigationCallExp, sourceElement, this.context, event, cacheForTracebackSteps) : this.selfWithNavigationSteps(navigationCallExp, sourceElement, this.context, event, cacheForNavigationSteps);
                for (AnnotatedEObject r : selfCandidates) {
                    resultCollection.add(r.getAnnotatedObject());
                }
            }
        }
        return resultCollection;
    }

    private org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache createTracebackStepCache() {
        org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache cacheForTracebackSteps = this.configuration.isTracebackStepISAActive() ? new org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache(this.configuration, this.tracebackStepCache.getUnusedEvaluationRequestFactory()) : null;
        return cacheForTracebackSteps;
    }

    private TracebackCache createNavigationStepCache() {
        TracebackCache cacheForNavigationSteps = this.configuration.isTracebackStepISAActive() ? null : new TracebackCache();
        return cacheForNavigationSteps;
    }

    public Collection<EObject> getContextObjects(EObject evaluationResult) {
        Iterable<AnnotatedEObject> annotatedResults;
        Object step;
        Object cache;
        AnnotatedEObject startObject = this.createStartObject(evaluationResult);
        if (this.configuration.isTracebackStepISAActive()) {
            cache = this.createTracebackStepCache();
            step = this.getTracebackStepForExpression(this.expression, this.context);
            annotatedResults = step.traceback(startObject, null, (org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache)cache, null);
        } else {
            cache = this.createNavigationStepCache();
            step = this.getNavigationStepsToSelfForExpression(this.expression, this.context);
            Set<AnnotatedEObject> sourceElementAsSet = Collections.singleton(startObject);
            annotatedResults = step.navigate(sourceElementAsSet, (TracebackCache)cache, null);
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (AnnotatedEObject annotatedResult : annotatedResults) {
            result.add(annotatedResult.getAnnotatedObject());
        }
        return result;
    }

    private boolean hasNoEffectOnOverallExpression(Notification event, NavigationCallExp attributeOrAssociationEndCall, AnnotatedEObject sourceElement) {
        if (this.configuration.isDeltaPropagationActive()) {
            PartialEvaluatorImpl partialEvaluatorAtPre = this.createPartialEvaluator(event, this.oppositeEndFinder, this.oclFactory);
            Object oldValue = partialEvaluatorAtPre.evaluate(null, (CallExp)attributeOrAssociationEndCall, sourceElement.getAnnotatedObject());
            PartialEvaluatorImpl partialEvaluatorAtPost = this.createPartialEvaluator(this.oppositeEndFinder, this.oclFactory);
            Object newValue = partialEvaluatorAtPost.evaluate(null, (CallExp)attributeOrAssociationEndCall, sourceElement.getAnnotatedObject());
            return partialEvaluatorAtPost.hasNoEffectOnOverallExpression((OCLExpression)attributeOrAssociationEndCall, oldValue, newValue, this.filterSynthesizer);
        }
        return false;
    }

    private Collection<EObject> handleLifeCycleEvent(Notification event, boolean notifyOnNewContextElements) {
        HashSet<EObject> result = new HashSet<EObject>();
        Boolean addEvent = NotificationHelper.isAddEvent((Notification)event);
        if (NotificationHelper.isManyEvent((Notification)event)) {
            List featureValue = addEvent != false ? (List)event.getNewValue() : (List)event.getOldValue();
            for (Object value : featureValue) {
                if (!(value instanceof EObject)) continue;
                if (addEvent.booleanValue() && notifyOnNewContextElements && this.getContext().isInstance(value)) {
                    result.add((EObject)value);
                }
                EClass valuesClass = ((EObject)value).eClass();
                this.addAllPossibleContextsIfNonEmptyDelta(featureValue, result, event, valuesClass);
            }
        } else {
            Object value = addEvent != false ? event.getNewValue() : event.getOldValue();
            if (value instanceof EObject) {
                if (addEvent.booleanValue() && notifyOnNewContextElements && this.getContext().isInstance(value)) {
                    result.add((EObject)value);
                }
                List<Object> featureValueAsObjectCollection = Collections.singletonList(value);
                EClass valuesClass = ((EObject)value).eClass();
                this.addAllPossibleContextsIfNonEmptyDelta(featureValueAsObjectCollection, result, event, valuesClass);
            }
        }
        return result;
    }

    private void addAllPossibleContextsIfNonEmptyDelta(Collection<?> featureValue, Collection<EObject> result, Notification event, EClass eClass) {
        this.addAllPossibleContextsIfNotEmptyDeltaForSingleClass(featureValue, result, event, eClass);
        for (EClass superClass : eClass.getEAllSuperTypes()) {
            this.addAllPossibleContextsIfNotEmptyDeltaForSingleClass(featureValue, result, event, superClass);
        }
    }

    private void addAllPossibleContextsIfNotEmptyDeltaForSingleClass(Collection<?> featureValue, Collection<EObject> result, Notification event, EClass eClass) {
        for (OperationCallExp allInstancesCall : this.filterSynthesizer.getAllInstancesCallsFor((EClassifier)eClass)) {
            Collection<Object> featureValueAsObjectCollection = featureValue;
            if (this.getPartialEvaluatorForAllInstancesDeltaPropagation().transitivelyPropagateDelta((OCLExpression)allInstancesCall, featureValueAsObjectCollection, this.filterSynthesizer).isEmpty()) continue;
            result.addAll(InstanceScopeAnalysis.getAllPossibleContextInstances((Notifier)event.getNotifier(), this.getContext(), this.oppositeEndFinder));
        }
    }

    public boolean isUnaffectedDueToPrimitiveAttributeValueComparisonWithLiteralOnly(Notification changeEvent, String replacementFor__TEMP__) {
        if (!NotificationHelper.isAttributeValueChangeEvent((Notification)changeEvent)) {
            return false;
        }
        Set<? extends NavigationCallExp> calls = this.getAttributeOrAssociationEndCalls(changeEvent);
        if (calls.size() == 0) {
            System.err.println("Could niot find any attribute or association end calls for the attribute value change event : " + changeEvent);
            return false;
        }
        for (NavigationCallExp navigationCallExp : calls) {
            if (!(navigationCallExp.getType() instanceof PrimitiveType) || !((EStructuralFeature)((PropertyCallExp)navigationCallExp).getReferredProperty()).equals(NotificationHelper.getNotificationFeature((Notification)changeEvent))) continue;
            OCLExpression otherArgument = null;
            boolean attributeIsParameter = false;
            if (!(navigationCallExp.eContainer() instanceof OperationCallExp)) continue;
            OperationCallExp op = (OperationCallExp)navigationCallExp.eContainer();
            if (op != null && this.isComparisonOperation(op)) {
                otherArgument = (OCLExpression)op.getSource();
                attributeIsParameter = true;
            } else {
                CallExp callExp = (CallExp)navigationCallExp.eContainer();
                if (callExp != null && callExp instanceof OperationCallExp && this.isComparisonOperation((OperationCallExp)callExp)) {
                    op = (OperationCallExp)callExp;
                    otherArgument = (OCLExpression)op.getArgument().iterator().next();
                    attributeIsParameter = false;
                }
            }
            if (otherArgument != null && otherArgument instanceof PrimitiveLiteralExp) {
                if (!this.doesComparisonResultChange(changeEvent, (LiteralExp)((PrimitiveLiteralExp)otherArgument), replacementFor__TEMP__, ((EOperation)op.getReferredOperation()).getName(), attributeIsParameter)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean doesComparisonResultChange(Notification avce, LiteralExp otherArgument, String replacementFor__TEMP__, String operationName, boolean attributeIsParameter) {
        boolean result;
        boolean bl = result = avce.getNewValue() == null || avce.getOldValue() == null;
        if (!result) {
            int newComparison;
            Object value;
            if (otherArgument instanceof StringLiteralExp) {
                value = ((StringLiteralExp)otherArgument).getStringSymbol();
                if (value.equals("__TEMP__")) {
                    value = replacementFor__TEMP__;
                }
            } else if (otherArgument instanceof BooleanLiteralExp) {
                value = ((BooleanLiteralExp)otherArgument).getBooleanSymbol();
            } else if (otherArgument instanceof IntegerLiteralExp) {
                value = ((IntegerLiteralExp)otherArgument).getIntegerSymbol();
            } else if (otherArgument instanceof RealLiteralExp) {
                value = ((RealLiteralExp)otherArgument).getRealSymbol();
            } else {
                throw new RuntimeException("Internal error. Unknown OCL primitive literal expression " + otherArgument);
            }
            int oldComparison = attributeIsParameter ? ((Comparable)value).compareTo(avce.getOldValue()) : ((Comparable)avce.getOldValue()).compareTo(value);
            int n = newComparison = attributeIsParameter ? ((Comparable)value).compareTo(avce.getNewValue()) : ((Comparable)avce.getNewValue()).compareTo(value);
            if (operationName.equals("=")) {
                result = oldComparison == 0 ^ newComparison == 0;
            } else if (operationName.equals("<>")) {
                result = oldComparison != 0 ^ newComparison != 0;
            } else if (operationName.equals("<")) {
                result = oldComparison < 0 ^ newComparison < 0;
            } else if (operationName.equals("<=")) {
                result = oldComparison <= 0 ^ newComparison <= 0;
            } else if (operationName.equals(">")) {
                result = oldComparison > 0 ^ newComparison > 0;
            } else if (operationName.equals(">=")) {
                result = oldComparison >= 0 ^ newComparison >= 0;
            } else {
                this.logger.info("operator " + operationName + " not supported in impact analysis performance improvement; assuming a change");
                result = true;
            }
        }
        return result;
    }

    private Set<? extends NavigationCallExp> getAttributeOrAssociationEndCalls(Notification changeEvent) {
        Set<Object> result;
        if (NotificationHelper.isAttributeValueChangeEvent((Notification)changeEvent)) {
            result = this.filterSynthesizer.getAttributeCallExpressions((EAttribute)NotificationHelper.getNotificationFeature((Notification)changeEvent));
        } else if (NotificationHelper.isLinkLifeCycleEvent((Notification)changeEvent)) {
            EReference ref = (EReference)NotificationHelper.getNotificationFeature((Notification)changeEvent);
            HashSet localResult = new HashSet();
            localResult.addAll(this.filterSynthesizer.getAssociationEndCallExpressions(ref));
            result = localResult;
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private EClass getContext() {
        return this.context;
    }

    private NavigationStep getNavigationStepsToSelfForExpression(OCLExpression exp, EClass context) {
        NavigationStep result = (NavigationStep)this.getPathCache().getOrCreateNavigationPath(exp, context, this.filterSynthesizer, null, this.oclFactory);
        return result;
    }

    private TracebackStep getTracebackStepForExpression(OCLExpression exp, EClass context) {
        TracebackStep result = (TracebackStep)this.tracebackStepCache.getOrCreateNavigationPath(exp, context, this.filterSynthesizer, null, this.oclFactory);
        return result;
    }

    protected Collection<AnnotatedEObject> getSourceElement(Notification changeEvent, NavigationCallExp attributeOrAssociationEndCall) {
        assert (NotificationHelper.isAttributeValueChangeEvent((Notification)changeEvent) || NotificationHelper.isLinkLifeCycleEvent((Notification)changeEvent));
        EClassifier sourceType = (EClassifier)attributeOrAssociationEndCall.getSource().getType();
        HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>();
        if (attributeOrAssociationEndCall instanceof PropertyCallExp) {
            if (sourceType.isInstance(changeEvent.getNotifier())) {
                result.add(this.createStartObject((EObject)changeEvent.getNotifier()));
            }
        } else {
            throw new RuntimeException("Can only handle PropertyCallExp and OppositePropertyCallExp expression types, not " + attributeOrAssociationEndCall.getClass().getName());
        }
        return result;
    }

    private AnnotatedEObject createStartObject(EObject eObject) {
        return new AnnotatedEObject(eObject, "<start>");
    }

    protected Collection<Object> getSourceElementsForOppositePropertyCallExp(Notification changeEvent) {
        HashSet<Object> result = new HashSet<Object>();
        Object oldValue = changeEvent.getOldValue();
        Object newValue = changeEvent.getNewValue();
        switch (changeEvent.getEventType()) {
            case 1: 
            case 2: {
                result.addAll(OclHelper.flatten((Object)oldValue));
                result.addAll(OclHelper.flatten((Object)newValue));
                break;
            }
            case 3: 
            case 5: {
                result.addAll(OclHelper.flatten((Object)newValue));
                break;
            }
            case 4: 
            case 6: {
                result.addAll(OclHelper.flatten((Object)oldValue));
            }
        }
        return result;
    }

    private boolean isComparisonOperation(OperationCallExp op) {
        return comparisonOpNames.contains(((EOperation)op.getReferredOperation()).getName());
    }

    private Iterable<AnnotatedEObject> selfWithNavigationSteps(NavigationCallExp attributeOrAssociationEndCall, AnnotatedEObject sourceElement, EClass context, Notification changeEvent, TracebackCache cache) {
        NavigationStep step = this.getNavigationStepsToSelfForExpression((OCLExpression)attributeOrAssociationEndCall.getSource(), context);
        Set<AnnotatedEObject> sourceElementAsSet = Collections.singleton(sourceElement);
        Set<AnnotatedEObject> result = step.navigate(sourceElementAsSet, cache, changeEvent);
        return result;
    }

    private Iterable<AnnotatedEObject> selfWithTracebackSteps(NavigationCallExp attributeOrAssociationEndCall, AnnotatedEObject sourceElement, EClass context, Notification changeEvent, org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache cache) {
        TracebackStep step = this.getTracebackStepForExpression((OCLExpression)attributeOrAssociationEndCall.getSource(), context);
        OperationCallExpKeyedSet result = step.traceback(sourceElement, null, cache, changeEvent);
        return result;
    }

    protected PartialEvaluatorImpl getPartialEvaluatorForAllInstancesDeltaPropagation() {
        return this.partialEvaluatorForAllInstancesDeltaPropagation;
    }

    public PartialEvaluatorFactory getPartialEvaluatorFactory() {
        return this;
    }
}

