/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.MultiplicityElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasePreOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.InterDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2PivotConversion
extends AbstractConversion {
    private static final Logger logger = Logger.getLogger(CS2PivotConversion.class);
    public static final TracingOption CONTINUATION = new TracingOption("org.eclipse.ocl.examples.xtext.base", "continuation");
    protected final CS2Pivot converter;
    protected final TypeManager typeManager;
    protected final Collection<? extends Resource> csResources;
    protected final Map<Pivotable, Package> oldCS2PivotMap = new HashMap<Pivotable, Package>();
    protected final Map<String, MonikeredElementCS> moniker2CSmap = new HashMap<String, MonikeredElementCS>();
    protected final Map<String, MonikeredElement> oldMoniker2PivotMap;
    protected final Map<String, MonikeredElement> newMoniker2PivotMap;
    private final Map<EPackage, BaseCSVisitor<MonikeredElement, CS2PivotConversion>> left2RightVisitorMap = new HashMap<EPackage, BaseCSVisitor<MonikeredElement, CS2PivotConversion>>();
    private final Map<EPackage, BaseCSVisitor<Continuation<?>, CS2PivotConversion>> postOrderVisitorMap = new HashMap();
    private final Map<EPackage, BaseCSVisitor<Continuation<?>, CS2PivotConversion>> preOrderVisitorMap = new HashMap();
    private Map<TemplateableElement, Set<TemplateableElement>> specializations = new HashMap<TemplateableElement, Set<TemplateableElement>>();
    private InterDependency<BasePreOrderVisitor.PackageContentContinuation> packagesHaveTypes = new InterDependency("All unspecialized types defined", null);
    private InterDependency<BasePreOrderVisitor.TemplateSignatureContinuation> typesHaveSignatures = new InterDependency("All unspecialized signatures defined", this.packagesHaveTypes);
    private InterDependency<BasePreOrderVisitor.TemplateBindingContinuation> typesHaveSpecializations = new InterDependency("All specialized types defined", this.typesHaveSignatures);
    private InterDependency<BasePreOrderVisitor.OperationContinuation<?>> operationsHaveTemplateParameters = new InterDependency("All operation template parameters defined", this.typesHaveSignatures);
    private final Map<CacheKey<?>, Object> intermediateCache = new HashMap();
    private Map<MonikeredElementCS, MonikeredElement> debugCheckMap = new HashMap<MonikeredElementCS, MonikeredElement>();
    private Map<ElementCS, Element> debugOtherMap = new HashMap<ElementCS, Element>();
    private Map<String, Package> oldPackagesByName = null;
    private Map<String, Package> oldPackagesByQualifiedName = null;
    private HashSet<TypedElement> underspecifiedTypedElements = null;
    private final IDiagnosticConsumer diagnosticsConsumer;

    public CS2PivotConversion(CS2Pivot converter, IDiagnosticConsumer diagnosticsConsumer, Collection<? extends Resource> csResources) {
        this.converter = converter;
        this.diagnosticsConsumer = diagnosticsConsumer;
        this.typeManager = converter.getTypeManager();
        this.csResources = csResources;
        ArrayList<Resource> mappedResources = new ArrayList<Resource>();
        for (Resource resource : csResources) {
            mappedResources.add(converter.getPivotResource(resource));
        }
        mappedResources.add(this.typeManager.getOrphanPackage().eResource());
        this.oldMoniker2PivotMap = this.typeManager.computeMoniker2PivotMap(mappedResources);
        this.newMoniker2PivotMap = new HashMap<String, MonikeredElement>();
    }

    public OclExpression addBadExpressionError(ModelElementCS csElement, String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
        InvalidLiteralExp invalidLiteralExp = this.typeManager.createInvalidExpression();
        this.installPivotElementInternal(csElement, (Element)invalidLiteralExp);
        return invalidLiteralExp;
    }

    public void addDiagnostic(ModelElementCS csElement, Diagnostic diagnostic) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, diagnostic.getMessage());
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addDiagnostic(ModelElementCS csElement, String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public InvalidType addBadTypeError(ModelElementCS csElement, String message, Object ... bindings) {
        InvalidType invalidType = this.typeManager.getOclInvalidType();
        this.installPivotElementInternal(csElement, (Element)invalidType);
        return invalidType;
    }

    protected void addUnderspecifiedTypedElement(TypedElement pivotElement) {
        if (this.underspecifiedTypedElements == null) {
            this.underspecifiedTypedElements = new HashSet();
        }
        this.underspecifiedTypedElements.add(pivotElement);
    }

    public void addWarning(ModelElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public boolean checkForNoErrors(Collection<? extends Resource> csResources) {
        for (Resource resource : csResources) {
            if (resource.getErrors().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void checkMonikers() {
        for (Map.Entry<MonikeredElementCS, MonikeredElement> entry : this.debugCheckMap.entrySet()) {
            String moniker;
            MonikeredElementCS csElement = entry.getKey();
            MonikeredElement element = entry.getValue();
            String csMoniker = csElement.getMoniker();
            if (element.eResource() == null || csMoniker.equals(moniker = element.getMoniker())) continue;
            logger.warn((Object)("Inconsistent monikers\n" + csElement.eClass().getName() + ": '" + csMoniker + "'\n" + element.eClass().getName() + ": '" + moniker + "'"));
        }
    }

    private Set<Element> computeActualContents(Collection<? extends Notifier> pivotResources) {
        HashSet<Element> actualContents = new HashSet<Element>();
        TreeIterator tit = EcoreUtil.getAllContents(pivotResources);
        while (tit.hasNext()) {
            Notifier eObject = (Notifier)tit.next();
            if (!(eObject instanceof Element)) continue;
            actualContents.add((Element)eObject);
        }
        return actualContents;
    }

    private Map<EObject, Collection<EStructuralFeature.Setting>> computeCrossUsages(Collection<? extends Notifier> emfObjects) {
        CrossUsager result = new CrossUsager(emfObjects);
        result.crossReference();
        return result;
    }

    private Set<Element> computeDirectlyReferencedPivotElements() {
        Resource libraryResource = this.typeManager.getLibraryResource();
        HashSet<Element> referencedElements = new HashSet<Element>();
        for (Resource resource : this.csResources) {
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                Resource resource2;
                Element element;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Pivotable) || (element = ((Pivotable)eObject).getPivot()) == null || (resource2 = element.eResource()) == null || resource2 == libraryResource) continue;
                referencedElements.add(element);
            }
        }
        return referencedElements;
    }

    private Set<Element> computeLibraryPivotElements() {
        HashSet<Element> libraryElements = new HashSet<Element>();
        for (Library library : this.typeManager.getLibraries()) {
            TreeIterator tit = library.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Element)) continue;
                libraryElements.add((Element)eObject);
            }
        }
        return libraryElements;
    }

    private Set<Element> computeReferencedPivotElements(Collection<? extends Element> directlyReferencedElements, Map<EObject, Collection<EStructuralFeature.Setting>> pivotCrossUsages) {
        Resource libraryResource = this.typeManager.getLibraryResource();
        Package orphanPackage = this.typeManager.getOrphanPackage();
        Class orphanClass = this.typeManager.getOrphanClass();
        HashSet<Element> oldElements = new HashSet<Element>();
        HashSet<TemplateableElement> deadTemplates = null;
        oldElements.add((Element)orphanPackage);
        oldElements.add((Element)orphanClass);
        HashSet<Object> newElements = new HashSet<Element>(directlyReferencedElements);
        while (!newElements.isEmpty()) {
            oldElements.addAll(newElements);
            HashSet<Element> moreElements = new HashSet<Element>();
            for (Element element : newElements) {
                TemplateParameterSubstitution templateParameterSubstitution;
                ParameterableElement actual;
                Collection<EStructuralFeature.Setting> settings;
                for (EObject eObject : element.eCrossReferences()) {
                    Resource eResource = eObject.eResource();
                    if (eResource == null || eResource == libraryResource || oldElements.contains(eObject) || !(eObject instanceof Element)) continue;
                    moreElements.add((Element)eObject);
                }
                if (element != orphanClass && element != orphanPackage) {
                    for (EObject eObject : element.eContents()) {
                        if (oldElements.contains(eObject) || !(eObject instanceof Element)) continue;
                        moreElements.add((Element)eObject);
                    }
                }
                if ((settings = pivotCrossUsages.get(element)) != null) {
                    for (EStructuralFeature.Setting setting : settings) {
                        EObject eObject = setting.getEObject();
                        if (oldElements.contains(eObject) || !(eObject instanceof Element)) continue;
                        moreElements.add((Element)eObject);
                    }
                }
                if (!(element instanceof TemplateParameterSubstitution) || (actual = (templateParameterSubstitution = (TemplateParameterSubstitution)element).getActual()) == null || actual.eResource() != null) continue;
                if (deadTemplates == null) {
                    deadTemplates = new HashSet<TemplateableElement>();
                }
                deadTemplates.add(templateParameterSubstitution.getTemplateBinding().getBoundElement());
            }
            newElements = moreElements;
        }
        if (deadTemplates != null) {
            oldElements.removeAll(deadTemplates);
        }
        return oldElements;
    }

    protected void diagnoseContinuationFailure(List<BasicContinuation<?>> continuations) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        for (BasicContinuation<?> continuation : continuations) {
            s.append("\n  ");
            s.append(continuation);
            Dependency[] dependencyArray = continuation.getDependencies();
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dependency dependency = dependencyArray[n2];
                s.append("\n    ");
                if (!dependency.canExecute()) {
                    s.append("BLOCKED ");
                    dependency.canExecute();
                }
                s.append(dependency);
                ++n2;
            }
            continuation.canExecute();
            if (++i < 10) continue;
            s.append("\n  ...");
            break;
        }
        logger.error((Object)("Failed to complete continuations" + s.toString()));
    }

    public void garbageCollect(Collection<? extends Resource> pivotResources) {
        Resource libraryResource = this.typeManager.getLibraryResource();
        ArrayList<? extends Resource> allPivotResources = new ArrayList<Resource>(pivotResources);
        allPivotResources.add((Resource)this.typeManager.getOrphanPackage());
        Map<EObject, Collection<EStructuralFeature.Setting>> pivotCrossUsages = this.computeCrossUsages(allPivotResources);
        Set<Element> actualContents = this.computeActualContents(allPivotResources);
        Set<Element> directlyReferencedContents = this.computeDirectlyReferencedPivotElements();
        Set<Element> libraryElements = this.computeLibraryPivotElements();
        Set<Element> referencedContents = this.computeReferencedPivotElements(directlyReferencedContents, pivotCrossUsages);
        HashSet<Element> referencedElements = new HashSet<Element>();
        HashSet<Object> killElements = new HashSet<Object>();
        for (EObject eObject : referencedContents) {
            Resource resource = eObject.eResource();
            if (resource == null) {
                killElements.add(eObject);
                continue;
            }
            if (resource == libraryResource || !(eObject instanceof Element)) continue;
            referencedElements.add((Element)eObject);
        }
        HashSet<Element> hashSet = new HashSet<Element>(actualContents);
        hashSet.removeAll(referencedElements);
        hashSet.removeAll(libraryElements);
        killElements.addAll(hashSet);
        HashSet<Element> referencedOrphanElements = new HashSet<Element>();
        for (Element element : referencedElements) {
            if (element.eResource() != null) continue;
            referencedOrphanElements.add(element);
        }
        for (EObject eObject : killElements) {
            Collection<EStructuralFeature.Setting> settings = pivotCrossUsages.get(eObject);
            if (settings == null) continue;
            for (EStructuralFeature.Setting setting : settings) {
                EObject eObject2 = setting.getEObject();
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature.isDerived()) continue;
                boolean cfr_ignored_0 = eObject2 instanceof MonikeredElement;
                if (eStructuralFeature.isMany()) {
                    Collection list = (Collection)eObject2.eGet(eStructuralFeature);
                    list.remove(eObject);
                    continue;
                }
                eObject2.eSet(eStructuralFeature, null);
            }
        }
    }

    protected void gatherNewPackages(Set<Package> newPackages, List<? extends EObject> csElements) {
        for (EObject eObject : csElements) {
            if (!(eObject instanceof PackageCS)) continue;
            PackageCS csPackage = (PackageCS)eObject;
            Element element = csPackage.getPivot();
            if (element instanceof Package) {
                newPackages.add((Package)element);
            }
            this.gatherNewPackages(newPackages, (List<? extends EObject>)csPackage.getOwnedNestedPackage());
        }
    }

    protected void gatherOldPackages(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            String qualifiedName;
            Package oldPkg;
            if (!(eObject instanceof Package)) continue;
            Package pkg = (Package)eObject;
            String name = pkg.getName();
            if (name == null) {
                name = "$null$";
            }
            if ((oldPkg = this.oldPackagesByQualifiedName.put(qualifiedName = this.getQualifiedName(new StringBuffer(), pkg), pkg)) != null) {
                logger.warn((Object)("Duplicate qualified package name: " + qualifiedName));
            }
            if (name.equals(qualifiedName)) {
                oldPkg = this.oldPackagesByName.put(name, pkg);
                if (oldPkg != null && name.equals(this.getQualifiedName(new StringBuffer(), oldPkg))) {
                    logger.warn((Object)("Duplicate unqualified package name: " + qualifiedName));
                }
            } else {
                oldPkg = this.oldPackagesByName.get(name);
                if (oldPkg == null) {
                    this.oldPackagesByName.put(name, pkg);
                }
            }
            this.gatherOldPackages((List<? extends EObject>)pkg.getNestedPackages());
        }
    }

    public final CS2Pivot getConverter() {
        return this.converter;
    }

    public <T> T getIntermediate(CacheKey<T> key) {
        return (T)this.intermediateCache.get(key);
    }

    public BaseCSVisitor<MonikeredElement, CS2PivotConversion> getLeft2RightVisitor(EPackage ePackage) {
        BaseCSVisitor<MonikeredElement, CS2PivotConversion> left2RightVisitor = this.left2RightVisitorMap.get(ePackage);
        if (left2RightVisitor == null && !this.left2RightVisitorMap.containsKey(ePackage)) {
            CS2Pivot.Factory factory = this.converter.getFactory(ePackage);
            if (factory != null) {
                left2RightVisitor = factory.createLeft2RightVisitor(this);
                if (left2RightVisitor == null) {
                    logger.error((Object)("No Left2Right Visitor created for " + ePackage.getName()));
                }
            } else {
                logger.error((Object)("No Left2Right Visitor Factory registered for " + ePackage.getName()));
            }
            this.left2RightVisitorMap.put(ePackage, left2RightVisitor);
        }
        return left2RightVisitor;
    }

    public InterDependency<BasePreOrderVisitor.OperationContinuation<?>> getOperationsHaveTemplateParametersInterDependency() {
        return this.operationsHaveTemplateParameters;
    }

    public InterDependency<BasePreOrderVisitor.PackageContentContinuation> getPackagesHaveTypesInterDependency() {
        return this.packagesHaveTypes;
    }

    public <T extends Element> T getPivotElement(java.lang.Class<T> pivotClass, String moniker) {
        MonikeredElement nameableElement = this.getPivotElement(moniker);
        if (nameableElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(nameableElement.getClass())) {
            throw new ClassCastException(String.valueOf(nameableElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        MonikeredElement castElement = nameableElement;
        return (T)castElement;
    }

    public MonikeredElement getPivotElement(String moniker) {
        MonikeredElement element = this.newMoniker2PivotMap.get(moniker);
        if (element == null) {
            element = this.oldMoniker2PivotMap.get(moniker);
        }
        return element;
    }

    public BaseCSVisitor<Continuation<?>, CS2PivotConversion> getPostOrderVisitor(EPackage ePackage) {
        BaseCSVisitor<Continuation<?>, CS2PivotConversion> postOrderVisitor = this.postOrderVisitorMap.get(ePackage);
        if (postOrderVisitor == null && !this.postOrderVisitorMap.containsKey(ePackage)) {
            CS2Pivot.Factory factory = this.converter.getFactory(ePackage);
            if (factory != null) {
                postOrderVisitor = factory.createPostOrderVisitor(this);
                if (postOrderVisitor == null) {
                    logger.error((Object)("No PostOrder Visitor created for " + ePackage.getName()));
                }
            } else {
                logger.error((Object)("No PostOrder Visitor Factory registered for " + ePackage.getName()));
            }
            this.postOrderVisitorMap.put(ePackage, postOrderVisitor);
        }
        return postOrderVisitor;
    }

    public BaseCSVisitor<Continuation<?>, CS2PivotConversion> getPreOrderVisitor(EPackage ePackage) {
        BaseCSVisitor<Continuation<?>, CS2PivotConversion> preOrderVisitor = this.preOrderVisitorMap.get(ePackage);
        if (preOrderVisitor == null && !this.preOrderVisitorMap.containsKey(ePackage)) {
            CS2Pivot.Factory factory = this.converter.getFactory(ePackage);
            if (factory != null) {
                preOrderVisitor = factory.createPreOrderVisitor(this);
                if (preOrderVisitor == null) {
                    logger.error((Object)("No PreOrder Visitor created for " + ePackage.getName()));
                }
            } else {
                logger.error((Object)("No PreOrder Visitor Factory registered for " + ePackage.getName()));
            }
            this.preOrderVisitorMap.put(ePackage, preOrderVisitor);
        }
        return preOrderVisitor;
    }

    protected String getQualifiedName(StringBuffer s, Package pkg) {
        String name;
        Package nestingPackage = pkg.getNestingPackage();
        if (nestingPackage != null) {
            this.getQualifiedName(s, nestingPackage);
            s.append("$$");
        }
        if ((name = pkg.getName()) == null) {
            name = "$null$";
        }
        s.append(name);
        return s.toString();
    }

    protected String getQualifiedName(StringBuffer s, PackageCS csPackage) {
        String name;
        EObject eContainer = csPackage.eContainer();
        if (eContainer instanceof PackageCS) {
            this.getQualifiedName(s, (PackageCS)eContainer);
            s.append("$$");
        }
        if ((name = csPackage.getName()) == null) {
            name = "$null$";
        }
        s.append(name);
        return s.toString();
    }

    protected List<TemplateBindingCS> getTemplateBindings(ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedTemplateBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    protected List<TemplateSignature> getTemplateSignatures(Element pivotElement) {
        TemplateableElement templateableElement;
        TemplateSignature templateSignature;
        EObject container = pivotElement.eContainer();
        List<Object> pivotTemplateSignatures = container instanceof Element ? this.getTemplateSignatures((Element)container) : new ArrayList();
        if (pivotElement instanceof TemplateableElement && (templateSignature = (templateableElement = (TemplateableElement)pivotElement).getOwnedTemplateSignature()) != null) {
            pivotTemplateSignatures.add(templateSignature);
        }
        return pivotTemplateSignatures;
    }

    public final TypeManager getTypeManager() {
        return this.typeManager;
    }

    public InterDependency<BasePreOrderVisitor.TemplateSignatureContinuation> getTypesHaveSignaturesInterDependency() {
        return this.typesHaveSignatures;
    }

    public InterDependency<BasePreOrderVisitor.TemplateBindingContinuation> getTypesHaveSpecializationsInterDependency() {
        return this.typesHaveSpecializations;
    }

    public void handleVisitNamedElement(NamedElementCS csNamedElement, NamedElement pivotElement) {
        EList pivotAnnotations = pivotElement.getOwnedAnnotations();
        EList<AnnotationElementCS> csAnnotations = csNamedElement.getOwnedAnnotation();
        this.refreshPivotList((java.lang.Class)Annotation.class, (List)pivotAnnotations, (List<? extends ModelElementCS>)csAnnotations);
    }

    public void installPivotElement(ModelElementCS csElement, Element newPivotElement) {
        if (csElement instanceof MonikeredElementCS) {
            assert (!"NavigatingExpCS".equals(csElement.eClass().getName()));
            this.debugCheckMap.put((MonikeredElementCS)csElement, (MonikeredElement)newPivotElement);
        } else {
            this.debugOtherMap.put(csElement, newPivotElement);
        }
        this.installPivotElementInternal(csElement, newPivotElement);
    }

    private void installPivotElementInternal(ModelElementCS csElement, Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement == null) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        } else if (oldPivotElement != newPivotElement) {
            if (oldPivotElement.eResource() != null) {
                logger.warn((Object)("Conflicting pivot element for " + csElement.getDescription()));
            }
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public void installResidualMonikers(MonikeredElement monikeredElement) {
        if (!monikeredElement.hasMoniker()) {
            this.putPivotElement(monikeredElement);
        }
        TreeIterator tit = monikeredElement.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof MonikeredElement)) continue;
            MonikeredElement childElement = (MonikeredElement)eObject;
            if (!childElement.hasMoniker()) {
                this.putPivotElement(childElement);
            }
            String moniker = childElement.getMoniker();
            MonikeredElement getElement = this.getPivotElement(MonikeredElement.class, moniker);
            assert (getElement == childElement);
        }
    }

    protected void installRootContents(Resource csResource) {
        for (EObject eObject : csResource.getContents()) {
            Resource pivotResource;
            Element pivotElement;
            if (!(eObject instanceof Pivotable) || (pivotElement = ((Pivotable)eObject).getPivot()) == null || (pivotResource = pivotElement.eResource()) != null || (pivotResource = this.converter.getPivotResource(csResource)) == null) continue;
            pivotResource.getContents().add((Object)pivotElement);
        }
    }

    protected List<BasicContinuation<?>> progressContinuations(List<BasicContinuation<?>> continuations) {
        ArrayList moreContinuations = new ArrayList();
        boolean madeProgress = false;
        boolean tracingOn = CONTINUATION.isActive();
        if (tracingOn) {
            CONTINUATION.println("-------------------------------------------------");
            CONTINUATION.println(this.packagesHaveTypes.toString());
            CONTINUATION.println(this.typesHaveSignatures.toString());
            CONTINUATION.println(this.typesHaveSpecializations.toString());
        }
        for (BasicContinuation<?> continuation : continuations) {
            boolean canExecute = continuation.canExecute();
            if (tracingOn) {
                CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + continuation);
            }
            if (canExecute) {
                madeProgress = true;
                BasicContinuation<?> nextContinuation = continuation.execute();
                if (nextContinuation == null) continue;
                nextContinuation.addTo(moreContinuations);
                continue;
            }
            moreContinuations.add(continuation);
        }
        return madeProgress ? moreContinuations : null;
    }

    public <T> T putIntermediate(CacheKey<T> key, T object) {
        return (T)this.intermediateCache.put(key, object);
    }

    public void putPivotElement(MonikeredElement pivotElement) {
        String moniker = pivotElement.getMoniker();
        this.putPivotElement(moniker, pivotElement);
    }

    public void putPivotElement(String moniker, MonikeredElement pivotElement) {
        MonikeredElement oldElement = this.oldMoniker2PivotMap.get(moniker);
        assert (pivotElement == oldElement || oldElement == null);
        oldElement = this.newMoniker2PivotMap.put(moniker, pivotElement);
        if (pivotElement != oldElement) assert (oldElement == null);
    }

    protected void refreshComments(Element pivotElement, ElementCS csElement) {
        List<ILeafNode> documentationNodes;
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node != null && (documentationNodes = CS2Pivot.getDocumentationNodes(node)) != null) {
            Comment comment;
            String trimmedString;
            String string;
            ArrayList<String> documentationStrings = new ArrayList<String>();
            for (ILeafNode documentationNode : documentationNodes) {
                String text = documentationNode.getText();
                documentationStrings.add(text.substring(3, text.length() - 3).trim());
            }
            EList ownedComments = pivotElement.getOwnedComments();
            int iMax = Math.min(documentationStrings.size(), ownedComments.size());
            int i = 0;
            while (i < iMax) {
                string = (String)documentationStrings.get(i);
                trimmedString = this.trimString(string);
                if (!trimmedString.equals((comment = (Comment)ownedComments.get(i)).getBody())) {
                    comment.setBody(trimmedString);
                }
                ++i;
            }
            while (i < documentationStrings.size()) {
                string = (String)documentationStrings.get(i);
                trimmedString = this.trimString(string);
                comment = PivotFactory.eINSTANCE.createComment();
                comment.setBody(trimmedString);
                ownedComments.add(comment);
                ++i;
            }
            while (i < ownedComments.size()) {
                ownedComments.remove(ownedComments.size() - 1);
            }
        }
    }

    public <T extends OclExpression> T refreshExpression(java.lang.Class<T> pivotClass, EClass pivotEClass, MonikeredElementCS csElement) {
        OclExpression pivotElement = (OclExpression)this.refreshMonikeredElement(pivotClass, pivotEClass, csElement);
        this.installPivotElement(csElement, (Element)pivotElement);
        return (T)pivotElement;
    }

    public <T extends Element> void refreshList(java.lang.Class<T> pivotClass, List<T> pivotElements, List<? extends MonikeredElementCS> csElements) {
        if (!pivotElements.isEmpty() || !csElements.isEmpty()) {
            ArrayList<Element> newPivotElements = new ArrayList<Element>();
            for (MonikeredElementCS monikeredElementCS : csElements) {
                String moniker = monikeredElementCS.getMoniker();
                Object pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)monikeredElementCS);
                if (pivotElement == null) {
                    pivotElement = this.getPivotElement(pivotClass, moniker);
                }
                if (pivotElement == null) continue;
                newPivotElements.add((Element)pivotElement);
            }
            PivotUtil.refreshList(pivotElements, newPivotElements);
        }
    }

    public <T extends MonikeredElement> T refreshMonikeredElement(java.lang.Class<T> pivotClass, EClass pivotEClass, MonikeredElementCS csElement) {
        String moniker = csElement.getMoniker();
        MonikeredElementCS oldElement = this.moniker2CSmap.put(moniker, csElement);
        if (oldElement != null && oldElement != csElement) {
            logger.warn((Object)("Duplicate " + moniker));
        }
        return this.refreshMonikeredElement(pivotClass, pivotEClass, moniker);
    }

    public <T extends MonikeredElement> T refreshMonikeredElement(java.lang.Class<T> pivotClass, EClass pivotEClass, String moniker) {
        assert (pivotClass == pivotEClass.getInstanceClass());
        assert (moniker != null);
        MonikeredElement pivotElement = this.getPivotElement(moniker);
        if (pivotElement == null) {
            logger.trace((Object)("Creating " + pivotEClass.getName() + " : " + moniker));
            pivotElement = (MonikeredElement)PivotFactory.eINSTANCE.create(pivotEClass);
            pivotElement.setMoniker(moniker);
            this.putPivotElement(moniker, pivotElement);
        } else if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            logger.trace((Object)("Recreating " + pivotEClass.getName() + " : " + moniker));
            pivotElement = (MonikeredElement)PivotFactory.eINSTANCE.create(pivotEClass);
            this.reputPivotElement(moniker, pivotElement);
        } else {
            assert (!pivotElement.hasMoniker() || moniker.equals(pivotElement.getMoniker()));
            logger.trace((Object)("Reusing " + pivotEClass.getName() + " : " + moniker));
            this.newMoniker2PivotMap.put(moniker, pivotElement);
        }
        MonikeredElement castElement = pivotElement;
        return (T)castElement;
    }

    public void refreshName(NamedElement pivotNamedElement, String newName) {
        String oldName = pivotNamedElement.getName();
        if (!(newName == oldName || newName != null && newName.equals(oldName))) {
            pivotNamedElement.setName(newName);
        }
    }

    public <T extends NamedElement> T refreshNamedElement(java.lang.Class<T> pivotClass, EClass pivotEClass, NamedElementCS csElement) {
        NamedElement pivotElement = (NamedElement)this.refreshMonikeredElement(pivotClass, pivotEClass, csElement);
        this.installPivotElement(csElement, (Element)pivotElement);
        this.refreshName(pivotElement, csElement.getName());
        this.refreshComments((Element)pivotElement, csElement);
        return (T)pivotElement;
    }

    public <T extends Package> T refreshPackage(java.lang.Class<T> pivotClass, EClass pivotEClass, PackageCS csElement) {
        String moniker;
        Package pivotElement;
        Element pivotObject = csElement.getPivot();
        if (pivotObject == null) {
            pivotObject = this.oldCS2PivotMap.get(csElement);
        }
        if (pivotObject == null) {
            String qualifiedName = this.getQualifiedName(new StringBuffer(), csElement);
            pivotObject = this.oldPackagesByQualifiedName.get(qualifiedName);
        }
        if (pivotObject == null) {
            pivotObject = this.oldPackagesByName.get(csElement.getName());
        }
        if (pivotObject == null) {
            pivotElement = this.typeManager.createPackage(pivotClass, pivotEClass, csElement.getName(), csElement.getNsURI());
            moniker = pivotElement.getMoniker();
            logger.trace((Object)("Created " + pivotEClass.getName() + " : " + moniker));
            this.typeManager.installPackage(pivotElement);
        } else {
            Package pivotElement2;
            if (!pivotClass.isAssignableFrom(pivotObject.getClass())) {
                throw new ClassCastException();
            }
            pivotElement = pivotElement2 = (Package)pivotObject;
            moniker = pivotElement.getMoniker();
            logger.trace((Object)("Reusing " + pivotEClass.getName() + " : " + moniker));
            this.refreshName((NamedElement)pivotElement, csElement.getName());
        }
        this.putPivotElement(moniker, (MonikeredElement)pivotElement);
        this.installPivotElement(csElement, (Element)pivotElement);
        this.refreshComments((Element)pivotElement, csElement);
        return (T)pivotElement;
    }

    public <T extends Element> void refreshPivotList(java.lang.Class<T> pivotClass, List<? super T> pivotElements, List<? extends ModelElementCS> csElements) {
        if (pivotElements.isEmpty() && csElements.isEmpty()) {
            return;
        }
        ArrayList<Element> newPivotElements = new ArrayList<Element>();
        for (ModelElementCS modelElementCS : csElements) {
            Element pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)modelElementCS);
            if (pivotElement != null) {
                newPivotElements.add(pivotElement);
                continue;
            }
            assert (pivotElement != null);
        }
        PivotUtil.refreshList(pivotElements, newPivotElements);
    }

    public void refreshTemplateSignature(TemplateableElementCS csTemplateableElement, TemplateableElement pivotTemplateableElement) {
        TemplateSignatureCS csTemplateSignature = csTemplateableElement.getOwnedTemplateSignature();
        if (csTemplateSignature == null) {
            if (pivotTemplateableElement.getOwnedTemplateSignature() != null) {
                pivotTemplateableElement.setOwnedTemplateSignature(null);
            }
            return;
        }
        String moniker = csTemplateSignature.getMoniker();
        TemplateSignature pivotTemplateSignature = this.refreshMonikeredElement(TemplateSignature.class, PivotPackage.Literals.TEMPLATE_SIGNATURE, csTemplateSignature);
        pivotTemplateSignature.setMoniker(moniker);
        if (pivotTemplateableElement.getOwnedTemplateSignature() != pivotTemplateSignature) {
            pivotTemplateableElement.setOwnedTemplateSignature(pivotTemplateSignature);
        }
        this.installPivotElement(csTemplateSignature, (Element)pivotTemplateSignature);
        ArrayList<TemplateParameter> newPivotTemplateParameters = new ArrayList<TemplateParameter>();
        EList<TemplateParameterCS> csTemplateParameters = csTemplateSignature.getOwnedTemplateParameter();
        for (TemplateParameterCS csTemplateParameter : csTemplateParameters) {
            moniker = csTemplateParameter.getMoniker();
            Class pivotTemplateParameterClass = this.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, csTemplateParameter);
            pivotTemplateParameterClass.setMoniker(moniker);
            TemplateParameter pivotTemplateParameter = pivotTemplateParameterClass.getOwningTemplateParameter();
            if (pivotTemplateParameter == null) {
                pivotTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
                pivotTemplateParameter.setOwnedParameteredElement((ParameterableElement)pivotTemplateParameterClass);
            }
            this.installPivotElement(csTemplateParameter, (Element)pivotTemplateParameterClass);
            newPivotTemplateParameters.add(pivotTemplateParameter);
        }
        PivotUtil.refreshList((List)pivotTemplateSignature.getOwnedParameters(), newPivotTemplateParameters);
    }

    public <T extends TypedMultiplicityElement> T refreshTypedMultiplicityElement(java.lang.Class<T> pivotClass, EClass pivotEClass, TypedElementCS csTypedElement) {
        TypedMultiplicityElement pivotElement = (TypedMultiplicityElement)this.refreshNamedElement(pivotClass, pivotEClass, csTypedElement);
        this.refreshMultiplicity((MultiplicityElement)pivotElement, csTypedElement);
        return (T)pivotElement;
    }

    public <T> void refreshMultiplicity(MultiplicityElement pivotElement, TypedElementCS csTypedElement) {
        pivotElement.setIsOrdered(ElementUtil.isOrdered(csTypedElement));
        pivotElement.setIsUnique(ElementUtil.isUnique(csTypedElement));
        int lower = ElementUtil.getLower(csTypedElement);
        int upper = ElementUtil.getUpper(csTypedElement);
        pivotElement.setLower(BigInteger.valueOf(lower));
        pivotElement.setUpper(BigInteger.valueOf(upper));
    }

    protected void resetPivotMappings(Collection<? extends Resource> csResources) {
        for (Resource resource : csResources) {
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Pivotable)) continue;
                Pivotable pivotable = (Pivotable)eObject;
                Element pivot = pivotable.getPivot();
                if (pivot instanceof Package) {
                    this.oldCS2PivotMap.put(pivotable, (Package)pivot);
                }
                pivotable.resetPivot();
            }
        }
    }

    public void resolveIterationSpecialization(LoopExp expression) {
        TemplateParameter formal;
        Map bindings;
        Iteration specializedIteration = expression.getReferredIteration();
        EList specializedTemplateBindings = specializedIteration.getTemplateBindings();
        if (specializedTemplateBindings.size() <= 0) {
            return;
        }
        Iteration unspecializedIteration = (Iteration)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)specializedIteration);
        EList unspecializedParameters = unspecializedIteration.getOwnedParameters();
        if (unspecializedParameters.size() <= 0) {
            return;
        }
        Parameter parameter = (Parameter)unspecializedParameters.get(0);
        Type parameterType = parameter.getType();
        if (!(parameterType instanceof LambdaType)) {
            return;
        }
        Type bodyType = expression.getBody().getType();
        if ("collect".equals(unspecializedIteration.getName())) {
            while (bodyType instanceof CollectionType) {
                bodyType = ((CollectionType)bodyType).getElementType();
            }
        }
        if ((bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, (Type)bodyType, (LambdaType)((LambdaType)parameterType))) == null) {
            return;
        }
        boolean bindingsChanged = false;
        for (TemplateBinding templateBinding : specializedTemplateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                Object actual = templateParameterSubstitution.getActual();
                if (actual != null || (actual = (ParameterableElement)bindings.get(formal = templateParameterSubstitution.getFormal())) == null) continue;
                bindingsChanged = true;
            }
        }
        if (!bindingsChanged) {
            return;
        }
        HashMap<TemplateParameter, ParameterableElement> rebindings = new HashMap<TemplateParameter, ParameterableElement>();
        for (TemplateBinding templateBinding : specializedTemplateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                formal = templateParameterSubstitution.getFormal();
                ParameterableElement actual = templateParameterSubstitution.getActual();
                if (actual == null) {
                    actual = (ParameterableElement)bindings.get(formal);
                }
                rebindings.put(formal, actual);
            }
        }
        Iteration respecializedIteration = (Iteration)this.typeManager.getSpecializedOperation((Operation)unspecializedIteration, rebindings);
        this.setReferredIteration(expression, respecializedIteration);
        this.setType((TypedElement)expression, respecializedIteration.getType());
        Parameter specializedIterator = (Parameter)specializedIteration.getOwnedIterators().get(0);
        TreeIterator tit = expression.eAllContents();
        while (tit.hasNext()) {
            Variable variable;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Variable) || (variable = (Variable)eObject).getRepresentedParameter() != specializedIterator) continue;
            variable.setRepresentedParameter((Parameter)respecializedIteration.getOwnedIterators().get(0));
        }
    }

    public void resolveIterationUnderspecification(LoopExp expression) {
        Parameter respecializedIterator;
        Parameter specializedIterator;
        Iteration specializedIteration = expression.getReferredIteration();
        EList specializedTemplateBindings = specializedIteration.getTemplateBindings();
        if (specializedTemplateBindings.size() <= 0) {
            return;
        }
        Iteration unspecializedIteration = (Iteration)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)specializedIteration);
        Map bindings = PivotUtil.getAllTemplateParametersAsBindings((EObject)unspecializedIteration);
        if (bindings == null) {
            return;
        }
        boolean bindingsChanged = false;
        for (TemplateBinding templateBinding : specializedTemplateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                Object actual = templateParameterSubstitution.getActual();
                if (!this.typeManager.isUnderspecified((ParameterableElement)actual) || (actual = this.resolveUnderspecifiedType((Type)actual)) == null) continue;
                templateParameterSubstitution.setActual((ParameterableElement)actual);
                bindingsChanged = true;
            }
        }
        if (!bindingsChanged) {
            return;
        }
        HashMap<TemplateParameter, ParameterableElement> rebindings = new HashMap<TemplateParameter, ParameterableElement>();
        for (TemplateBinding templateBinding : specializedTemplateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                TemplateParameter formal = templateParameterSubstitution.getFormal();
                ParameterableElement actual = templateParameterSubstitution.getActual();
                if (actual == null) {
                    actual = (ParameterableElement)bindings.get(formal);
                }
                rebindings.put(formal, actual);
            }
        }
        Iteration respecializedIteration = (Iteration)this.typeManager.getSpecializedOperation((Operation)unspecializedIteration, rebindings);
        this.setReferredIteration(expression, respecializedIteration);
        this.setType((TypedElement)expression, respecializedIteration.getType());
        HashMap<Parameter, Parameter> mappings = new HashMap<Parameter, Parameter>();
        int i = respecializedIteration.getOwnedIterators().size();
        while (--i >= 0) {
            specializedIterator = (Parameter)specializedIteration.getOwnedIterators().get(i);
            respecializedIterator = (Parameter)respecializedIteration.getOwnedIterators().get(i);
            mappings.put(specializedIterator, respecializedIterator);
        }
        i = respecializedIteration.getOwnedAccumulators().size();
        while (--i >= 0) {
            specializedIterator = (Parameter)specializedIteration.getOwnedAccumulators().get(i);
            respecializedIterator = (Parameter)respecializedIteration.getOwnedAccumulators().get(i);
            mappings.put(specializedIterator, respecializedIterator);
        }
        i = respecializedIteration.getOwnedParameters().size();
        while (--i >= 0) {
            specializedIterator = (Parameter)specializedIteration.getOwnedParameters().get(i);
            respecializedIterator = (Parameter)respecializedIteration.getOwnedParameters().get(i);
            mappings.put(specializedIterator, respecializedIterator);
        }
        TreeIterator tit = expression.eAllContents();
        while (tit.hasNext()) {
            Variable variable;
            Parameter respecializedParameter;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Variable) || (respecializedParameter = (Parameter)mappings.get((variable = (Variable)eObject).getRepresentedParameter())) == null) continue;
            variable.setRepresentedParameter(respecializedParameter);
        }
    }

    public void resolveNamespaces(List<Namespace> namespaces) {
        Iterator<Namespace> iterator = namespaces.iterator();
        while (iterator.hasNext()) {
            Namespace namespace;
            Namespace namespace2 = namespace = iterator.next();
        }
    }

    protected void resolveUnderspecifiedTypes() {
        for (TypedElement underspecifiedTypedElement : this.underspecifiedTypedElements) {
            Type underspecifiedType = underspecifiedTypedElement.getType();
            Type resolvedType = this.resolveUnderspecifiedType(underspecifiedType);
            underspecifiedTypedElement.setType(resolvedType);
        }
        for (TypedElement underspecifiedTypedElement : this.underspecifiedTypedElements) {
            if (underspecifiedTypedElement instanceof LoopExp) {
                LoopExp underspecifiedIterationCall = (LoopExp)underspecifiedTypedElement;
                this.resolveIterationUnderspecification(underspecifiedIterationCall);
                continue;
            }
            if (!(underspecifiedTypedElement instanceof OperationCallExp)) continue;
            OperationCallExp operationCallExp = (OperationCallExp)underspecifiedTypedElement;
        }
    }

    protected Type resolveUnderspecifiedType(Type type) {
        if (type instanceof UnspecifiedType) {
            return ((UnspecifiedType)type).getLowerBound();
        }
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Type resolvedElementType = this.resolveUnderspecifiedType(collectionType.getElementType());
            return this.typeManager.getCollectionType(collectionType.getName(), resolvedElementType);
        }
        if (type instanceof PrimitiveType) {
            return type;
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Property> resolvedProperties = new ArrayList<Property>();
            for (Property part : ((TupleType)type).getOwnedAttributes()) {
                if (this.typeManager.isUnderspecified((ParameterableElement)part.getType())) {
                    Property prop = PivotFactory.eINSTANCE.createProperty();
                    prop.setName(part.getName());
                    prop.setType(this.resolveUnderspecifiedType(part.getType()));
                    resolvedProperties.add(part);
                    continue;
                }
                resolvedProperties.add(part);
            }
            return this.typeManager.getTupleType(tupleType.getName(), resolvedProperties, null, null);
        }
        if (type instanceof ClassifierType) {
            ClassifierType classifierType = (ClassifierType)type;
            Type resolvedElementType = this.resolveUnderspecifiedType(classifierType.getInstanceType());
            return this.typeManager.getClassifierType(resolvedElementType);
        }
        throw new UnsupportedOperationException();
    }

    public void reputPivotElement(String moniker, MonikeredElement pivotElement) {
        MonikeredElement oldElement = this.oldMoniker2PivotMap.get(moniker);
        oldElement = this.newMoniker2PivotMap.put(moniker, pivotElement);
    }

    public void reusePivotElement(ModelElementCS csElement, Element newPivotElement) {
        if (newPivotElement != null) {
            this.debugOtherMap.put(csElement, newPivotElement);
            this.installPivotElementInternal(csElement, newPivotElement);
        }
    }

    public void setReferredIteration(LoopExp expression, Iteration iteration) {
        expression.setReferredIteration(iteration);
        if (iteration != null) {
            for (Parameter parameter : iteration.getOwnedIterators()) {
                if (!this.typeManager.isUnderspecified((ParameterableElement)parameter.getType())) continue;
                this.addUnderspecifiedTypedElement((TypedElement)expression);
            }
            for (Parameter parameter : iteration.getOwnedAccumulators()) {
                if (!this.typeManager.isUnderspecified((ParameterableElement)parameter.getType())) continue;
                this.addUnderspecifiedTypedElement((TypedElement)expression);
            }
            for (Parameter parameter : iteration.getOwnedParameters()) {
                if (!this.typeManager.isUnderspecified((ParameterableElement)parameter.getType())) continue;
                this.addUnderspecifiedTypedElement((TypedElement)expression);
            }
        }
    }

    public void setReferredOperation(OperationCallExp expression, Operation operation) {
        expression.setReferredOperation(operation);
        if (operation != null) {
            for (Parameter parameter : operation.getOwnedParameters()) {
                if (!this.typeManager.isUnderspecified((ParameterableElement)parameter.getType())) continue;
                this.addUnderspecifiedTypedElement((TypedElement)expression);
            }
        }
    }

    public void setType(TypedElement pivotElement, Type type) {
        if (type != pivotElement.getType()) {
            pivotElement.setType(type);
            if (this.typeManager.isUnderspecified((ParameterableElement)type)) {
                this.addUnderspecifiedTypedElement(pivotElement);
            }
        }
    }

    public void setTypeWithMultiplicity(TypedElement typedElement, TypedMultiplicityElement typedMultiplicityElement) {
        Type type;
        if (typedMultiplicityElement != null && !typedMultiplicityElement.eIsProxy() && (type = this.typeManager.getTypeWithMultiplicity(typedMultiplicityElement)) != null && !type.eIsProxy()) {
            this.setType(typedElement, type);
        }
    }

    protected void specializeTemplateBindings(List<TemplateBinding> templateBindings, List<TemplateSignature> templateSignatures, List<TemplateBindingCS> csTemplateBindings) {
        int pivotIMax;
        int csIMax = csTemplateBindings.size();
        if (csIMax != (pivotIMax = templateSignatures.size())) {
            logger.warn((Object)("Inconsistent template bindings size for " + csTemplateBindings.get(0).getOwningTemplateBindableElement().getMoniker()));
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            TemplateBindingCS csTemplateBinding = csTemplateBindings.get(i);
            TemplateSignature templateSignature = templateSignatures.get(i);
            int oldMax = templateBindings.size();
            TemplateBinding templateBinding = null;
            int j = i;
            while (j < oldMax) {
                TemplateBinding oldTemplateBinding = templateBindings.get(j);
                if (oldTemplateBinding.getSignature() == templateSignature) {
                    if (j != i) {
                        templateBindings.add(i, templateBindings.remove(j));
                    }
                    templateBinding = oldTemplateBinding;
                    break;
                }
                ++j;
            }
            if (templateBinding == null) {
                templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
                templateBinding.setSignature(templateSignature);
                if (i < oldMax) {
                    templateBindings.add(i, templateBinding);
                } else {
                    templateBindings.add(templateBinding);
                }
            }
            this.installPivotElement(csTemplateBinding, (Element)templateBinding);
            this.specializeTemplateParameterSubstitutions((List<TemplateParameterSubstitution>)templateBinding.getParameterSubstitutions(), (List<TemplateParameter>)templateSignature.getOwnedParameters(), (List<TemplateParameterSubstitutionCS>)csTemplateBinding.getOwnedParameterSubstitution());
            assert (templateSignatures.get(i) == templateBindings.get(i).getSignature());
            ++i;
        }
        int k = templateBindings.size();
        while (k > newMax) {
            templateBindings.remove(--k);
        }
        assert (templateSignatures.size() == templateBindings.size());
    }

    protected void specializeTemplateParameterSubstitutions(List<TemplateParameterSubstitution> templateParameterSubstitutions, List<TemplateParameter> templateParameters, List<TemplateParameterSubstitutionCS> csTemplateParameterSubstitutions) {
        int pivotIMax;
        int csIMax = csTemplateParameterSubstitutions.size();
        if (csIMax != (pivotIMax = templateParameters.size())) {
            logger.warn((Object)"Inconsistent template parameter substitutions size");
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            ParameterableElement pivotActualParameter;
            ParameterableElementCS csActualParameter;
            TemplateParameterSubstitutionCS csTemplateParameterSubstitution = csTemplateParameterSubstitutions.get(i);
            TemplateParameter templateParameter = templateParameters.get(i);
            int oldMax = templateParameterSubstitutions.size();
            TemplateParameterSubstitution templateParameterSubstitution = null;
            int j = i;
            while (j < oldMax) {
                TemplateParameterSubstitution oldTemplateParameterSubstitution = templateParameterSubstitutions.get(j);
                if (oldTemplateParameterSubstitution.getFormal() == templateParameter) {
                    if (j != i) {
                        templateParameterSubstitutions.add(i, templateParameterSubstitutions.remove(j));
                    }
                    templateParameterSubstitution = oldTemplateParameterSubstitution;
                    break;
                }
                ++j;
            }
            if (templateParameterSubstitution == null) {
                templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(templateParameter);
                if (i < oldMax) {
                    templateParameterSubstitutions.add(i, templateParameterSubstitution);
                } else {
                    templateParameterSubstitutions.add(templateParameterSubstitution);
                }
            }
            if ((csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter()) instanceof WildcardTypeRefCS) {
                pivotActualParameter = templateParameterSubstitution.getOwnedActual();
                if (pivotActualParameter == null) {
                    pivotActualParameter = PivotFactory.eINSTANCE.createClass();
                    templateParameterSubstitution.setOwnedActual(pivotActualParameter);
                }
                String name = "wildcard";
                if (i > 1) {
                    name = String.valueOf(name) + i;
                }
                ((NamedElement)pivotActualParameter).setName(name);
                this.installPivotElement(csActualParameter, (Element)pivotActualParameter);
            } else {
                pivotActualParameter = (ParameterableElement)PivotUtil.getPivot(ParameterableElement.class, (Pivotable)csActualParameter);
                templateParameterSubstitution.setActual(pivotActualParameter);
            }
            this.installPivotElement(csTemplateParameterSubstitution, (Element)templateParameterSubstitution);
            assert (templateParameters.get(i) == templateParameterSubstitutions.get(i).getFormal());
            ++i;
        }
        int k = templateParameterSubstitutions.size();
        while (k > newMax) {
            templateParameterSubstitutions.remove(--k);
        }
        assert (templateParameters.size() == templateParameterSubstitutions.size());
    }

    protected TemplateableElement specializeTemplates(TypedTypeRefCS csElement) {
        TemplateBindingCS ownedTemplateBinding = csElement.getOwnedTemplateBinding();
        assert (ownedTemplateBinding != null);
        Type unspecializedPivotElement = csElement.getType();
        String moniker = csElement.getMoniker();
        logger.trace((Object)("Specializing " + moniker));
        if (unspecializedPivotElement == null || unspecializedPivotElement.eIsProxy()) {
            logger.error((Object)("Nothing to specialize as " + moniker));
            return null;
        }
        TemplateableElement specializedPivotElement = this.getPivotElement(TemplateableElement.class, moniker);
        if (specializedPivotElement == null) {
            if (unspecializedPivotElement instanceof Type) {
                EClass eClass = unspecializedPivotElement.eClass();
                java.lang.Class pivotClazz = eClass.getInstanceClass();
                Type pivotClass = (Type)this.refreshMonikeredElement(pivotClazz, eClass, csElement);
                this.refreshName((NamedElement)pivotClass, unspecializedPivotElement.getName());
                pivotClass.setMoniker(moniker);
                specializedPivotElement = pivotClass;
                if (pivotClass instanceof CollectionType) {
                    Type elementType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((TemplateParameterSubstitutionCS)ownedTemplateBinding.getOwnedParameterSubstitution().get(0)).getOwnedActualParameter());
                    ((CollectionType)pivotClass).setElementType(elementType);
                } else if (pivotClass instanceof ClassifierType) {
                    Type instanceType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((TemplateParameterSubstitutionCS)ownedTemplateBinding.getOwnedParameterSubstitution().get(0)).getOwnedActualParameter());
                    ((ClassifierType)pivotClass).setInstanceType(instanceType);
                }
            } else {
                logger.error((Object)("Missing support for non-type specialization " + moniker));
                return null;
            }
            specializedPivotElement.setUnspecializedElement((TemplateableElement)unspecializedPivotElement);
            this.typeManager.addOrphanClass((Type)specializedPivotElement);
        }
        this.installPivotElement(csElement, (Element)specializedPivotElement);
        if (specializedPivotElement == unspecializedPivotElement) {
            return null;
        }
        EList templateBindings = specializedPivotElement.getTemplateBindings();
        List<TemplateSignature> templateSignatures = this.getTemplateSignatures((Element)unspecializedPivotElement);
        List<TemplateBindingCS> csTemplateBindings = this.getTemplateBindings(csElement);
        this.specializeTemplateBindings((List<TemplateBinding>)templateBindings, templateSignatures, csTemplateBindings);
        Set<TemplateableElement> specializationList = this.specializations.get(unspecializedPivotElement);
        if (specializationList == null) {
            specializationList = new HashSet<TemplateableElement>();
            this.specializations.put((TemplateableElement)unspecializedPivotElement, specializationList);
        }
        specializationList.add(specializedPivotElement);
        return specializedPivotElement;
    }

    protected String trimString(String string) {
        StringBuffer s = new StringBuffer();
        String prefix = "";
        String[] stringArray = string.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String trimmedLine = line.trim();
            if (trimmedLine.length() == 0) {
                s.append("\n");
                prefix = "";
            } else {
                s.append(prefix);
                s.append(trimmedLine.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                prefix = " ";
            }
            ++n2;
        }
        String trimmedString = s.toString();
        return trimmedString;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean update() {
        this.resetPivotMappings(this.csResources);
        this.debugCheckMap.clear();
        this.debugOtherMap.clear();
        this.oldPackagesByName = new HashMap<String, Package>();
        this.oldPackagesByQualifiedName = new HashMap<String, Package>();
        for (Resource resource : this.converter.cs2pivotResourceMap.values()) {
            this.gatherOldPackages((List<? extends EObject>)resource.getContents());
        }
        continuations = new ArrayList<BasicContinuation<?>>();
        for (Resource csResource : this.csResources) {
            this.visitInPreOrder((List<? extends EObject>)csResource.getContents(), continuations);
        }
        for (Resource csResource : this.csResources) {
            this.installRootContents(csResource);
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(this.csResources);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        if (this.typeManager.getLibraryResource() == null && this.typeManager.getDefaultStandardLibraryURI() == null) {
            for (Resource resource : this.converter.cs2pivotResourceMap.values()) {
                this.typeManager.loadLibrary(resource);
            }
        }
        if ((oclAnyType = this.typeManager.getOclAnyType()) == null) {
            return false;
        }
        for (Resource csResource : this.csResources) {
            this.visitInPostOrder((List<? extends EObject>)csResource.getContents(), continuations);
        }
        hasNoErrors = this.checkForNoErrors(this.csResources);
        if (hasNoErrors) ** GOTO lbl43
        return false;
lbl-1000:
        // 1 sources

        {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
lbl43:
            // 2 sources

            ** while (continuations.size() > 0)
        }
lbl44:
        // 3 sources

        for (Resource csResource : this.csResources) {
            this.installRootContents(csResource);
        }
        if (this.underspecifiedTypedElements != null) {
            this.resolveUnderspecifiedTypes();
        }
        this.typeManager.resolveSpecializationBaseClasses();
        hasNoMoreErrors = this.checkForNoErrors(this.csResources);
        if (!hasNoMoreErrors) {
            return false;
        }
        newPackages = new HashSet<Package>();
        for (Resource resource : this.csResources) {
            this.gatherNewPackages(newPackages, (List<? extends EObject>)resource.getContents());
        }
        obsoletePackages = new HashSet<Package>(this.oldPackagesByQualifiedName.values());
        obsoletePackages.removeAll(newPackages);
        for (Package obsoletePackage : obsoletePackages) {
            eContainer = obsoletePackage.eContainer();
            if (eContainer == null) continue;
            eContainmentFeature = obsoletePackage.eContainmentFeature();
            if (eContainmentFeature.isMany()) {
                siblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                siblings.remove(obsoletePackage);
                continue;
            }
            eContainer.eSet((EStructuralFeature)eContainmentFeature, null);
        }
        this.checkMonikers();
        for (Resource csResource : this.csResources) {
            pivotResource = this.converter.getPivotResource(csResource);
            TypeManager.setMonikerAsID(Collections.singletonList(pivotResource));
        }
        return true;
    }

    public void usePivotElement(ModelElementCS csElement, Element newPivotElement) {
    }

    public <T extends MonikeredElement> T visitLeft2Right(java.lang.Class<T> pivotClass, VisitableCS csObject) {
        if (csObject == null) {
            return null;
        }
        BaseCSVisitor<MonikeredElement, CS2PivotConversion> left2RightVisitor = this.getLeft2RightVisitor(csObject.eClass().getEPackage());
        if (left2RightVisitor == null) {
            throw new IllegalArgumentException("Unsupportable " + csObject.eClass().getName() + " for CS2Pivot Left2Right pass");
        }
        MonikeredElement monikeredElement = csObject.accept(left2RightVisitor);
        if (!pivotClass.isAssignableFrom(monikeredElement.getClass())) {
            throw new ClassCastException(String.valueOf(monikeredElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        MonikeredElement castElement = monikeredElement;
        return (T)castElement;
    }

    protected void visitInPostOrder(List<? extends EObject> eObjects, List<BasicContinuation<?>> continuations) {
        int i = eObjects.size();
        while (i-- > 0) {
            Continuation<?> continuation;
            EObject eObject = eObjects.get(i);
            BaseCSVisitor<Continuation<?>, CS2PivotConversion> postOrderVisitor = this.getPostOrderVisitor(eObject.eClass().getEPackage());
            if (postOrderVisitor == null || !(eObject instanceof VisitableCS)) {
                throw new IllegalArgumentException("Unsupportable " + eObject.eClass().getName() + " for CS2Pivot PostOrder pass");
            }
            EList eContents = eObject.eContents();
            if (eContents.size() > 0) {
                this.visitInPostOrder((List<? extends EObject>)eContents, continuations);
            }
            if ((continuation = ((VisitableCS)eObject).accept(postOrderVisitor)) == null) continue;
            continuation.addTo(continuations);
        }
    }

    protected void visitInPreOrder(List<? extends EObject> eObjects, List<BasicContinuation<?>> continuations) {
        for (EObject eObject : eObjects) {
            EList eContents;
            BaseCSVisitor<Continuation<?>, CS2PivotConversion> preOrderVisitor = this.getPreOrderVisitor(eObject.eClass().getEPackage());
            if (preOrderVisitor == null || !(eObject instanceof VisitableCS)) {
                throw new IllegalArgumentException("Unsupportable " + eObject.eClass().getName() + " for CS2Pivot PreOrder pass");
            }
            Continuation<?> continuation = ((VisitableCS)eObject).accept(preOrderVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
            if ((eContents = eObject.eContents()).size() <= 0) continue;
            this.visitInPreOrder((List<? extends EObject>)eContents, continuations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheKey<T> {
        protected final String name;

        public CacheKey(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CrossUsager
    extends EcoreUtil.CrossReferencer {
        private CrossUsager(Collection<?> emfObjects) {
            super(emfObjects);
        }

        protected void add(InternalEObject eObject, EReference eReference, EObject crossReferencedEObject) {
            EStructuralFeature.Setting eSetting = eObject.eSetting((EStructuralFeature)eReference);
            Collection collection = this.getCollection(crossReferencedEObject);
            if (!collection.contains(eSetting)) {
                collection.add(eSetting);
            }
        }

        protected void crossReference() {
            super.crossReference();
        }

        protected void handleCrossReference(EObject eObject) {
            super.handleCrossReference(eObject);
            InternalEObject internalEObject = (InternalEObject)eObject;
            for (EObject eContent : eObject.eContents()) {
                EReference eReference = (EReference)eContent.eContainingFeature();
                this.add(internalEObject, eReference, eContent);
            }
        }
    }
}

