/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class AliasAnalysis
extends AdapterImpl {
    private Map<String, EObject> allNames = new HashMap<String, EObject>();
    private Set<Package> localPackages = new HashSet<Package>();
    private Set<Package> otherPackages = new HashSet<Package>();
    private Map<Package, String> allAliases = new HashMap<Package, String>();

    public static void dispose(Resource resource) {
        EList eAdapters;
        AliasAnalysis adapter;
        if (resource != null && (adapter = (AliasAnalysis)((Object)PivotUtil.getAdapter(AliasAnalysis.class, (List)(eAdapters = resource.eAdapters())))) != null) {
            adapter.dispose();
        }
    }

    public static AliasAnalysis getAdapter(Resource resource) {
        if (resource == null) {
            return null;
        }
        EList eAdapters = resource.eAdapters();
        AliasAnalysis adapter = (AliasAnalysis)((Object)PivotUtil.getAdapter(AliasAnalysis.class, (List)eAdapters));
        if (adapter == null) {
            adapter = new AliasAnalysis(resource);
            adapter.computePackages();
            adapter.computeAliases();
        }
        return adapter;
    }

    public AliasAnalysis(Resource resource) {
        resource.eAdapters().add((Object)this);
    }

    private void computeAliases() {
        String alias;
        for (Package localPackage : this.localPackages) {
            if (localPackage.getNsPrefix() == null && localPackage.getNestingPackage() != null) continue;
            alias = this.computeAlias(localPackage);
            this.allAliases.put(localPackage, alias);
        }
        for (Package otherPackage : this.otherPackages) {
            if (otherPackage.getNsPrefix() == null && otherPackage.getNestingPackage() != null) continue;
            alias = this.computeAlias(otherPackage);
            this.allAliases.put(otherPackage, alias);
        }
    }

    private void addName(String name, EObject eObject) {
        if (name != null) {
            if (!this.allNames.containsKey(name)) {
                this.allNames.put(name, eObject);
            } else if (this.allNames.get(name) != eObject) {
                this.allNames.put(name, null);
            }
        }
    }

    private String computeAlias(Package pivotPackage) {
        String nsPrefix = pivotPackage.getNsPrefix();
        String aliasBase = nsPrefix != null ? nsPrefix : pivotPackage.getName();
        int index = 0;
        String alias = aliasBase;
        while (this.allNames.containsKey(alias) && this.allNames.get(alias) != pivotPackage) {
            alias = String.valueOf(aliasBase) + "_" + index++;
        }
        this.addName(alias, (EObject)pivotPackage);
        return alias;
    }

    private void computePackages() {
        TreeIterator tit = ((Resource)this.target).getAllContents();
        block0: while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Pivotable) {
                eObject = ((Pivotable)eObject).getPivot();
            }
            if (!(eObject instanceof NamedElement)) continue;
            this.addName(((NamedElement)eObject).getName(), eObject);
            if (eObject instanceof Package) {
                Package pPackage = (Package)eObject;
                this.addName(pPackage.getNsPrefix(), eObject);
                Package pivotPackage = pPackage;
                this.localPackages.add(pivotPackage);
                continue;
            }
            EObject eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof Package) {
                    this.otherPackages.add((Package)eContainer);
                    continue block0;
                }
                if (eContainer instanceof TemplateableElement) {
                    eContainer = PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)((TemplateableElement)eContainer));
                }
                eContainer = eContainer.eContainer();
            }
        }
        this.otherPackages.removeAll(this.localPackages);
        HashSet<Package> nestedPackages = new HashSet<Package>();
        for (Package localPackage : this.localPackages) {
            EObject eContainerContainer;
            EObject eContainer = localPackage.eContainer();
            if (!(eContainer instanceof Package) || !((eContainerContainer = eContainer.eContainer()) instanceof Package)) continue;
            nestedPackages.add(localPackage);
        }
        this.localPackages.removeAll(nestedPackages);
    }

    public void dispose() {
        this.target.eAdapters().remove((Object)this);
    }

    public String getAlias(EObject eObject) {
        if (eObject instanceof Pivotable) {
            eObject = ((Pivotable)eObject).getPivot();
        }
        if (eObject instanceof Package) {
            return this.allAliases.get(eObject);
        }
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return type == AliasAnalysis.class;
    }
}

