/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseReferenceVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2CSConversion
extends AbstractConversion
implements PivotConstants {
    private static final Logger logger = Logger.getLogger(Pivot2CSConversion.class);
    protected final Pivot2CS converter;
    protected final TypeManager typeManager;
    protected final BaseDeclarationVisitor defaultDeclarationVisitor;
    protected final BaseReferenceVisitor defaultReferenceVisitor;
    private org.eclipse.ocl.examples.pivot.Class scope = null;
    private final Map<EClass, BaseDeclarationVisitor> declarationVisitorMap = new HashMap<EClass, BaseDeclarationVisitor>();
    private final Map<EClass, BaseReferenceVisitor> referenceVisitorMap = new HashMap<EClass, BaseReferenceVisitor>();
    private Set<Package> importedPackages = null;

    public Pivot2CSConversion(Pivot2CS converter) {
        this.converter = converter;
        this.typeManager = converter.getTypeManager();
        this.defaultDeclarationVisitor = converter.createDefaultDeclarationVisitor(this);
        this.defaultReferenceVisitor = converter.createDefaultReferenceVisitor(this);
    }

    protected void addBooleanQualifier(List<String> qualifiers, DetailCS csDetail, String csString) {
        if (csDetail.getValue().size() == 1 && Boolean.valueOf((String)csDetail.getValue().get(0)).booleanValue()) {
            qualifiers.add(csString);
        } else {
            qualifiers.add("!" + csString);
        }
    }

    protected void createImports(Resource csResource, Set<Package> importedPackages) {
        AliasAnalysis.dispose(csResource);
        URI oclinecoreURI = csResource.getURI();
        RootPackageCS documentCS = (RootPackageCS)csResource.getContents().get(0);
        EList imports = documentCS.getOwnedImport();
        for (Package importedPackage : importedPackages) {
            ImportCS importCS = BaseCSTFactory.eINSTANCE.createImportCS();
            AliasAnalysis aliasAnalysis = AliasAnalysis.getAdapter(csResource);
            String alias = aliasAnalysis.getAlias((EObject)importedPackage);
            importCS.setName(alias);
            importCS.setNamespace((Namespace)importedPackage);
            importCS.setPivot((Element)importedPackage);
            EObject eObject = importedPackage.getETarget();
            URI fullURI = EcoreUtil.getURI((EObject)(eObject != null ? eObject : importedPackage));
            URI deresolvedURI = fullURI.deresolve(oclinecoreURI);
            importCS.setUri(deresolvedURI.toString());
            imports.add(importCS);
        }
    }

    public BaseDeclarationVisitor getDeclarationVisitor(EClass eClass) {
        BaseDeclarationVisitor declarationVisitor = this.declarationVisitorMap.get(eClass);
        if (declarationVisitor == null && !this.declarationVisitorMap.containsKey(eClass)) {
            Pivot2CS.Factory factory = this.converter.getFactory(eClass);
            if (factory != null) {
                declarationVisitor = factory.createDeclarationVisitor(this);
                if (declarationVisitor == null) {
                    logger.error((Object)("No Visitor created for " + eClass.getName()));
                }
            } else {
                declarationVisitor = this.defaultDeclarationVisitor;
            }
            this.declarationVisitorMap.put(eClass, declarationVisitor);
        }
        return declarationVisitor;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public BaseReferenceVisitor getReferenceVisitor(EClass eClass) {
        BaseReferenceVisitor referenceVisitor = this.referenceVisitorMap.get(eClass);
        if (referenceVisitor == null && !this.referenceVisitorMap.containsKey(eClass)) {
            Pivot2CS.Factory factory = this.converter.getFactory(eClass);
            if (factory != null) {
                referenceVisitor = factory.createReferenceVisitor(this);
                if (referenceVisitor == null) {
                    logger.error((Object)("No Visitor created for " + eClass.getName()));
                }
            } else {
                referenceVisitor = this.defaultReferenceVisitor;
            }
            this.referenceVisitorMap.put(eClass, referenceVisitor);
        }
        return referenceVisitor;
    }

    public org.eclipse.ocl.examples.pivot.Class getScope() {
        return this.scope;
    }

    protected List<TemplateBindingCS> getTemplateBindings(ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedTemplateBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    public void importPackage(Package importPackage) {
        assert (importPackage != null);
        this.importedPackages.add(importPackage);
    }

    protected <T extends ClassifierCS> T refreshClassifier(Class<T> csClass, EClass csEClass, Type object) {
        ClassifierCS csElement = (ClassifierCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        this.refreshList((List)csElement.getOwnedConstraint(), this.visitDeclarations((Class<T>)ConstraintCS.class, (List)object.getOwnedRules(), null));
        TemplateSignature ownedTemplateSignature = object.getOwnedTemplateSignature();
        if (ownedTemplateSignature != null) {
            csElement.setOwnedTemplateSignature(this.visitDeclaration(TemplateSignatureCS.class, (EObject)ownedTemplateSignature));
        }
        if (object.eIsSet((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME)) {
            csElement.setInstanceClassName(object.getInstanceClassName());
        } else {
            csElement.eUnset((EStructuralFeature)BaseCSTPackage.Literals.CLASSIFIER_CS__INSTANCE_CLASS_NAME);
        }
        return (T)csElement;
    }

    public <T extends MonikeredElementCS> T refreshMonikeredElement(Class<T> csClass, EClass csEClass, MonikeredElement object) {
        assert (csClass == csEClass.getInstanceClass());
        EFactory eFactoryInstance = csEClass.getEPackage().getEFactoryInstance();
        MonikeredElementCS csElement = (MonikeredElementCS)eFactoryInstance.create(csEClass);
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            throw new ClassCastException();
        }
        csElement.setPivot((Element)object);
        MonikeredElementCS castElement = csElement;
        return (T)castElement;
    }

    public <T extends NamedElementCS> T refreshNamedElement(Class<T> csClass, EClass csEClass, NamedElement object) {
        NamedElementCS csElement = (NamedElementCS)this.refreshMonikeredElement(csClass, csEClass, (MonikeredElement)object);
        String name = object.getName();
        csElement.setName(name);
        this.refreshList((List)csElement.getOwnedAnnotation(), this.visitDeclarations((Class<T>)AnnotationCS.class, (List)object.getOwnedAnnotations(), null));
        return (T)csElement;
    }

    public void refreshQualifiers(List<String> qualifiers, String string, boolean polarity) {
        for (String qualifier : qualifiers) {
            if (!qualifier.equals(string)) continue;
            if (!polarity) {
                qualifiers.remove(qualifier);
            }
            return;
        }
        if (polarity) {
            qualifiers.add(string);
        }
    }

    public void refreshQualifiers(List<String> qualifiers, String trueString, String falseString, Boolean polarity) {
        boolean isFalse = false;
        boolean isTrue = false;
        for (String qualifier : qualifiers) {
            if (qualifier.equals(trueString)) {
                if (isTrue || polarity != Boolean.TRUE) {
                    qualifiers.remove(qualifier);
                }
                isTrue = true;
            }
            if (!qualifier.equals(falseString)) continue;
            if (isTrue || polarity != Boolean.FALSE) {
                qualifiers.remove(qualifier);
            }
            isFalse = true;
        }
        if (polarity == Boolean.TRUE) {
            if (!isTrue) {
                qualifiers.add(trueString);
            }
        } else if (polarity == Boolean.FALSE && !isFalse) {
            qualifiers.add(falseString);
        }
    }

    public <T extends StructuralFeatureCS> T refreshStructuralFeature(Class<T> csClass, EClass csEClass, Property object) {
        StructuralFeatureCS csElement = (StructuralFeatureCS)this.refreshTypedMultiplicityElement(csClass, csEClass, (TypedMultiplicityElement)object);
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "derived", object.isDerived());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "readonly", object.isReadOnly());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "static", object.isStatic());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "transient", object.isTransient());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "unsettable", object.isUnsettable());
        this.refreshQualifiers((List<String>)csElement.getQualifier(), "volatile", object.isVolatile());
        if (object.eIsSet((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT)) {
            csElement.setDefault(object.getDefault());
        } else {
            csElement.eUnset((EStructuralFeature)BaseCSTPackage.Literals.STRUCTURAL_FEATURE_CS__DEFAULT);
        }
        return (T)csElement;
    }

    public <T extends TypedElementCS> T refreshTypedElement(Class<T> csClass, EClass csEClass, TypedElement object) {
        TypedElementCS csElement = (TypedElementCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        Type type = object.getType();
        if (type != null) {
            TypedRefCS typeRef = this.visitReference(TypedRefCS.class, (EObject)type);
            csElement.setOwnedType(typeRef);
        }
        this.refreshList((List)csElement.getOwnedConstraint(), this.visitDeclarations((Class<T>)ConstraintCS.class, (List)object.getOwnedRules(), null));
        return (T)csElement;
    }

    public <T extends TypedElementCS> T refreshTypedMultiplicityElement(Class<T> csClass, EClass csEClass, TypedMultiplicityElement object) {
        T csElement = this.refreshTypedElement(csClass, csEClass, (TypedElement)object);
        if (object.getType() != null) {
            int lower = object.getLower().intValue();
            int upper = object.getUpper().intValue();
            if (lower == 0) {
                if (upper == 1) {
                    csElement.setMultiplicity("?");
                } else if (upper == -1) {
                    csElement.setMultiplicity("*");
                }
            } else if (lower == 1 && upper == -1) {
                csElement.setMultiplicity("+");
            }
            if (csElement.getMultiplicity() == null) {
                csElement.setLower(lower);
                csElement.setUpper(upper);
            }
        }
        EList<String> qualifiers = csElement.getQualifier();
        this.refreshQualifiers((List<String>)qualifiers, "ordered", "!ordered", object.isOrdered() ? Boolean.TRUE : null);
        this.refreshQualifiers((List<String>)qualifiers, "unique", "!unique", object.isUnique() ? null : Boolean.FALSE);
        return csElement;
    }

    public org.eclipse.ocl.examples.pivot.Class setScope(org.eclipse.ocl.examples.pivot.Class object) {
        org.eclipse.ocl.examples.pivot.Class savedScope = this.scope;
        this.scope = object;
        return savedScope;
    }

    public void update(Collection<? extends Resource> csResources) {
        HashMap<Resource, Set<Package>> imports = new HashMap<Resource, Set<Package>>();
        for (Resource resource : csResources) {
            this.importedPackages = new HashSet<Package>();
            Resource pivotResource = this.converter.getPivotResource(resource);
            List<PackageCS> list = this.visitDeclarations((Class)PackageCS.class, (List)pivotResource.getContents(), null);
            this.refreshList((List)resource.getContents(), list);
            imports.put(resource, this.importedPackages);
        }
        for (Resource resource : csResources) {
            this.createImports(resource, (Set)imports.get(resource));
        }
    }

    public <T extends ElementCS> T visitDeclaration(Class<T> csClass, EObject eObject) {
        ElementCS csElement;
        BaseDeclarationVisitor declarationVisitor = this.getDeclarationVisitor(eObject.eClass());
        if (declarationVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported declaration " + eObject.eClass().getName()));
            return null;
        }
        ElementCS castElement = csElement = (ElementCS)((Visitable)eObject).accept((Visitor)declarationVisitor);
        return (T)castElement;
    }

    public <T extends ElementCS, V extends EObject> List<T> visitDeclarations(Class<T> csClass, List<V> eObjects, AbstractConversion.Predicate<V> predicate) {
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            if (predicate != null && !predicate.filter(eObject)) continue;
            T csElement = this.visitDeclaration(csClass, eObject);
            if (csElement != null) {
                csElements.add(csElement);
                continue;
            }
            assert (csElement != null);
        }
        return csElements;
    }

    public <T extends ElementCS> T visitReference(Class<T> csClass, EObject eObject) {
        BaseReferenceVisitor referenceVisitor = this.getReferenceVisitor(eObject.eClass());
        if (referenceVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported reference " + eObject.eClass().getName()));
            return null;
        }
        ElementCS csElement = (ElementCS)((Visitable)eObject).accept((Visitor)referenceVisitor);
        if (csElement == null) {
            return null;
        }
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            logger.error((Object)("CS " + csElement.getClass().getName() + "' element is not a '" + csClass.getName() + "'"));
            return null;
        }
        ElementCS castElement = csElement;
        return (T)castElement;
    }

    public <T extends ElementCS, V extends EObject> List<T> visitReferences(Class<T> csClass, List<? extends V> eObjects, AbstractConversion.Predicate<V> predicate) {
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            if (predicate != null && !predicate.filter(eObject)) continue;
            T csElement = this.visitReference(csClass, eObject);
            if (csElement != null) {
                csElements.add(csElement);
                continue;
            }
            assert (csElement != null);
        }
        return csElements;
    }
}

