/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.AbstractScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentView {
    private static final Logger logger = Logger.getLogger(EnvironmentView.class);
    protected final TypeManager typeManager;
    protected final EStructuralFeature reference;
    protected final String name;
    private final Map<String, Object> contentsByName = new HashMap<String, Object>();
    private Map<EObject, Map<TemplateParameter, ParameterableElement>> templateBindings = null;
    private int contentsSize = 0;
    private List<Filter> matchers = null;
    private Set<Filter> resolvers = null;

    public EnvironmentView(TypeManager typeManager, EStructuralFeature reference, String name) {
        this.typeManager = typeManager;
        this.reference = reference;
        this.name = name;
    }

    public boolean accepts(EClass eClass) {
        return PivotUtil.conformsTo((EStructuralFeature)this.reference, (EClassifier)eClass);
    }

    public int addElement(String elementName, EObject element) {
        return this.addElement(elementName, null, element);
    }

    public int addElement(String elementName, Type forType, EObject element) {
        Object value;
        EClassifier requiredType;
        if (element == null) {
            return 0;
        }
        element = this.typeManager.getPrimaryElement(element);
        if (this.name != null && !this.name.equals(elementName)) {
            return 0;
        }
        if (this.name != null && this.matchers != null) {
            for (Filter filter : this.matchers) {
                if (filter.matches(this, forType, element)) continue;
                return 0;
            }
        }
        if (this.reference != null && !(requiredType = this.reference.getEType()).isInstance((Object)element)) {
            return 0;
        }
        if (this.matchers != null) {
            if (this.resolvers == null) {
                this.resolvers = new HashSet<Filter>();
            }
            this.resolvers.addAll(this.matchers);
        }
        if ((value = this.contentsByName.get(elementName)) != element) {
            if (value == null) {
                this.contentsByName.put(elementName, element);
                ++this.contentsSize;
            } else {
                List<EObject> values;
                if (value instanceof EObject) {
                    values = new ArrayList<EObject>();
                    values.add((EObject)value);
                    this.contentsByName.put(elementName, values);
                } else {
                    List castValue = (List)value;
                    values = castValue;
                }
                if (!values.contains(element)) {
                    values.add(element);
                    ++this.contentsSize;
                }
            }
        }
        return 1;
    }

    public int addElements(Iterable<? extends EObject> elements) {
        return this.addElements(null, elements);
    }

    public int addElements(Type forType, Iterable<? extends EObject> elements) {
        int additions = 0;
        if (elements != null) {
            for (EObject eObject : elements) {
                if (!(eObject instanceof Nameable)) continue;
                Nameable namedElement = (Nameable)eObject;
                additions += this.addElement(namedElement.getName(), forType, (EObject)namedElement);
            }
        }
        return additions;
    }

    public void addElementsOfScope(Element element, ScopeView scopeView) {
        ScopeAdapter scopeAdapter;
        if (element != null && (scopeAdapter = ElementUtil.getScopeAdapter(this.typeManager, element)) != null) {
            scopeAdapter.computeLookup(this, scopeView);
        }
    }

    public void addElementsOfScope(ModelElementCS csElement, ScopeView scopeView) {
        ScopeCSAdapter scopeAdapter = ElementUtil.getScopeCSAdapter(csElement);
        if (scopeAdapter != null) {
            scopeAdapter.computeLookup(this, scopeView);
        }
    }

    public void addFilter(Filter filter) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<Filter>();
        }
        this.matchers.add(filter);
    }

    public void addLibContents(Type libType, ScopeView scopeView) {
        if (libType == null) {
            return;
        }
        this.addElementsOfScope((Element)libType, scopeView);
        if (libType instanceof Class) {
            for (Class superClass : ((Class)libType).getSuperClasses()) {
                this.addLibContents((Type)superClass, scopeView);
            }
        }
    }

    public int addNamedElement(Nameable namedElement) {
        return this.addNamedElement(null, namedElement);
    }

    public int addNamedElement(Type forType, Nameable namedElement) {
        if (namedElement != null) {
            return this.addElement(namedElement.getName(), forType, (EObject)namedElement);
        }
        return 0;
    }

    public int addNamedElements(Iterable<? extends Nameable> namedElements) {
        return this.addNamedElements(null, namedElements);
    }

    public int addNamedElements(Type forType, Iterable<? extends Nameable> namedElements) {
        int additions = 0;
        if (namedElements != null) {
            for (Nameable nameable : namedElements) {
                additions += this.addElement(nameable.getName(), forType, (EObject)nameable);
            }
        }
        return additions;
    }

    public int computeLookups(Type type) {
        ScopeAdapter scopeAdapter = AbstractScopeAdapter.getScopeAdapter(this.typeManager, (Element)type);
        ScopeView innerScopeView = scopeAdapter.getInnerScopeView(this.typeManager, null);
        return this.computeLookups(innerScopeView);
    }

    public int computeLookups(ScopeView aScope) {
        try {
            while (aScope != null && !this.hasFinalResult()) {
                ScopeAdapter aScopeAdapter = aScope.getScopeAdapter();
                if (aScopeAdapter != null) {
                    EObject aTarget = aScopeAdapter.getTarget();
                    aScope = aScopeAdapter.computeLookup(this, aScope);
                    continue;
                }
                break;
            }
        }
        catch (IllegalLibraryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Lookup of '" + this.name + "' failed"), (Throwable)e);
        }
        return this.resolveDuplicates();
    }

    public EObject getContent() {
        if (this.contentsSize == 0) {
            return null;
        }
        if (this.contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return (EObject)value;
        }
        return null;
    }

    public IEObjectDescription getDescription() {
        if (this.contentsSize == 0) {
            return null;
        }
        if (this.contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (this.templateBindings != null && value instanceof Operation) {
                Map<TemplateParameter, ParameterableElement> map = this.templateBindings.get(value);
                value = this.typeManager.getSpecializedOperation((Operation)value, map);
            }
            if (!(value instanceof EObject)) continue;
            return EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)value));
        }
        return null;
    }

    public List<IEObjectDescription> getDescriptions() {
        ArrayList<IEObjectDescription> contents = new ArrayList<IEObjectDescription>();
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object values = entry.getValue();
            if (values instanceof EObject) {
                contents.add(EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)values)));
                continue;
            }
            if (!(values instanceof List)) continue;
            for (Object value : (List)values) {
                contents.add(EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)value)));
            }
        }
        return contents;
    }

    public String getName() {
        return this.name;
    }

    public EStructuralFeature getReference() {
        return this.reference;
    }

    public EClassifier getRequiredType() {
        return this.reference != null ? this.reference.getEType() : null;
    }

    public EObject getResolvedContent() {
        Map<TemplateParameter, ParameterableElement> map;
        EObject eObject = this.getContent();
        if (eObject == null) {
            return null;
        }
        if (this.templateBindings != null && (map = this.templateBindings.get(eObject)) != null && eObject instanceof Operation) {
            eObject = this.typeManager.getSpecializedOperation((Operation)eObject, map);
        }
        return eObject;
    }

    public int getSize() {
        return this.contentsSize;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean hasFinalResult() {
        if (this.contentsSize == 0) {
            return false;
        }
        return this.getName() != null;
    }

    public void removeFilter(Filter filter) {
        if (this.matchers != null) {
            this.matchers.remove(filter);
        }
    }

    public int resolveDuplicates() {
        if (this.contentsSize > 1 && this.resolvers != null && this.getName() != null) {
            int newSize = 0;
            for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    for (Filter filter : this.resolvers) {
                        int i = 0;
                        while (i < values.size() - 1) {
                            EObject reference = (EObject)values.get(i);
                            Map<TemplateParameter, ParameterableElement> referenceBindings = this.templateBindings != null ? this.templateBindings.get(reference) : null;
                            int j = i + 1;
                            while (j < values.size()) {
                                Map<TemplateParameter, ParameterableElement> candidateBindings;
                                EObject candidate = (EObject)values.get(j);
                                int verdict = filter.compareMatches(reference, referenceBindings, candidate, candidateBindings = this.templateBindings != null ? this.templateBindings.get(candidate) : null);
                                if (verdict == 0) {
                                    ++j;
                                    continue;
                                }
                                if (verdict < 0) {
                                    values.remove(i);
                                    reference = null;
                                    break;
                                }
                                values.remove(j);
                                candidate = null;
                            }
                            if (reference == null) continue;
                            ++i;
                        }
                    }
                    newSize += values.size();
                    continue;
                }
                ++newSize;
            }
            this.contentsSize = newSize;
        }
        return this.getSize();
    }

    public void setBindings(EObject eObject, Map<TemplateParameter, ParameterableElement> bindings) {
        if (this.templateBindings == null) {
            this.templateBindings = new HashMap<EObject, Map<TemplateParameter, ParameterableElement>>();
        }
        this.templateBindings.put(eObject, bindings);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.reference != null) {
            s.append(this.reference.getName());
            s.append(" : ");
            s.append(this.reference.getEType().getName());
        }
        s.append(" \"");
        if (this.name != null) {
            s.append(this.name);
        }
        s.append("\" {");
        String prefix = "";
        for (String contentName : this.contentsByName.keySet()) {
            s.append(prefix);
            s.append(contentName);
            Object content = this.contentsByName.get(contentName);
            if (content instanceof List) {
                s.append("*");
                s.append(((List)content).size());
            }
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter {
        public int compareMatches(EObject var1, Map<TemplateParameter, ParameterableElement> var2, EObject var3, Map<TemplateParameter, ParameterableElement> var4);

        public boolean matches(EnvironmentView var1, Type var2, EObject var3);
    }
}

