/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.utilities.Abstract2Moniker;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2Moniker
extends Abstract2Moniker {
    private static final Logger logger = Logger.getLogger(CS2Moniker.class);
    private static Map<EPackage, Factory> csFactoryMap = new HashMap<EPackage, Factory>();
    private List<TemplateParameterCS> csTemplateParameters = null;
    private List<TemplateParameterCS> csEmittedParameters = null;
    private Map<EPackage, BaseCSVisitor<?, ?>> csVisitorMap = new HashMap();

    public static void addFactory(EPackage ePackage, Factory factory) {
        csFactoryMap.put(ePackage, factory);
    }

    public static String toString(MonikeredElementCS csElement) {
        CS2Moniker moniker = new CS2Moniker(csElement);
        moniker.appendElementCS(csElement);
        String string = moniker.toString();
        if (TRACE_MONIKERS.isActive()) {
            TRACE_MONIKERS.println(String.valueOf(csElement.eClass().getName()) + " ==> " + string);
        }
        assert (!"".equals(string));
        return string;
    }

    public CS2Moniker(MonikeredElementCS target) {
        super((EObject)target);
    }

    public void appendConstraintCSDisambiguator(ConstraintCS csConstraint) {
        String csConstraintStereotype = csConstraint.getStereotype();
        EObject csContainer = csConstraint.eContainer();
        if (csContainer == null) {
            return;
        }
        Object container = csContainer.eGet(csConstraint.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            String name2 = csConstraint.getName();
            for (Object content : (List)container) {
                ConstraintCS sibling;
                String siblingStereotype;
                if (content == csConstraint) break;
                if (!(content instanceof ConstraintCS) || (siblingStereotype = (sibling = (ConstraintCS)content).getStereotype()) == null || !siblingStereotype.equals(csConstraintStereotype)) continue;
                String name1 = sibling.getName();
                if (name1 != name2 && (name1 == null || !name1.equals(name2))) break;
                ++index;
            }
            this.append("~");
            if (name2 != null) {
                this.append(name2);
            }
            if (index != 0) {
                this.append("~");
                this.append(index);
            }
        }
    }

    public void appendElementCS(VisitableCS csVisitable) {
        assert (csVisitable != null);
        int oldSize = this.length();
        EPackage ePackage = csVisitable.eClass().getEPackage();
        BaseCSVisitor<?, ?> monikerVisitor = this.getVisitor(ePackage);
        if (monikerVisitor != null) {
            csVisitable.accept(monikerVisitor);
        }
        assert (this.length() > oldSize);
    }

    protected void appendMultiplicityCS(TypedElementCS csTypedElement) {
        int lower = ElementUtil.getLower(csTypedElement);
        int upper = ElementUtil.getUpper(csTypedElement);
        if (upper != 1) {
            this.append("[");
            this.append(lower);
            this.append(ElementUtil.isOrdered(csTypedElement) ? "S" : "s");
            this.append(ElementUtil.isUnique(csTypedElement) ? "U" : "u");
            this.append(upper);
            this.append("]");
        }
    }

    public void appendNameCS(NamedElementCS csNamedElement) {
        this.append(csNamedElement != null ? csNamedElement.getName() : null);
    }

    public void appendParametersCS(List<ParameterCS> csIterators, List<ParameterCS> csAccumulators, List<ParameterCS> csParameters) {
        this.append("(");
        String prefix = "";
        if (csIterators != null) {
            for (ParameterCS csIterator : csIterators) {
                this.append(prefix);
                this.appendElementCS(csIterator.getOwnedType());
                this.appendMultiplicityCS(csIterator);
                prefix = ",";
            }
            prefix = "|";
        }
        if (csAccumulators != null && csAccumulators.size() > 0) {
            prefix = ";";
            for (ParameterCS csAccumulator : csAccumulators) {
                this.append(prefix);
                this.appendElementCS(csAccumulator.getOwnedType());
                this.appendMultiplicityCS(csAccumulator);
                prefix = ",";
            }
            prefix = "|";
        }
        for (ParameterCS csParameter : csParameters) {
            this.append(prefix);
            TypedRefCS ownedType = csParameter.getOwnedType();
            if (ownedType != null) {
                this.appendElementCS(ownedType);
                this.appendMultiplicityCS(csParameter);
            }
            prefix = ",";
        }
        this.append(")");
    }

    public void appendParentCS(ElementCS csElement, String parentSeparator) {
        EObject parent = csElement != null ? csElement.eContainer() : null;
        this.appendParentElementCS(parent, parentSeparator);
    }

    public void appendParentElementCS(EObject parent, String parentSeparator) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (parent instanceof MonikeredElementCS && ((MonikeredElementCS)parent).hasMoniker()) {
            TemplateSignatureCS csTemplateSignature;
            this.append(((MonikeredElementCS)parent).getMoniker());
            if (parent instanceof TemplateableElementCS && (csTemplateSignature = ((TemplateableElementCS)parent).getOwnedTemplateSignature()) != null) {
                for (TemplateParameterCS csTemplateParameter : csTemplateSignature.getOwnedTemplateParameter()) {
                    this.emittedTemplateParameterCS(csTemplateParameter);
                }
            }
        } else if (parent instanceof VisitableCS) {
            this.appendElementCS((VisitableCS)parent);
        }
        this.append(parentSeparator);
    }

    public void appendRoleCS(ElementCS object) {
        EReference eFeature = object.eContainmentFeature();
        this.appendRoleCS((EStructuralFeature)eFeature);
        if (eFeature.isMany()) {
            int index = ((List)object.eContainer().eGet(object.eContainingFeature())).indexOf(object);
            this.append(index);
        }
    }

    public void appendRoleCS(EStructuralFeature eFeature) {
        String roleName = (String)roleNames.get(eFeature);
        if (roleName == null) {
            roleName = eFeature.getName();
        }
        this.append(roleName);
    }

    public void appendTemplateBindingsCS(TypedTypeRefCS typeRef) {
        TemplateBindingCS templateBinding = typeRef.getOwnedTemplateBinding();
        if (templateBinding != null) {
            this.append("[");
            EList<TemplateParameterSubstitutionCS> templateParameterSubstitutions = templateBinding.getOwnedParameterSubstitution();
            if (!templateParameterSubstitutions.isEmpty()) {
                String prefix = "";
                for (TemplateParameterSubstitutionCS templateParameterSubstitution : templateParameterSubstitutions) {
                    this.append(prefix);
                    this.appendElementCS(templateParameterSubstitution.getOwnedActualParameter());
                    prefix = ",";
                }
            }
            this.append("]");
        }
    }

    public void appendTemplateParametersCS(TemplateableElementCS csTemplateableElement) {
        EList<TemplateParameterCS> csTemplateParameters;
        TemplateSignatureCS csTemplateSignature = csTemplateableElement.getOwnedTemplateSignature();
        if (csTemplateSignature != null && !(csTemplateParameters = csTemplateSignature.getOwnedTemplateParameter()).isEmpty()) {
            this.append("{");
            String prefix = "";
            for (TemplateParameterCS csTemplateParameter : csTemplateParameters) {
                this.append(prefix);
                this.emittedTemplateParameterCS(csTemplateParameter);
                this.appendNameCS(csTemplateParameter);
                prefix = ",";
            }
            this.append("}");
        }
    }

    private void computeTemplateParametersCS(EObject csElement) {
        TemplateSignatureCS ownedTemplateSignature;
        EObject parent;
        if (this.csTemplateParameters != null) {
            return;
        }
        EObject eObject = parent = csElement != null ? csElement.eContainer() : null;
        if (parent != null) {
            this.computeTemplateParametersCS(parent);
        } else {
            this.csTemplateParameters = Collections.emptyList();
        }
        if (csElement instanceof TemplateableElementCS && (ownedTemplateSignature = ((TemplateableElementCS)csElement).getOwnedTemplateSignature()) != null) {
            if (this.csTemplateParameters.isEmpty()) {
                this.csTemplateParameters = new ArrayList<TemplateParameterCS>();
            }
            this.csTemplateParameters.addAll((Collection<TemplateParameterCS>)ownedTemplateSignature.getOwnedTemplateParameter());
        }
    }

    public BaseCSVisitor<?, ?> getVisitor(EPackage ePackage) {
        BaseCSVisitor<?, ?> monikerVisitor = this.csVisitorMap.get(ePackage);
        if (monikerVisitor == null && !this.csVisitorMap.containsKey(ePackage)) {
            Factory factory = csFactoryMap.get(ePackage);
            if (factory != null) {
                monikerVisitor = factory.create(this);
                if (monikerVisitor == null) {
                    logger.error((Object)("No Moniker Visitor created for " + ePackage.getName()));
                }
            } else {
                logger.error((Object)("No Moniker Visitor Factory registered for " + ePackage.getName()));
            }
            this.csVisitorMap.put(ePackage, monikerVisitor);
        }
        return monikerVisitor;
    }

    protected void emittedTemplateParameterCS(TemplateParameterCS csTemplateParameter) {
        if (this.csEmittedParameters == null) {
            this.csEmittedParameters = new ArrayList<TemplateParameterCS>();
        }
        this.csEmittedParameters.add(csTemplateParameter);
    }

    public TemplateParameterCS getTemplateParameterCS(String text) {
        for (TemplateParameterCS templateParameter : this.getTemplateParametersCS()) {
            if (!templateParameter.getName().equals(text)) continue;
            return templateParameter;
        }
        return null;
    }

    public List<TemplateParameterCS> getTemplateParametersCS() {
        if (this.csTemplateParameters == null) {
            this.computeTemplateParametersCS(this.target);
        }
        return this.csTemplateParameters;
    }

    public boolean hasEmittedCS(TemplateParameterCS csTemplateParameter) {
        if (this.csEmittedParameters != null && this.csEmittedParameters.contains(csTemplateParameter)) {
            return true;
        }
        Element pivot = csTemplateParameter.getPivot();
        return pivot instanceof TemplateParameter && this.hasEmitted((TemplateParameter)pivot);
    }

    public boolean isTemplateParameterCS(TemplateParameterCS object) {
        return this.getTemplateParametersCS().contains(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public BaseCSVisitor<?, ?> create(CS2Moniker var1);
    }
}

