/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.pivot.AbstractBasicEnvironment;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.BasicEnvironment;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ProblemAware;
import org.eclipse.ocl.examples.pivot.ProblemHandler;
import org.eclipse.ocl.examples.pivot.QueryBase;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.SyntaxException;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLUtil {
    private static final Map<Environment, Reference<BasicEnvironment>> environments = new WeakHashMap<Environment, Reference<BasicEnvironment>>();

    private OCLUtil() {
    }

    public static <T> T getAdapter(Environment env, Class<T> adapterType) {
        Object result = env instanceof Adaptable ? ((Adaptable)((Object)env)).getAdapter(adapterType) : (adapterType.isInstance(env) ? env : null);
        if (result == null && adapterType == BasicEnvironment.class) {
            result = OCLUtil.getBasicEnvironment(env);
        }
        return result;
    }

    private static BasicEnvironment getBasicEnvironment(final Environment env) {
        BasicEnvironment result = null;
        Reference<BasicEnvironment> ref = environments.get(env);
        if (ref != null) {
            result = ref.get();
        }
        if (result == null) {
            result = new AbstractBasicEnvironment(null){

                @Override
                public <T> T getAdapter(Class<T> adapterType) {
                    if (adapterType == Environment.class) {
                        return (T)env;
                    }
                    return super.getAdapter(adapterType);
                }
            };
            environments.put(env, new WeakReference<BasicEnvironment>(result));
        }
        return result;
    }

    public static <T> T getAdapter(EnvironmentFactory factory, Class<T> adapterType) {
        Object result = factory instanceof Adaptable ? ((Adaptable)((Object)factory)).getAdapter(adapterType) : (adapterType.isInstance(factory) ? factory : null);
        return result;
    }

    public static <T> T getAdapter(EvaluationEnvironment env, Class<T> adapterType) {
        Object result = env instanceof Adaptable ? ((Adaptable)((Object)env)).getAdapter(adapterType) : (adapterType.isInstance(env) ? env : null);
        return result;
    }

    public static Diagnostic checkForErrors(Environment env) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    public static Diagnostic checkForErrors(ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    public static Diagnostic checkForErrorsOrWarnings(ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    public static Environment getValidationEnvironment(Object target, Map<Object, Object> context) {
        Environment result = (Environment)context.get(Environment.class);
        if (result == null && (result = Environment.Registry.INSTANCE.getEnvironmentFor(target)) != null) {
            context.put(Environment.class, result);
        }
        return result;
    }

    public static Diagnostic getEvaluationProblems(QueryBase query) {
        if (query instanceof ProblemAware) {
            ProblemAware problemAware = (ProblemAware)((Object)query);
            return problemAware.getProblems();
        }
        return null;
    }
}

