/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.ocl.examples.pivot.EvaluationException;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.pivot.delegate.SettingBehavior;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    protected final OCLDelegateDomain delegateDomain;
    private Property property;
    private ExpressionInOcl specification;

    public OCLSettingDelegate(OCLDelegateDomain delegateDomain, EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        OCL ocl = this.delegateDomain.getOCL();
        TypeManager typeManager = ocl.getEnvironment().getTypeManager();
        if (this.specification == null) {
            if (this.property == null) {
                this.property = this.delegateDomain.getPivot(Property.class, (EObject)this.eStructuralFeature);
            }
            this.specification = SettingBehavior.INSTANCE.getExpressionInOcl(typeManager, this.property);
        }
        OCL.Query query = ocl.createQuery(this.specification);
        try {
            Value result = query.evaluate(owner);
            ValueFactory valueFactory = typeManager.getValueFactory();
            return valueFactory.getEcoreValueOf(result);
        }
        catch (EvaluationException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.property);
            throw new OCLDelegateException(message);
        }
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        if (this.property != null) {
            return "<" + this.delegateDomain.getURI() + ":setting> " + this.property;
        }
        String name = String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
        return "<" + this.delegateDomain.getURI() + ":setting> " + name;
    }
}

