/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;

public class EObjectOperation
implements CallableImplementation {
    protected final EOperation eFeature;
    protected ValueSpecification specification;

    public EObjectOperation(EOperation eFeature, ValueSpecification specification) {
        this.eFeature = eFeature;
        this.specification = specification;
    }

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceValue, CallExp callExp) {
        Operation operation;
        if (!(this.specification instanceof ExpressionInOcl) && this.specification instanceof OpaqueExpression) {
            operation = PivotUtil.getReferredOperation(callExp);
            String string = PivotUtil.getBody((OpaqueExpression)this.specification);
            try {
                TypeManager typeManager = evaluationVisitor.getTypeManager();
                URI uri = typeManager.getResourceIdentifier(operation, null);
                this.specification = PivotUtil.resolveSpecification(typeManager, uri, operation, string);
            }
            catch (ParserException e) {
                return evaluationVisitor.throwInvalidEvaluation(e, callExp, sourceValue, "parse failure", new Object[0]);
            }
        }
        if (this.specification instanceof ExpressionInOcl) {
            ExpressionInOcl expressionInOcl = (ExpressionInOcl)this.specification;
            EvaluationVisitor nestedEvaluationVisitor = evaluationVisitor.createNestedVisitor();
            EvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluationVisitor.getEvaluationEnvironment();
            nestedEvaluationEnvironment.add(expressionInOcl.getContextVariable(), sourceValue);
            OperationCallExp operationCall = (OperationCallExp)callExp;
            EList<OclExpression> arguments = operationCall.getArguments();
            EList<Variable> parameterVariables = expressionInOcl.getParameterVariables();
            int iMax = Math.min(parameterVariables.size(), arguments.size());
            int i = 0;
            while (i < iMax) {
                Value argumentValue = (Value)((OclExpression)arguments.get(i)).accept(evaluationVisitor);
                nestedEvaluationEnvironment.add(((Variable)parameterVariables.get(i)).getRepresentedParameter(), argumentValue);
                ++i;
            }
            return (Value)expressionInOcl.getBodyExpression().accept(nestedEvaluationVisitor);
        }
        operation = PivotUtil.getReferredOperation(callExp);
        return evaluationVisitor.throwInvalidEvaluation(null, callExp, sourceValue, "No specification for '" + operation + "'", new Object[0]);
    }

    public Diagnostic validate(TypeManager typeManager, CallExp callExp) {
        return null;
    }
}

