/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreTypeRefVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    public Pivot2EcoreTypeRefVisitor(Pivot2Ecore context) {
        super(context);
    }

    public EGenericType resolveEGenericType(Type type) {
        EObject eType = (EObject)this.safeVisit(type);
        if (eType instanceof EGenericType) {
            return (EGenericType)eType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)eType);
        return eGenericType;
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EClassifier visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitInvalidType(InvalidType object) {
        return EcorePackage.Literals.EOBJECT;
    }

    @Override
    public EClassifier visitPrimitiveType(PrimitiveType pivotType) {
        if (pivotType == ((Pivot2Ecore)((Object)this.context)).getTypeManager().getBooleanType()) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (pivotType == ((Pivot2Ecore)((Object)this.context)).getTypeManager().getIntegerType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        if (pivotType == ((Pivot2Ecore)((Object)this.context)).getTypeManager().getRealType()) {
            return EcorePackage.Literals.EBIG_DECIMAL;
        }
        if (pivotType == ((Pivot2Ecore)((Object)this.context)).getTypeManager().getStringType()) {
            return EcorePackage.Literals.ESTRING;
        }
        if (pivotType == ((Pivot2Ecore)((Object)this.context)).getTypeManager().getUnlimitedNaturalType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        throw new IllegalArgumentException("Unsupported primitive type '" + pivotType + "' in Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitTemplateBinding(TemplateBinding object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameterSubstitution(TemplateParameterSubstitution pivotTemplateParameterSubstitution) {
        EObject actualType = (EObject)this.safeVisit(pivotTemplateParameterSubstitution.getActual());
        if (actualType instanceof EGenericType) {
            return actualType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)actualType);
        return eGenericType;
    }

    @Override
    public EObject visitType(Type pivotType) {
        TemplateParameter templateParameter = pivotType.getTemplateParameter();
        if (templateParameter != null) {
            ETypeParameter eTypeParameter = ((Pivot2Ecore)((Object)this.context)).getCreated(ETypeParameter.class, templateParameter);
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter(eTypeParameter);
            return eGenericType;
        }
        EList templateBindings = pivotType.getTemplateBindings();
        if (templateBindings.size() == 0) {
            EClassifier eClassifier = ((Pivot2Ecore)((Object)this.context)).getCreated(EClassifier.class, pivotType);
            if (eClassifier != null) {
                return eClassifier;
            }
            return pivotType.getETarget();
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject rawType = (EObject)this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)rawType);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)templateBindings.get(0)).getParameterSubstitutions());
        return eGenericType;
    }

    @Override
    public EObject visitVoidType(VoidType object) {
        return EcorePackage.Literals.EOBJECT;
    }
}

