/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.library.AbstractCallableImplementation;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class ExplicitNavigationProperty
extends AbstractCallableImplementation {
    public static final ExplicitNavigationProperty INSTANCE = new ExplicitNavigationProperty();

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceValue, CallExp callExp) {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        TypeManager typeManager = evaluationVisitor.getTypeManager();
        PropertyCallExp propertyCall = (PropertyCallExp)callExp;
        Property property = propertyCall.getReferredProperty();
        Object object = sourceValue.asObject();
        if (object instanceof ClassifierType && !(property.getClass_() instanceof ClassifierType)) {
            object = ((ClassifierType)object).getInstanceType();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            EStructuralFeature eFeature = eClass.getEStructuralFeature(property.getName());
            Object eValue = eObject.eGet(eFeature);
            if (eValue instanceof Enumerator) {
                Enumerator eEnumerator = (Enumerator)eValue;
                EClassifier eEnum = eFeature.getEType();
                Enumeration pivotEnum = typeManager.getPivotOfEcore(Enumeration.class, (EObject)eEnum);
                EnumerationLiteral pivotEnumLiteral = PivotUtil.getNamedElement(pivotEnum.getOwnedLiterals(), eEnumerator.getName());
                return valueFactory.createElementValue(pivotEnumLiteral);
            }
            return valueFactory.valueOf(eValue, (ETypedElement)eFeature);
        }
        return evaluationVisitor.throwInvalidEvaluation(null, callExp, sourceValue, EvaluatorMessages.MissingSourceValue, new Object[0]);
    }
}

