/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.math.BigInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintNameVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintTypeVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class PrettyPrintExprVisitor
extends PrettyPrintNameVisitor {
    private Precedence currentPrecedence = null;

    public static String prettyPrint(Element element) {
        PrettyPrintExprVisitor visitor = new PrettyPrintExprVisitor(PrettyPrintExprVisitor.getNamespace(element.eContainer()));
        try {
            visitor.safeVisit(element);
            return visitor.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public static String prettyPrint(Visitable element, Namespace scope) {
        PrettyPrintExprVisitor visitor = new PrettyPrintExprVisitor(scope);
        try {
            visitor.safeVisit(element);
            return visitor.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public PrettyPrintExprVisitor(Namespace scope) {
        super(scope);
    }

    protected void appendSourceNavigation(CallExp object) {
        OclExpression source = object.getSource();
        if (!(source == null || source instanceof VariableExp && ((VariableExp)source).isImplicit())) {
            if (source instanceof OperationCallExp && ((OperationCallExp)source).getReferredOperation().getPrecedence() != null) {
                this.delegate.append("(");
                this.precedenceVisit(source, null);
                this.delegate.append(")");
            } else {
                this.safeVisit(source);
            }
            if (source.getType() instanceof CollectionType) {
                this.delegate.append("->");
            } else {
                this.delegate.append(".");
            }
        }
    }

    protected void precedenceVisit(OclExpression expression, Precedence newPrecedence) {
        Precedence savedPrecedcence = this.currentPrecedence;
        try {
            this.currentPrecedence = newPrecedence;
            this.safeVisit(expression);
        }
        finally {
            this.currentPrecedence = savedPrecedcence;
        }
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp object) {
        this.delegate.append(Boolean.toString(object.isBooleanSymbol()));
        return null;
    }

    public Object visitCollectionItem(CollectionItem object) {
        this.safeVisit(object.getItem());
        return null;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp object) {
        this.delegate.appendName(object.getType(), PrettyPrintTypeVisitor.reservedNames);
        this.delegate.append("{");
        String prefix = "";
        for (CollectionLiteralPart part : object.getParts()) {
            this.delegate.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.delegate.append("}");
        return null;
    }

    public Object visitCollectionRange(CollectionRange object) {
        this.safeVisit(object.getFirst());
        this.delegate.append("..");
        this.safeVisit(object.getLast());
        return null;
    }

    public Object visitConstraint(Constraint object) {
        this.delegate.append(object.getStereotype());
        if (object.getName() != null) {
            this.delegate.append(" ");
            this.delegate.appendName(object);
        }
        this.delegate.append(": ");
        this.safeVisit(object.getSpecification());
        return null;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp object) {
        this.safeVisit(object.getReferredEnumLiteral());
        return null;
    }

    public Object visitExpressionInOcl(ExpressionInOcl object) {
        this.safeVisit(object.getBodyExpression());
        return null;
    }

    public Object visitIfExp(IfExp object) {
        this.delegate.append("if ");
        this.safeVisit(object.getCondition());
        this.delegate.append(" then ");
        this.safeVisit(object.getThenExpression());
        this.delegate.append(" else ");
        this.safeVisit(object.getElseExpression());
        this.delegate.append(" endif");
        return null;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp object) {
        this.delegate.append(object.getIntegerSymbol());
        return null;
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp object) {
        this.delegate.append("invalid");
        return null;
    }

    public Object visitIterateExp(IterateExp object) {
        EList<Variable> iterators = object.getIterators();
        Iteration referredOperation = object.getReferredIteration();
        this.appendSourceNavigation(object);
        this.delegate.appendName(referredOperation);
        this.delegate.append("(");
        if (iterators.size() > 0) {
            boolean hasExplicitIterator = false;
            String prefix = "";
            for (Variable iterator : iterators) {
                if (iterator.isImplicit()) continue;
                this.delegate.append(prefix);
                this.safeVisit(iterator);
                prefix = ", ";
                hasExplicitIterator = true;
            }
            if (hasExplicitIterator) {
                this.delegate.append(" ; ");
            }
            this.safeVisit(object.getResult());
            this.delegate.append(" | ");
        }
        this.safeVisit(object.getBody());
        this.delegate.append(")");
        return null;
    }

    public Object visitIteratorExp(IteratorExp object) {
        EList<Variable> iterators = object.getIterators();
        Iteration referredOperation = object.getReferredIteration();
        this.appendSourceNavigation(object);
        this.delegate.appendName(referredOperation);
        this.delegate.append("(");
        if (iterators.size() > 0) {
            boolean hasExplicitIterator = false;
            String prefix = "";
            for (Variable iterator : iterators) {
                if (iterator.isImplicit()) continue;
                this.delegate.append(prefix);
                this.safeVisit(iterator);
                prefix = ", ";
                hasExplicitIterator = true;
            }
            if (hasExplicitIterator) {
                this.delegate.append(" | ");
            }
        }
        this.safeVisit(object.getBody());
        this.delegate.append(")");
        return null;
    }

    public Object visitLetExp(LetExp object) {
        this.delegate.append("let ");
        this.safeVisit(object.getVariable());
        this.delegate.append(" in ");
        this.safeVisit(object.getIn());
        return null;
    }

    public Object visitNullLiteralExp(NullLiteralExp object) {
        this.delegate.append("null");
        return null;
    }

    public Object visitOclExpression(OclExpression object) {
        this.delegate.append("<");
        this.delegate.append(object.eClass().getName());
        this.delegate.append(">");
        return null;
    }

    public Object visitOperationCallExp(OperationCallExp object) {
        Precedence precedence;
        OclExpression source = object.getSource();
        EList<OclExpression> arguments = object.getArguments();
        Operation referredOperation = object.getReferredOperation();
        Precedence precedence2 = precedence = referredOperation != null ? referredOperation.getPrecedence() : null;
        if (precedence == null) {
            this.appendSourceNavigation(object);
            this.delegate.appendName(referredOperation);
            this.delegate.append("(");
            String prefix = "";
            for (OclExpression argument : arguments) {
                this.delegate.append(prefix);
                this.precedenceVisit(argument, null);
                prefix = ", ";
            }
            this.delegate.append(")");
        } else {
            boolean lowerPrecedence;
            boolean bl = lowerPrecedence = this.currentPrecedence != null && precedence.getOrder().compareTo(this.currentPrecedence.getOrder()) > 0;
            if (lowerPrecedence) {
                this.delegate.append("(");
            }
            if (arguments.size() == 0) {
                this.delegate.appendName(referredOperation, null);
                this.delegate.append(" ");
                this.precedenceVisit(source, precedence);
            } else {
                this.precedenceVisit(source, precedence);
                this.delegate.append(" ");
                this.delegate.appendName(referredOperation, null);
                this.delegate.append(" ");
                this.precedenceVisit((OclExpression)arguments.get(0), precedence);
            }
            if (lowerPrecedence) {
                this.delegate.append(")");
            }
        }
        return null;
    }

    public Object visitParameter(Parameter object) {
        this.delegate.appendName(object);
        Type type = object.getType();
        if (type != null) {
            this.delegate.append(" : ");
            this.delegate.safeVisit(type);
        }
        return null;
    }

    public Object visitPropertyCallExp(PropertyCallExp object) {
        this.appendSourceNavigation(object);
        this.delegate.appendName(object.getReferredProperty());
        return null;
    }

    public Object visitRealLiteralExp(RealLiteralExp object) {
        this.delegate.append(object.getRealSymbol());
        return null;
    }

    public Object visitStringLiteralExp(StringLiteralExp object) {
        this.delegate.append("'");
        this.delegate.append(PivotUtil.convertToOCLString(object.getStringSymbol()));
        this.delegate.append("'");
        return null;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp object) {
        this.delegate.append("Tuple");
        this.delegate.append("{");
        String prefix = "";
        for (TupleLiteralPart part : object.getParts()) {
            this.delegate.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.delegate.append("}");
        return null;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart object) {
        this.delegate.appendName(object);
        this.delegate.append(" = ");
        this.safeVisit(object.getInitExpression());
        return null;
    }

    public Object visitTypeExp(TypeExp object) {
        this.delegate.safeVisit(object.getReferredType());
        return null;
    }

    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp object) {
        BigInteger symbol = object.getUnlimitedNaturalSymbol();
        if (symbol.signum() < 0) {
            this.delegate.append("*");
        } else {
            this.delegate.append(symbol);
        }
        return null;
    }

    public Object visitVariable(Variable object) {
        OclExpression initExpression;
        this.delegate.appendName(object);
        Type type = object.getType();
        if (type != null) {
            this.delegate.append(" : ");
            this.delegate.safeVisit(type);
        }
        if ((initExpression = object.getInitExpression()) != null) {
            this.delegate.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    public Object visitVariableExp(VariableExp object) {
        VariableDeclaration referredVariable = object.getReferredVariable();
        if (referredVariable != null && "self".equals(referredVariable.getName())) {
            this.delegate.appendName(referredVariable, null);
        } else {
            this.delegate.appendName(referredVariable);
        }
        return null;
    }

    public static class Printer {
        public String prettyPrint(Visitable element, Namespace scope) {
            PrettyPrintExprVisitor visitor = new PrettyPrintExprVisitor(scope);
            try {
                visitor.safeVisit(element);
                return visitor.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
            }
        }
    }
}

