/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintTypeVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrintNameVisitor
extends AbstractExtendingVisitor<Object, Namespace> {
    protected final PrettyPrintTypeVisitor delegate;
    protected final TypeManager typeManager;

    public static Namespace getNamespace(EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Class) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Package) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static String prettyPrint(Visitable element, Namespace scope) {
        PrettyPrintNameVisitor visitor = new PrettyPrintNameVisitor(scope);
        try {
            visitor.safeVisit(element);
            return visitor.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public PrettyPrintNameVisitor(Namespace scope) {
        super(scope);
        this.delegate = new PrettyPrintTypeVisitor(scope);
        Resource resource = scope != null ? scope.eResource() : null;
        ResourceSet resourceSet = resource != null ? resource.getResourceSet() : null;
        this.typeManager = TypeManager.getAdapter(resourceSet);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Object visitClass(Class object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            return owningTemplateParameter.accept(this);
        }
        return super.visitClass(object);
    }

    @Override
    public String visitNamedElement(NamedElement object) {
        this.delegate.appendParent(null, object, "::");
        this.delegate.appendName(object, PrettyPrintTypeVisitor.reservedNames);
        return null;
    }

    @Override
    public Object visitOperation(Operation object) {
        this.delegate.appendParent(null, object, "::");
        this.delegate.appendName(object);
        this.delegate.appendTemplateParameters(object);
        this.delegate.appendTemplateBindings(object);
        this.delegate.appendParameters(object);
        Type type = object.getType();
        if (type != null) {
            this.delegate.append(" : ");
            this.delegate.appendTypedMultiplicity(object);
        }
        return null;
    }

    @Override
    public Object visitTemplateParameter(TemplateParameter object) {
        this.delegate.appendParent(null, object.getSignature(), "::");
        this.delegate.appendName((NamedElement)((Object)object.getParameteredElement()));
        return null;
    }

    @Override
    public Object visitTupleType(TupleType object) {
        this.delegate.appendParent(object.eContainer(), object, "::");
        this.delegate.appendName(object);
        this.delegate.append("(");
        EList<Property> tupleParts = object.getOwnedAttributes();
        if (!tupleParts.isEmpty()) {
            String prefix = "";
            for (Property tuplePart : tupleParts) {
                this.delegate.append(prefix);
                this.delegate.appendElement(tuplePart);
                prefix = ",";
            }
        }
        this.delegate.append(")");
        return null;
    }

    @Override
    public Object visitType(Type object) {
        this.delegate.appendParent(null, object, "::");
        this.delegate.appendName(object);
        this.delegate.appendTemplateParameters(object);
        this.delegate.appendTemplateBindings(object);
        return null;
    }

    @Override
    public Object visitTypedElement(TypedElement object) {
        this.delegate.appendParent(null, object, "::");
        this.delegate.appendName(object);
        this.delegate.append(" : ");
        this.delegate.appendElement(object.getType());
        return null;
    }

    @Override
    public Object visitTypedMultiplicityElement(TypedMultiplicityElement object) {
        this.delegate.appendParent(null, object, "::");
        this.delegate.appendName(object);
        this.delegate.append(" : ");
        this.delegate.appendTypedMultiplicity(object);
        return null;
    }

    @Override
    public String visiting(Visitable visitable) {
        this.delegate.visiting(visitable);
        return null;
    }

    public static class Printer {
        public String prettyPrint(Visitable element, Namespace scope) {
            PrettyPrintNameVisitor visitor = new PrettyPrintNameVisitor(scope);
            try {
                visitor.safeVisit(element);
                return visitor.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
            }
        }
    }
}

