/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

public class PivotEnvironmentFactory
extends AbstractEnvironmentFactory {
    private static PivotEnvironmentFactory globalRegistryInstance = null;
    protected final TypeManager typeManager;
    private final EPackage.Registry registry;

    public static PivotEnvironmentFactory getGlobalRegistryInstance() {
        if (globalRegistryInstance == null) {
            globalRegistryInstance = new PivotEnvironmentFactory();
        }
        return globalRegistryInstance;
    }

    public PivotEnvironmentFactory() {
        this(EPackage.Registry.INSTANCE, null);
    }

    public PivotEnvironmentFactory(EPackage.Registry reg, TypeManager typeManager) {
        this.registry = reg;
        this.typeManager = typeManager != null ? typeManager : new TypeManager();
    }

    public PivotEnvironment createEnvironment() {
        PivotEnvironment result = new PivotEnvironment(this, null);
        return result;
    }

    public PivotEnvironment loadEnvironment(Resource resource) {
        PivotEnvironment result = new PivotEnvironment(this, resource);
        return result;
    }

    public final EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    public PivotEnvironment createEnvironment(Environment parent) {
        if (!(parent instanceof PivotEnvironment)) {
            throw new IllegalArgumentException("Parent environment must be a Pivot environment: " + parent);
        }
        PivotEnvironment result = new PivotEnvironment((PivotEnvironment)parent);
        return result;
    }

    public PivotEvaluationEnvironment createEvaluationEnvironment() {
        return new PivotEvaluationEnvironment(this.typeManager);
    }

    public PivotEvaluationEnvironment createEvaluationEnvironment(EvaluationEnvironment parent) {
        return new PivotEvaluationEnvironment(parent);
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    protected Type getClassifier(Object context) {
        return null;
    }
}

