/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.model.OclMetaModel;
import org.eclipse.ocl.examples.pivot.utilities.CompleteElementIterable;
import org.eclipse.ocl.examples.pivot.utilities.PivotStandardLibrary;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagedAdapter;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeCaches
extends PivotStandardLibrary {
    private static final Logger logger = Logger.getLogger(TypeCaches.class);
    private Map<String, OrphanNode> moniker2orphan = new HashMap<String, OrphanNode>();
    private Map<String, String> uri2package = new HashMap<String, String>();
    private Map<String, Iterable<Package>> package2packages = new HashMap<String, Iterable<Package>>();
    private Map<String, Iterable<Property>> property2properties = new HashMap<String, Iterable<Property>>();
    private Map<String, Iterable<Operation>> operation2operations = new HashMap<String, Iterable<Operation>>();
    private Map<String, Iterable<Class>> class2classes = new HashMap<String, Iterable<Class>>();
    private Map<String, Map<String, Operation>> type2operation2operation = new HashMap<String, Map<String, Operation>>();
    private Package orphanagePackage = null;
    private Class orphanageClass = null;
    protected Package pivotMetaModel = null;

    private void addClass(Class pivotClass) {
        if (pivotClass instanceof LambdaType || pivotClass instanceof TupleType) {
            return;
        }
        String moniker = pivotClass.getMoniker();
        Iterable<Class> iterable = this.class2classes.get(moniker);
        if (iterable == null) {
            this.class2classes.put(moniker, pivotClass);
            ClassTracker.install(this, pivotClass);
        } else if (iterable instanceof Class) {
            if (iterable != pivotClass) {
                ArrayList<Class> iterables = new ArrayList<Class>();
                iterables.add((Class)iterable);
                iterables.add(pivotClass);
                this.class2classes.put(moniker, iterables);
                ClassTracker.install(this, pivotClass);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotClass));
            }
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            if (!iterables.contains(pivotClass)) {
                iterables.add(pivotClass);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotClass));
            }
        } else assert (false) : "Unknown iterable " + iterable.getClass().getName();
    }

    private void addOperation(Operation pivotOperation) {
        String moniker = pivotOperation.getMoniker();
        Iterable<Operation> iterable = this.operation2operations.get(moniker);
        if (iterable == null) {
            this.operation2operations.put(moniker, pivotOperation);
        } else if (iterable instanceof Operation) {
            if (iterable != pivotOperation) {
                ArrayList<Operation> iterables = new ArrayList<Operation>();
                iterables.add((Operation)iterable);
                iterables.add(pivotOperation);
                this.operation2operations.put(moniker, iterables);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotOperation));
            }
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            if (!iterables.contains(pivotOperation)) {
                iterables.add(pivotOperation);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotOperation));
            }
        } else assert (false) : "Unknown iterable " + iterable.getClass().getName();
    }

    public void addOrphanClass(Type pivotElement) {
        EList<TemplateParameterSubstitution> parameterSubstitutions;
        if (pivotElement.getUnspecializedElement() != null ? !$assertionsDisabled && pivotElement.getUnspecializedElement().getUnspecializedElement() != null : !$assertionsDisabled && !(pivotElement instanceof LambdaType) && !(pivotElement instanceof TupleType) && !(pivotElement instanceof UnspecifiedType)) {
            throw new AssertionError();
        }
        EList templateBindings = pivotElement.getTemplateBindings();
        if (templateBindings.size() == 1 && (parameterSubstitutions = ((TemplateBinding)templateBindings.get(0)).getParameterSubstitutions()).size() == 1) {
            TemplateParameterSubstitution parameterSubstitution = (TemplateParameterSubstitution)parameterSubstitutions.get(0);
            assert (parameterSubstitution.getActual().eContainer() != parameterSubstitution.getFormal());
        }
        assert (pivotElement.hasMoniker());
        Package orphans = this.getOrphanPackage();
        orphans.getOwnedTypes().add((Object)pivotElement);
        this.getOrphanNode(pivotElement);
    }

    public void addOrphanOperation(Operation pivotElement) {
        TemplateableElement unspecializedElement = pivotElement.getUnspecializedElement();
        assert (unspecializedElement != null && unspecializedElement.getUnspecializedElement() == null);
        Class orphanClass = this.getOrphanClass();
        orphanClass.getOwnedOperations().add((Object)pivotElement);
        this.getOrphanNode(pivotElement);
    }

    public void addPackage(Package pivotPackage) {
        Iterable<Package> iterable;
        String moniker = pivotPackage.getMoniker();
        String nsURI = pivotPackage.getNsURI();
        if (nsURI != null) {
            String string = this.uri2package.put(nsURI, moniker);
        }
        if ((iterable = this.package2packages.get(moniker)) == null) {
            this.package2packages.put(moniker, pivotPackage);
            PackageTracker.install(this, pivotPackage);
        } else if (iterable instanceof Package) {
            if (iterable != pivotPackage) {
                ArrayList<Package> iterables = new ArrayList<Package>();
                iterables.add((Package)iterable);
                iterables.add(pivotPackage);
                this.package2packages.put(moniker, iterables);
                PackageTracker.install(this, pivotPackage);
            }
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            if (!iterables.contains(pivotPackage)) {
                iterables.add(pivotPackage);
                PackageTracker.install(this, pivotPackage);
            }
        } else assert (false) : "Unknown iterable " + iterable.getClass().getName();
    }

    private void addProperty(Property pivotProperty) {
        String moniker = pivotProperty.getMoniker();
        Iterable<Property> iterable = this.property2properties.get(moniker);
        if (iterable == null) {
            this.property2properties.put(moniker, pivotProperty);
        } else if (iterable instanceof Property) {
            if (iterable != pivotProperty) {
                ArrayList<Property> iterables = new ArrayList<Property>();
                iterables.add((Property)iterable);
                iterables.add(pivotProperty);
                this.property2properties.put(moniker, iterables);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotProperty));
            }
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            if (!iterables.contains(pivotProperty)) {
                iterables.add(pivotProperty);
            } else {
                logger.warn((Object)("Duplicate addition of " + pivotProperty));
            }
        } else assert (false) : "Unknown iterable " + iterable.getClass().getName();
    }

    public Map<String, MonikeredElement> computeMoniker2PivotMap(Collection<? extends Resource> pivotResources) {
        HashMap<String, MonikeredElement> map = new HashMap<String, MonikeredElement>();
        for (Resource resource : pivotResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                assert (eObject.eResource() == resource);
                if (!(eObject instanceof MonikeredElement) || eObject == this.orphanagePackage) continue;
                MonikeredElement newElement = (MonikeredElement)eObject;
                String moniker = newElement.getMoniker();
                assert (moniker != null);
                MonikeredElement oldElement = (MonikeredElement)map.get(moniker);
                if (oldElement == null) {
                    map.put(moniker, newElement);
                    continue;
                }
                boolean newIsInOrphanage = this.isInOrphanage(newElement);
                boolean oldIsInOrphanage = this.isInOrphanage(oldElement);
                if (!newIsInOrphanage && !oldIsInOrphanage) {
                    assert (newElement.getClass() == oldElement.getClass());
                    continue;
                }
                if (newIsInOrphanage && !oldIsInOrphanage) {
                    map.put(moniker, newElement);
                    continue;
                }
                assert (oldIsInOrphanage != newIsInOrphanage);
            }
        }
        return map;
    }

    protected abstract Resource createOrphanage(URI var1);

    public void dispose() {
        if (this.package2packages != null) {
            ArrayList<Iterable<Package>> packages = new ArrayList<Iterable<Package>>(this.package2packages.values());
            for (Iterable<TemplateableElement> iterable : packages) {
                for (Package package_ : iterable) {
                    AbstractTracker.uninstall(this, (Notifier)package_);
                }
            }
            this.package2packages.clear();
            this.package2packages = null;
        }
        if (this.class2classes != null) {
            ArrayList<Iterable<Class>> classes = new ArrayList<Iterable<Class>>(this.class2classes.values());
            for (Iterable<TemplateableElement> iterable : classes) {
                ArrayList arrayList = new ArrayList();
                Iterables.addAll(arrayList, iterable);
                for (Class pivotClass : arrayList) {
                    AbstractTracker.uninstall(this, (Notifier)pivotClass);
                }
            }
            this.class2classes.clear();
            this.class2classes = null;
        }
        if (this.property2properties != null) {
            this.property2properties.clear();
            this.property2properties = null;
        }
        if (this.operation2operations != null) {
            this.operation2operations.clear();
            this.operation2operations = null;
        }
        if (this.type2operation2operation != null) {
            this.type2operation2operation.clear();
            this.type2operation2operation = null;
        }
    }

    private Set<Iteration> findModelIterationsOrNull(Type type, String operationName, List<Type> staticCompleteIteratorTypes, List<Type> staticCompleteAccumulatorTypes, List<Type> staticCompleteParameterTypes) {
        Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, type);
        int staticIteratorsSize = staticCompleteIteratorTypes.size();
        Set<Iteration> list = null;
        for (Iteration iteration : this.getLocalModelIterations(type, operationName)) {
            EList<Parameter> modelIterators = iteration.getOwnedIterators();
            if (staticIteratorsSize != modelIterators.size()) continue;
            boolean gotIt = true;
            int i = 0;
            while (i < staticIteratorsSize) {
                Type staticCompleteIteratorType = staticCompleteIteratorTypes.get(i);
                Parameter modelIterator = (Parameter)modelIterators.get(i);
                Type dynamicCompleteIteratorType = this.getSpecializedType(modelIterator.getType(), bindings);
                if (!this.conformsTo(dynamicCompleteIteratorType, staticCompleteIteratorType, null)) {
                    gotIt = false;
                }
                ++i;
            }
            if (!gotIt) continue;
            if (list == null) {
                list = new HashSet<Iteration>();
            }
            list.add(iteration);
        }
        if (list == null) {
            for (Type type2 : this.getSuperClasses(type)) {
                Set<Iteration> superIterations = this.findModelIterationsOrNull(type2, operationName, staticCompleteIteratorTypes, staticCompleteAccumulatorTypes, staticCompleteParameterTypes);
                if (superIterations == null) continue;
                if (list == null) {
                    list = superIterations;
                    continue;
                }
                list.addAll(superIterations);
            }
        }
        return list;
    }

    private Set<Operation> findModelOperationsOrNull(Type type, String operationName, List<Type> staticCompleteTypes, Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions) {
        int staticParametersSize = staticCompleteTypes.size();
        Set<Operation> list = null;
        for (Operation operation : this.getLocalModelOperations(type, operationName)) {
            Map<TemplateParameter, ParameterableElement> bindings = null;
            EList<Parameter> modelParameters = operation.getOwnedParameters();
            if (staticParametersSize != modelParameters.size()) continue;
            boolean gotIt = true;
            int i = 0;
            while (i < staticParametersSize) {
                Type staticCompleteType = staticCompleteTypes.get(i);
                Parameter modelParameter = (Parameter)modelParameters.get(i);
                Type dynamicCompleteType = this.getSpecializedType(modelParameter.getType(), templateParameterSubstitutions);
                if (!this.conformsTo(dynamicCompleteType, staticCompleteType, bindings)) {
                    gotIt = false;
                }
                ++i;
            }
            if (!gotIt) continue;
            if (list == null) {
                list = new HashSet<Operation>();
            }
            list.add(operation);
        }
        if (list == null) {
            for (Type type2 : this.getSuperClasses(type)) {
                Set<Operation> superOperations = this.findModelOperationsOrNull(type2, operationName, staticCompleteTypes, templateParameterSubstitutions);
                if (superOperations == null) continue;
                if (list == null) {
                    list = superOperations;
                    continue;
                }
                list.addAll(superOperations);
            }
        }
        return list;
    }

    public <T extends Type> T findOrphanClass(java.lang.Class<T> unspecializedType, String moniker) {
        EList<Type> ownedSpecializations = this.getOrphanPackage().getOwnedTypes();
        for (Type ownedSpecialization : ownedSpecializations) {
            if (!ownedSpecialization.getMoniker().equals(moniker)) continue;
            Type castSpecialization = ownedSpecialization;
            return (T)castSpecialization;
        }
        return null;
    }

    protected <T extends Operation> T findOrphanOperation(java.lang.Class<T> unspecializedOperation, String moniker) {
        EList<Operation> ownedSpecializations = this.getOrphanClass().getOwnedOperations();
        for (Operation ownedSpecialization : ownedSpecializations) {
            if (!ownedSpecialization.getMoniker().equals(moniker)) continue;
            Operation castSpecialization = ownedSpecialization;
            return (T)castSpecialization;
        }
        return null;
    }

    public Iterable<Class> getAllClasses(Type type) {
        Iterable<Class> iterable = this.class2classes.get(type.getMoniker());
        if (iterable != null) {
            return iterable;
        }
        if (type instanceof TupleType) {
            return (TupleType)type;
        }
        if (type.getOwningTemplateParameter() != null) {
            return iterable;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public Iterable<Constraint> getAllConstraints(Type type) {
        Set<Constraint> allConstraints = this.getAllConstraints(type, null);
        if (allConstraints != null) {
            return allConstraints;
        }
        return Collections.emptyList();
    }

    protected Set<Constraint> getAllConstraints(Type type, Set<Constraint> knownConstraints) {
        for (Constraint constraint : this.getLocalConstraints(type)) {
            if (knownConstraints == null) {
                knownConstraints = new HashSet<Constraint>();
                knownConstraints.add(constraint);
                continue;
            }
            if (knownConstraints.add(constraint)) continue;
            return knownConstraints;
        }
        for (Type type2 : this.getSuperClasses(type)) {
            knownConstraints = this.getAllConstraints(type2, knownConstraints);
        }
        return knownConstraints;
    }

    public Iterable<Operation> getAllOperations(Operation operation) {
        Iterable<Operation> iterable = this.operation2operations.get(operation.getMoniker());
        assert (iterable != null);
        return iterable;
    }

    public Iterable<String> getAllPackages() {
        if (this.pivotMetaModel == null) {
            this.lazyLoadPivotMetaModel();
        }
        return this.package2packages.keySet();
    }

    public Iterable<Package> getAllPackages(Package pkg) {
        if (this.pivotMetaModel == null) {
            this.lazyLoadPivotMetaModel();
        }
        Iterable<Package> iterable = this.package2packages.get(pkg.getMoniker());
        assert (iterable != null);
        return iterable;
    }

    public Iterable<Property> getAllProperties(Property property) {
        Iterable<Property> iterable = this.property2properties.get(property.getMoniker());
        if (iterable != null) {
            return iterable;
        }
        if (property.getClass_() instanceof TupleType) {
            return property;
        }
        assert (iterable != null);
        return iterable;
    }

    public Operation getDynamicOperation(Type dynamicType, Operation staticOperation) {
        String operationMoniker;
        Operation dynamicOperation;
        String typeMoniker = dynamicType.getMoniker();
        Map<String, Operation> operation2operation = this.type2operation2operation.get(typeMoniker);
        if (operation2operation == null) {
            operation2operation = new HashMap<String, Operation>();
            this.type2operation2operation.put(typeMoniker, operation2operation);
        }
        if ((dynamicOperation = operation2operation.get(operationMoniker = staticOperation.getMoniker())) != null) {
            return dynamicOperation;
        }
        if (staticOperation instanceof Iteration) {
            return this.getDynamicOperationForIteration(dynamicType, (Iteration)staticOperation);
        }
        return this.getDynamicOperationForOperation(dynamicType, staticOperation);
    }

    private Iteration getDynamicOperationForIteration(Type dynamicType, Iteration staticModelIteration) {
        Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, dynamicType);
        ArrayList<Type> staticCompleteIteratorTypes = new ArrayList<Type>();
        for (Parameter staticIterator : staticModelIteration.getOwnedIterators()) {
            staticCompleteIteratorTypes.add(this.getSpecializedType(staticIterator.getType(), bindings));
        }
        ArrayList<Type> staticCompleteAccumulatorTypes = new ArrayList<Type>();
        for (Parameter staticAccumulator : staticModelIteration.getOwnedAccumulators()) {
            staticCompleteAccumulatorTypes.add(this.getSpecializedType(staticAccumulator.getType(), bindings));
        }
        ArrayList<Type> staticCompleteParameterTypes = new ArrayList<Type>();
        for (Parameter staticParameter : staticModelIteration.getOwnedParameters()) {
            staticCompleteParameterTypes.add(this.getSpecializedType(staticParameter.getType(), bindings));
        }
        Iteration dynamicIteration = null;
        Set<Iteration> modelIterations = this.findModelIterationsOrNull(dynamicType, staticModelIteration.getName(), staticCompleteIteratorTypes, staticCompleteAccumulatorTypes, staticCompleteParameterTypes);
        if (modelIterations != null) {
            if (modelIterations.size() == 1) {
                dynamicIteration = modelIterations.iterator().next();
            } else if (modelIterations.size() > 1) {
                Iteration conformantIteration = null;
                boolean ok = true;
                for (Iteration completeIteration : modelIterations) {
                    Class conformantClass;
                    if (conformantIteration == null) {
                        conformantIteration = completeIteration;
                        continue;
                    }
                    Class completeClass = PivotUtil.getFeaturingClass(completeIteration);
                    if (this.conformsTo(completeClass, conformantClass = PivotUtil.getFeaturingClass(conformantIteration), bindings)) {
                        conformantIteration = completeIteration;
                        continue;
                    }
                    if (this.conformsTo(conformantClass, completeClass, bindings)) continue;
                    ok = false;
                }
                if (ok) {
                    dynamicIteration = conformantIteration;
                }
            }
        }
        return dynamicIteration;
    }

    private Operation getDynamicOperationForOperation(Type dynamicType, Operation staticModelOperation) {
        Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, dynamicType);
        PivotUtil.getAllTemplateParameterSubstitutions(bindings, staticModelOperation);
        ArrayList<Type> staticCompleteTypes = new ArrayList<Type>();
        for (Parameter staticParameter : staticModelOperation.getOwnedParameters()) {
            staticCompleteTypes.add(this.getSpecializedType(staticParameter.getType(), bindings));
        }
        Operation dynamicModelOperation = null;
        String name = staticModelOperation.getName();
        Set<Operation> modelOperations = this.findModelOperationsOrNull(dynamicType, name, staticCompleteTypes, bindings);
        if (modelOperations != null && modelOperations.size() == 1) {
            dynamicModelOperation = modelOperations.iterator().next();
        }
        return dynamicModelOperation;
    }

    public Iterable<Type> getLocalClasses(Package pkg) {
        return new CompletePackageTypesIterable(this.getAllPackages(pkg));
    }

    public Iterable<Constraint> getLocalConstraints(Operation operation) {
        if (operation.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementConstraintsIterable(this.getAllOperations(operation));
    }

    public Iterable<Constraint> getLocalConstraints(Property property) {
        if (property.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementConstraintsIterable(this.getAllProperties(property));
    }

    public Iterable<Constraint> getLocalConstraints(Type type) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementConstraintsIterable(this.getAllClasses(type));
    }

    private Iterable<Iteration> getLocalModelIterations(Type aType, String name) {
        ArrayList<Iteration> iterations = new ArrayList<Iteration>();
        Class type = this.getPrimaryClass(aType);
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        for (Operation anOperation : this.getLocalOperations(type, null)) {
            Operation iteration;
            if (!(anOperation instanceof Iteration) || !name.equals(anOperation.getName()) || iterations.contains(iteration = this.getPrimaryOperation(anOperation))) continue;
            iterations.add((Iteration)iteration);
        }
        return iterations;
    }

    private Iterable<Operation> getLocalModelOperations(Type aType, String name) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Class type = this.getPrimaryClass(aType);
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        for (Operation anOperation : this.getLocalOperations(type, null)) {
            Operation operation;
            if (anOperation instanceof Iteration || !name.equals(anOperation.getName()) || operations.contains(operation = this.getPrimaryOperation(anOperation))) continue;
            operations.add(operation);
        }
        return operations;
    }

    public Iterable<Operation> getLocalOperations(Type type, Boolean selectStatic) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassOperationsIterable(this.getAllClasses(type), selectStatic);
    }

    public Iterable<Package> getLocalPackages(Package pkg) {
        return new CompletePackagePackagesIterable(this.getAllPackages(pkg));
    }

    public Iterable<Property> getLocalProperties(Type type, Boolean selectStatic) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassPropertiesIterable(this.getAllClasses(type), selectStatic);
    }

    public Class getOrphanClass() {
        if (this.orphanageClass == null) {
            this.orphanageClass = PivotFactory.eINSTANCE.createClass();
            this.orphanageClass.setName("$$");
            this.getOrphanPackage().getOwnedTypes().add((Object)this.orphanageClass);
        }
        return this.orphanageClass;
    }

    private OrphanNode getOrphanNode(MonikeredElement pivotElement) {
        if (pivotElement.eIsProxy()) {
            return null;
        }
        String moniker = pivotElement.getMoniker();
        OrphanNode thisOrphanNode = this.moniker2orphan.get(moniker);
        if (thisOrphanNode == null) {
            thisOrphanNode = new OrphanNode(pivotElement);
            this.moniker2orphan.put(moniker, thisOrphanNode);
            for (EObject eObject : pivotElement.eCrossReferences()) {
                OrphanNode thatOrphanNode;
                if (!(eObject instanceof MonikeredElement) || (thatOrphanNode = this.getOrphanNode((MonikeredElement)eObject)) == null) continue;
                thatOrphanNode.addDependency(thisOrphanNode);
            }
        }
        return thisOrphanNode;
    }

    public Package getOrphanPackage() {
        if (this.orphanagePackage == null) {
            this.orphanagePackage = PivotFactory.eINSTANCE.createPackage();
            this.orphanagePackage.setName("$$");
            this.orphanagePackage.setMoniker("$$");
            this.orphanagePackage.setNsURI("http://www.eclipse.org/ocl/3.1.0/orphanage");
            this.orphanagePackage.setNsPrefix("orphanage");
            URI uri = URI.createURI((String)"http://www.eclipse.org/ocl/3.1.0/orphanage");
            Resource orphanage = this.createOrphanage(uri);
            orphanage.getContents().add((Object)this.orphanagePackage);
            this.installResource(orphanage);
        }
        return this.orphanagePackage;
    }

    public String getPackageMoniker(String uri) {
        return this.uri2package.get(uri);
    }

    public Class getPrimaryClass(String moniker) {
        Iterable<Class> iterable = this.class2classes.get(moniker);
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return null;
    }

    public Class getPrimaryClass(Type pivotClass) {
        Iterable<Class> iterable = this.class2classes.get(pivotClass.getMoniker());
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return (Class)pivotClass;
    }

    public EObject getPrimaryElement(EObject element) {
        Iterable<Iterable<Operation>> primaryElement = null;
        if (element instanceof Operation) {
            primaryElement = this.operation2operations.get(((Operation)element).getMoniker());
        } else if (element instanceof Package) {
            primaryElement = this.package2packages.get(((Package)element).getMoniker());
        } else if (element instanceof Property) {
            primaryElement = this.property2properties.get(((Property)element).getMoniker());
        } else if (element instanceof Type) {
            primaryElement = this.class2classes.get(((Type)element).getMoniker());
        }
        if (primaryElement != null) {
            return (EObject)primaryElement.iterator().next();
        }
        return element;
    }

    public Operation getPrimaryOperation(String moniker) {
        Iterable<Operation> iterable = this.operation2operations.get(moniker);
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return null;
    }

    public Operation getPrimaryOperation(Operation pivotOperation) {
        Iterable<Operation> iterable = this.operation2operations.get(pivotOperation.getMoniker());
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return pivotOperation;
    }

    public Package getPrimaryPackage(String moniker) {
        Iterable<Package> iterable = this.package2packages.get(moniker);
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return null;
    }

    public Package getPrimaryPackage(Package pivotPackage) {
        Iterable<Package> iterable = this.package2packages.get(pivotPackage.getMoniker());
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return pivotPackage;
    }

    public Property getPrimaryProperty(String moniker) {
        Iterable<Property> iterable = this.property2properties.get(moniker);
        if (iterable != null) {
            return iterable.iterator().next();
        }
        return null;
    }

    protected abstract Type getSpecializedType(Type var1, Map<TemplateParameter, ParameterableElement> var2);

    public Iterable<Class> getSuperClasses(Type pivotType) {
        return new CompleteClassSuperClassesIterable(this.getAllClasses(pivotType));
    }

    public void installPackageMoniker(Package pivotPackage, boolean installTrackers) {
        String name = pivotPackage.getName();
        if (name == null) {
            name = "$null$";
        }
        String packageMoniker = name;
        if (pivotPackage instanceof Library) {
            pivotPackage.setMoniker("$" + packageMoniker);
            if (installTrackers) {
                this.addPackage(pivotPackage);
            }
        } else {
            Iterable<Package> existingPackage;
            int suffix = 0;
            String nsURI = pivotPackage.getNsURI();
            while (!((existingPackage = this.package2packages.get(packageMoniker)) == null || nsURI != null && nsURI.equals(existingPackage.iterator().next().getNsURI()))) {
                packageMoniker = String.valueOf(name) + "_" + ++suffix;
            }
            pivotPackage.setMoniker(packageMoniker);
            if (installTrackers) {
                this.addPackage(pivotPackage);
            }
            if (suffix > 0 && name != "$null$" && nsURI == null) {
                logger.warn((Object)("Conflicting package " + pivotPackage));
            }
        }
    }

    public void installPropertyDeclaration(Property thisProperty) {
        if (thisProperty.isTransient() || thisProperty.isVolatile() || thisProperty.isDerived()) {
            return;
        }
        Property opposite = thisProperty.getOpposite();
        if (opposite != null) {
            return;
        }
        Class thatType = (Class)thisProperty.getType();
        if (thatType == null || thatType instanceof DataType) {
            return;
        }
        Class thisType = thisProperty.getClass_();
        String name = thisType.getName();
        for (Property thatProperty : thatType.getOwnedAttributes()) {
            if (!name.equals(thatProperty.getName())) continue;
            if (!thatProperty.isImplicit()) {
                return;
            }
            opposite = thatProperty;
        }
        if (opposite != null) {
            opposite.setOpposite(null);
            thisProperty.setOpposite(null);
            opposite.setUpper(BigInteger.valueOf(-1L));
            return;
        }
        opposite = PivotFactory.eINSTANCE.createProperty();
        opposite.setImplicit(true);
        opposite.setName(name);
        opposite.setType(thisType);
        opposite.setLower(BigInteger.valueOf(0L));
        if (thisProperty.isComposite()) {
            opposite.setUpper(BigInteger.valueOf(1L));
        } else {
            opposite.setUpper(BigInteger.valueOf(-1L));
        }
        opposite.setOpposite(thisProperty);
        thisProperty.setOpposite(opposite);
        thatType.getOwnedAttributes().add((Object)opposite);
    }

    protected abstract void installResource(Resource var1);

    protected boolean isInOrphanage(EObject eObject) {
        EObject eContainer = eObject;
        while (eContainer != null) {
            if (eContainer == this.orphanagePackage) {
                return true;
            }
            eContainer = eContainer.eContainer();
        }
        return false;
    }

    protected abstract void lazyLoadPivotMetaModel();

    protected void loadPivotMetaModel(Library pivotLibrary) {
        for (Package libPackage : this.package2packages.get(pivotLibrary.getMoniker())) {
            if (PivotUtil.getNamedElement(libPackage.getOwnedTypes(), PivotPackage.Literals.ELEMENT.getName()) == null) continue;
            this.pivotMetaModel = libPackage;
            return;
        }
        OclMetaModel metaModelResource = new OclMetaModel(this);
        this.pivotMetaModel = (Package)metaModelResource.getContents().get(0);
        this.pivotMetaModel.setName(pivotLibrary.getName());
        this.pivotMetaModel.setMoniker(pivotLibrary.getMoniker());
        this.addPackage(this.pivotMetaModel);
    }

    private void removeClass(Class pivotClass) {
        String moniker = pivotClass.getMoniker();
        Iterable<Class> iterable = this.class2classes.get(moniker);
        if (iterable == pivotClass) {
            this.class2classes.remove(moniker);
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            iterables.remove(pivotClass);
            if (iterables.size() == 0) {
                this.class2classes.remove(moniker);
            } else if (iterables.size() == 1) {
                this.class2classes.put(moniker, (Iterable)iterables.get(0));
            }
        } else if (iterable != null) assert (false) : "Unknown iterable " + iterable.getClass().getName();
        this.removeOrphan(pivotClass);
        for (Operation operation : new ArrayList<Operation>((Collection<Operation>)pivotClass.getOwnedOperations())) {
            this.removeOperation(operation);
        }
        for (Property property : new ArrayList<Property>((Collection<Property>)pivotClass.getOwnedAttributes())) {
            this.removeProperty(property);
        }
    }

    private void removeOperation(Operation pivotOperation) {
        String moniker = pivotOperation.getMoniker();
        Iterable<Operation> iterable = this.operation2operations.get(moniker);
        if (iterable == pivotOperation) {
            this.operation2operations.remove(moniker);
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            iterables.remove(pivotOperation);
            if (iterables.size() == 0) {
                this.operation2operations.remove(moniker);
            } else if (iterables.size() == 1) {
                this.operation2operations.put(moniker, (Iterable)iterables.get(0));
            }
        } else if (iterable != null) assert (false) : "Unknown iterable " + iterable.getClass().getName();
        this.removeOrphan(pivotOperation);
    }

    private void removeOrphan(MonikeredElement pivotElement) {
        String moniker = pivotElement.getMoniker();
        OrphanNode thisOrphanNode = this.moniker2orphan.get(moniker);
        if (thisOrphanNode != null) {
            Set<OrphanNode> orphans = thisOrphanNode.getAllDependencies(null);
            for (OrphanNode orphan : orphans) {
                MonikeredElement element = orphan.getElement();
                if (element instanceof Operation) {
                    Class orphanClass = this.getOrphanClass();
                    orphanClass.getOwnedOperations().remove((Object)element);
                } else if (element instanceof Class) {
                    Package orphanPackage = this.getOrphanPackage();
                    orphanPackage.getOwnedTypes().remove((Object)element);
                }
                orphan.dispose();
            }
        }
    }

    private void removePackage(Package pivotPackage) {
        Iterable<Package> iterable;
        String moniker = pivotPackage.getMoniker();
        String nsURI = pivotPackage.getNsURI();
        if (nsURI != null) {
            this.uri2package.remove(nsURI);
        }
        if ((iterable = this.package2packages.get(moniker)) == pivotPackage) {
            this.package2packages.remove(moniker);
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            iterables.remove(pivotPackage);
            if (iterables.size() == 0) {
                this.package2packages.remove(moniker);
            } else if (iterables.size() == 1) {
                this.package2packages.put(moniker, (Iterable)iterables.get(0));
            }
        } else if (iterable != null) assert (false) : "Unknown iterable " + iterable.getClass().getName();
        this.removeOrphan(pivotPackage);
    }

    private void removeProperty(Property pivotProperty) {
        String moniker = pivotProperty.getMoniker();
        Iterable<Property> iterable = this.property2properties.get(moniker);
        if (iterable == pivotProperty) {
            this.property2properties.remove(moniker);
        } else if (iterable instanceof List) {
            List iterables = (List)iterable;
            iterables.remove(pivotProperty);
            if (iterables.size() == 0) {
                this.property2properties.remove(moniker);
            } else if (iterables.size() == 1) {
                this.property2properties.put(moniker, (Iterable)iterables.get(0));
            }
        } else if (iterable != null) assert (false) : "Unknown iterable " + iterable.getClass().getName();
        this.removeOrphan(pivotProperty);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractTracker<T extends Notifier>
    implements TypeManagedAdapter {
        protected TypeCaches typeCaches;
        protected T target;

        public static void uninstall(TypeCaches typeCaches, Notifier value) {
            Adapter tracker;
            if (value != null && (tracker = EcoreUtil.getAdapter((List)value.eAdapters(), (Object)typeCaches)) != null) {
                ((AbstractTracker)tracker).dispose();
            }
        }

        protected AbstractTracker(TypeCaches typeCaches, T target) {
            this.typeCaches = typeCaches;
            this.target = target;
            target.eAdapters().add((Object)this);
        }

        @Override
        public abstract void dispose();

        public T getTarget() {
            return this.target;
        }

        @Override
        public boolean isAdapterFor(TypeManager typeManager) {
            return this.typeCaches == typeManager;
        }

        public final boolean isAdapterForType(Object type) {
            return type == this.typeCaches;
        }

        public void setTarget(Notifier newTarget) {
            assert (this.target == newTarget);
        }

        public void unsetTarget(Notifier oldTarget) {
            assert (this.target == oldTarget);
            this.target = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTracker
    extends AbstractTracker<Class> {
        public static ClassTracker install(TypeCaches typeCaches, Class target) {
            Adapter tracker = EcoreUtil.getAdapter((List)target.eAdapters(), (Object)typeCaches);
            if (tracker != null) {
                return (ClassTracker)tracker;
            }
            return new ClassTracker(typeCaches, target);
        }

        private ClassTracker(TypeCaches typeCaches, Class target) {
            super(typeCaches, target);
            for (Operation pivotOperation : target.getOwnedOperations()) {
                typeCaches.addOperation(pivotOperation);
            }
            for (Property pivotProperty : target.getOwnedAttributes()) {
                typeCaches.addProperty(pivotProperty);
            }
        }

        @Override
        public void dispose() {
            if (this.target != null) {
                this.typeCaches.removeClass((Class)this.target);
                ((Class)this.target).eAdapters().remove((Object)this);
            }
        }

        public void notifyChanged(Notification notification) {
            block18: {
                Object feature;
                int eventType;
                block17: {
                    eventType = notification.getEventType();
                    feature = notification.getFeature();
                    if (feature != PivotPackage.Literals.CLASS__OWNED_OPERATION) break block17;
                    switch (eventType) {
                        case 3: {
                            Object value = notification.getNewValue();
                            this.typeCaches.addOperation((Operation)value);
                            break;
                        }
                        case 5: {
                            List values = (List)notification.getNewValue();
                            for (Object value : values) {
                                this.typeCaches.addOperation((Operation)value);
                            }
                            break block18;
                        }
                        case 4: {
                            Object value = notification.getOldValue();
                            this.typeCaches.removeOperation((Operation)value);
                            break;
                        }
                        case 6: {
                            List values = (List)notification.getOldValue();
                            for (Object value : values) {
                                this.typeCaches.removeOperation((Operation)value);
                            }
                        }
                    }
                    break block18;
                }
                if (feature == PivotPackage.Literals.CLASS__OWNED_ATTRIBUTE) {
                    switch (eventType) {
                        case 3: {
                            Object value = notification.getNewValue();
                            this.typeCaches.addProperty((Property)value);
                            break;
                        }
                        case 5: {
                            List values = (List)notification.getNewValue();
                            for (Object value : values) {
                                this.typeCaches.addProperty((Property)value);
                            }
                            break;
                        }
                        case 4: {
                            Object value = notification.getOldValue();
                            this.typeCaches.removeProperty((Property)value);
                            break;
                        }
                        case 6: {
                            List values = (List)notification.getOldValue();
                            for (Object value : values) {
                                this.typeCaches.removeProperty((Property)value);
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassOperationsIterable
    extends CompleteElementIterable<Class, Operation> {
        protected final Boolean selectStatic;

        public CompleteClassOperationsIterable(Iterable<Class> classes, Boolean selectStatic) {
            super(classes);
            this.selectStatic = selectStatic;
        }

        @Override
        protected Iterable<Operation> getInnerIterable(Class model) {
            return model.getOwnedOperations();
        }

        @Override
        protected Operation getInnerValue(Operation element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassPropertiesIterable
    extends CompleteElementIterable<Class, Property> {
        protected final Boolean selectStatic;

        public CompleteClassPropertiesIterable(Iterable<Class> classes, Boolean selectStatic) {
            super(classes);
            this.selectStatic = selectStatic;
        }

        @Override
        protected Iterable<Property> getInnerIterable(Class model) {
            return model.getOwnedAttributes();
        }

        @Override
        protected Property getInnerValue(Property element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassSuperClassesIterable
    extends CompleteElementIterable<Class, Class> {
        public CompleteClassSuperClassesIterable(Iterable<Class> types) {
            super(types);
        }

        @Override
        protected Iterable<Class> getInnerIterable(Class model) {
            return model.getSuperClasses();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteElementConstraintsIterable
    extends CompleteElementIterable<NamedElement, Constraint> {
        public CompleteElementConstraintsIterable(Iterable<? extends NamedElement> models) {
            super(models);
        }

        @Override
        protected Iterable<Constraint> getInnerIterable(NamedElement model) {
            return model.getOwnedRules();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompletePackagePackagesIterable
    extends CompleteElementIterable<Package, Package> {
        public CompletePackagePackagesIterable(Iterable<Package> packages) {
            super(packages);
        }

        @Override
        protected Iterable<Package> getInnerIterable(Package model) {
            return model.getNestedPackages();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompletePackageTypesIterable
    extends CompleteElementIterable<Package, Type> {
        public CompletePackageTypesIterable(Iterable<Package> packages) {
            super(packages);
        }

        @Override
        protected Iterable<Type> getInnerIterable(Package model) {
            return model.getOwnedTypes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrphanNode {
        protected final MonikeredElement element;
        protected Set<OrphanNode> dependencies = null;

        public OrphanNode(MonikeredElement element) {
            this.element = element;
        }

        public void addDependency(OrphanNode orphanNode) {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<OrphanNode>();
            }
            this.dependencies.add(orphanNode);
        }

        public void dispose() {
            if (this.dependencies != null) {
                this.dependencies.clear();
                this.dependencies = null;
            }
        }

        public Set<OrphanNode> getAllDependencies(Set<OrphanNode> orphans) {
            if (orphans == null) {
                orphans = new HashSet<OrphanNode>();
                orphans.add(this);
            }
            if (this.dependencies != null) {
                for (OrphanNode orphan : this.dependencies) {
                    if (!orphans.add(orphan)) continue;
                    orphan.getAllDependencies(orphans);
                }
            }
            return orphans;
        }

        public MonikeredElement getElement() {
            return this.element;
        }

        public String toString() {
            return "<orphan-node> " + this.element.getMoniker();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageTracker
    extends AbstractTracker<Package> {
        public static PackageTracker install(TypeCaches typeCaches, Package target) {
            Adapter tracker = EcoreUtil.getAdapter((List)target.eAdapters(), (Object)typeCaches);
            if (tracker != null) {
                return (PackageTracker)tracker;
            }
            return new PackageTracker(typeCaches, target);
        }

        private PackageTracker(TypeCaches typeCaches, Package target) {
            super(typeCaches, target);
            this.installPackageContent(target);
        }

        @Override
        public void dispose() {
            if (this.target != null) {
                this.typeCaches.removePackage((Package)this.target);
            }
            ((Package)this.target).eAdapters().remove((Object)this);
        }

        private void installPackageContent(Package pivotPackage) {
            for (Type pivotType : pivotPackage.getOwnedTypes()) {
                if (!(pivotType instanceof Class)) continue;
                this.typeCaches.addClass((Class)pivotType);
            }
            for (Package nestedPackage : pivotPackage.getNestedPackages()) {
                this.installPackageContent(nestedPackage);
            }
        }

        public void notifyChanged(Notification notification) {
            block16: {
                Object feature;
                int eventType;
                block15: {
                    eventType = notification.getEventType();
                    feature = notification.getFeature();
                    if (feature != PivotPackage.Literals.PACKAGE__OWNED_TYPE) break block15;
                    switch (eventType) {
                        case 3: {
                            Object value = notification.getNewValue();
                            if (value instanceof Class) {
                                this.typeCaches.addClass((Class)value);
                                break;
                            }
                            break block16;
                        }
                        case 5: {
                            List values = (List)notification.getNewValue();
                            for (Object value : values) {
                                if (!(value instanceof Class)) continue;
                                this.typeCaches.addClass((Class)value);
                            }
                            break block16;
                        }
                        case 4: {
                            Object value = notification.getOldValue();
                            if (value instanceof Class) {
                                PackageTracker.uninstall(this.typeCaches, (Notifier)((Class)value));
                                this.typeCaches.removeClass((Class)value);
                                break;
                            }
                            break block16;
                        }
                        case 6: {
                            List values = (List)notification.getOldValue();
                            for (Object value : values) {
                                if (!(value instanceof Class)) continue;
                                PackageTracker.uninstall(this.typeCaches, (Notifier)((Class)value));
                                this.typeCaches.removeClass((Class)value);
                            }
                        }
                    }
                    break block16;
                }
                if (feature == PivotPackage.Literals.PACKAGE__NESTED_PACKAGE) {
                    switch (eventType) {
                        case 3: {
                            Object value = notification.getNewValue();
                            this.typeCaches.addPackage((Package)value);
                            break;
                        }
                        case 4: {
                            Object value = notification.getOldValue();
                            this.typeCaches.removePackage((Package)value);
                            PackageTracker.uninstall(this.typeCaches, (Notifier)((Package)value));
                        }
                    }
                }
            }
        }
    }
}

