/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.internal.impl.TypedElementImpl;
import org.eclipse.ocl.examples.pivot.library.ConstrainedOperation;
import org.eclipse.ocl.examples.pivot.library.ConstrainedProperty;
import org.eclipse.ocl.examples.pivot.library.ExplicitNavigationProperty;
import org.eclipse.ocl.examples.pivot.library.ImplicitCompositionProperty;
import org.eclipse.ocl.examples.pivot.library.ImplicitNonCompositionProperty;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.library.TuplePartProperty;
import org.eclipse.ocl.examples.pivot.library.UnimplementedOperation;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.model.OclMetaModel;
import org.eclipse.ocl.examples.pivot.uml.UML2Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotResourceFactoryImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeCaches;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager
extends TypeCaches
implements Adapter {
    private static Set<Factory> factoryMap = new HashSet<Factory>();
    private static final Logger logger;
    protected final ResourceSet pivotResourceSet;
    protected List<Library> pivotLibraries = new ArrayList<Library>();
    protected Resource pivotLibraryResource = null;
    protected ResourceSetImpl externalResourceSet = null;
    private Map<String, List<Precedence>> nameToPrecedencesMap = null;
    private Map<String, String> infixToPrecedenceNameMap = null;
    private Map<String, String> prefixToPrecedenceNameMap = null;
    private Map<String, Namespace> globalNamespaces = new HashMap<String, Namespace>();
    private Set<Type> globalTypes = new HashSet<Type>();
    private int unspecifiedTypeCount = 0;
    private Map<URI, External2Pivot> external2PivotMap = new HashMap<URI, External2Pivot>();
    private Map<Object, URI> uriMap = null;

    static {
        Ecore2Pivot.FACTORY.getClass();
        UML2Ecore2Pivot.FACTORY.getClass();
        logger = Logger.getLogger(TypeManager.class);
    }

    public static void addFactory(Factory factory) {
        factoryMap.add(factory);
    }

    public static TypeManager findAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return PivotUtil.getAdapter(TypeManager.class, (Notifier)resourceSet);
    }

    public static TypeManager getAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        EList eAdapters = resourceSet.eAdapters();
        TypeManager adapter = PivotUtil.getAdapter(TypeManager.class, (List<Adapter>)eAdapters);
        if (adapter == null) {
            adapter = new TypeManager(resourceSet);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    public static void initializePivotResourceSet(ResourceSet pivotResourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = pivotResourceSet.getResourceFactoryRegistry();
        Map contentTypeToFactoryMap = resourceFactoryRegistry.getContentTypeToFactoryMap();
        contentTypeToFactoryMap.put("org.eclipse.ocl.examples.pivot", new PivotResourceFactoryImpl());
        Map extensionToFactoryMap = resourceFactoryRegistry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        extensionToFactoryMap.put("pivot", new PivotResourceFactoryImpl());
        EPackage.Registry packageRegistry = pivotResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/3.1.0/Pivot", (Object)PivotPackage.eINSTANCE);
    }

    public static boolean isLibraryType(Type type) {
        if (type instanceof LambdaType) {
            return false;
        }
        if (type instanceof TupleType) {
            return ((TupleType)type).getOwnedAttributes().isEmpty();
        }
        return type.getTemplateBindings().isEmpty();
    }

    public static void setMonikerAsID(Collection<? extends Resource> resources) {
        for (Resource resource : resources) {
            if (resource instanceof XMLResource) {
                XMLResource xmlResource = (XMLResource)resource;
                TreeIterator it = resource.getAllContents();
                while (it.hasNext()) {
                    String id;
                    String moniker;
                    EObject eObject = (EObject)it.next();
                    if (eObject instanceof MonikeredElement) {
                        moniker = ((MonikeredElement)eObject).getMoniker();
                        id = moniker.replaceAll("<", "&lt;");
                        xmlResource.setID(eObject, id);
                        continue;
                    }
                    if (!(eObject instanceof TemplateParameter)) continue;
                    moniker = String.valueOf(((TemplateParameter)eObject).getParameteredElement().getMoniker()) + ".";
                    id = moniker.replaceAll("<", "&lt;");
                    xmlResource.setID(eObject, id);
                }
                continue;
            }
            logger.warn((Object)("Resource '" + resource.getURI() + "' is not an XMLResource"));
        }
    }

    public TypeManager() {
        this((ResourceSet)new ResourceSetImpl());
        TypeManager.initializePivotResourceSet(this.pivotResourceSet);
    }

    public TypeManager(ResourceSet pivotResourceSet) {
        this.pivotResourceSet = pivotResourceSet;
        pivotResourceSet.eAdapters().add((Object)this);
    }

    public void addExternalResource(External2Pivot external2Pivot) {
        this.external2PivotMap.put(external2Pivot.getURI(), external2Pivot);
    }

    public Namespace addGlobalNamespace(String name, Namespace namespace) {
        return this.globalNamespaces.put(name, namespace);
    }

    public boolean addGlobalTypes(Collection<Type> types) {
        return this.globalTypes.addAll(types);
    }

    public int compareOperationMatches(Operation reference, Map<TemplateParameter, ParameterableElement> referenceBindings, Operation candidate, Map<TemplateParameter, ParameterableElement> candidateBindings) {
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterators().size() - ((Iteration)reference).getOwnedIterators().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            Class referenceType = PivotUtil.getFeaturingClass((Iteration)reference);
            Class candidateType = PivotUtil.getFeaturingClass((Iteration)candidate);
            Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
            Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
            if (referenceType != candidateType) {
                if (this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                    return 1;
                }
                if (this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                    return -1;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> compilePrecedences(Collection<? extends Package> rootPackages) {
        void var4_7;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> orderedPrecedences = new ArrayList<String>();
        this.nameToPrecedencesMap = new HashMap<String, List<Precedence>>();
        this.infixToPrecedenceNameMap = new HashMap<String, String>();
        this.prefixToPrecedenceNameMap = new HashMap<String, String>();
        for (Package package_ : rootPackages) {
            EList<Precedence> precedences = package_.getOwnedPrecedences();
            if (precedences.size() <= 0) continue;
            this.compilePrecedencePackage(package_);
            int prevIndex = -1;
            List<Precedence> list = null;
            String name = null;
            for (Precedence precedence : precedences) {
                name = precedence.getName();
                int index = orderedPrecedences.indexOf(name);
                if (index < 0) {
                    index = prevIndex < 0 ? orderedPrecedences.size() : prevIndex + 1;
                    orderedPrecedences.add(index, name);
                    list = new ArrayList<Precedence>();
                    this.nameToPrecedencesMap.put(name, list);
                } else {
                    list = this.nameToPrecedencesMap.get(name);
                    if (index <= prevIndex) {
                        errors.add("Inconsistent precedence ordering for '" + name + "'");
                    } else if (prevIndex >= 0 && index != prevIndex + 1) {
                        errors.add("Ambiguous precedence ordering for '" + name + "'");
                    }
                    if (precedence.getAssociativity() != list.get(0).getAssociativity()) {
                        errors.add("Inconsistent precedence associativity for '" + name + "'");
                    }
                }
                prevIndex = index;
                list.add(precedence);
            }
            if (list == null || list.size() != 1 || prevIndex == orderedPrecedences.size() - 1) continue;
            errors.add("Ambiguous precedence ordering for '" + name + "' at tail");
        }
        boolean bl = false;
        while (var4_7 < orderedPrecedences.size()) {
            String name = (String)orderedPrecedences.get((int)var4_7);
            BigInteger order = BigInteger.valueOf((long)var4_7);
            for (Precedence precedence : this.nameToPrecedencesMap.get(name)) {
                precedence.setOrder(order);
            }
            ++var4_7;
        }
        return errors;
    }

    protected void compilePrecedenceOperation(Operation operation) {
        Precedence precedence = operation.getPrecedence();
        if (precedence != null) {
            EList<Parameter> parameters = operation.getOwnedParameters();
            if (parameters.size() == 0) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                String oldName = this.prefixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    logger.warn((Object)("Conflicting precedences for prefix operation '" + operatorName + "'"));
                }
            } else if (parameters.size() == 1) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                String oldName = this.infixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    logger.warn((Object)("Conflicting precedences for infix operation '" + operatorName + "'"));
                }
            }
        }
    }

    protected void compilePrecedencePackage(Package pivotPackage) {
        for (Package nestedPackage : pivotPackage.getNestedPackages()) {
            this.compilePrecedencePackage(nestedPackage);
        }
        for (Type type : pivotPackage.getOwnedTypes()) {
            if (!TypeManager.isLibraryType(type)) continue;
            this.compilePrecedenceType(type);
        }
    }

    protected void compilePrecedenceType(Type pivotType) {
        this.defineLibraryType(pivotType);
        if (pivotType instanceof Class) {
            for (Operation operation : ((Class)pivotType).getOwnedOperations()) {
                this.compilePrecedenceOperation(operation);
            }
        }
    }

    protected CallableImplementation computeOperationImplementation(Operation operation) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        CallableImplementation implementation = operation.getImplementation();
        String implementationClassName = operation.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            java.lang.Class<?> theClass = java.lang.Class.forName(implementationClassName);
            Field field = theClass.getField("INSTANCE");
            return (CallableImplementation)field.get(null);
        }
        for (Constraint constraint : this.getLocalConstraints(operation)) {
            ValueSpecification specification;
            if (!"body".equals(constraint.getStereotype()) || !((specification = constraint.getSpecification()) instanceof ExpressionInOcl)) continue;
            return new ConstrainedOperation((ExpressionInOcl)specification);
        }
        return UnimplementedOperation.INSTANCE;
    }

    public Collection<Package> computePivotRootPackages() {
        HashSet<Package> rootPackages = new HashSet<Package>();
        if (this.pivotLibraryResource != null) {
            for (EObject eObject : this.pivotLibraryResource.getContents()) {
                if (!(eObject instanceof Package)) continue;
                rootPackages.add((Package)eObject);
            }
        }
        for (Resource pivotResource : this.pivotResourceSet.getResources()) {
            for (EObject eObject : pivotResource.getContents()) {
                if (!(eObject instanceof Package)) continue;
                rootPackages.add((Package)eObject);
            }
        }
        return rootPackages;
    }

    protected CallableImplementation computePropertyImplementation(Property property) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        CallableImplementation implementation = property.getImplementation();
        String implementationClassName = property.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            java.lang.Class<?> theClass = java.lang.Class.forName(implementationClassName);
            Field field = theClass.getField("INSTANCE");
            return (CallableImplementation)field.get(null);
        }
        for (Constraint constraint : this.getLocalConstraints(property)) {
            ValueSpecification specification;
            if (!"body".equals(constraint.getStereotype()) || !((specification = constraint.getSpecification()) instanceof ExpressionInOcl)) continue;
            return new ConstrainedProperty((ExpressionInOcl)specification);
        }
        if (property.isImplicit()) {
            Property opposite = property.getOpposite();
            if (opposite.isComposite()) {
                return ImplicitCompositionProperty.INSTANCE;
            }
            return ImplicitNonCompositionProperty.INSTANCE;
        }
        if (property.getClass_() instanceof TupleType) {
            return TuplePartProperty.INSTANCE;
        }
        return ExplicitNavigationProperty.INSTANCE;
    }

    @Override
    @Deprecated
    public boolean conformsTo(Type firstType, Type secondType) {
        return this.conformsTo(firstType, secondType, null);
    }

    @Override
    public boolean conformsTo(Type firstType, Type secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        if (firstType == null || secondType == null) {
            return false;
        }
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstType);
                    return true;
                }
            }
        }
        if (firstType == secondType) {
            return true;
        }
        if ((firstType = this.getPrimaryClass(firstType)) == (secondType = this.getPrimaryClass(secondType))) {
            return true;
        }
        if (secondType instanceof AnyType) {
            return true;
        }
        if (firstType instanceof AnyType) {
            return false;
        }
        if (firstType instanceof InvalidType) {
            return true;
        }
        if (secondType instanceof InvalidType) {
            return false;
        }
        if (firstType instanceof VoidType) {
            return true;
        }
        if (secondType instanceof VoidType) {
            return false;
        }
        if (firstType instanceof ClassifierType) {
            if (secondType instanceof ClassifierType) {
                return this.conformsToClassifierType((ClassifierType)firstType, (ClassifierType)secondType, bindings);
            }
            return false;
        }
        if (firstType instanceof CollectionType) {
            if (secondType instanceof CollectionType) {
                return this.conformsToCollectionType((CollectionType)firstType, (CollectionType)secondType, bindings);
            }
            return false;
        }
        if (firstType instanceof LambdaType) {
            if (secondType instanceof LambdaType) {
                return this.conformsToLambdaType((LambdaType)firstType, (LambdaType)secondType, bindings);
            }
            return false;
        }
        if (firstType instanceof TupleType) {
            if (secondType instanceof TupleType) {
                return this.conformsToTupleType((TupleType)firstType, (TupleType)secondType, bindings);
            }
            return false;
        }
        if (firstType instanceof Class) {
            if (secondType instanceof Class) {
                Class firstClass = (Class)firstType;
                Class secondClass = (Class)secondType;
                for (Class superClass : firstClass.getSuperClasses()) {
                    if (!this.conformsTo(superClass, secondClass, bindings)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean conformsToClassifierType(ClassifierType firstType, ClassifierType secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        Type firstElementType = firstType.getInstanceType();
        Type secondElementType = secondType.getInstanceType();
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstElementType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondElementType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    protected boolean conformsToLambdaType(LambdaType firstType, LambdaType secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        throw new UnsupportedOperationException();
    }

    protected boolean conformsToCollectionType(CollectionType firstType, CollectionType secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        CollectionType unspecializedFirstType = PivotUtil.getUnspecializedTemplateableElement(firstType);
        CollectionType unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (!this.isSuperClassOf(unspecializedSecondType, unspecializedFirstType)) {
            return false;
        }
        Type firstElementType = firstType.getElementType();
        Type secondElementType = secondType.getElementType();
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter;
            if (firstElementType != null && (firstTemplateParameter = firstElementType.getOwningTemplateParameter()) != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if (secondElementType != null && (secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                parameterableElement = bindings.get(secondTemplateParameter);
                if (parameterableElement instanceof Type) {
                    secondElementType = (Type)parameterableElement;
                } else if (parameterableElement == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    protected boolean conformsToTupleType(TupleType actualType, TupleType requiredType, Map<TemplateParameter, ParameterableElement> bindings) {
        EList<Property> actualProperties = actualType.getOwnedAttributes();
        EList<Property> requiredProperties = requiredType.getOwnedAttributes();
        if (actualProperties.size() != requiredProperties.size()) {
            return false;
        }
        for (Property actualProperty : actualProperties) {
            Property requiredProperty = PivotUtil.getNamedElement(requiredProperties, actualProperty.getName());
            if (requiredProperty == null) {
                return false;
            }
            if (this.conformsTo(actualProperty.getType(), requiredProperty.getType(), bindings)) continue;
            return false;
        }
        return true;
    }

    public InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.getOclInvalidType());
        return invalidLiteralExp;
    }

    @Override
    protected Resource createOrphanage(URI uri) {
        return this.pivotResourceSet.createResource(uri);
    }

    public Package createPackage(String string, String nsURI) {
        return this.createPackage(Package.class, PivotPackage.Literals.PACKAGE, string, nsURI);
    }

    public <T extends Package> T createPackage(java.lang.Class<T> pivotClass, EClass pivotEClass, String name, String nsURI) {
        Package pivotPackage = (Package)PivotFactory.eINSTANCE.create(pivotEClass);
        pivotPackage.setName(name);
        pivotPackage.setNsURI(nsURI);
        this.installPackageMoniker(pivotPackage, true);
        return (T)pivotPackage;
    }

    public Resource createResource(URI uri, String contentType) {
        return this.pivotResourceSet.createResource(uri, contentType);
    }

    public UnspecifiedType createUnspecifiedType() {
        String value = "<unspecified:" + this.unspecifiedTypeCount++ + ">";
        UnspecifiedType unspecifiedType = PivotFactory.eINSTANCE.createUnspecifiedType();
        unspecifiedType.setName(value);
        unspecifiedType.setLowerBound(this.getOclAnyType());
        unspecifiedType.setUpperBound(this.getOclVoidType());
        unspecifiedType.setMoniker(value);
        this.addOrphanClass(unspecifiedType);
        return unspecifiedType;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public ClassifierType getClassifierType(Type type) {
        return this.getLibraryType(this.getClassifierType(), Collections.singletonList(type), true);
    }

    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return this.getOrderedSetType();
            }
            return this.getSequenceType();
        }
        if (isUnique) {
            return this.getSetType();
        }
        return this.getBagType();
    }

    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique, Type elementType) {
        return this.getLibraryType(this.getCollectionType(isOrdered, isUnique), Collections.singletonList(elementType), true);
    }

    public Type getCollectionType(String collectionTypeName, Type elementType) {
        if (elementType == null || elementType.eIsProxy()) {
            return this.getOclInvalidType();
        }
        return this.getLibraryType(collectionTypeName, Collections.singletonList(elementType));
    }

    public List<Class> getCommonClasses(Class leftClass, Class rightClass) {
        List<Class> commonClasses = null;
        if (this.conformsTo(rightClass, leftClass, null)) {
            commonClasses = new ArrayList<Class>();
            commonClasses.add(leftClass);
        }
        for (Class superClass : leftClass.getSuperClasses()) {
            List<Class> commonSuperClasses = this.getCommonClasses(superClass, rightClass);
            if (commonSuperClasses == null) continue;
            if (commonClasses == null) {
                commonClasses = commonSuperClasses;
                continue;
            }
            commonClasses.addAll(commonSuperClasses);
        }
        return commonClasses;
    }

    public Type getCommonTupleType(TupleType leftType, TupleType rightType, Map<TemplateParameter, ParameterableElement> bindings) {
        EList<Property> leftProperties = leftType.getOwnedAttributes();
        EList<Property> rightProperties = rightType.getOwnedAttributes();
        if (leftProperties.size() != rightProperties.size()) {
            return null;
        }
        boolean isLeft = true;
        boolean isRight = true;
        ArrayList<Property> commonProperties = new ArrayList<Property>(leftProperties.size());
        for (Property leftProperty : leftProperties) {
            Property rightProperty = PivotUtil.getNamedElement(rightProperties, leftProperty.getName());
            Type leftPropertyType = leftProperty.getType();
            Type rightPropertyType = rightProperty.getType();
            TypedElement commonProperty = null;
            Type commonType = this.getCommonType(leftPropertyType, rightPropertyType, bindings);
            if (commonType == null) {
                return null;
            }
            if (commonType != leftPropertyType) {
                isLeft = false;
            } else {
                commonProperty = leftProperty;
            }
            if (commonType != rightPropertyType) {
                isRight = false;
            } else {
                commonProperty = rightProperty;
            }
            if (commonProperty == null) {
                commonProperty = new TuplePart(leftProperty.getName(), commonType);
            }
            commonProperties.add((Property)commonProperty);
        }
        if (isLeft) {
            return leftType;
        }
        if (isRight) {
            return rightType;
        }
        return this.getTupleType(leftType.getName(), commonProperties, bindings, null);
    }

    @Deprecated
    public Type getCommonType(Type leftType, Type rightType) {
        return this.getCommonType(leftType, rightType, null);
    }

    public Type getCommonType(Type leftType, Type rightType, Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions) {
        if (leftType instanceof UnspecifiedType) {
            ((UnspecifiedType)leftType).setUpperBound(rightType);
            return rightType;
        }
        if (rightType instanceof UnspecifiedType) {
            ((UnspecifiedType)rightType).setUpperBound(leftType);
            return leftType;
        }
        if (leftType instanceof TupleType && rightType instanceof TupleType) {
            return this.getCommonTupleType((TupleType)leftType, (TupleType)rightType, templateParameterSubstitutions);
        }
        if (this.conformsTo(leftType, rightType, templateParameterSubstitutions)) {
            return rightType;
        }
        if (this.conformsTo(rightType, leftType, templateParameterSubstitutions)) {
            return leftType;
        }
        if (!(leftType instanceof Class) || !(rightType instanceof Class)) {
            return null;
        }
        List<Class> commonClasses = this.getCommonClasses((Class)leftType, (Class)rightType);
        if (commonClasses == null) {
            return null;
        }
        Class mostConformant = null;
        for (Class commonClass : commonClasses) {
            if (mostConformant == null) {
                mostConformant = commonClass;
                continue;
            }
            if (!this.conformsTo(commonClass, mostConformant, templateParameterSubstitutions)) continue;
            mostConformant = commonClass;
        }
        return mostConformant;
    }

    public String getDefaultStandardLibraryURI() {
        return this.defaultStandardLibraryURI;
    }

    public ResourceSet getExternalResourceSet() {
        if (this.externalResourceSet == null) {
            this.externalResourceSet = new ResourceSetImpl();
            TypeManagerResourceSetAdapter.getAdapter((ResourceSet)this.externalResourceSet, this);
            for (Factory factory : factoryMap) {
                factory.configure((ResourceSet)this.externalResourceSet);
            }
        }
        return this.externalResourceSet;
    }

    public Set<Map.Entry<String, Namespace>> getGlobalNamespaces() {
        return this.globalNamespaces.entrySet();
    }

    public Iterable<Type> getGlobalTypes() {
        return this.globalTypes;
    }

    public CallableImplementation getImplementation(Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String implementationClassName;
        CallableImplementation implementation = feature.getImplementation();
        if (implementation == null && (implementationClassName = feature.getImplementationClass()) != null) {
            java.lang.Class<?> theClass = java.lang.Class.forName(implementationClassName);
            Field field = theClass.getField("INSTANCE");
            implementation = (CallableImplementation)field.get(null);
        }
        return implementation;
    }

    public CallableImplementation getImplementation(Operation operation) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        CallableImplementation implementation = operation.getImplementation();
        if (implementation == null) {
            implementation = this.computeOperationImplementation(operation);
            operation.setImplementation(implementation);
        }
        return implementation;
    }

    public CallableImplementation getImplementation(Property property) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        CallableImplementation implementation = property.getImplementation();
        if (implementation == null) {
            implementation = this.computePropertyImplementation(property);
            property.setImplementation(implementation);
        }
        return implementation;
    }

    public Precedence getInfixPrecedence(String operatorName) {
        String precedenceName;
        if (this.infixToPrecedenceNameMap == null) {
            this.compilePrecedences(this.computePivotRootPackages());
        }
        if ((precedenceName = this.infixToPrecedenceNameMap.get(operatorName)) == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }

    public LambdaType getLambdaType(String typeName, Type contextType, List<? extends Type> parameterTypes, Type resultType, Map<TemplateParameter, ParameterableElement> bindings, String moniker) {
        LambdaType existingLambdaType;
        if (moniker == null) {
            Pivot2Moniker s = new Pivot2Moniker(null);
            s.append(typeName);
            s.appendLambdaType(contextType, parameterTypes, resultType, bindings);
            moniker = s.toString();
        }
        if ((existingLambdaType = this.findOrphanClass(LambdaType.class, moniker)) != null) {
            return existingLambdaType;
        }
        LambdaType lambdaType = PivotFactory.eINSTANCE.createLambdaType();
        lambdaType.setName(typeName);
        lambdaType.setContextType(this.getSpecializedType(contextType, bindings));
        for (Type type : parameterTypes) {
            lambdaType.getParameterTypes().add((Object)this.getSpecializedType(type, bindings));
        }
        lambdaType.setResultType(this.getSpecializedType(resultType, bindings));
        if (bindings != null) {
            TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
            for (Map.Entry<TemplateParameter, ParameterableElement> binding : bindings.entrySet()) {
                TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(binding.getKey());
                templateParameterSubstitution.setActual(binding.getValue());
                templateBinding.getParameterSubstitutions().add((Object)templateParameterSubstitution);
            }
            lambdaType.getTemplateBindings().add((Object)templateBinding);
        }
        lambdaType.setMoniker(moniker);
        this.addOrphanClass(lambdaType);
        return lambdaType;
    }

    public List<Library> getLibraries() {
        return this.pivotLibraries;
    }

    public Resource getLibraryResource() {
        return this.pivotLibraryResource;
    }

    public Type getLibraryType(String string, List<? extends ParameterableElement> templateArguments) {
        Type libraryType = this.getRequiredLibraryType(string);
        if (libraryType == null) {
            return null;
        }
        return this.getLibraryType(libraryType, templateArguments, true);
    }

    public <T extends Type> T getLibraryType(T libraryType, List<? extends ParameterableElement> templateArguments, boolean resolveSuperClasses) {
        List<TemplateParameter> templateParameters;
        assert (libraryType == PivotUtil.getUnspecializedTemplateableElement(libraryType));
        if (libraryType == this.getClassifierType() && templateArguments != null && templateArguments.size() == 1 && templateArguments.get(0) == libraryType) {
            return libraryType;
        }
        TemplateSignature templateSignature = libraryType.getOwnedTemplateSignature();
        List<TemplateParameter> list = templateParameters = templateSignature != null ? templateSignature.getParameters() : Collections.emptyList();
        if (templateParameters.isEmpty()) {
            return libraryType;
        }
        if (templateArguments == null || templateArguments.size() != templateParameters.size()) {
            throw new IllegalArgumentException("Incorrect template bindings for template type");
        }
        boolean isUnspecialized = this.isUnspecialized(templateParameters, templateArguments);
        if (isUnspecialized) {
            return libraryType;
        }
        String moniker = this.getSpecializedMoniker(libraryType, templateArguments);
        Class existingSpecializedType1 = this.getPrimaryClass(moniker);
        java.lang.Class requiredClass = ClassUtils.getClass(libraryType);
        if (existingSpecializedType1 != null && requiredClass.isAssignableFrom(existingSpecializedType1.getClass())) {
            Class castExistingSpecializedType1 = existingSpecializedType1;
            return (T)castExistingSpecializedType1;
        }
        Object existingSpecializedType = this.findOrphanClass(requiredClass, moniker);
        if (existingSpecializedType != null) {
            return existingSpecializedType;
        }
        EClass eClass = libraryType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Type specializedType = (Type)eFactoryInstance.create(eClass);
        specializedType.setName(libraryType.getName());
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        int i = 0;
        while (i < templateParameters.size()) {
            TemplateParameter formalParameter = templateParameters.get(i);
            ParameterableElement actualType = templateArguments.get(i);
            allBindings.put(formalParameter, templateArguments.get(i));
            TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
            templateParameterSubstitution.setFormal(formalParameter);
            if (actualType != null && actualType.eContainer() == null) {
                templateParameterSubstitution.setOwnedActual(actualType);
            } else {
                templateParameterSubstitution.setActual(actualType);
            }
            templateBinding.getParameterSubstitutions().add((Object)templateParameterSubstitution);
            ++i;
        }
        specializedType.getTemplateBindings().add((Object)templateBinding);
        if (resolveSuperClasses && libraryType instanceof Class) {
            Class libraryClass = (Class)libraryType;
            Class specializedClass = (Class)specializedType;
            this.resolveSuperClasses(specializedClass, libraryClass, allBindings);
        }
        if (specializedType instanceof CollectionType) {
            ((CollectionType)specializedType).setElementType((Type)templateArguments.get(0));
        } else if (specializedType instanceof TupleType) {
            ((TupleType)specializedType).getSuperClasses().add((Object)this.getOclAnyType());
        } else if (specializedType instanceof ClassifierType) {
            ParameterableElement templateArgument = templateArguments.get(0);
            ClassifierType specializedClassifierType = (ClassifierType)specializedType;
            specializedClassifierType.setInstanceType((Type)templateArgument);
            if (templateArgument instanceof Enumeration) {
                specializedClassifierType.getSuperClasses().add((Object)this.getEnumerationType());
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("Enumeration")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else if (templateArgument instanceof InvalidType) {
                specializedClassifierType.getSuperClasses().add((Object)this.getOclInvalidType());
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("InvalidType")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else if (templateArgument instanceof VoidType) {
                specializedClassifierType.getSuperClasses().add((Object)this.getOclVoidType());
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("VoidType")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else if (templateArgument instanceof PrimitiveType) {
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("PrimitiveType")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else if (templateArgument instanceof CollectionType) {
                specializedClassifierType.getSuperClasses().add((Object)this.getCollectionType());
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("CollectionType")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else if (templateArgument instanceof AnyType) {
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("Class")));
            } else if (templateArgument instanceof TupleType) {
                specializedClassifierType.getSuperClasses().add((Object)this.getTupleType());
                specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("TupleType")));
                specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
            } else {
                ClassifierType classifierType = this.getClassifierType(this.getClassifierType());
                if (classifierType != specializedClassifierType) {
                    specializedClassifierType.getSuperClasses().add((Object)classifierType);
                    specializedClassifierType.getSuperClasses().add((Object)((Class)this.getPivotType("Class")));
                    specializedClassifierType.getSuperClasses().remove((Object)this.getOclAnyType());
                }
            }
        }
        specializedType.setUnspecializedElement(libraryType);
        specializedType.setMoniker(moniker);
        this.addOrphanClass(specializedType);
        return (T)specializedType;
    }

    public Package getPivotMetaModel() {
        AnyType oclAnyType;
        if (this.pivotMetaModel == null && (oclAnyType = this.getOclAnyType()) != null) {
            OclMetaModel metaModelResource = new OclMetaModel(this);
            this.pivotMetaModel = (Package)metaModelResource.getContents().get(0);
            this.pivotMetaModel.setName(oclAnyType.getPackage().getName());
            this.pivotMetaModel.setMoniker(oclAnyType.getPackage().getMoniker());
            this.addPackage(this.pivotMetaModel);
        }
        return this.pivotMetaModel;
    }

    public <T extends NamedElement> T getPivotOfEcore(java.lang.Class<T> pivotClass, EObject eObject) {
        Resource metaModel = eObject.eResource();
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(metaModel, this);
        return (T)((NamedElement)ecore2Pivot.getCreated(pivotClass, eObject));
    }

    public ResourceSet getPivotResourceSet() {
        return this.pivotResourceSet;
    }

    @Override
    public Type getPivotType(String className) {
        Package pivotMetaModel = this.getPivotMetaModel();
        if (pivotMetaModel == null) {
            return null;
        }
        return PivotUtil.getNamedElement(pivotMetaModel.getOwnedTypes(), className);
    }

    public Iterable<? extends Nameable> getPrecedences(Package pivotPackage) {
        return pivotPackage.getOwnedPrecedences();
    }

    public Precedence getPrefixPrecedence(String operatorName) {
        String precedenceName;
        if (this.prefixToPrecedenceNameMap == null) {
            this.compilePrecedences(this.computePivotRootPackages());
        }
        if ((precedenceName = this.prefixToPrecedenceNameMap.get(operatorName)) == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }

    public URI getResourceIdentifier(Object uniqueContext, String subContext) {
        URI uri;
        if (subContext == null) {
            subContext = "";
        }
        if (uniqueContext instanceof MonikeredElement) {
            uri = URI.createURI((String)(String.valueOf(((MonikeredElement)uniqueContext).getMoniker()) + subContext + ".essentialocl"));
        } else {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<Object, URI>();
            }
            if ((uri = this.uriMap.get(uniqueContext)) == null) {
                uri = URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + subContext + ".essentialocl"));
                this.uriMap.put(uniqueContext, uri);
            }
        }
        return uri;
    }

    public CollectionType getSetType(Type elementType) {
        return this.getLibraryType(this.getSetType(), Collections.singletonList(elementType), true);
    }

    protected String getSpecializedMoniker(Type libraryType, List<? extends ParameterableElement> templateArguments) {
        Pivot2Moniker s = new Pivot2Moniker(null);
        s.appendElement((Element)libraryType.eContainer());
        s.append("!");
        s.append(libraryType.getName());
        s.appendTemplateArguments(templateArguments, null);
        String moniker = s.toString();
        return moniker;
    }

    public <T extends Operation> T getSpecializedOperation(T unspecializedOperation, Map<TemplateParameter, ParameterableElement> templateBindings) {
        String specializedMoniker2;
        String string;
        List<List<TemplateParameter>> templateParameterLists = PivotUtil.getAllTemplateParameterLists(unspecializedOperation);
        if (templateParameterLists == null || templateParameterLists.isEmpty()) {
            return unspecializedOperation;
        }
        boolean isSpecialized = false;
        ArrayList<ParameterableElement> templateArguments = new ArrayList<ParameterableElement>();
        for (List<TemplateParameter> templateParameters : templateParameterLists) {
            for (TemplateParameter templateParameter : templateParameters) {
                ParameterableElement binding = templateBindings.get(templateParameter);
                if (binding != templateParameter.getParameteredElement()) {
                    isSpecialized = true;
                }
                templateArguments.add(binding);
            }
        }
        if (!isSpecialized) {
            return unspecializedOperation;
        }
        Map<TemplateParameter, ParameterableElement> allBindings = templateBindings;
        String moniker = this.getSpecializedOperationMoniker(unspecializedOperation, templateArguments, allBindings);
        Object existingSpecializedOperation = this.findOrphanOperation(ClassUtils.getClass(unspecializedOperation), moniker);
        if (existingSpecializedOperation != null) {
            return existingSpecializedOperation;
        }
        EClass eClass = unspecializedOperation.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Operation specializedOperation = (Operation)eFactoryInstance.create(eClass);
        specializedOperation.setName(unspecializedOperation.getName());
        for (List<TemplateParameter> templateParameters : templateParameterLists) {
            if (templateParameters.size() <= 0) continue;
            TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
            templateBinding.setSignature(templateParameters.get(0).getSignature());
            for (TemplateParameter templateParameter : templateParameters) {
                ParameterableElement actualType = allBindings.get(templateParameter);
                TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(templateParameter);
                templateParameterSubstitution.setActual(actualType);
                templateBinding.getParameterSubstitutions().add((Object)templateParameterSubstitution);
            }
            specializedOperation.getTemplateBindings().add((Object)templateBinding);
        }
        if (unspecializedOperation instanceof Iteration) {
            Iteration unspecializedIteration = (Iteration)unspecializedOperation;
            Iteration specializedIteration = (Iteration)specializedOperation;
            for (Parameter unspecializedIterator : unspecializedIteration.getOwnedIterators()) {
                Parameter specializedIterator = PivotFactory.eINSTANCE.createParameter();
                specializedIterator.setName(unspecializedIterator.getName());
                specializedIterator.setLower(unspecializedIterator.getLower());
                specializedIterator.setUpper(unspecializedIterator.getUpper());
                specializedIterator.setIsOrdered(unspecializedIterator.isOrdered());
                specializedIterator.setIsUnique(unspecializedIterator.isUnique());
                specializedIterator.setType(this.getSpecializedType(unspecializedIterator.getType(), allBindings));
                specializedIteration.getOwnedIterators().add((Object)specializedIterator);
            }
            for (Parameter unspecializedAccumulator : unspecializedIteration.getOwnedAccumulators()) {
                Parameter specializedAccumulator = PivotFactory.eINSTANCE.createParameter();
                specializedAccumulator.setName(unspecializedAccumulator.getName());
                specializedAccumulator.setLower(unspecializedAccumulator.getLower());
                specializedAccumulator.setUpper(unspecializedAccumulator.getUpper());
                specializedAccumulator.setIsOrdered(unspecializedAccumulator.isOrdered());
                specializedAccumulator.setIsUnique(unspecializedAccumulator.isUnique());
                specializedAccumulator.setType(this.getSpecializedType(unspecializedAccumulator.getType(), allBindings));
                specializedIteration.getOwnedAccumulators().add((Object)specializedAccumulator);
            }
        }
        for (Parameter unspecializedParameter : unspecializedOperation.getOwnedParameters()) {
            Parameter specializedParameter = PivotFactory.eINSTANCE.createParameter();
            specializedParameter.setName(unspecializedParameter.getName());
            specializedParameter.setLower(unspecializedParameter.getLower());
            specializedParameter.setUpper(unspecializedParameter.getUpper());
            specializedParameter.setIsOrdered(unspecializedParameter.isOrdered());
            specializedParameter.setIsUnique(unspecializedParameter.isUnique());
            specializedParameter.setType(this.getSpecializedType(unspecializedParameter.getType(), allBindings));
            specializedOperation.getOwnedParameters().add((Object)specializedParameter);
        }
        Type returnType = unspecializedOperation.getType();
        Type specializedReturnType = this.getSpecializedType(returnType, allBindings);
        specializedOperation.setType(specializedReturnType);
        specializedOperation.setImplementation(unspecializedOperation.getImplementation());
        specializedOperation.setImplementationClass(unspecializedOperation.getImplementationClass());
        specializedOperation.setPrecedence(unspecializedOperation.getPrecedence());
        specializedOperation.setIsStatic(unspecializedOperation.isStatic());
        specializedOperation.setUnspecializedElement(unspecializedOperation);
        this.addOrphanOperation(specializedOperation);
        String specializedMoniker = specializedOperation.getMoniker();
        if (!moniker.equals(specializedMoniker) && !(string = this.getSpecializedOperationMoniker(unspecializedOperation, templateArguments, allBindings)).equals(specializedMoniker2 = Pivot2Moniker.toString(specializedOperation))) {
            logger.warn((Object)("Inconsistent monikers:\n\t" + string + "\n\t" + specializedMoniker2));
        }
        return (T)specializedOperation;
    }

    protected String getSpecializedOperationMoniker(Operation operation, List<? extends ParameterableElement> templateArguments, Map<TemplateParameter, ParameterableElement> templateBindings) {
        Pivot2Moniker s = new Pivot2Moniker(null);
        s.appendElement((Element)operation.eContainer(), templateBindings);
        s.append("!");
        s.append(operation.getName());
        s.appendTemplateArguments(templateArguments, templateBindings);
        s.appendParameters(operation, templateBindings);
        String moniker = s.toString();
        return moniker;
    }

    @Override
    protected Type getSpecializedType(Type type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        TemplateParameter owningTemplateParameter = type.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            if (usageBindings == null) {
                return type;
            }
            ParameterableElement parameterableElement = usageBindings.get(owningTemplateParameter);
            return parameterableElement instanceof Type ? (Type)parameterableElement : type;
        }
        if (usageBindings == null) {
            return type;
        }
        if (type instanceof TupleType) {
            return this.getSpecializedTupleType((TupleType)type, usageBindings);
        }
        if (type instanceof LambdaType) {
            return this.getSpecializedLambdaType((LambdaType)type, usageBindings);
        }
        Type unspecializedType = PivotUtil.getUnspecializedTemplateableElement(type);
        Map<TemplateParameter, ParameterableElement> typeBindings = PivotUtil.getAllTemplateParametersAsBindings(type);
        PivotUtil.getAllTemplateParameterSubstitutions(typeBindings, type);
        if (typeBindings != null && !typeBindings.isEmpty()) {
            for (TemplateParameter templateParameter : typeBindings.keySet()) {
                ParameterableElement aParameterableElement;
                TemplateParameter aTemplateParameter;
                ParameterableElement parameterableElement = typeBindings.get(templateParameter);
                if (parameterableElement == null || (aTemplateParameter = parameterableElement.getOwningTemplateParameter()) == null || (aParameterableElement = usageBindings.get(aTemplateParameter)) == null) continue;
                typeBindings.put(templateParameter, aParameterableElement);
            }
            List<TemplateParameter> templateParameters = PivotUtil.getAllTemplateParameters(unspecializedType);
            ArrayList<ParameterableElement> templateArguments = new ArrayList<ParameterableElement>(templateParameters.size());
            for (TemplateParameter templateParameter : templateParameters) {
                ParameterableElement templateArgument = typeBindings.get(templateParameter);
                if (templateArgument == null) {
                    templateArgument = templateParameter.getParameteredElement();
                }
                if (templateArgument instanceof Type) {
                    templateArgument = this.getSpecializedType((Type)templateArgument, usageBindings);
                }
                templateArguments.add(templateArgument);
            }
            return this.getLibraryType(unspecializedType, templateArguments, true);
        }
        return type;
    }

    protected Type getSpecializedLambdaType(LambdaType type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        LambdaType specializedLambdaType = this.getLambdaType(type.getName(), type.getContextType(), (List<? extends Type>)type.getParameterTypes(), type.getResultType(), usageBindings, null);
        return specializedLambdaType;
    }

    protected Type getSpecializedTupleType(TupleType type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        TupleType specializedTupleType = type;
        HashMap<String, Type> resolutions = null;
        for (Property property : specializedTupleType.getOwnedAttributes()) {
            Type propertyType = this.getTypeWithMultiplicity(property);
            Type resolvedPropertyType = this.getSpecializedType(propertyType, usageBindings);
            if (resolvedPropertyType == propertyType) continue;
            if (resolutions == null) {
                resolutions = new HashMap<String, Type>();
            }
            resolutions.put(property.getName(), resolvedPropertyType);
        }
        if (resolutions != null) {
            ArrayList<Property> parts = new ArrayList<Property>();
            Iterator iterator = specializedTupleType.getOwnedAttributes().iterator();
            while (iterator.hasNext()) {
                Property property;
                TypedElement part = property = (Property)iterator.next();
                Type resolvedPropertyType = (Type)resolutions.get(property.getName());
                if (resolvedPropertyType != null) {
                    part = new TuplePart(property.getName(), resolvedPropertyType);
                }
                parts.add((Property)part);
            }
            specializedTupleType = this.getTupleType(type.getName(), parts, usageBindings, null);
        }
        return specializedTupleType;
    }

    public ResourceSet getTarget() {
        return this.pivotResourceSet;
    }

    public TupleType getTupleType(String typeName, Collection<? extends TypedElement> parts, Map<TemplateParameter, ParameterableElement> bindings, String moniker) {
        TupleType existingTupleType;
        if (moniker == null) {
            Pivot2Moniker s = new Pivot2Moniker(null);
            s.append(typeName);
            s.appendTupleType(parts);
            moniker = s.toString();
        }
        if ((existingTupleType = this.findOrphanClass(TupleType.class, moniker)) != null) {
            return existingTupleType;
        }
        TupleType tupleType = PivotFactory.eINSTANCE.createTupleType();
        tupleType.setName(typeName);
        for (TypedElement typedElement : parts) {
            Property tuplePart = PivotFactory.eINSTANCE.createProperty();
            tuplePart.setName(typedElement.getName());
            tuplePart.setType(this.getSpecializedType(typedElement.getType(), bindings));
            tupleType.getOwnedAttributes().add((Object)tuplePart);
        }
        tupleType.setMoniker(moniker);
        tupleType.getSuperClasses().add((Object)this.getTupleType());
        this.addOrphanClass(tupleType);
        return tupleType;
    }

    public Type getTypeWithMultiplicity(TypedMultiplicityElement element) {
        boolean isMany;
        Type elementType = PivotUtil.getBehavioralType(element.getType());
        int upperBound = element.getUpper().intValue();
        boolean bl = isMany = upperBound < 0 || 1 < upperBound;
        if (!isMany) {
            return elementType;
        }
        boolean isOrdered = element.isOrdered();
        boolean isUnique = element.isUnique();
        CollectionType collectionType = isOrdered ? (isUnique ? this.getOrderedSetType() : this.getSequenceType()) : (isUnique ? this.getSetType() : this.getBagType());
        return this.getLibraryType(collectionType, Collections.singletonList(elementType), true);
    }

    public ValueFactory getValueFactory() {
        return ValueFactory.INSTANCE;
    }

    protected void installLibrary(Library pivotLibrary) {
        String uri = pivotLibrary.getNsURI();
        if (this.pivotLibraries.isEmpty()) {
            if (uri == null) {
                throw new IllegalLibraryException(OCLMessages.MissingLibraryURI_ERROR_);
            }
            this.setDefaultStandardLibraryURI(uri);
            this.pivotLibraries.add(pivotLibrary);
        } else if (!this.pivotLibraries.contains(pivotLibrary)) {
            String libraryURI = this.getDefaultStandardLibraryURI();
            if (uri != null && !uri.equals(libraryURI)) {
                throw new IllegalLibraryException(NLS.bind((String)OCLMessages.ImportedLibraryURI_ERROR_, (Object)uri, (Object)libraryURI));
            }
            this.pivotLibraries.add(pivotLibrary);
        }
    }

    public void installPackage(Package pivotPackage) {
        if (pivotPackage instanceof Library) {
            this.installLibrary((Library)pivotPackage);
        }
        this.addPackage(pivotPackage);
    }

    @Override
    public void installResource(Resource pivotResource) {
        for (EObject eObject : pivotResource.getContents()) {
            if (!(eObject instanceof Package)) continue;
            Package pivotPackage = (Package)eObject;
            this.installPackage(pivotPackage);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == TypeManager.class;
    }

    public boolean isSuperClassOf(Type unspecializedFirstType, Class secondType) {
        Type unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (unspecializedFirstType == unspecializedSecondType) {
            return true;
        }
        Class secondClass = secondType;
        for (Class superClass : secondClass.getSuperClasses()) {
            if (!this.isSuperClassOf(unspecializedFirstType, superClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnderspecified(ParameterableElement type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TemplateableElement) {
            for (TemplateBinding templateBinding : ((TemplateableElement)((Object)type)).getTemplateBindings()) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                    if (!this.isUnderspecified((Type)templateParameterSubstitution.getActual())) continue;
                    return true;
                }
            }
        }
        if (type instanceof UnspecifiedType) {
            return true;
        }
        if (type instanceof CollectionType) {
            return this.isUnderspecified(((CollectionType)type).getElementType());
        }
        if (type instanceof TupleType) {
            for (Property part : ((TupleType)type).getOwnedAttributes()) {
                if (!this.isUnderspecified(part.getType())) continue;
                return true;
            }
        }
        if (type instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)type;
            if (this.isUnderspecified(lambdaType.getContextType())) {
                return true;
            }
            for (Type parameterType : lambdaType.getParameterTypes()) {
                if (!this.isUnderspecified(parameterType)) continue;
                return true;
            }
            if (this.isUnderspecified(lambdaType.getResultType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean isUnspecialized(List<TemplateParameter> templateParameters, List<? extends ParameterableElement> templateArguments) {
        int iMax = templateParameters.size();
        assert (templateArguments.size() == iMax);
        boolean isUnspecialized = true;
        int i = 0;
        while (i < iMax) {
            if (templateArguments.get(i) != templateParameters.get(i).getParameteredElement()) {
                isUnspecialized = false;
            }
            ++i;
        }
        return isUnspecialized;
    }

    @Override
    protected void lazyLoadPivotMetaModel() {
        if (!this.pivotLibraries.isEmpty()) {
            this.loadPivotMetaModel(this.pivotLibraries.get(0));
        }
    }

    @Override
    protected Resource loadDefaultLibrary(String uri) {
        if (!this.pivotLibraries.isEmpty() && this.pivotLibraryResource == null) {
            this.loadLibrary(this.pivotLibraries.get(0).eResource());
            return this.pivotLibraryResource;
        }
        if (uri == null) {
            return null;
        }
        StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get(uri);
        if (contribution == null) {
            return null;
        }
        Resource resource = contribution.getResource();
        this.loadLibrary(resource);
        return resource;
    }

    public void loadLibrary(Resource pivotResource) {
        assert (this.pivotLibraryResource == null || this.pivotLibraryResource == pivotResource);
        if (pivotResource != null) {
            this.pivotLibraryResource = pivotResource;
            this.installResource(pivotResource);
        }
        for (Package rootPackage : this.computePivotRootPackages()) {
            if (!(rootPackage instanceof Library)) continue;
            this.pivotLibraries.add((Library)rootPackage);
            this.loadLibraryPackage(rootPackage);
        }
    }

    protected void loadLibraryPackage(Package pivotPackage) {
        for (Package nestedPackage : pivotPackage.getNestedPackages()) {
            this.loadLibraryPackage(nestedPackage);
        }
        for (Type type : pivotPackage.getOwnedTypes()) {
            if (!TypeManager.isLibraryType(type)) continue;
            this.defineLibraryType(type);
        }
    }

    public Element loadResource(URI uri, String alias) {
        Resource resource;
        URI resourceURI = uri.trimFragment();
        String resourceURIstring = resourceURI.toString();
        if (resourceURIstring.equals(this.defaultStandardLibraryURI)) {
            resource = this.loadDefaultLibrary(resourceURIstring);
        } else {
            StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get(resourceURIstring);
            if (contribution != null) {
                resource = contribution.getResource();
            } else {
                External2Pivot external2Pivot = this.external2PivotMap.get(uri);
                if (external2Pivot != null) {
                    resource = external2Pivot.getResource();
                } else {
                    External2Pivot external2Pivot2;
                    String firstURI;
                    EObject firstContent;
                    EList contents;
                    ResourceSet resourceSet = this.getExternalResourceSet();
                    try {
                        resource = resourceSet.getResource(resourceURI, true);
                    }
                    catch (RuntimeException e) {
                        Resource resource2 = resourceSet.getResource(resourceURI, false);
                        if (resource2 != null) {
                            resourceSet.getResources().remove((Object)resource2);
                            resource2 = null;
                        }
                        throw e;
                    }
                    if (resource != null && (contents = resource.getContents()).size() > 0 && (firstContent = (EObject)contents.get(0)) instanceof EPackage && (firstURI = ((EPackage)firstContent).getNsURI()) != null && (external2Pivot2 = this.external2PivotMap.get(URI.createURI((String)firstURI))) != null) {
                        resource = external2Pivot2.getResource();
                    }
                }
            }
        }
        if (resource != null) {
            for (Factory factory : factoryMap) {
                if (!factory.canHandle(resource)) continue;
                return factory.importFromResource(this, resource, uri.fragment());
            }
            throw new IllegalArgumentException("Cannot ccreate pivot from '" + uri + "'");
        }
        logger.warn((Object)("Cannot load package with URI '" + uri + "'"));
        return null;
    }

    public void notifyChanged(Notification notification) {
    }

    public void resolveSpecializationBaseClasses() {
        EList<Type> orphanTypes = this.getOrphanPackage().getOwnedTypes();
        int i = 0;
        while (i < orphanTypes.size()) {
            Type orphanType = (Type)orphanTypes.get(i);
            if (orphanType instanceof Class) {
                this.resolveSuperClasses((Class)orphanType);
                if (orphanType instanceof CollectionType) {
                    ((CollectionType)orphanType).setElementType((Type)((TemplateParameterSubstitution)((TemplateBinding)orphanType.getTemplateBindings().get(0)).getParameterSubstitutions().get(0)).getActual());
                } else if (orphanType instanceof ClassifierType) {
                    ((ClassifierType)orphanType).setInstanceType((Type)((TemplateParameterSubstitution)((TemplateBinding)orphanType.getTemplateBindings().get(0)).getParameterSubstitutions().get(0)).getActual());
                }
            }
            ++i;
        }
    }

    public void resolveSuperClasses(Class specializedClass) {
        EList<Class> oldSuperClasses = specializedClass.getSuperClasses();
        if (oldSuperClasses.size() > 0) {
            return;
        }
        Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(specializedClass);
        if (unspecializedType == null) {
            return;
        }
        Map<TemplateParameter, ParameterableElement> specializedBindings = PivotUtil.getAllTemplateParameterSubstitutions(null, specializedClass);
        ArrayList<Class> newSuperClasses = new ArrayList<Class>();
        for (Class unspecializedSuper : unspecializedType.getSuperClasses()) {
            Class unspecializedSuperType;
            Class specializedSuperType;
            ArrayList<ParameterableElement> templateArguments = null;
            EList unboundSuperTemplateBindings = unspecializedSuper.getTemplateBindings();
            if (unboundSuperTemplateBindings.size() > 0) {
                Map<TemplateParameter, ParameterableElement> superBindings = PivotUtil.getAllTemplateParameterSubstitutions(null, unspecializedSuper);
                List<TemplateParameter> unspecializedSuperTemplateParameters = PivotUtil.getAllTemplateParameters((Collection<TemplateBinding>)unboundSuperTemplateBindings);
                templateArguments = new ArrayList<ParameterableElement>(unspecializedSuperTemplateParameters.size());
                for (TemplateParameter unspecializedSuperTemplateParameter : unspecializedSuperTemplateParameters) {
                    TemplateParameter unspecializedFormal;
                    ParameterableElement unspecializedActual;
                    ParameterableElement templateArgument = null;
                    if (superBindings != null && (unspecializedActual = superBindings.get(unspecializedSuperTemplateParameter)) != null && (unspecializedFormal = unspecializedActual.getOwningTemplateParameter()) != null && specializedBindings != null) {
                        templateArgument = specializedBindings.get(unspecializedFormal);
                    }
                    if (templateArgument == null) {
                        templateArgument = unspecializedSuperTemplateParameter.getParameteredElement();
                    }
                    templateArguments.add(templateArgument);
                }
            }
            if ((specializedSuperType = this.getLibraryType(unspecializedSuperType = PivotUtil.getUnspecializedTemplateableElement(unspecializedSuper), templateArguments, false)) == null || newSuperClasses.contains(specializedSuperType)) continue;
            newSuperClasses.add(specializedSuperType);
        }
        PivotUtil.refreshList(oldSuperClasses, newSuperClasses);
    }

    public void resolveSuperClasses(Class specializedClass, Class libraryClass, Map<TemplateParameter, ParameterableElement> allBindings) {
        for (Class superClass : libraryClass.getSuperClasses()) {
            ArrayList<ParameterableElement> superTemplateArguments = null;
            EList superTemplateBindings = superClass.getTemplateBindings();
            if (superTemplateBindings.size() > 0) {
                superTemplateArguments = new ArrayList<ParameterableElement>();
                for (TemplateBinding superTemplateBinding : superTemplateBindings) {
                    for (TemplateParameterSubstitution superTemplateParameterSubstitution : superTemplateBinding.getParameterSubstitutions()) {
                        ParameterableElement superActual = superTemplateParameterSubstitution.getActual();
                        ParameterableElement actualActual = allBindings.get(superActual.getTemplateParameter());
                        superTemplateArguments.add(actualActual);
                    }
                }
            }
            Class unspecializedSuperClass = PivotUtil.getUnspecializedTemplateableElement(superClass);
            specializedClass.getSuperClasses().add((Object)this.getLibraryType(unspecializedSuperClass, superTemplateArguments, true));
        }
    }

    public Operation resolveOperation(Type leftType, String operationName, Type ... rightTypes) {
        if (!(leftType instanceof Class)) {
            return null;
        }
        Set<Operation> candidateOperations = this.resolveOperations((Class)leftType, operationName, rightTypes);
        if (candidateOperations == null) {
            return null;
        }
        if (candidateOperations.size() > 1) {
            logger.warn((Object)("Ambiguous operation '" + operationName + "'"));
        }
        return candidateOperations.iterator().next();
    }

    public Set<Operation> resolveOperations(Class pivotClass, String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, pivotClass);
        Set<Operation> pivotOperations = this.resolveLocalOperation(pivotClass, operationName, pivotArguments);
        for (TemplateBinding templateBinding : pivotClass.getTemplateBindings()) {
            Set<Operation> morePivotOperations;
            TemplateSignature signature = templateBinding.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (!(template instanceof Class) || (morePivotOperations = this.resolveLocalOperation((Class)template, operationName, pivotArguments)) == null) continue;
            if (pivotOperations == null) {
                pivotOperations = morePivotOperations;
                continue;
            }
            pivotOperations.addAll(morePivotOperations);
        }
        if (pivotOperations == null) {
            EList<Class> superClasses = pivotClass.getSuperClasses();
            if (!superClasses.isEmpty()) {
                for (Class superClass : superClasses) {
                    Set<Operation> superOperations = this.resolveOperations(superClass, operationName, pivotArguments);
                    if (superOperations == null) continue;
                    if (pivotOperations == null) {
                        pivotOperations = superOperations;
                        continue;
                    }
                    pivotOperations.addAll(superOperations);
                }
            } else {
                AnyType oclAnyType = this.getOclAnyType();
                if (pivotClass != oclAnyType) {
                    pivotOperations = this.resolveOperations(oclAnyType, operationName, pivotArguments);
                }
            }
        }
        return pivotOperations;
    }

    public Set<Operation> resolveLocalOperation(Class pivotClass, String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = null;
        HashSet<Operation> pivotOperations = null;
        for (Operation pivotOperation : pivotClass.getOwnedOperations()) {
            EList<Parameter> pivotParameters;
            if (!operationName.equals(pivotOperation.getName()) || pivotArguments.length != (pivotParameters = pivotOperation.getOwnedParameters()).size()) continue;
            boolean typesConform = true;
            int i = 0;
            while (i < pivotArguments.length) {
                Type argumentType = pivotArguments[i];
                Parameter pivotParameter = (Parameter)pivotParameters.get(i);
                Type parameterType = pivotParameter.getType();
                if (!this.conformsTo(argumentType, parameterType, templateParameterSubstitutions)) {
                    typesConform = false;
                    break;
                }
                ++i;
            }
            if (!typesConform) continue;
            if (pivotOperations == null) {
                pivotOperations = new HashSet<Operation>();
            }
            pivotOperations.add(pivotOperation);
        }
        return pivotOperations;
    }

    public void setDefaultStandardLibraryURI(String defaultStandardLibraryURI) {
        this.defaultStandardLibraryURI = defaultStandardLibraryURI;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.pivotResourceSet);
    }

    public static interface Factory {
        public boolean canHandle(Resource var1);

        public void configure(ResourceSet var1);

        public Element importFromResource(TypeManager var1, Resource var2, String var3);
    }

    public static class TuplePart
    extends TypedElementImpl {
        public TuplePart(String name, Type type) {
            this.setName(name);
            this.setType(type);
        }
    }
}

