/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.TupleValue;
import org.eclipse.ocl.examples.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SequenceValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.TupleValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionValue<C extends Collection<Value>>
extends AbstractedCollectionValue {
    protected final C elements;

    protected AbstractCollectionValue(ValueFactory valueFactory, C elements) {
        super(valueFactory);
        this.elements = elements;
        assert (elements != null);
    }

    @Override
    public IntegerValue count(Value value) throws InvalidValueException {
        long count = 0L;
        for (Value next : this.elements) {
            if (!next.equals(value)) continue;
            ++count;
        }
        return this.valueFactory.integerValueOf(count);
    }

    @Override
    public BooleanValue excludes(Value value) {
        return this.valueFactory.booleanValueOf(!this.elements.contains(value));
    }

    @Override
    public BooleanValue excludesAll(CollectionValue c) {
        for (Value next : c) {
            if (!this.elements.contains(next)) continue;
            return this.valueFactory.getFalse();
        }
        return this.valueFactory.getTrue();
    }

    @Override
    public boolean flatten(Collection<Value> flattenedElements) throws InvalidValueException {
        boolean flattened = false;
        for (Value element : this.elements) {
            CollectionValue collectionElement = element.isCollectionValue();
            if (collectionElement != null) {
                flattened = true;
                collectionElement.flatten(flattenedElements);
                continue;
            }
            flattenedElements.add(element);
        }
        return flattened;
    }

    @Override
    protected Collection<Value> getElements() {
        return this.elements;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public BooleanValue includes(Value value) {
        return this.valueFactory.booleanValueOf(this.elements.contains(value));
    }

    @Override
    public BooleanValue includesAll(CollectionValue c) {
        for (Value next : c) {
            if (this.elements.contains(next)) continue;
            return this.valueFactory.getFalse();
        }
        return this.valueFactory.getTrue();
    }

    @Override
    public int intSize() {
        return this.elements.size();
    }

    @Override
    public CollectionValue intersection(CollectionValue c) throws InvalidValueException {
        if (this instanceof UniqueCollectionValue || c instanceof UniqueCollectionValue) {
            return SetValueImpl.intersection(this.valueFactory, this, c);
        }
        return BagValueImpl.intersection(this.valueFactory, this, c);
    }

    @Override
    public Iterator<Value> iterator() {
        return this.elements != null ? this.elements.iterator() : Collections.emptyList().iterator();
    }

    @Override
    public Value maxMin(Value.BinaryOperation binaryOperation) throws InvalidValueException {
        Value result = null;
        for (Value element : this.elements) {
            if (result == null) {
                result = element;
                continue;
            }
            if ((result = binaryOperation.evaluate(this.valueFactory, result, element)) == null) {
                this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingResult, "max/min");
                continue;
            }
            if (!result.isUndefined()) continue;
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.UndefinedResult, "max/min");
        }
        if (result == null) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, new Object[]{this.getKind(), "max/min"});
        }
        return result;
    }

    @Override
    public Set<TupleValue> product(CollectionValue c, TupleType tupleType) {
        HashSet<TupleValue> result = new HashSet<TupleValue>();
        for (Value next1 : this) {
            for (Value next2 : c) {
                result.add(new TupleValueImpl(this.valueFactory, tupleType, next1, next2));
            }
        }
        return result;
    }

    @Override
    public Value sum(Value.BinaryOperation binaryOperation, Value zero) throws InvalidValueException {
        Value result = zero;
        for (Value element : this.elements) {
            result = binaryOperation.evaluate(this.valueFactory, result, element);
        }
        return result;
    }

    @Override
    public CollectionValue union(CollectionValue c) throws InvalidValueException {
        if (this instanceof BagValue || c instanceof BagValue) {
            return BagValueImpl.union(this.valueFactory, this, c);
        }
        if (this instanceof SequenceValue || c instanceof SequenceValue) {
            return SequenceValueImpl.union(this.valueFactory, this, c);
        }
        if (this instanceof OrderedSetValue || c instanceof OrderedSetValue) {
            return OrderedSetValueImpl.union(this.valueFactory, this, c);
        }
        return SetValueImpl.union(this.valueFactory, this, c);
    }
}

