/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerRangeImpl
extends AbstractList<Value> {
    protected final ValueFactory valueFactory;
    protected final int first;
    protected final int last;
    protected final int delta;
    protected final int size;

    public IntegerRangeImpl(ValueFactory valueFactory, int first, int last) {
        this.valueFactory = valueFactory;
        this.first = first;
        this.last = last;
        if (last > first) {
            this.delta = 1;
            this.size = last - first + 1;
        } else {
            this.delta = -1;
            this.size = first - last + 1;
        }
    }

    @Override
    public IntegerValue get(int index) {
        return this.valueFactory.integerValueOf(this.first + index * this.getDelta());
    }

    public int getDelta() {
        return this.delta;
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    @Override
    public int getLast() {
        return this.last;
    }

    @Override
    public Iterator<Value> iterator() {
        return new IntegerRangeIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntegerRangeIterator
    implements Iterator<Value> {
        private int curr;
        private boolean initialized;

        public IntegerRangeIterator() {
            this.curr = IntegerRangeImpl.this.first;
            this.initialized = false;
        }

        @Override
        public IntegerValue next() {
            if (!this.initialized) {
                this.curr = IntegerRangeImpl.this.first - IntegerRangeImpl.this.getDelta();
                this.initialized = true;
            }
            if (this.hasNext()) {
                this.curr += IntegerRangeImpl.this.getDelta();
                return IntegerRangeImpl.this.valueFactory.integerValueOf(this.curr);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return !this.initialized || this.curr != IntegerRangeImpl.this.last;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

