/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.NumericValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;
import org.eclipse.ocl.examples.pivot.values.impl.RealValueImpl;

public class IntegerValueImpl
extends AbstractValue
implements IntegerValue {
    private final BigInteger value;

    public IntegerValueImpl(ValueFactory valueFactory, long value) {
        this(valueFactory, BigInteger.valueOf(value));
    }

    public IntegerValueImpl(ValueFactory valueFactory, BigInteger value) {
        super(valueFactory);
        this.value = value;
        assert (value != null);
    }

    public IntegerValue abs() {
        return this.valueFactory.integerValueOf(this.value.abs());
    }

    public IntegerValue add(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.add(right.bigIntegerValue()));
    }

    public Double asDouble() {
        return this.value.doubleValue();
    }

    public Integer asInteger() {
        return this.value.intValue();
    }

    public IntegerValue asIntegerValue() {
        return this;
    }

    public Object asObject() {
        return this.value;
    }

    public Value asValidValue() {
        return this;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public int compareTo(NumericValue o) {
        if (o instanceof IntegerValue) {
            return this.value.compareTo(((IntegerValue)o).bigIntegerValue());
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    public IntegerValue div(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.value.divide(right.bigIntegerValue()));
    }

    public RealValue divide(IntegerValue right) throws InvalidValueException {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(this.valueFactory, bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerValue) {
            BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
            return bigIntegerValue != null && this.value.compareTo(bigIntegerValue) == 0;
        }
        if (obj instanceof RealValue) {
            BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
        }
        return false;
    }

    public Type getType(TypeManager typeManager, Type staticType) {
        return this.value.signum() >= 0 ? typeManager.getUnlimitedNaturalType() : typeManager.getIntegerType();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public IntegerValue isIntegerValue() {
        return this;
    }

    public boolean isUnlimitedNatural() {
        return this.value.signum() >= 0;
    }

    public IntegerValue max(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.max(right.bigIntegerValue()));
    }

    public IntegerValue min(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.min(right.bigIntegerValue()));
    }

    public IntegerValue mod(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.value.remainder(right.bigIntegerValue()));
    }

    public IntegerValue multiply(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.multiply(right.bigIntegerValue()));
    }

    public IntegerValue negate() {
        return this.valueFactory.integerValueOf(this.value.negate());
    }

    public int signum() {
        return this.value.signum();
    }

    public IntegerValue subtract(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.subtract(right.bigIntegerValue()));
    }

    public IntegerValue toIntegerValue() {
        return this;
    }

    public RealValue toRealValue() {
        return this.valueFactory.realValueOf(this);
    }

    public String toString() {
        return this.value.toString();
    }
}

