/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;
import org.eclipse.ocl.examples.pivot.values.Bag;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.ElementValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.InvalidValue;
import org.eclipse.ocl.examples.pivot.values.NullValue;
import org.eclipse.ocl.examples.pivot.values.NumericValue;
import org.eclipse.ocl.examples.pivot.values.ObjectValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.SetValue;
import org.eclipse.ocl.examples.pivot.values.StringValue;
import org.eclipse.ocl.examples.pivot.values.UnlimitedValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.BagImpl;
import org.eclipse.ocl.examples.pivot.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.BooleanValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.ElementValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.IntegerValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.InvalidValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.NullValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.ObjectValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SequenceValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.StringValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.TupleValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.TypeValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.UnlimitedValueImpl;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueFactoryImpl
implements ValueFactory {
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    public final BagValue emptyBagValue = new BagValueImpl((ValueFactory)this, new Value[0]);
    public final OrderedSetValue emptyOrderedSetValue = new OrderedSetValueImpl((ValueFactory)this, new Value[0]);
    public final SequenceValue emptySequenceValue = new SequenceValueImpl((ValueFactory)this, new Value[0]);
    public final SetValue emptySetValue = new SetValueImpl((ValueFactory)this, new Value[0]);
    public final BooleanValue falseValue = new BooleanValueImpl(this, false);
    public final InvalidValue invalidValue = new InvalidValueImpl(this);
    public final NullValue nullValue = new NullValueImpl(this);
    public final BooleanValue trueValue = new BooleanValueImpl(this, true);
    public final UnlimitedValue unlimitedValue = new UnlimitedValueImpl(this);
    public final NumericValue zeroValue = this.integerValueOf(0L);
    protected final String name;

    public ValueFactoryImpl(String name) {
        this.name = name;
    }

    @Override
    public BooleanValue booleanValueOf(boolean value) {
        return value ? this.trueValue : this.falseValue;
    }

    @Override
    public BagValue createBagOf(Object ... objects) {
        BagImpl<Value> collection = new BagImpl<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        return this.createBagValue((Bag<? extends Value>)collection);
    }

    @Override
    public BagValue createBagValue(Value ... values) {
        return new BagValueImpl((ValueFactory)this, values);
    }

    @Override
    public BagValue createBagValue(Bag<? extends Value> values) {
        return new BagValueImpl((ValueFactory)this, (Collection<? extends Value>)values);
    }

    @Override
    public BagValue createBagValue(Collection<? extends Value> values) {
        return new BagValueImpl((ValueFactory)this, values);
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, Value ... values) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetValue(values);
            }
            return this.createSequenceValue(values);
        }
        if (isUnique) {
            return this.createSetValue(values);
        }
        return this.createBagValue(values);
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, Collection<Value> values) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetValue(values);
            }
            return this.createSequenceValue(values);
        }
        if (isUnique) {
            return this.createSetValue(values);
        }
        return this.createBagValue(values);
    }

    @Override
    public CollectionValue createCollectionValue(CollectionKind kind, Value ... values) {
        switch (kind) {
            case BAG: {
                return this.createBagValue(values);
            }
            case ORDERED_SET: {
                return this.createOrderedSetValue(values);
            }
            case SEQUENCE: {
                return this.createSequenceValue(values);
            }
            case SET: {
                return this.createSetValue(values);
            }
        }
        String message = NLS.bind((String)OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)((Object)kind));
        IllegalArgumentException error = new IllegalArgumentException(message);
        PivotPlugin.throwing(ValueFactoryImpl.class, "createNewCollection", error);
        throw error;
    }

    @Override
    public CollectionValue createCollectionValue(CollectionKind kind, Collection<Value> values) {
        switch (kind) {
            case BAG: {
                return this.createBagValue(values);
            }
            case ORDERED_SET: {
                return this.createOrderedSetValue(values);
            }
            case SEQUENCE: {
                return this.createSequenceValue(values);
            }
            case SET: {
                return this.createSetValue(values);
            }
        }
        String message = NLS.bind((String)OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)((Object)kind));
        IllegalArgumentException error = new IllegalArgumentException(message);
        PivotPlugin.throwing(ValueFactoryImpl.class, "createNewCollection", error);
        throw error;
    }

    @Override
    public <E extends Element> ElementValue<E> createElementValue(E element) {
        return new ElementValueImpl<E>((ValueFactory)this, element);
    }

    @Override
    public ObjectValue createObjectValue(Object object) {
        return new ObjectValueImpl(this, object);
    }

    @Override
    public OrderedSetValue createOrderedSetOf(Object ... objects) {
        LinkedHashSet<Value> collection = new LinkedHashSet<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        return this.createOrderedSetValue(collection);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(Value ... values) {
        return new OrderedSetValueImpl((ValueFactory)this, values);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(LinkedHashSet<? extends Value> values) {
        return new OrderedSetValueImpl((ValueFactory)this, (Collection<? extends Value>)values);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(Collection<? extends Value> values) {
        return new OrderedSetValueImpl((ValueFactory)this, values);
    }

    @Override
    public SequenceValue createSequenceOf(Object ... objects) {
        ArrayList<Value> collection = new ArrayList<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        return this.createSequenceValue((List<? extends Value>)collection);
    }

    @Override
    public SequenceValue createSequenceValue(Value ... values) {
        return new SequenceValueImpl((ValueFactory)this, values);
    }

    @Override
    public SequenceValue createSequenceValue(List<? extends Value> values) {
        return new SequenceValueImpl((ValueFactory)this, (Collection<? extends Value>)values);
    }

    @Override
    public SequenceValue createSequenceValue(Collection<? extends Value> values) {
        return new SequenceValueImpl((ValueFactory)this, values);
    }

    @Override
    public SetValue createSetOf(Object ... objects) {
        HashSet<Value> collection = new HashSet<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        return this.createSetValue((Set<? extends Value>)collection);
    }

    @Override
    public SetValue createSetValue(Value ... values) {
        return new SetValueImpl((ValueFactory)this, values);
    }

    @Override
    public SetValue createSetValue(Set<? extends Value> values) {
        return new SetValueImpl((ValueFactory)this, (Collection<? extends Value>)values);
    }

    @Override
    public SetValue createSetValue(Collection<? extends Value> values) {
        return new SetValueImpl((ValueFactory)this, values);
    }

    @Override
    public Value createTupleValue(TupleType type, Map<? extends TypedElement, Value> values) {
        return new TupleValueImpl(this, type, values);
    }

    @Override
    public Value createTypeValue(ClassifierType type) {
        return new TypeValueImpl((ValueFactory)this, type);
    }

    @Override
    public Object getEcoreValueOf(Value value) {
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof CollectionValue) {
            CollectionValue collectionValue = (CollectionValue)value;
            BasicEList ecoreResult = new BasicEList(collectionValue.intSize());
            for (Value elementValue : collectionValue) {
                ecoreResult.add(this.getEcoreValueOf(elementValue));
            }
            return ecoreResult;
        }
        if (value instanceof IntegerValueImpl) {
            return ((IntegerValueImpl)value).intValue();
        }
        if (value instanceof RealValueImpl) {
            return ((RealValueImpl)value).doubleValue();
        }
        Object object = value.asObject();
        if (object instanceof Element) {
            EObject target = ((Element)object).getETarget();
            if (target instanceof EEnumLiteral) {
                return ((EEnumLiteral)target).getInstance();
            }
            return target;
        }
        return object;
    }

    @Override
    public BagValue getEmptyBagValue() {
        return this.emptyBagValue;
    }

    @Override
    public OrderedSetValue getEmptyOrderedSetValue() {
        return this.emptyOrderedSetValue;
    }

    @Override
    public SequenceValue getEmptySequenceValue() {
        return this.emptySequenceValue;
    }

    @Override
    public SetValue getEmptySetValue() {
        return this.emptySetValue;
    }

    @Override
    public BooleanValue getFalse() {
        return this.falseValue;
    }

    @Override
    public InvalidValue getInvalid() {
        return this.invalidValue;
    }

    @Override
    public NullValue getNull() {
        return this.nullValue;
    }

    @Override
    public BooleanValue getTrue() {
        return this.trueValue;
    }

    @Override
    public UnlimitedValue getUnlimited() {
        return this.unlimitedValue;
    }

    @Override
    public NumericValue getZero() {
        return this.zeroValue;
    }

    @Override
    public IntegerValue integerValueOf(long value) {
        return new IntegerValueImpl((ValueFactory)this, value);
    }

    @Override
    public IntegerValue integerValueOf(BigInteger value) {
        return new IntegerValueImpl((ValueFactory)this, value);
    }

    @Override
    public IntegerValue integerValueOf(String aValue) throws InvalidValueException {
        try {
            int len = aValue.length();
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                return new IntegerValueImpl((ValueFactory)this, BigInteger.valueOf(Long.parseLong(aValue)));
            }
            return new IntegerValueImpl((ValueFactory)this, new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            return this.throwInvalidValueException(e, EvaluatorMessages.InvalidInteger, aValue);
        }
    }

    @Override
    public RealValue realValueOf(double value) {
        return new RealValueImpl((ValueFactory)this, value);
    }

    @Override
    public RealValue realValueOf(BigDecimal value) {
        return new RealValueImpl((ValueFactory)this, value);
    }

    @Override
    public RealValue realValueOf(IntegerValue integerValue) {
        return this.realValueOf(integerValue.bigDecimalValue());
    }

    @Override
    public RealValue realValueOf(String aValue) throws InvalidValueException {
        try {
            return new RealValueImpl((ValueFactory)this, new BigDecimal(aValue.trim()));
        }
        catch (NumberFormatException e) {
            return this.throwInvalidValueException(e, EvaluatorMessages.InvalidReal, aValue);
        }
    }

    @Override
    public StringValue stringValueOf(String value) {
        return new StringValueImpl(this, value);
    }

    @Override
    public InvalidValue throwInvalidValueException(String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage);
    }

    public InvalidValue throwInvalidValueException(Throwable e, String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage, e);
    }

    public String toString() {
        return "ValueFactory : " + this.name;
    }

    @Override
    public Value valueOf(Object object) {
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Number) {
            if (object instanceof Integer || object instanceof Long || object instanceof Short) {
                return this.integerValueOf(((Number)object).longValue());
            }
            if (object instanceof Float || object instanceof Double) {
                return this.realValueOf(((Number)object).doubleValue());
            }
            if (object instanceof BigDecimal) {
                return this.realValueOf((BigDecimal)object);
            }
            if (object instanceof BigInteger) {
                return this.integerValueOf((BigInteger)object);
            }
        }
        if (object instanceof String) {
            return this.stringValueOf((String)object);
        }
        if (object instanceof Boolean) {
            return this.booleanValueOf((Boolean)object);
        }
        if (object instanceof Element) {
            if (object instanceof ClassifierType) {
                return this.createTypeValue((ClassifierType)object);
            }
            return this.createElementValue((Element)object);
        }
        if (object == null) {
            return this.nullValue;
        }
        if (object.getClass().isArray()) {
            try {
                int length = Array.getLength(object);
                ArrayList<Value> values = new ArrayList<Value>();
                int i = 0;
                while (i < length) {
                    Value v = this.valueOf(Array.get(object, i));
                    values.add(v);
                    ++i;
                }
                return this.createSequenceValue((List<? extends Value>)values);
            }
            catch (IllegalArgumentException length) {
                // empty catch block
            }
        }
        if (object instanceof Collection) {
            Collection objects = (Collection)object;
            ArrayList<Value> values = new ArrayList<Value>(objects.size());
            for (Object obj : objects) {
                values.add(this.valueOf(obj));
            }
            if (object instanceof LinkedHashSet) {
                return this.createOrderedSetValue(values);
            }
            if (object instanceof Bag) {
                return this.createBagValue(values);
            }
            if (object instanceof Set) {
                return this.createSetValue(values);
            }
            return this.createSequenceValue((List<? extends Value>)values);
        }
        return this.createObjectValue(object);
    }

    @Override
    public Value valueOf(Object eValue, ETypedElement eFeature) {
        if (eFeature.isMany()) {
            Collection eValues = (Collection)eValue;
            ArrayList<Value> values = new ArrayList<Value>(eValues.size());
            for (Object eVal : eValues) {
                values.add(this.valueOf(eVal));
            }
            boolean isOrdered = eFeature.isOrdered();
            boolean isUnique = eFeature.isUnique();
            return this.createCollectionValue(isOrdered, isUnique, values);
        }
        if (eValue instanceof Value) {
            return (Value)eValue;
        }
        return this.valueOf(eValue);
    }
}

